export const highlightMatch = (label: string, term: string) => {
  if (!term) return label;

  const regex = new RegExp(`(${term.replace(/[.*+?^${}()|[\]\\]/g, "\\$&")})`, "gi");

  let lastIndex = 0;
  const elements: React.ReactElement[] = [];


  label.replace(regex, (match, _group, offset) => {

    if (offset > lastIndex) {
      elements.push(<span key={elements.length}>{label.slice(lastIndex, offset)}</span>);
    }

    elements.push(
      <span
        key={elements.length}
        className="bg-green-300 dark:bg-green-600 rounded-sm px-0.5"
      >
        {match}
      </span>
    );
    lastIndex = offset + match.length;
    return match;
  });

  if (lastIndex < label.length) {
    elements.push(<span key={elements.length}>{label.slice(lastIndex)}</span>);
  }

  return elements;
};
