// 'use client';

// import Link from 'next/link';
// import { usePathname, useRouter } from 'next/navigation';
// import { useMemo, useState } from 'react';
// import {
//   HomeIcon,
//   PackageIcon,
//   WorkflowIcon,
//   FileTextIcon,
//   ClipboardListIcon,
//   LogOutIcon,
//   ArrowLeftIcon,
//   ArrowRightIcon,
//   WarehouseIcon,
//   UserCheckIcon,
//   FlaskConicalIcon,
//   ShieldCheckIcon,
//   FileLineChartIcon,
//   UserCircleIcon,
//   ShoppingCartIcon,
//   FilePlusIcon,
//   CalendarDaysIcon,
//   ListTodoIcon,
//   FileSignatureIcon,
//   UserXIcon,
//   UsersIcon,
// } from 'lucide-react';
// import { useAuth } from '@/context/AuthContext';
// import Image from 'next/image';
// import { motion } from 'framer-motion';
// import { SidebarData } from '@/data/sidebarData';
// import { highlightMatch } from './common/HighLightMatch';
// import { useSearch } from '@/context/SearchContext';

// const iconMap: Record<string, React.ReactNode> = {
//   HomeIcon: <HomeIcon className="w-5 h-5" />,
//   PackageIcon: <PackageIcon className="w-5 h-5" />,
//   WorkflowIcon: <WorkflowIcon className="w-5 h-5" />,
//   FileTextIcon: <FileTextIcon className="w-5 h-5" />,
//   ClipboardListIcon: <ClipboardListIcon className="w-5 h-5" />,
//   WarehouseIcon: <WarehouseIcon className="w-5 h-5" />,
//   SupplierVisitIcon: <UserCheckIcon className="w-5 h-5" />,
//   SampleTestIcon: <FlaskConicalIcon className="w-5 h-5" />,
//   SupplierApprovalIcon: <ShieldCheckIcon className="w-5 h-5" />,
//   SupplierRatingIcon: <FileLineChartIcon className="w-5 h-5" />,
//   SupplierActionsIcon: <ClipboardListIcon className="w-5 h-5" />,
//   SupplierAgreementIcon: <FileSignatureIcon className="w-5 h-5" />,   // ✅ new
//   DisqualifiedSuppliersIcon: <UserXIcon className="w-5 h-5" />,       // ✅ new
//   ShoppingCartIcon: <ShoppingCartIcon className="w-5 h-5" />,
//   FilePlusIcon: <FilePlusIcon className="w-5 h-5" />,
//   CalendarIcon: <CalendarDaysIcon className="w-5 h-5" />,
//   TodoIcon: <ListTodoIcon className="w-5 h-5" />,
//   UsersIcon: <UsersIcon className="w-5 h-5" />,
// };

// interface SidebarProps {
//   onMobileToggle?: () => void;
// }

// export default function Sidebar({ onMobileToggle }: SidebarProps = {}) {
//   const pathname = usePathname();
//   const { logout } = useAuth();
//   const router = useRouter();
//   const [collapsed, setCollapsed] = useState(false);
//   const [hovered, setHovered] = useState(false);
//   const { searchTerm, setSearchTerm } = useSearch();

//   // Determine if sidebar should be expanded based on collapsed state or hover
//   const isSidebarExpanded = !collapsed || hovered;

//   const handleLogout = () => {
//     logout();
//     router.push('/login');
//     onMobileToggle?.();
//   };

//   const renderedSidebarItems = useMemo(() =>
//     SidebarData.flatMap(section =>
//       section.submenuItems
//         .filter(({ label }) =>
//           label.toLowerCase().includes(searchTerm.toLowerCase())
//         )
//         .map(({ label, link, icon }) => ({
//           key: link,
//           label,
//           link,
//           iconComponent: iconMap[icon],
//           isActive: pathname === link,
//           section: section.label,
//         }))
//     ), [pathname, searchTerm]
//   );

//   return (
//     <motion.aside
//       animate={{ width: isSidebarExpanded ? 256 : 80 }}
//       transition={{ type: 'spring', stiffness: 300, damping: 30 }}
//       className={`bg-white dark:bg-gray-800 shadow-md transition-colors duration-300 flex flex-col
//     ${isSidebarExpanded ? 'w-64' : 'w-20'}
//     h-screen lg:sticky top-0 left-0  overflow-x-hidden  overflow-y-auto scrollbar-thin scrollbar-thumb-rounded scrollbar-thumb-gray-400 dark:scrollbar-thumb-gray-600 hover:scrollbar-thumb-gray-500`}
//       onMouseEnter={() => setHovered(true)}
//       onMouseLeave={() => setHovered(false)}
//     >

//       {/* Logo and Collapse Button */}
//       <div className="sticky top-0 z-10 bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700 flex flex-col items-center px-4 pt-4 pb-4">
//         <Image
//           src={isSidebarExpanded ? '/image.png' : '/favicon.ico'}
//           alt="Logo"
//           width={isSidebarExpanded ? 60 : 32}
//           height={40}
//           priority
//           className="h-10 w-auto"
//         />
//         {/* {isSidebarExpanded && (
//           <span className="text-xl font-semibold text-green-700 dark:text-green-300 mt-2">
//             QMS
//           </span>
//         )} */}
//         <motion.button
//           whileHover={{ scale: 1.3 }}
//           whileTap={{ scale: 0.9 }}
//           onClick={() => setCollapsed(!collapsed)}
//           className="absolute -right-1 top-4 z-50 bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-full p-1 shadow-md hover:bg-gray-100 dark:hover:bg-gray-600"
//           title={collapsed ? 'Expand' : 'Collapse'}
//         >
//           {collapsed ? (
//             <ArrowRightIcon className="w-5 h-5 text-gray-600 dark:text-gray-300" />
//           ) : (
//             <ArrowLeftIcon className="w-5 h-5 text-gray-600 dark:text-gray-300" />
//           )}
//         </motion.button>
//       </div>
//       {/* <div className="px-3 pt-3 pb-3">
//         <div className="relative">
//           <span className="absolute inset-y-0 left-2 flex items-center text-gray-500 dark:text-gray-400">
//             <SearchIcon className="w-4 h-4 sm:w-5 sm:h-5" />
//           </span>
//           <input
//             type="text"
//             value={searchTerm}
//             onChange={(e) => setSearchTerm(e.target.value)}
//             placeholder="Search..."
//             className="w-full pl-8 text-sm px-3 py-1.5 rounded-md bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder:text-gray-500 dark:placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-green-400"
//           />
//         </div>
//       </div> */}

//       {/* Navigation */}
//       <ul className="border-t border-gray-200 dark:border-gray-700 flex-1 space-y-2 pt-2 px-2">
//         {SidebarData.map((section) => (
//           <li key={section.label}>
//             {isSidebarExpanded && (
//               <h3 className="px-3 py-2 text-[0.7rem] font-bold text-gray-500 dark:text-gray-400">
//                 {section.label}
//               </h3>
//             )}
//             <ul className="space-y-1">
//               {renderedSidebarItems
//                 .filter((item) => item.section === section.label)
//                 .map(({ key, label, link, iconComponent, isActive }) => (
//                   <li key={key}>
//                     <Link
//                       href={link}
//                       className={`relative group flex items-center gap-3 px-3 py-2 rounded-md font-medium transition-all
//     ${isActive
//                           ? 'bg-green-100 dark:bg-green-900 text-green-700 dark:text-green-300'
//                           : 'text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700'
//                         }`}
//                       title={isSidebarExpanded ? '' : label}
//                       onClick={onMobileToggle}
//                     >
//                       {isActive && (
//                         <motion.span
//                           layoutId="activeIndicator"
//                           className="absolute left-0 top-0 bottom-0 w-1 rounded-r bg-green-600"
//                         />
//                       )}
//                       <span className="flex items-center justify-center w-5 h-5 text-green-600 dark:text-green-400 group-hover:bg-green-200 dark:group-hover:bg-green-900 group-hover:text-green-600 dark:group-hover:text-green-400 group-hover:scale-130 transition-transform duration-200">
//                         {iconComponent}
//                       </span>
//                       {isSidebarExpanded && <span className="text-sm group-hover:text-green-600 dark:group-hover:text-green-400 group-hover:scale-100 transition-transform duration-200">{highlightMatch(label, searchTerm)}</span>}
//                     </Link>
//                   </li>
//                 ))}
//             </ul>
//           </li>
//         ))}
//       </ul>

//       {/* User Profile Section */}
//       <Link
//         href="login/profile"
//         className="mx-2 mb-3 mt-auto rounded-xl border border-gray-200 dark:border-gray-700
//     bg-gray-50 dark:bg-gray-900 hover:bg-gray-200 dark:hover:bg-gray-800
//     transition-all shadow-sm p-3 flex items-center gap-3"
//       >
//         <UserCircleIcon className="w-9 h-9 text-gray-600 dark:text-gray-300" />
//         {isSidebarExpanded && (
//           <div>
//             <span className="block text-sm font-medium text-gray-700 dark:text-gray-200">Admin</span>
//             <span className="block text-xs text-gray-500 dark:text-gray-400">admin@example.com</span>
//           </div>
//         )}
//       </Link>

//       {/* Logout */}
//       <div className="px-3 pb-4">
//         <motion.button
//           whileHover={{ scale: 1.05 }}
//           whileTap={{ scale: 0.95 }}
//           onClick={handleLogout}
//           className="flex items-center gap-3 w-full px-3 py-2 rounded-lg
//     bg-red-50 dark:bg-red-900/30 text-red-600 dark:text-red-300
//     hover:bg-red-100 dark:hover:bg-red-800/50 transition-colors shadow-sm"
//           title={isSidebarExpanded ? '' : 'Logout'}
//         >
//           <LogOutIcon className="w-5 h-5" />
//           {isSidebarExpanded && <span className="text-sm">Logout</span>}
//         </motion.button>
//       </div>
//     </motion.aside>
//   );
// }




"use client";

import Link from "next/link";
import { usePathname, useRouter } from "next/navigation";
import { useMemo, useState } from "react";
import {
  HomeIcon,
  PackageIcon,
  WorkflowIcon,
  FileTextIcon,
  ClipboardListIcon,
  LogOutIcon,
  ArrowLeftIcon,
  ArrowRightIcon,
  WarehouseIcon,
  UserCheckIcon,
  FlaskConicalIcon,
  ShieldCheckIcon,
  FileLineChartIcon,
  UserCircleIcon,
  ShoppingCartIcon,
  FilePlusIcon,
  CalendarDaysIcon,
  ListTodoIcon,
  FileSignatureIcon,
  UserXIcon,
  UsersIcon,
  ChevronRightIcon,
  TruckIcon,
} from "lucide-react";
import {
  BsPersonBadge,
  BsMortarboardFill,
  BsFillBarChartLineFill,
  BsJournalText,
  BsCardList,
  BsChatDotsFill,
  BsGraphUp,
} from "react-icons/bs";
import { HiMiniIdentification } from "react-icons/hi2";
import { LuCalendarDays } from "react-icons/lu";
import { MdGeneratingTokens } from "react-icons/md";
import { LiaAwardSolid } from "react-icons/lia";
import { FaGoogleWallet } from "react-icons/fa";
import { useAuth } from "@/context/AuthContext";
import Image from "next/image";
import { motion } from "framer-motion";
import { SidebarData } from "@/data/sidebarData";
import { highlightMatch } from "./common/HighLightMatch";
import { useSearch } from "@/context/SearchContext";
import React from "react";

const iconMap: Record<string, React.ReactNode> = {
  HomeIcon: <HomeIcon className="w-5 h-5" />,
  PackageIcon: <PackageIcon className="w-5 h-5" />,
  WorkflowIcon: <WorkflowIcon className="w-5 h-5" />,
  FileTextIcon: <FileTextIcon className="w-5 h-5" />,
  ClipboardListIcon: <ClipboardListIcon className="w-5 h-5" />,
  WarehouseIcon: <WarehouseIcon className="w-5 h-5" />,
  SupplierVisitIcon: <UserCheckIcon className="w-5 h-5" />,
  SampleTestIcon: <FlaskConicalIcon className="w-5 h-5" />,
  SupplierApprovalIcon: <ShieldCheckIcon className="w-5 h-5" />,
  SupplierRatingIcon: <FileLineChartIcon className="w-5 h-5" />,
  SupplierActionsIcon: <ClipboardListIcon className="w-5 h-5" />,
  SupplierAgreementIcon: <FileSignatureIcon className="w-5 h-5" />,
  DisqualifiedSuppliersIcon: <UserXIcon className="w-5 h-5" />,
  ShoppingCartIcon: <ShoppingCartIcon className="w-5 h-5" />,
  FilePlusIcon: <FilePlusIcon className="w-5 h-5" />,
  CalendarIcon: <CalendarDaysIcon className="w-5 h-5" />,
  TodoIcon: <ListTodoIcon className="w-5 h-5" />,
  UsersIcon: <UsersIcon className="w-5 h-5" />,
  TruckIcon: <TruckIcon className="w-5 h-5" />,
  BsPersonBadgeIcon: <BsPersonBadge className="w-5 h-5" />,
  BsMortarboardFillIcon: <BsMortarboardFill className="w-5 h-5" />,
  BsFillBarChartLineFillIcon: <BsFillBarChartLineFill className="w-5 h-5" />,
  HiMiniIdentificationIcon: <HiMiniIdentification className="w-5 h-5" />,
  LuCalendarDaysIcon: <LuCalendarDays className="w-5 h-5" />,
  MdGeneratingTokensIcon: <MdGeneratingTokens className="w-5 h-5" />,
  BsJournalTextIcon: <BsJournalText className="w-5 h-5" />,
  BsCardListIcon: <BsCardList className="w-5 h-5" />,
  BsChatDotsFillIcon: <BsChatDotsFill className="w-5 h-5" />,
  BsGraphUpIcon: <BsGraphUp className="w-5 h-5" />,
  LiaAwardSolidIcon: <LiaAwardSolid className="w-5 h-5" />,
  FaGoogleWalletIcon: <FaGoogleWallet className="w-5 h-5" />,
};

interface SidebarProps {
  onMobileToggle?: () => void;
}

export default function Sidebar({ onMobileToggle }: SidebarProps = {}) {
  const pathname = usePathname();
  const { user, logout } = useAuth();
  const router = useRouter();
  const [collapsed, setCollapsed] = useState(false);
  const [hovered, setHovered] = useState(false);
  const [openSections, setOpenSections] = useState<string[]>([]);
  const { searchTerm } = useSearch();

  const isSidebarExpanded = !collapsed || hovered;

  const handleLogout = () => {
    logout();
    router.push("/login");
    onMobileToggle?.();
  };

  // 🔒 Filter SidebarData by user role
  const filteredSidebarData = useMemo(() => {
    if (!user) return [];

    const role = user.role?.toLowerCase();

    if (role === "hr") {
      return SidebarData.filter((section) =>
        ["HRM", "APPS", "USER'S"].includes(section.label)
      );
    }

    if (["admin", "manager", "user"].includes(role)) {
      return SidebarData.filter((section) => section.label !== "HRM");
    }

    // super admin or any other roles
    return SidebarData;
  }, [user]);

  // 🔍 Search filtering for visible items
  const renderedSidebarItems = useMemo(
    () =>
      SidebarData.flatMap((section) =>
        section.submenuItems
          .filter(({ label }) =>
            label.toLowerCase().includes(searchTerm.toLowerCase())
          )
          .map(({ label, link, icon }) => ({
            key: link,
            label,
            link,
            iconComponent: iconMap[icon],
            isActive: pathname === link,
            section: section.label,
          }))
      ),
    [pathname, searchTerm]
  );

  const toggleSection = (label: string) => {
    setOpenSections((prev) =>
      prev.includes(label)
        ? prev.filter((l) => l !== label)
        : [...prev, label]
    );
  };

  return (
    <motion.aside
      animate={{ width: isSidebarExpanded ? 256 : 80 }}
      transition={{ type: "spring", stiffness: 300, damping: 30 }}
      className={`bg-white dark:bg-gray-800 shadow-md transition-colors duration-300 flex flex-col
      ${isSidebarExpanded ? "w-64" : "w-20"}
      h-screen lg:sticky top-0 left-0 overflow-x-hidden overflow-y-auto scrollbar-thin scrollbar-thumb-rounded scrollbar-thumb-gray-400 dark:scrollbar-thumb-gray-600 hover:scrollbar-thumb-gray-500`}
      onMouseEnter={() => setHovered(true)}
      onMouseLeave={() => setHovered(false)}
    >
      {/* LOGO + Collapse Button */}
      <div className="sticky top-0 z-10 bg-white dark:bg-gray-800 border-b border-gray-200 dark:border-gray-700 flex flex-col items-center px-4 pt-4 pb-4">
        <Image
          src={isSidebarExpanded ? "/image.png" : "/favicon.ico"}
          alt="Logo"
          width={isSidebarExpanded ? 60 : 32}
          height={40}
          priority
          className="h-10 w-auto"
        />
        {/* {isSidebarExpanded && (
          <span className="text-xl font-semibold text-green-700 dark:text-green-300 mt-2">
            QMS
          </span>
        )} */}
        <motion.button
          whileHover={{ scale: 1.3 }}
          whileTap={{ scale: 0.9 }}
          onClick={() => setCollapsed(!collapsed)}
          className="absolute -right-1 top-4 z-50 bg-white dark:bg-gray-700 border border-gray-200 dark:border-gray-600 rounded-full p-1 shadow-md hover:bg-gray-100 dark:hover:bg-gray-600"
          title={collapsed ? "Expand" : "Collapse"}
        >
          {collapsed ? (
            <ArrowRightIcon className="w-5 h-5 text-gray-600 dark:text-gray-300" />
          ) : (
            <ArrowLeftIcon className="w-5 h-5 text-gray-600 dark:text-gray-300" />
          )}
        </motion.button>
      </div>
      {/* <div className="px-3 pt-3 pb-3">
        <div className="relative">
          <span className="absolute inset-y-0 left-2 flex items-center text-gray-500 dark:text-gray-400">
            <SearchIcon className="w-4 h-4 sm:w-5 sm:h-5" />
          </span>
          <input
            type="text"
            value={searchTerm}
            onChange={(e) => setSearchTerm(e.target.value)}
            placeholder="Search..."
            className="w-full pl-8 text-sm px-3 py-1.5 rounded-md bg-gray-100 dark:bg-gray-700 text-gray-900 dark:text-gray-100 placeholder:text-gray-500 dark:placeholder:text-gray-400 focus:outline-none focus:ring-2 focus:ring-green-400"
          />
        </div>
      </div> */}

      {/* Navigation */}
      <ul className="border-t border-gray-200 dark:border-gray-700 flex-1 space-y-2 pt-2 px-2">
        {filteredSidebarData.map((section) => {
          const isOpen = openSections.includes(section.label);
          return (
            <li key={section.label}>
              {/* ✅ HRM section clickable but chevron toggles */}
              <div
                className={`flex items-center w-full px-3 py-2 rounded-lg text-sm
                  transition-all duration-200
                  ${isSidebarExpanded ? "justify-between" : "justify-center"}
                  ${
                    isOpen
                      ? "bg-green-200 dark:bg-green-900/20 text-green-600 dark:text-green-400 shadow-sm"
                      : "text-grey-600 dark:text-grey-400 hover:bg-green-100 dark:hover:bg-green-800/40 hover:text-green-700 dark:hover:text-green-300"
                  } hover:scale-[1.02]`}
                title={!isSidebarExpanded ? section.label : ""}
              >
                {/* Left part (icon + label) */}
                {section.label === "HRM" ? (
                  <Link
                    href="/hrm"
                    className="flex items-center gap-1 flex-1"
                    onClick={onMobileToggle}
                  >
                    {section.icon && (
                      <span
                        className={`flex items-center justify-center ${
                          isSidebarExpanded ? "w-5 h-5 mr-1" : "w-5 h-5"
                        } text-green-600 dark:text-green-400`}
                      >
                        {React.createElement(
                          // @ts-ignore
                          require("lucide-react")[section.icon],
                          { className: isSidebarExpanded ? "w-5 h-5 mr-1" : "w-5 h-5", strokeWidth: 3 }
                        )}
                      </span>
                    )}
                    {isSidebarExpanded && (
                      <span className="text-sm font-bold leading-tight text-gray-700 dark:text-gray-100">
                        {section.label}
                      </span>
                    )}
                  </Link>
                ) : (
                  <button
                    onClick={() => toggleSection(section.label)}
                    className="flex items-center gap-1 flex-1"
                  >
                    {section.icon && (
                      <span
                        className={`flex items-center justify-center ${
                          isSidebarExpanded ? "w-5 h-5 mr-1" : "w-5 h-5"
                        } text-green-600 dark:text-green-400`}
                      >
                        {React.createElement(
                          // @ts-ignore
                          require("lucide-react")[section.icon],
                          { className: isSidebarExpanded ? "w-5 h-5 mr-1" : "w-5 h-5", strokeWidth: 3 }
                        )}
                      </span>
                    )}
                    {isSidebarExpanded && (
                      <span className="text-sm font-bold leading-tight text-gray-700 dark:text-gray-100">
                        {section.label}
                      </span>
                    )}
                  </button>
                )}

                {/* Chevron (toggles only) */}
                {isSidebarExpanded && (
                  <motion.span
                    onClick={() => toggleSection(section.label)}
                    animate={{ rotate: isOpen ? 90 : 0 }}
                    transition={{ type: "spring", stiffness: 300, damping: 20 }}
                    className="text-gray-500 dark:text-gray-400 cursor-pointer"
                  >
                    <ChevronRightIcon className="w-4 h-4" />
                  </motion.span>
                )}
              </div>

              {/* Submenu Items */}
              {isOpen && (
                <ul className="space-y-1">
                  {renderedSidebarItems
                    .filter((item) => item.section === section.label)
                    .map(({ key, label, link, iconComponent, isActive }) => (
                      <li key={key}>
                        <Link
                          href={link}
                          className={`relative group flex items-center gap-3 px-3 py-2 rounded-md font-medium transition-all
                            ${
                              isActive
                                ? "bg-green-100 dark:bg-green-900 text-green-700 dark:text-green-300"
                                : "text-gray-700 dark:text-gray-300 hover:bg-gray-100 dark:hover:bg-gray-700"
                            }`}
                          title={isSidebarExpanded ? "" : label}
                          onClick={onMobileToggle}
                        >
                          {isActive && (
                            <motion.span
                              layoutId="activeIndicator"
                              className="absolute left-0 top-0 bottom-0 w-1 rounded-r bg-green-600"
                            />
                          )}
                          <span className="flex items-center justify-center w-4 h-4 text-green-600 dark:text-green-400">
                            {iconComponent}
                          </span>
                          {isSidebarExpanded && (
                            <span className="text-sm">
                              {highlightMatch(label, searchTerm)}
                            </span>
                          )}
                        </Link>
                      </li>
                    ))}
                </ul>
              )}
            </li>
          );
        })}
      </ul>

      {/* ✅ PROFILE SECTION */}
      {user && (
        <Link
          href="/login/profile"
          className="mx-2 mb-3 mt-auto rounded-xl border border-gray-200 dark:border-gray-700 
          bg-gray-50 dark:bg-gray-900 hover:bg-gray-200 dark:hover:bg-gray-800 
          transition-all shadow-sm p-3 flex items-center gap-3"
        >
          <UserCircleIcon className="w-9 h-9 text-gray-600 dark:text-gray-300" />
          {isSidebarExpanded && (
            <div>
              <span className="block text-sm font-medium text-gray-700 dark:text-gray-200">
                {user.name || "User"}
              </span>
              <span className="block text-xs text-gray-500 dark:text-gray-400">
                {user.role || "Role"}
              </span>
            </div>
          )}
        </Link>
      )}

      {/* LOGOUT */}
      <div className="px-3 pb-4">
        <motion.button
          whileHover={{ scale: 1.05 }}
          whileTap={{ scale: 0.95 }}
          onClick={handleLogout}
          className="flex items-center gap-3 w-full px-3 py-2 rounded-lg
          bg-red-50 dark:bg-red-900/30 text-red-600 dark:text-red-300
          hover:bg-red-100 dark:hover:bg-red-800/50 transition-colors shadow-sm"
          title={isSidebarExpanded ? "" : "Logout"}
        >
          <LogOutIcon className="w-5 h-5" />
          {isSidebarExpanded && <span className="text-sm">Logout</span>}
        </motion.button>
      </div>
    </motion.aside>
  );
}
