"use client";

import { ShieldCheck, Gavel, LifeBuoy } from "lucide-react";

export default function Footer() {
  return (
    <footer className="mt-auto border-t border-gray-200 dark:border-gray-700 bg-white dark:bg-gray-800 px-4 sm:px-6 lg:px-8 py-4 text-sm text-gray-600 dark:text-gray-400 sticky top-[100vh]">
      <div className="max-w-7xl mx-auto flex flex-col sm:flex-row items-center sm:items-center justify-between gap-2 sm:gap-4 w-full">
        <div className="flex gap-4 justify-center sm:justify-start w-full sm:w-auto">
          <a
            href="/privacy"
            className="flex items-center gap-1 hover:text-green-600 dark:hover:text-green-400 transition-colors duration-200"
          >
            <ShieldCheck className="w-4 h-4" /> Privacy
          </a>
          <a
            href="/terms"
            className="flex items-center gap-1 hover:text-green-600 dark:hover:text-green-400 transition-colors duration-200"
          >
            <Gavel className="w-4 h-4" /> Terms
          </a>
          <a
            href="/support"
            className="flex items-center gap-1 hover:text-green-600 dark:hover:text-green-400 transition-colors duration-200"
          >
            <LifeBuoy className="w-4 h-4" /> Support
          </a>
        </div>
        <p className="text-sm text-center sm:text-right w-full sm:w-auto">
          &copy; {new Date().getFullYear()}{' '}
          <span className="font-semibold text-gray-700 dark:text-gray-200">QMS System</span>. All rights reserved.
        </p>
      </div>
    </footer>
  );
}
