@extends('layouts.master')

@section('content')
    <div class="page-wrapper">
        <div class="content container-fluid">
            <div class="page-header">
                <div class="row align-items-center">
                    <div class="col">
                        <h3 class="page-title">Projects</h3>
                        <ul class="breadcrumb">
                            <li class="breadcrumb-item"><a href="index.html">Dashboard</a></li>
                            <li class="breadcrumb-item active">Projects</li>
                        </ul>
                    </div>
                    @if (Auth::user()->role_name == 'Admin')
                    
                    <div class="col-auto float-right ml-auto">
                        <button class="btn add-btn" data-toggle="modal" data-target="#add_project_modal">
                            <i class="fa fa-plus"></i> Create Project
                        </button>
                    </div>
                    @endif
                </div>
            </div>
            
@if ($errors->any())
    <div class="alert alert-danger">
        <ul>
            @foreach ($errors->all() as $error)
                <li>{{ $error }}</li>
            @endforeach
        </ul>
    </div>
@endif

            <!-- Projects Table -->
            <div class="table-responsive">
                <table id="projectTable" class="table table-striped">
                    <thead>
                        <tr>
                            <th>Project ID</th>
                            <th>Project Name</th>
                            <th>Client</th>
                            <th>Assigned Group</th>
                            <th>Assigned To</th>
                            <th>Status</th>
                            <th>Actions</th>
                        </tr>
                    </thead>
                    <tbody>
                        @foreach ($projects as $index => $project)
                            <tr>
                                <td>{{ $loop->iteration }}</td>
                                <td>{{ $project->project_name }}</td>
                                <td>{{ $project->client->first_name }}</td>
                                <!-- $project->group->name  ?  -->
                                <td> {{ collect($groups)->firstWhere('id', $project->assigned_group_id)['department'] ?? '' }}</td>
                                <td>{{ $project->assignedTo->name }}</td>
                                <td>{{ $project->status }}</td>
                                <td>
                                    <button class="btn btn-primary edit-btn" data-id="{{ $project->id }}" data-toggle="modal" data-target="#add_project_modal">
                                        <i class="fa fa-edit"></i> 
                                    </button>
                                    <form action="{{ route('projects.destroy', $project->id) }}" method="POST" style="display:inline;">
                                        @csrf
                                        @method('DELETE')
                                        <button class="btn btn-danger" type="submit">
                                            <i class="fa fa-trash"></i> 
                                        </button>
                                    </form>
                                </td>
                            </tr>
                        @endforeach
                    </tbody>
                </table>
            </div>
        </div>
    </div>

    <!-- Add/Edit Project Modal -->
    <div id="add_project_modal" class="modal fade" tabindex="-1" role="dialog">
        <div class="modal-dialog modal-dialog-centered modal-lg">
            <div class="modal-content">
                <div class="modal-header">
                    <h5 class="modal-title">Add Project</h5>
                    <button type="button" class="close" data-dismiss="modal" aria-label="Close">
                        <span aria-hidden="true">&times;</span>
                    </button>
                </div>
                <div class="modal-body">
                    <form id="projectForm" method="POST" action="{{ route('projects.store') }}" enctype="multipart/form-data">
                        @csrf
                        
                        <input type="hidden" name="project_id" id="project_id">
                        
                        <div class="form-group">
                            <label for="project_name">Project Name</label>
                            <input type="text" class="form-control" id="project_name" name="project_name" required>
                        </div>
                        <div class="form-group">
                            <label for="client_name">Client</label>
                            <select class="form-control" id="client_name" name="client_id" required>
                                @foreach ($clients as $client)
                                    <option value="{{ $client->id }}">{{ $client->first_name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
    <label for="assigned_group">Assigned Group</label>
    <select class="form-control" id="assigned_group" name="assigned_group_id" required>
        @foreach ($groups as $group)
            <option value="{{ $group['id'] }}">{{ $group['department'] }}</option>
        @endforeach
    </select>
</div>

                        <div class="form-group">
                            <label for="assigned_to">Assigned To</label>
                            <select class="form-control" id="assigned_to" name="assigned_to_id" required>
                                @foreach ($users as $user)
                                    <option value="{{ $user->id }}">{{ $user->name }}</option>
                                @endforeach
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="status">Status</label>
                            <select class="form-control" id="status" name="status" required>
                                <option value="Active">Active</option>
                                <option value="Completed">Completed</option>
                                <option value="Pending">Pending</option>
                            </select>
                        </div>
                        <div class="form-group">
                            <label for="start_date">Start Date</label>
                            <input type="date" class="form-control" id="start_date" name="start_date" required>
                        </div>
                        <div class="form-group">
                            <label for="end_date">End Date</label>
                            <input type="date" class="form-control" id="end_date" name="end_date" required>
                        </div>
                        <div class="form-group">
                            <label for="project_logo">Project Logo</label>
                            <input type="file" class="form-control" id="project_logo" name="project_logo">
                        </div>
                            <!-- Image preview section -->
                            <div id="imagePreviewContainer" style="display: none; margin-top: 10px;">
                                <img id="imagePreview" src="" alt="Project Logo" style="max-width: 100px; height: auto; border-radius: 5px;">
                            </div>
                        <div class="form-group">
                            <label for="description">Description</label>
                            <textarea class="form-control" id="description" name="description" required></textarea>
                        </div>
                        
                        <div class="modal-footer">
                            <button type="submit" class="btn btn-primary">Save Project</button>
                            <button type="button" class="btn btn-secondary" data-dismiss="modal">Cancel</button>
                        </div>
                    </form>
                </div>
            </div>
        </div>
    </div>

@endsection

@section('script')
    <script>
        $(document).ready(function() {
            let setUrl = null;
            // Initialize DataTables
            $('#projectTable').DataTable();

            $('.add-btn').on('click', function() {
            setUrl = "<?= route('projects.store' ) ?>";
            $('#projectForm').attr('action',setUrl).attr('method','POST');
            $('#modal-title').text('Add Project');
            $('#projectForm')[0].reset();
            $('#imagePreviewContainer').hide();

        });

            // Handle Edit button click
            $('.edit-btn').click(function() {
                var projectId = $(this).data('id');
                setUrl = "<?= route('projects.update', ['project'=>':id']) ?>".replace(':id', projectId);
                $.ajax({
                    url: '/projects/edit',
                    method: 'POST',
                    data: {id:projectId,
                        _token:'{{ csrf_token() }}'
                    },
                    success: function(response) {
                        console.log(response);
                        // Fill the modal with data from the project
                        var project = response.project;
                        $('#project_id').val(project.id);
                        $('#project_name').val(project.project_name);
                        $('#client_name').val(project.client_id);
                        $('#assigned_group').val(project.assigned_group_id);
                        $('#assigned_to').val(project.assigned_to_id);
                        $('#status').val(project.status);
                        $('#start_date').val(project.start_date);
                        $('#end_date').val(project.end_date);
                        $('#description').val(project.description);
                        
                        $('#projectForm').attr('action',setUrl).attr('method','POST');
                        // Change modal title to 'Edit Project'
                        $('#add_project_modal .modal-title').text('Edit Project');

                        if (project.project_logo) {
                            $('#imagePreview').attr('src', '/images/projects/' + project.project_logo);
                            $('#imagePreviewContainer').show();
                        } else {
                            $('#imagePreviewContainer').hide();
                        }

                        // Set form action to update route
                        // $('#projectForm').attr('action', '/projects/' + project.id);
                       
                    }
                });
            });
        });
    </script>
@endsection
