title: SilverStripe Documentation
introduction: Welcome to the SilverStripe Developer Documentation. This website is aimed at website developers looking to learn how to build and manage web applications with the SilverStripe Framework.

## Getting Started with SilverStripe

Before you start developing your first web application, you'll need to install the latest version of SilverStripe onto 
a web server. The [Getting Started](/getting_started) section will show you what 
[server requirements](/getting_started/server_requirements) you will need to meet and how to 
[download and install SilverStripe](/getting_started/installation).

To check out the features that SilverStripe offers without installing it, read the [Feature Overview](http://www.silverstripe.org/software/) 
and play with the interactive [demo website](http://demo.silverstripe.org/).

##  Getting support

SilverStripe has an wide range of options for getting support. The [forums](http://www.silverstripe.org/community/forums/) 
and [IRC channel](http://irc.silverstripe.org/) are the best places to talk and discuss questions and problems with the
community. There are also several other websites with SilverStripe documentation to make use of. 

* The [API Documentation](http://api.silverstripe.org/) contains technical reference and class information. 
* The [User Help](http://userhelp.silverstripe.com) website contains documentation related to working within the CMS. 

New features, API changes and the development [roadmap](http://www.silverstripe.org/roadmap/) for the product are 
discussed on the [core mailinglist](https://groups.google.com/forum/#!forum/silverstripe-dev) along with 
[UserVoice](http://silverstripe.uservoice.com/forums/251266-new-features).


## Building your first SilverStripe Web application

Once you have completed the [Getting Started](/getting_started) guide and have got SilverStripe
installed and running, the following [Tutorials](http://silverstripe.org/learn/lessons) will lead through the basics and core concepts of 
SilverStripe.

Make sure you know the basic concepts of PHP5 before attempting to follow the tutorials. If you have not programmed with PHP5 be sure to read the [Introduction to PHP5 (zend.com)](http://devzone.zend.com/6/php-101--php-for-the-absolute-beginner).


## SilverStripe Concepts

The [Developer Gudes](/developer_guides) contain more detailed documentation on certain SilverStripe topics, 'how to'
examples and reference documentation.

[CHILDREN Folder=02_Developer_Guides]

## Contributing to SilverStripe

The SilverStripe Framework, Content Management System and related websites are open source and welcome community 
contributions.

[CHILDREN Folder=05_Contributing]
