# 3.0.1-rc1 #

## Overview ##

3.0.1 RC1 Fixes issues that weren't severe enough to prevent the release of 3.0.0, or which
have come up in testing since the 3.0.0 release, with special focus on CMS state updating
and data consistency.

## Upgrading ##

See [3.0.0](/changelogs/3.0.0) for previous details.

## Changelog ##

### API Changes

 * 2012-07-23 [b769107](https://github.com/silverstripe/sapphire/commit/b769107) Prep forForeignID for immutability in 3.1 per 7673 (Hamish Friedlander)
 * 2012-07-20 [e8e4604](https://github.com/silverstripe/sapphire/commit/e8e4604) Prep DataList for immutability in 3.1 per 7673 (Hamish Friedlander)
 * 2012-07-20 [1ed41b8](https://github.com/silverstripe/sapphire/commit/1ed41b8) Prep ArrayList for immutability in 3.1 per 7673 (Hamish Friedlander)
 * 2012-07-18 [a38bfc5](https://github.com/silverstripe/sapphire/commit/a38bfc5) Deprecate EnumField::Lower() and EnumField::Upper() to LowerCase() and UpperCase() for consistency with StringField (Will Rossiter)
 * 2012-07-10 [eef67b6](https://github.com/silverstripe/sapphire/commit/eef67b6) Clean up the return values for getCurrentLink (Mateusz Uzdowski)
 * 2012-07-01 [f1db65d](https://github.com/silverstripe/sapphire/commit/f1db65d) add api for setting a custom template on a RSS feed. (Will Rossiter)
 * 2012-07-01 [f9ea543](https://github.com/silverstripe/sapphire/commit/f9ea543) add SecurityToken::reset() as a shortcut for regenerating a secure token. (Will Rossiter)
 * 2012-06-29 [16cb504](https://github.com/silverstripe/sapphire/commit/16cb504) add $includeGetVars flag for SS_HTTPRequest() to return the URL with the attached GET parameters. (Will Rossiter)
 * 2012-06-27 [2b31f4a](https://github.com/silverstripe/sapphire/commit/2b31f4a) New commit tagging rules in contrib guidelines (Ingo Schommer)

### Features and Enhancements

 * 2012-07-18 [09067cc](https://github.com/silverstripe/sapphire/commit/09067cc) Open first tab with validation errors (Ingo Schommer)
 * 2012-07-17 [120de7c](https://github.com/silverstripe/sapphire/commit/120de7c) Tree node updates after save (fixes #7450, #7389) (Ingo Schommer)
 * 2012-07-15 [d571cdc](https://github.com/silverstripe/sapphire/commit/d571cdc) Hide the search bar in Chosen dropdown fields when list is reasonably short. (unclecheese)
 * 2012-07-13 [155758f](https://github.com/silverstripe/sapphire/commit/155758f) Save and restore tab state upon CMS navigation (fixes #7647) (Ingo Schommer)
 * 2012-07-13 [b3787dc](https://github.com/silverstripe/silverstripe-installer/commit/b3787dc) phing translations-mergeback (Ingo Schommer)
 * 2012-07-12 [57c615d](https://github.com/silverstripe/silverstripe-cms/commit/57c615d) Reinstated filters in ReportAdmin (Ingo Schommer)
 * 2012-07-05 [683d420](https://github.com/silverstripe/sapphire/commit/683d420) Database-&gt;supportsTimezoneOverride() (Ingo Schommer)
 * 2012-07-04 [eb733de](https://github.com/silverstripe/sapphire/commit/eb733de) Add set config method to GridField. (Andrew Short)
 * 2012-06-29 [c282190](https://github.com/silverstripe/sapphire/commit/c282190) Add YamlFixture String argument support (Michał Ochman)
 * 2012-06-28 [0236a3c](https://github.com/silverstripe/sapphire/commit/0236a3c) Docs for form validation (incl. HTML5 types) and model validatoin (Ingo Schommer)
 * 2012-06-27 [34a2ce2](https://github.com/silverstripe/sapphire/commit/34a2ce2) Documentation for Versioned (Ingo Schommer)
 * 2012-06-26 [d935a74](https://github.com/silverstripe/sapphire/commit/d935a74) Modify GridFieldLevelup to be more reusable (Naomi Guyer)
 * 2012-06-26 [ef651d9](https://github.com/silverstripe/silverstripe-cms/commit/ef651d9) Add GridfieldLevelup component to files area (Naomi Guyer)
 * 2012-06-25 [e2d7352](https://github.com/silverstripe/sapphire/commit/e2d7352) File::get_app_category() (mightycoco)
 * 2012-06-21 [01062c7](https://github.com/silverstripe/sapphire/commit/01062c7) Add back CountryDropdownField (Hamish Friedlander)
 * 2012-06-17 [77d7122](https://github.com/silverstripe/sapphire/commit/77d7122) Add method to disable automatic limiting on PaginagedLists. (Andrew Short)
 * 2012-06-17 [060fca5](https://github.com/silverstripe/sapphire/commit/060fca5) Add method to disable automatic limiting on PaginagedLists. (Andrew Short)

### Bugfixes

 * 2012-07-25 [b39744c](https://github.com/silverstripe/silverstripe-installer/commit/b39744c) translations-sync was failing due to leakage (Hamish Friedlander)
 * 2012-07-25 [b25b45a](https://github.com/silverstripe/sapphire/commit/b25b45a) Fix i18nTextCollector restriction to specific modules (Hamish Friedlander)
 * 2012-07-24 [6225f9c](https://github.com/silverstripe/silverstripe-installer/commit/6225f9c) Remove the xml brackets from the string. Breaks phing. (Mateusz Uzdowski)
 * 2012-07-23 [22d6c7a](https://github.com/silverstripe/sapphire/commit/22d6c7a) Updating node would position wrong, Sort isnt === offset (Hamish Friedlander)
 * 2012-07-23 [e160b76](https://github.com/silverstripe/sapphire/commit/e160b76) 7362 dont include trailing space in bare string (Hamish Friedlander)
 * 2012-07-21 [15dbfe8](https://github.com/silverstripe/sapphire/commit/15dbfe8) typo in docs (via Joe Harvey). (Will Rossiter)
 * 2012-07-19 [b57f2bd](https://github.com/silverstripe/sapphire/commit/b57f2bd) UploadField does not work on DataObjects (unclecheese)
 * 2012-07-19 [35cc658](https://github.com/silverstripe/sapphire/commit/35cc658) Make RequestProcessor-&gt;filters settable as a property too (Hamish Friedlander)
 * 2012-07-18 [3156e75](https://github.com/silverstripe/sapphire/commit/3156e75) Redisplay CMS forms with validation errors (Ingo Schommer)
 * 2012-07-18 [498a3fd](https://github.com/silverstripe/sapphire/commit/498a3fd) Fixed i18n text collection in templates (Ingo Schommer)
 * 2012-07-18 [9e1f742](https://github.com/silverstripe/sapphire/commit/9e1f742) open ticket 7678 fixing usable_tags to send an array to ArrayList (Kirk Mayo)
 * 2012-07-18 [f7b6f1d](https://github.com/silverstripe/silverstripe-cms/commit/f7b6f1d) ticket #5239 - Infinite loop: live subpage of draft page redirects onto itself when called just by url segment (carlos barberis)
 * 2012-07-18 [e8cd675](https://github.com/silverstripe/sapphire/commit/e8cd675) trac 7482 couldnt publish composite fields to live (Hamish Friedlander)
 * 2012-07-18 [6992863](https://github.com/silverstripe/sapphire/commit/6992863) trac 7482, we werent unlazying composite fields right (Hamish Friedlander)
 * 2012-07-17 [70dcb55](https://github.com/silverstripe/sapphire/commit/70dcb55) Use prepStringForDB consistently across the framework. (Mateusz Uzdowski)
 * 2012-07-16 [2bd9852](https://github.com/silverstripe/sapphire/commit/2bd9852) ed spelling of "Maori" in lang selection (Ingo Schommer)
 * 2012-07-16 [b15faba](https://github.com/silverstripe/silverstripe-cms/commit/b15faba) open ticket 5880 always show the current page type in the page type dropdown list (Kirk Mayo)
 * 2012-07-15 [b9ed6f7](https://github.com/silverstripe/sapphire/commit/b9ed6f7) When Chosen dropdowns are instantiated on hidden tabs, the width is rendered very small and they are unreadable. This is a known bug in Chosen. A change has been proposed at the Chosen page here: https://github.com/harvesthq/chosen/issues/92 but no pull request has been executed. (unclecheese)
 * 2012-07-15 [b4ecc30](https://github.com/silverstripe/sapphire/commit/b4ecc30) Enforce startClosed prop on ToggleCompositeField (Ingo Schommer)
 * 2012-07-15 [c555256](https://github.com/silverstripe/sapphire/commit/c555256) PaginatedList::getIterator() trims the original list to the page lenght when the source list is DataList (Saophalkun Ponlu)
 * 2012-07-13 [84ad9b5](https://github.com/silverstripe/silverstripe-cms/commit/84ad9b5) Retain page search state on list view actions (fixes #7648) (Ingo Schommer)
 * 2012-07-13 [b74178e](https://github.com/silverstripe/silverstripe-cms/commit/b74178e) Reload full view in admin/settings to avoid tabs breaking (Ingo Schommer)
 * 2012-07-13 [a5a0853](https://github.com/silverstripe/sapphire/commit/a5a0853) Force "full" ajax content reload with invalid fragments (Ingo Schommer)
 * 2012-07-12 [7a52a7f](https://github.com/silverstripe/sapphire/commit/7a52a7f) Default form submits to text/html, fixing validation (#7653) (Ingo Schommer)
 * 2012-07-12 [8055fc2](https://github.com/silverstripe/silverstripe-cms/commit/8055fc2) Corrected page edit links in reports (Ingo Schommer)
 * 2012-07-12 [54fd54a](https://github.com/silverstripe/silverstripe-cms/commit/54fd54a) Change all shortcodes into the new, comma separated, format. (Mateusz Uzdowski)
 * 2012-07-12 [c785f3c](https://github.com/silverstripe/sapphire/commit/c785f3c) Adjust the tree construction and triggers to work with IE. (Mateusz Uzdowski)
 * 2012-07-12 [7c41ff2](https://github.com/silverstripe/sapphire/commit/7c41ff2) Change all shortcodes into the new, comma separated, format. (Mateusz Uzdowski)
 * 2012-07-11 [ac45825](https://github.com/silverstripe/sapphire/commit/ac45825) fixed alignment of radio buttons on add page pane trac/7473 (Kirk Mayo)
 * 2012-07-11 [e096c29](https://github.com/silverstripe/sapphire/commit/e096c29) open ticket 7603 fixing search filtering - thought I should initialise $dataListClone (Jeremy Bridson)
 * 2012-07-10 [d77c43d](https://github.com/silverstripe/silverstripe-cms/commit/d77c43d) CMS pages list view link targets (fixes #7589) (Ingo Schommer)
 * 2012-07-10 [4a9c6d1](https://github.com/silverstripe/sapphire/commit/4a9c6d1) fixed action buttons on edit page content - stopped them from overlapping in ie8. (Kirk Mayo)
 * 2012-07-10 [630ab87](https://github.com/silverstripe/sapphire/commit/630ab87) fixed the misaligned edit and delete buttons in gridfield Trac 7527 (Kirk Mayo)
 * 2012-07-05 [78038eb](https://github.com/silverstripe/sapphire/commit/78038eb) 7617: Back button in CMS after Add/Edit/View action in GridField does not work (jakr)
 * 2012-07-04 [2069695](https://github.com/silverstripe/sapphire/commit/2069695) Ticket #7592 GridFieldDataColumns: Wrong documentation for getFieldCasting Moved documentation to the appropriate function, added note about the two parameter callback function. (jakr)
 * 2012-07-04 [9d88169](https://github.com/silverstripe/sapphire/commit/9d88169) open/6875 removing DataGrid filter fields from track changes (Kirk Mayo)
 * 2012-07-02 [890f7e3](https://github.com/silverstripe/sapphire/commit/890f7e3) $db in extensions not inited early enough (#7598) (Hamish Friedlander)
 * 2012-07-01 [a4ff1d3](https://github.com/silverstripe/sapphire/commit/a4ff1d3) check GetRandom() exists for RandomGenerator (Sean Harvey)
 * 2012-06-29 [db47dcf](https://github.com/silverstripe/silverstripe-cms/commit/db47dcf) ed url concat in SiteTreURLSegmentField.js (Ingo Schommer)
 * 2012-06-29 [4977318](https://github.com/silverstripe/sapphire/commit/4977318) ensure RestfulServiceTest uses email as the unique identifer field for running tests. Fixes: #6156. (Will Rossiter)
 * 2012-06-29 [4ee709e](https://github.com/silverstripe/sapphire/commit/4ee709e) ensure limits to SQLQuery are passed as positive values (Will Rossiter)
 * 2012-06-29 [48408d3](https://github.com/silverstripe/sapphire/commit/48408d3) exclude error string in headers to prevent white screen display. (Will Rossiter)
 * 2012-06-29 [0910a65](https://github.com/silverstripe/sapphire/commit/0910a65) restore and update style for DevelopmentAdmin. (Will Rossiter)
 * 2012-06-29 [040f780](https://github.com/silverstripe/silverstripe-cms/commit/040f780) Allow children on RedirectorPage (Trac #7587) (Sam Minnee)
 * 2012-06-29 [8d67028](https://github.com/silverstripe/sapphire/commit/8d67028) Santise model classes in ModelAdmin (Simon Welsh)
 * 2012-06-29 [5271504](https://github.com/silverstripe/sapphire/commit/5271504) ed changelog links (Sam Minnee)
 * 2012-06-28 [19e087d](https://github.com/silverstripe/sapphire/commit/19e087d) ed references to deprecated APIs in docs (Ingo Schommer)
 * 2012-06-28 [3141e71](https://github.com/silverstripe/sapphire/commit/3141e71) notify PaginatedList the full-text results are already limited. (Mateusz Uzdowski)
 * 2012-06-28 [b654b95](https://github.com/silverstripe/sapphire/commit/b654b95) Allow Versioned::get_latest_version() and Version::get_version() to return results if the classname has changed. (Sam Minnee)
 * 2012-06-26 [81c085f](https://github.com/silverstripe/sapphire/commit/81c085f) ed width of DateField with dmyfields=true (ARNHOE)
 * 2012-06-25 [84d97b6](https://github.com/silverstripe/sapphire/commit/84d97b6) updated oembedUrl app_category check (mightycoco)
 * 2012-06-25 [e582935](https://github.com/silverstripe/sapphire/commit/e582935) insertion of images (trac #7438) (mightycoco)
 * 2012-06-25 [5c6ec68](https://github.com/silverstripe/sapphire/commit/5c6ec68) Min-width on html dialog box (fixes #7541) (Naomi Guyer)
 * 2012-06-25 [e51bf76](https://github.com/silverstripe/sapphire/commit/e51bf76) Insert link styling broken, and inconsistent with Insert media (fixes #7528) (Naomi Guyer)
 * 2012-06-25 [cd0a1ff](https://github.com/silverstripe/sapphire/commit/cd0a1ff) DataQuery::applyRelation was returning the base class. (Simon Welsh)
 * 2012-06-25 [070ba56](https://github.com/silverstripe/sapphire/commit/070ba56) DataQuery::applyRelation was returning the base class. (Simon Welsh)
 * 2012-06-22 [ba9c3c7](https://github.com/silverstripe/sapphire/commit/ba9c3c7) Type checking in CMS URL params (fixes #7187) (Ingo Schommer)
 * 2012-06-21 [1197a2f](https://github.com/silverstripe/sapphire/commit/1197a2f) Media styles in IE9 (fixes #4 of #7497) (Naomi Guyer)
 * 2012-06-21 [d384538](https://github.com/silverstripe/sapphire/commit/d384538) Padding in navigation elements in IE7 (Naomi Guyer)

### Other

 * 2012-07-25 [981352d](https://github.com/silverstripe/sapphire/commit/981352d) Updated translations (Hamish Friedlander)
 * 2012-07-25 [3a01ae6](https://github.com/silverstripe/silverstripe-cms/commit/3a01ae6) Updated translations (Hamish Friedlander)
 * 2012-07-25 [6b20bc8](https://github.com/silverstripe/silverstripe-cms/commit/6b20bc8) Add javascript japanese translation - thanks Yuki Awano (Hamish Friedlander)
 * 2012-07-25 [dc18c51](https://github.com/silverstripe/sapphire/commit/dc18c51) Add javascript japanese translation - thanks Yuki Awano (Hamish Friedlander)
 * 2012-07-23 [1717e40](https://github.com/silverstripe/silverstripe-cms/commit/1717e40) Always show badge on current page in side tree (Hamish Friedlander)
 * 2012-07-23 [ace2dfe](https://github.com/silverstripe/silverstripe-cms/commit/ace2dfe) Make compass not include line number comments (Hamish Friedlander)
 * 2012-07-21 [62e897b](https://github.com/silverstripe/sapphire/commit/62e897b) Update db/build url in docs. (Will Rossiter)
 * 2012-07-20 [c9b3430](https://github.com/silverstripe/sapphire/commit/c9b3430) Update docs to indicate lists not mutable as per 7673 (Hamish Friedlander)
 * 2012-07-20 [34fdad8](https://github.com/silverstripe/sapphire/commit/34fdad8) typo in RSS feed. (Mateusz Uzdowski)
 * 2012-07-18 [ac59895](https://github.com/silverstripe/sapphire/commit/ac59895) Validation error styling in CMS (Ingo Schommer)
 * 2012-07-18 [abc87a4](https://github.com/silverstripe/silverstripe-cms/commit/abc87a4) Localized CMS breadcrumbs title (Ingo Schommer)
 * 2012-07-18 [faff2c1](https://github.com/silverstripe/sapphire/commit/faff2c1) Localized CMS breadcrumbs title (Ingo Schommer)
 * 2012-07-17 [2ba3fbe](https://github.com/silverstripe/silverstripe-cms/commit/2ba3fbe) 'updatetreenodes' URL in tree template (#7450) (Ingo Schommer)
 * 2012-07-17 [1a91431](https://github.com/silverstripe/sapphire/commit/1a91431) Query param searches for GridFieldAddExistingAutocompleter (Ingo Schommer)
 * 2012-07-17 [8c0a853](https://github.com/silverstripe/sapphire/commit/8c0a853) Limit the results shown in the autocompleter. (Andrew Short)
 * 2012-07-17 [8d38551](https://github.com/silverstripe/sapphire/commit/8d38551) Don't change track autocompleter fields. (Andrew Short)
 * 2012-07-16 [a033ddf](https://github.com/silverstripe/sapphire/commit/a033ddf) More init checks in HtmlEditorField.js (Ingo Schommer)
 * 2012-07-16 [d4b8db2](https://github.com/silverstripe/sapphire/commit/d4b8db2) Marking fake LeftAndMain-&gt;redirect() responses as finished (Ingo Schommer)
 * 2012-07-16 [bbfa54c](https://github.com/silverstripe/sapphire/commit/bbfa54c) Allow custom preview URLs through hidden fields (Ingo Schommer)
 * 2012-07-15 [69e4fa0](https://github.com/silverstripe/silverstripe-cms/commit/69e4fa0) Toggle metadata fields in SiteTree-&gt;getCMSFields() (Ingo Schommer)
 * 2012-07-15 [b42a76b](https://github.com/silverstripe/sapphire/commit/b42a76b) Fluent interface for ToggleCompositeField (Ingo Schommer)
 * 2012-07-15 [aa76aca](https://github.com/silverstripe/sapphire/commit/aa76aca) Update extend cms docs to include 3.0 API change. (Will Rossiter)
 * 2012-07-13 [3ff0c42](https://github.com/silverstripe/silverstripe-cms/commit/3ff0c42) Ignore ajaxified tabsets on tab state saving (Ingo Schommer)
 * 2012-07-13 [b93e2bb](https://github.com/silverstripe/silverstripe-cms/commit/b93e2bb) Remove .ss-tabset class from CMSMain forms, confuses tab state setting. (Ingo Schommer)
 * 2012-07-13 [bf91594](https://github.com/silverstripe/sapphire/commit/bf91594) Disable tab state logic on uninit'ed tabs, allow opt-out (Ingo Schommer)
 * 2012-07-13 [c493dc7](https://github.com/silverstripe/sapphire/commit/c493dc7) Avoid lonely question mark for GridField URLs in CMS (Ingo Schommer)
 * 2012-07-13 [44c237c](https://github.com/silverstripe/silverstripe-cms/commit/44c237c) Adding DOM ids for all tabsets to aid saving their state (Ingo Schommer)
 * 2012-07-13 [d45b33e](https://github.com/silverstripe/sapphire/commit/d45b33e) Docs about merging back translations (Ingo Schommer)
 * 2012-07-13 [e0d99e2](https://github.com/silverstripe/silverstripe-cms/commit/e0d99e2) Updated translations (Ingo Schommer)
 * 2012-07-13 [d0faad1](https://github.com/silverstripe/sapphire/commit/d0faad1) Updated translations (Ingo Schommer)
 * 2012-07-13 [712f28b](https://github.com/silverstripe/sapphire/commit/712f28b) Scoped deprecation messages (fixes #7645) (Ingo Schommer)
 * 2012-07-12 [8d3d3a7](https://github.com/silverstripe/sapphire/commit/8d3d3a7) Typo in the Filename of the CSS-File (Juerg Rast)
 * 2012-07-11 [f507a51](https://github.com/silverstripe/sapphire/commit/f507a51) Update reference in docs from :Contains to :PartialMatch (Will Rossiter)
 * 2012-07-10 [29a0399](https://github.com/silverstripe/sapphire/commit/29a0399) Refactor the linking functionality for the TinyMCE popup. (Mateusz Uzdowski)
 * 2012-07-06 [bc1c7f7](https://github.com/silverstripe/sapphire/commit/bc1c7f7) Add sorting to GridFieldDetailFormTest fixtures (Ingo Schommer)
 * 2012-07-06 [6466993](https://github.com/silverstripe/sapphire/commit/6466993) Warning when running tests without flush=1 (Ingo Schommer)
 * 2012-07-05 [2be8924](https://github.com/silverstripe/silverstripe-installer/commit/2be8924) Accepting "FIX" notation in changelog generator script (Ingo Schommer)
 * 2012-07-05 [6649034](https://github.com/silverstripe/sapphire/commit/6649034) Mark DBDatetimeTest skipped on wrong offsets, rather than error out. (Ingo Schommer)
 * 2012-07-05 [b3e8696](https://github.com/silverstripe/silverstripe-installer/commit/b3e8696) Enforce flush on CI test runs (Ingo Schommer)
 * 2012-07-05 [c8c84b0](https://github.com/silverstripe/sapphire/commit/c8c84b0) Don't flush manifest in test bootstrap for performance reasons (Ingo Schommer)
 * 2012-07-05 [9ce0c9a](https://github.com/silverstripe/sapphire/commit/9ce0c9a) Relative include path for RailsYAML PHPUnit tests (Ingo Schommer)
 * 2012-07-04 [b6c59f2](https://github.com/silverstripe/sapphire/commit/b6c59f2) Restricting input.time width (ARNHOE)
 * 2012-07-04 [de73db9](https://github.com/silverstripe/sapphire/commit/de73db9) Restructured 3.0 changelog (Ingo Schommer)
 * 2012-07-04 [c8dbcf7](https://github.com/silverstripe/silverstripe-installer/commit/c8dbcf7) PHPUnit XML configs for other db drivers on TeamCity (Ingo Schommer)
 * 2012-07-04 [8548014](https://github.com/silverstripe/sapphire/commit/8548014) CLI bootstrap: Merge existing $_GET and $_REQUEST data (Ingo Schommer)
 * 2012-07-04 [b44ff84](https://github.com/silverstripe/sapphire/commit/b44ff84) Allow multi-line application names. (Andrew Short)
 * 2012-07-01 [2b5214b](https://github.com/silverstripe/sapphire/commit/2b5214b) Summarized 3.0 changes in changelog (jakr)
 * 2012-06-30 [9cfbe9b](https://github.com/silverstripe/sapphire/commit/9cfbe9b) update core controller template with more help information. (Will Rossiter)
 * 2012-06-29 [89079c4](https://github.com/silverstripe/silverstripe-cms/commit/89079c4) Checking for existence of 'Locale' data in CMS controllers (Ingo Schommer)
 * 2012-06-29 [fa62c1b](https://github.com/silverstripe/sapphire/commit/fa62c1b) Smarter concat of query params in LeftAndMain.js (Ingo Schommer)
 * 2012-06-29 [1686636](https://github.com/silverstripe/sapphire/commit/1686636) add flag for combine in order to test Requirements::combine_files() while in dev (Will Rossiter)
 * 2012-06-29 [4424ec6](https://github.com/silverstripe/sapphire/commit/4424ec6) Updated change logs for 3.0.0 stable (Sam Minnee)
 * 2012-06-28 [402297e](https://github.com/silverstripe/sapphire/commit/402297e) Removed outdated docs for SQLQuery and data model techniques (Ingo Schommer)
 * 2012-06-28 [3ef394c](https://github.com/silverstripe/sapphire/commit/3ef394c) Proof reading tutorials 1 and 2 (Ingo Schommer)
 * 2012-06-28 [aa8dfd1](https://github.com/silverstripe/sapphire/commit/aa8dfd1) FileField-&gt;getUpload() and setUpload() (Ingo Schommer)
 * 2012-06-28 [14753e9](https://github.com/silverstripe/sapphire/commit/14753e9) Documentation, tutorial (part2) (Naomi Guyer)
 * 2012-06-28 [2c024e4](https://github.com/silverstripe/sapphire/commit/2c024e4) Documentation, tutorial (part1) (Naomi Guyer)
 * 2012-06-27 [ee71356](https://github.com/silverstripe/sapphire/commit/ee71356) Removed 'subversion' docs (Ingo Schommer)
 * 2012-06-27 [0b31234](https://github.com/silverstripe/sapphire/commit/0b31234) Consolidated template and page-type docs (Ingo Schommer)
 * 2012-06-27 [cb145a0](https://github.com/silverstripe/sapphire/commit/cb145a0) "dmyplaceholders" setting for DateFields (Ingo Schommer)
 * 2012-06-27 [0586143](https://github.com/silverstripe/sapphire/commit/0586143) Added RC3 changelog (Sam Minnee)
 * 2012-06-27 [2a97606](https://github.com/silverstripe/sapphire/commit/2a97606) open/7523 added a note relating to versions and added a missing quote to the changelog for 3.0 (Kirk Mayo)
 * 2012-06-27 [fc2cbcc](https://github.com/silverstripe/sapphire/commit/fc2cbcc) Updating the configuration module with the default database option and corrected a out of date link (Kirk Mayo)
 * 2012-06-26 [218037b](https://github.com/silverstripe/sapphire/commit/218037b) Add .dropdown class to CountryDropdownField to make it use chosen.js (Ingo Schommer)
 * 2012-06-26 [45b2cbf](https://github.com/silverstripe/sapphire/commit/45b2cbf) Using new template controls in docs (Ingo Schommer)
 * 2012-06-26 [a9fa281](https://github.com/silverstripe/sapphire/commit/a9fa281) Form field docs update (fixes #7521) (Ingo Schommer)
 * 2012-06-26 [56a3777](https://github.com/silverstripe/sapphire/commit/56a3777) Improved upgrading docs (fixes #7508) (Ingo Schommer)
 * 2012-06-25 [5cad545](https://github.com/silverstripe/silverstripe-installer/commit/5cad545) Auto conflict merges in phing translation tasks (Ingo Schommer)
 * 2012-06-25 [6dfd99a](https://github.com/silverstripe/silverstripe-installer/commit/6dfd99a) Ignore stash errors in phing build task (Ingo Schommer)
 * 2012-06-25 [bb5e3e5](https://github.com/silverstripe/silverstripe-cms/commit/bb5e3e5) Remove DB dependency from SiteTree-&gt;provideEntities() (Ingo Schommer)
 * 2012-06-25 [029c14b](https://github.com/silverstripe/silverstripe-installer/commit/029c14b) Phing checkout bug when branch doesn't exist (Ingo Schommer)
 * 2012-06-25 [04cf94f](https://github.com/silverstripe/silverstripe-installer/commit/04cf94f) Getlocalization phing target fixes (Ingo Schommer)
 * 2012-06-25 [8c5c922](https://github.com/silverstripe/sapphire/commit/8c5c922) Changelog (Ingo Schommer)
 * 2012-06-22 [3e7bf77](https://github.com/silverstripe/sapphire/commit/3e7bf77) Translation process docs (Ingo Schommer)
 * 2012-06-22 [a997099](https://github.com/silverstripe/sapphire/commit/a997099) I found that I needed to increase nginx buffer size to accommodate the size of the ajax requests (John Milmine)
 * 2012-06-21 [578f6a1](https://github.com/silverstripe/sapphire/commit/578f6a1) Fixed broken links in docs (Ingo Schommer)
 * 2012-06-20 [813ed75](https://github.com/silverstripe/silverstripe-cms/commit/813ed75) Test MenuTitle null'ing (see #7505) (Ingo Schommer)
 * 2012-06-20 [464504a](https://github.com/silverstripe/sapphire/commit/464504a) Updated commit docs (Ingo Schommer)
 * 2012-06-20 [e2c1deb](https://github.com/silverstripe/sapphire/commit/e2c1deb) Chainable Form-&gt;loadDataFrom() (unclecheese)
 * 2012-06-20 [51a1026](https://github.com/silverstripe/sapphire/commit/51a1026) Fixed case sensitive require_once() (broken by 3a01c2ab2) (Ingo Schommer)
 * 2012-06-20 [0ef8253](https://github.com/silverstripe/sapphire/commit/0ef8253) Upgrade TinyMCE dependency from 3.5.1.1 to 3.5.3 (Sean Harvey)
 * 2012-06-20 [1d8c96d](https://github.com/silverstripe/sapphire/commit/1d8c96d) changed sake tasks example to realistic command and added get parameter example to dev/build (John Milmine)
 * 2012-06-20 [7db0e32](https://github.com/silverstripe/sapphire/commit/7db0e32) Remove unnecessarily repeated mixins (Naomi Guyer)
 * 2012-06-18 [78163f9](https://github.com/silverstripe/silverstripe-cms/commit/78163f9) Updated translations master (Ingo Schommer)
 * 2012-06-15 [b27597c](https://github.com/silverstripe/sapphire/commit/b27597c) Removing "functionality below isn't implemented" message in datamodel docs, as these are now implemented. (Sean Harvey)

