# 3.0.0-rc1 #

## Overview ##

### CMS ###

 * Fixed memory leaks in the CMS, by better event delegation, as well as patches to jstree and TinyMCE libraries. Reduced leaks in legacy browsers (IE7/IE8).
 * Better interface consistency after data submissions, e.g. updating breadcrumb titles after saving a page
 
### Framework ###

 * Moved SapphireSoapServer and SOAPModelAccess into its own [module](https://github.com/silverstripe/silverstripe-soapserver)
 * Moved RestfulServer into its own [module](https://github.com/silverstripe/silverstripe-restfulserver)
 * Fixed session issues with subsequent navigation to nested form fields in CMS, e.g. GridField and UploadField
 
## Upgrading ##

See [3.0.0](/changelogs/3.0.0) for previous details.

## Changelog ##

### API Changes

 * 2012-06-15 [9bd7765](https://github.com/silverstripe/sapphire/commit/9bd7765) Renames Transliterator to SS_Transliterator (Simon Welsh)
 * 2012-06-15 [3f01367](https://github.com/silverstripe/sapphire/commit/3f01367) Add Security::ignore_disallowed_actions() to allow site features to be disabled when permissions have failed, rather than redirecting to the log-in form. (Trac #7097) (Sam Minnee)
 * 2012-06-12 [2637969](https://github.com/silverstripe/sapphire/commit/2637969) Renamed JS event from 'reloadeditform' on 'aftersubmitform', 'beforesave' to 'beforesubmitform'. Listening to bubbled event on container to avoid binding to forms which are removed before the event is triggered. (Ingo Schommer)
 * 2012-06-12 [bbd1bb7](https://github.com/silverstripe/sapphire/commit/bbd1bb7) Upgrade jquery entwine (Hamish Friedlander)
 * 2012-06-11 [114ebb6](https://github.com/silverstripe/sapphire/commit/114ebb6) Don't have any instance caching in singleton(), rely on Injector for this. (Sam Minnee)
 * 2012-06-11 [f65a7c6](https://github.com/silverstripe/sapphire/commit/f65a7c6) Remove dodgy DataObject::destroy() behaviour, opting instead for using PHP5.3's garbage collector. (Sam Minnee)
 * 2012-06-04 [9e21fb8](https://github.com/silverstripe/sapphire/commit/9e21fb8) Moved SapphireSoapServer and SOAPModelAccess into its own module at https://github.com/silverstripe/silverstripe-soapserver (fixes #7282) (Ingo Schommer)
 * 2012-06-04 [cb8b118](https://github.com/silverstripe/sapphire/commit/cb8b118) Moved RestfulServer into its own module at https://github.com/silverstripe/silverstripe-restfulserver (fixes #7282) (Ingo Schommer)
 * 2012-05-31 [7fe0858](https://github.com/silverstripe/sapphire/commit/7fe0858) Marked Form::unsetFieldFromTab() as deprecated. Please use Fields() and the FieldList API instead. (Sean Harvey)
 * 2012-05-30 [75e51de](https://github.com/silverstripe/sapphire/commit/75e51de) Moved submitForm() from $('.cms-content') to $('.cms-container'), unifying ajax response handling between panel loading and form submission (Ingo Schommer)
 * 2012-05-30 [948ca46](https://github.com/silverstripe/sapphire/commit/948ca46) Added $value argument as the first argument of a gridfield formattting callback. (Sam Minnee)
 * 2012-05-29 [0821f02](https://github.com/silverstripe/sapphire/commit/0821f02) Added DataList::filterByCallback() to allow filtering by PHP code. (Sam Minnee)
 * 2012-05-29 [70d5ffe](https://github.com/silverstripe/sapphire/commit/70d5ffe) Added GridField::addDataFields() to allow the definition of custom callbacks to be used by all GridField components. API CHANGE: Added GridField::getDataFieldValue() to encapsulate field lookup for all components. API CHANGE: Allow 'callback' key to be specified in a GridFieldDataColumn column info.  In this case, title should be put as the 'title' key of a map rather than simply the column info. (Sam Minnee)
 * 2012-05-29 [780f2d2](https://github.com/silverstripe/sapphire/commit/780f2d2) Added DataQuery::aggregate() to allow for aggregates beyond Min, Max, Avg, Sum. (Sam Minnee)

### Features and Enhancements

 * 2012-06-15 [eff93bd](https://github.com/silverstripe/sapphire/commit/eff93bd) Disable UploadField when handling unsaved relations (fixes #7187) (Ingo Schommer)
 * 2012-06-14 [9139f73](https://github.com/silverstripe/sapphire/commit/9139f73) Added the ability to set a cost (the property was protected before and there were no setters and getters) and enforced the php requirements on the cost string used in the salt of crypt. Specifically, two digit from 04-31. Updated unit tests for blowfish algorithm to actually use the salt generation function and to test the newly implemented cost setting and getting functionality. (Cam Spiers)
 * 2012-06-14 [21e7ec6](https://github.com/silverstripe/sapphire/commit/21e7ec6) In dev mode, include some basic leak detection functions in the admin panel (Hamish Friedlander)
 * 2012-06-14 [e58929d](https://github.com/silverstripe/sapphire/commit/e58929d) Make ToggleCompositeField use new entwine features (Hamish Friedlander)
 * 2012-06-13 [6c1f799](https://github.com/silverstripe/sapphire/commit/6c1f799) HTML titles in TreeDropdownField (Ingo Schommer)
 * 2012-06-13 [d9c7bb8](https://github.com/silverstripe/sapphire/commit/d9c7bb8) Implemented help text for form fields. (Andrew Short)
 * 2012-06-13 [aa67b56](https://github.com/silverstripe/sapphire/commit/aa67b56) Refactored ToggleCompositeField. (Andrew Short)
 * 2012-06-12 [bda7272](https://github.com/silverstripe/silverstripe-cms/commit/bda7272) Show node badges in tree sidebar view on hover (fixes #7410) (Ingo Schommer)
 * 2012-06-12 [ed9c856](https://github.com/silverstripe/sapphire/commit/ed9c856) Strikethrough styling for deleted tree nodes, adding status classes to tree node &lt;li&gt; in addition to the existing &lt;span class="badge"&gt; (fixes #7410) (Ingo Schommer)
 * 2012-06-11 [3ada9a9](https://github.com/silverstripe/sapphire/commit/3ada9a9) Basic css spacing issues (Paul Clarke)
 * 2012-06-11 [e96ca5f](https://github.com/silverstripe/sapphire/commit/e96ca5f) Change media insertion to use button and apply design (Naomi Guyer)
 * 2012-06-08 [c0b3512](https://github.com/silverstripe/sapphire/commit/c0b3512) Oembed.enabled config property (Ingo Schommer)
 * 2012-06-08 [71b3fe5](https://github.com/silverstripe/sapphire/commit/71b3fe5) Updated tutorial documentation (thanks to Cam Findlay and Andy Adiwidjaja) (Andy Adiwidjaja)
 * 2012-06-07 [267f41b](https://github.com/silverstripe/sapphire/commit/267f41b) Point userhelp link at a new userhelp instance. (#7430) (Sam Minnee)
 * 2012-05-30 [ad7c443](https://github.com/silverstripe/silverstripe-cms/commit/ad7c443) Saving tab state for CMSPagesController (Ingo Schommer)
 * 2012-05-30 [c9fc7cd](https://github.com/silverstripe/silverstripe-cms/commit/c9fc7cd) Declaring Pjax fragments on CMS templates and forms (Ingo Schommer)
 * 2012-05-30 [19bfd01](https://github.com/silverstripe/sapphire/commit/19bfd01) Declare a single DOM element with multiple Pjax fragments. Unified ajax response handling in CMS, followup  from submitForm() refactoring. Removed replacement of arbitrary CSS selectors through Pjax, relies on a fragment now (to keep logic consistent). (Ingo Schommer)
 * 2012-05-19 [792c89e](https://github.com/silverstripe/sapphire/commit/792c89e) Adding List() in the GenericTemplateGlobalProvider so templates can use &lt;% cached List(Member).max(LastEdited) %&gt; instead of deprecated "Aggregate" syntax. (Sean Harvey)
 * 2012-04-24 [322d392](https://github.com/silverstripe/silverstripe-installer/commit/322d392) adding checkout for the simple theme to the Phing checkout script (Julian Seidenberg)
 * 2012-04-18 [473eda4](https://github.com/silverstripe/sapphire/commit/473eda4) Allowing multiple fragments to be returned by PjaxResponseNegotiator through JSON (Ingo Schommer)

### Bugfixes

 * 2012-06-17 [417c037](https://github.com/silverstripe/sapphire/commit/417c037) Avoid Session::set() clearing on existing val (fixes #7487) (Ingo Schommer)
 * 2012-06-15 [c8052da](https://github.com/silverstripe/silverstripe-cms/commit/c8052da) Corrected page history pane loading (fixes #7477) (Ingo Schommer)
 * 2012-06-15 [e7ecdf4](https://github.com/silverstripe/silverstripe-cms/commit/e7ecdf4) Fixed page tree view (Sam Minnee)
 * 2012-06-15 [8b83487](https://github.com/silverstripe/sapphire/commit/8b83487) DataList used in SearchContext::getQuery() should be returned so limit() and sort() are applied correctly (Sean Harvey)
 * 2012-06-15 [bfe354d](https://github.com/silverstripe/silverstripe-cms/commit/bfe354d) Disable javascript not used right now because assets don't have batch actions. (Trac #7367) (Sam Minnee)
 * 2012-06-15 [538bcdc](https://github.com/silverstripe/sapphire/commit/538bcdc) Ensure that the DataList is being used correctly when applying filters in HtmlEditorField and Hierarchy (Sean Harvey)
 * 2012-06-15 [f546e0d](https://github.com/silverstripe/sapphire/commit/f546e0d) trac/7462 Amended the css to fix this by adding text-transform: capitialize and display: block to the relevant css (Kirk Mayo)
 * 2012-06-15 [792c905](https://github.com/silverstripe/silverstripe-cms/commit/792c905) Fixed DataList operations to respect the fact that they're idempotent. (Sam Minnee)
 * 2012-06-15 [c801671](https://github.com/silverstripe/sapphire/commit/c801671) #7394: Allow unselect dropdowns in chosen if there's an empty option (Sean Harvey)
 * 2012-06-15 [a1e7c1f](https://github.com/silverstripe/sapphire/commit/a1e7c1f) Updated MySQLDatabase::indexList() to return index columns escaped by double quotes (Sam Minnee)
 * 2012-06-15 [8b2cb9a](https://github.com/silverstripe/sapphire/commit/8b2cb9a) Declare PasswordEncryptor_Blowfish::get_cost() as static (Sean Harvey)
 * 2012-06-15 [1059863](https://github.com/silverstripe/sapphire/commit/1059863) Supress mkdir() when attempting to create a temp folder, instead of the variable. This gives a nicer error in the installer. (Sean Harvey)
 * 2012-06-15 [72fd012](https://github.com/silverstripe/sapphire/commit/72fd012) "Sync files" button doesn't work when syncing the root of the assets folder (Sean Harvey)
 * 2012-06-15 [acee026](https://github.com/silverstripe/sapphire/commit/acee026) Buttons in the cms that didnt have .ss-ui-button werent becoming buttons because we changed buttons to trigger on onadd, but the ss-ui-button class was being added dynamically (Hamish Friedlander)
 * 2012-06-15 [8ae4597](https://github.com/silverstripe/sapphire/commit/8ae4597) TreeDropdownField wasnt closing, because the closePanel method is in an entwine namespace (Hamish Friedlander)
 * 2012-06-14 [7f27474](https://github.com/silverstripe/silverstripe-cms/commit/7f27474) Show AssetAdmin tree by not invoking $EditForm twice in template (Ingo Schommer)
 * 2012-06-14 [a64cf8c](https://github.com/silverstripe/silverstripe-cms/commit/a64cf8c) AssetAdmin-&gt;delete() is now allowed, and redirects to parent folder automatically (Ingo Schommer)
 * 2012-06-14 [ecb48bb](https://github.com/silverstripe/sapphire/commit/ecb48bb) Force full window reload on IE7/IE8 every 20 pushState requests (see #7258) (Ingo Schommer)
 * 2012-06-14 [77099dd](https://github.com/silverstripe/sapphire/commit/77099dd) Moved initialisation of injector to the start of Core.php to make sure that it is initialised correctly before additional code blocks reference it (in particular some of the code introduced by Sam that is triggered during add_extension). (Marcus Nyeholt)
 * 2012-06-14 [eaf05a6](https://github.com/silverstripe/silverstripe-cms/commit/eaf05a6) AssetAdmin root navigation (fixes #7448) (Ingo Schommer)
 * 2012-06-14 [56388ef](https://github.com/silverstripe/sapphire/commit/56388ef) Make sure to only construct args for prototype object creation if there are actually args passed through to prevent overwriting with null args if they're passed (Marcus Nyeholt)
 * 2012-06-14 [856991d](https://github.com/silverstripe/sapphire/commit/856991d) Ticket #6069 Checking of URLSegment can end in an infinite loop (when saving Page in CMS) (carlos barberis)
 * 2012-06-14 [882b426](https://github.com/silverstripe/sapphire/commit/882b426) Ticket #5578  SiteTree-&gt;CanCreateTopLevel() doesn't change dragged tree nodes or ParentID changes (Paul Meyrick)
 * 2012-06-14 [1085fd2](https://github.com/silverstripe/sapphire/commit/1085fd2) TinyMCE isnt unbinding formatselect or styleselect which leaks memory. We should really fix TinyMCE, but lets just brute-force it for now. (Hamish Friedlander)
 * 2012-06-14 [8177c93](https://github.com/silverstripe/sapphire/commit/8177c93) Fix thirdparty library jquery-cookie referencing $ outside a closure, which wont work in noConflict mode (Hamish Friedlander)
 * 2012-06-13 [4c0a0f9](https://github.com/silverstripe/sapphire/commit/4c0a0f9) Inlining TinyMCE HTML popup (fixes #7451) (Ingo Schommer)
 * 2012-06-13 [78c15ea](https://github.com/silverstripe/sapphire/commit/78c15ea) Fix correct input type for ImageFormAction replaces. (Will Rossiter)
 * 2012-06-13 [a6cee24](https://github.com/silverstripe/silverstripe-cms/commit/a6cee24) Consistently style custom defined page icons. (Andrew Short)
 * 2012-06-13 [160d516](https://github.com/silverstripe/sapphire/commit/160d516) Consistently style custom defined page icons. (Andrew Short)
 * 2012-06-13 [b1d95cf](https://github.com/silverstripe/sapphire/commit/b1d95cf) Passing existing SS_HTTPResponse to PjaxResponseNegotiator in LeftAndMain so state like X-Status HTTP headers are retained (fixes #7427) (Ingo Schommer)
 * 2012-06-12 [896d198](https://github.com/silverstripe/sapphire/commit/896d198) Correct DOM structure on updating tree nodes from edit forms, adding badge classes to force strike-through styling on deleted nodes (see #7410) (Ingo Schommer)
 * 2012-06-12 [b86a787](https://github.com/silverstripe/sapphire/commit/b86a787) Use new jQuery.Entwine event capturing, onadd and onremove features to plug some memory leaks (Hamish Friedlander)
 * 2012-06-11 [cdea489](https://github.com/silverstripe/silverstripe-cms/commit/cdea489) Catch and display validation errors when adding a page. (Andrew Short)
 * 2012-06-11 [34eb1b3](https://github.com/silverstripe/sapphire/commit/34eb1b3) Fixed incorrect variables breaking form submission. (Andrew Short)
 * 2012-06-11 [1aefc0a](https://github.com/silverstripe/sapphire/commit/1aefc0a) Ensure that extensio arugments are passed when temporarily instantiating for setting up statics. (Sam Minnee)
 * 2012-06-11 [3f68e6f](https://github.com/silverstripe/sapphire/commit/3f68e6f) Ensure that a single string value (as opposed to an array of values) is accepted by implode() in CheckboxSetField by casting it as an array. (Sean Harvey)
 * 2012-06-08 [7523f98](https://github.com/silverstripe/sapphire/commit/7523f98) ES: File Uploads (Naomi Guyer)
 * 2012-06-06 [d4baf2d](https://github.com/silverstripe/sapphire/commit/d4baf2d) Stability improvements on CMS layout logic (Ingo Schommer)
 * 2012-06-06 [415a680](https://github.com/silverstripe/sapphire/commit/415a680) CMS Breadcrumbs and tabs as inline blocks which can span multiple lines, rather than being cropped off (fixes #6882) (Ingo Schommer)
 * 2012-06-06 [da915a4](https://github.com/silverstripe/sapphire/commit/da915a4) Fix JS bug that was preventing passwords from being changed in 'hidden by default' ConfirmedPasswordField instances. (Sam Minnee)
 * 2012-06-06 [13be7cb](https://github.com/silverstripe/sapphire/commit/13be7cb) Ensure that enum values with a single quote are escaped correctly for PHP coming out of MySQL ('' to \'), otherwise dev/build shows these as changed all the time. (Sean Harvey)
 * 2012-06-05 [1bb6026](https://github.com/silverstripe/silverstripe-cms/commit/1bb6026) Don't apply clientside deferred cache to list view since it relies on URL as a cache key which is set on the deferred container (=not replaced with view) (Ingo Schommer)
 * 2012-06-05 [8b8de05](https://github.com/silverstripe/silverstripe-cms/commit/8b8de05) Don't filter AssetAdmin list view when showing detail view (fixes #7408) (Ingo Schommer)
 * 2012-06-05 [5499079](https://github.com/silverstripe/sapphire/commit/5499079) Fixed ORM bugs introduced in ec554689325765881a83df6f87c34efe80c92961 (Sam Minnee)
 * 2012-06-04 [f794e98](https://github.com/silverstripe/sapphire/commit/f794e98) Moved localised JS messages in correct module (fixes #7393) (Ingo Schommer)
 * 2012-06-04 [acfc658](https://github.com/silverstripe/sapphire/commit/acfc658) Fail silently in _t() legacy mode when using sprintf(), to avoid outdated translations breaking with a fatal error (e.g. CMSMain.ACCESS changed from two to one usage of {title}, which isn't changed yet in most languages). Slight performance overhead, but acceptable since its legacy usage only (Ingo Schommer)
 * 2012-06-03 [6ed5ef9](https://github.com/silverstripe/silverstripe-cms/commit/6ed5ef9) Redirecting legacy admin/cms URL to new admin/pages (fixes #7409) (Ingo Schommer)
 * 2012-06-03 [8847506](https://github.com/silverstripe/silverstripe-cms/commit/8847506) Selecting correct parent when adding a new page (fixes #7188) (Ingo Schommer)
 * 2012-06-03 [c18c29f](https://github.com/silverstripe/sapphire/commit/c18c29f) Updating tree state (after adding/renaming nodes, changing parent). Deselecting nodes when switching to edit view (fixes #7389, #7336, #7309) (Ingo Schommer)
 * 2012-06-02 [ec55468](https://github.com/silverstripe/sapphire/commit/ec55468) Handling of classes with namespaces in database (Fabian Schmengler)
 * 2012-06-02 [afdd868](https://github.com/silverstripe/sapphire/commit/afdd868) Added double quotes to column names in automatically generated indexes for many_many relationships (this time in the right place, should not interfere with index name - all tests pass) (Fabian Schmengler)
 * 2012-05-30 [9c697f4](https://github.com/silverstripe/silverstripe-cms/commit/9c697f4) Fixed regression in ListViewForm not showing listChildrenLink (Sean Harvey)
 * 2012-05-30 [73b9f93](https://github.com/silverstripe/sapphire/commit/73b9f93) Improved layout of moneyfield. (Sam Minnee)
 * 2012-05-30 [e19ab7a](https://github.com/silverstripe/sapphire/commit/e19ab7a) Ensure that DataList::filter() doesn't modify the original object. (Sam Minnee)
 * 2012-05-29 [ad6b7a4](https://github.com/silverstripe/sapphire/commit/ad6b7a4) Add Maori locale data (mi, mi_NZ) from CLDR 1.9 to avoid Zend_Locale complaining (fixes #7386) (Ingo Schommer)
 * 2012-05-29 [5b03f49](https://github.com/silverstripe/sapphire/commit/5b03f49) Respecting server-overrides on X-Pjax responses during ajax redirects. Fixes GridFieldDetailForm redirect after delete, e.g. in ModelAdmin. Partially reverts 8b4b896. Closes pull request #488 (Ingo Schommer)
 * 2012-05-29 [d7a8fa9](https://github.com/silverstripe/sapphire/commit/d7a8fa9) If RequiredFields::php() is given any fieldName that is NULL, don't attempt to validate a NULL field. (Sean Harvey)
 * 2012-05-28 [0235a8c](https://github.com/silverstripe/sapphire/commit/0235a8c) Partially reverting 28e43bdc which broke media insertion (Sean Harvey)
 * 2012-05-09 [21dda5f](https://github.com/silverstripe/silverstripe-installer/commit/21dda5f) Fixing including of thirdparty tests when using phpunit.xml (requires PHPUnit 3.6, so marking that as the minimum requirement in comments) (Sean Harvey)
 * 2012-04-27 [e03d576](https://github.com/silverstripe/silverstripe-installer/commit/e03d576) Tutorial template fixes (Naomi Guyer)
 * 2012-04-27 [b7d4ed8](https://github.com/silverstripe/silverstripe-installer/commit/b7d4ed8) Tutorial theme doctype (Naomi Guyer)
 * 2012-04-24 [bd74ba4](https://github.com/silverstripe/silverstripe-installer/commit/bd74ba4) updating theme to "Simple" in change log creator and documentation (Julian Seidenberg)

### Minor changes

 * 2012-06-15 [5fa1633](https://github.com/silverstripe/sapphire/commit/5fa1633) Saving UploadField detail form correctly when nested in GridField (Ingo Schommer)
 * 2012-06-15 [4986355](https://github.com/silverstripe/silverstripe-cms/commit/4986355) Simplified page type dropdown labels, removed redundant info (fixes #7474) (Ingo Schommer)
 * 2012-06-15 [16527f7](https://github.com/silverstripe/sapphire/commit/16527f7) Removed old CSS files (Ingo Schommer)
 * 2012-06-15 [02332da](https://github.com/silverstripe/sapphire/commit/02332da) GridField compat with ViewableData records (fixes #7479) (Ingo Schommer)
 * 2012-06-15 [b04c199](https://github.com/silverstripe/sapphire/commit/b04c199) Fixing additional cases where DataList needs to be returned correctly when filtering (Sean Harvey)
 * 2012-06-15 [a9c7c69](https://github.com/silverstripe/sapphire/commit/a9c7c69) Ensure DataQuery used in apply() is returned on Filter classes (to be consistent with GreaterThanFilter etc which will return it) (Sean Harvey)
 * 2012-06-15 [09e821e](https://github.com/silverstripe/sapphire/commit/09e821e) Don't leave cost=31 blowfish setting dormant in code, causing timeouts. (Sam Minnee)
 * 2012-06-15 [80941ef](https://github.com/silverstripe/sapphire/commit/80941ef) Fixed unit test to respect idempotent semantics of DataList filter() and sort(). (Sam Minnee)
 * 2012-06-15 [c051b80](https://github.com/silverstripe/silverstripe-cms/commit/c051b80) Using links for fake remote tabs in CMSMain_Content.ss to avoid 'missing fragment identifier' errors from jQuery UI. (Ingo Schommer)
 * 2012-06-14 [deff232](https://github.com/silverstripe/sapphire/commit/deff232) Using onadd in preview JS (Ingo Schommer)
 * 2012-06-14 [40cef4d](https://github.com/silverstripe/sapphire/commit/40cef4d) Fixed event naming (Ingo Schommer)
 * 2012-06-14 [04e5ff0](https://github.com/silverstripe/sapphire/commit/04e5ff0) Hiding CMS-specific badges in TreeDropdownField (fixes #7456) (Ingo Schommer)
 * 2012-06-14 [3c81958](https://github.com/silverstripe/silverstripe-cms/commit/3c81958) Only set folder field state in AssetAdmin if a folder is shown (Ingo Schommer)
 * 2012-06-14 [c81d0e1](https://github.com/silverstripe/sapphire/commit/c81d0e1) Only set X-Pjax header in redirections if it doesn't already exist in the response (Ingo Schommer)
 * 2012-06-14 [2fa835a](https://github.com/silverstripe/sapphire/commit/2fa835a) Moving edit form focus logic from onadd() to onmatch() to give the form time to become visible (see #7258) (Ingo Schommer)
 * 2012-06-14 [7ba759e](https://github.com/silverstripe/sapphire/commit/7ba759e) Fixed jQuery.jstree men leaks on 'dnd' and 'context menu' plugins, by removing globally bound event handlers (see #7258) (Ingo Schommer)
 * 2012-06-14 [5260738](https://github.com/silverstripe/sapphire/commit/5260738) Avoid reinitialising tabs (see #7258) (Ingo Schommer)
 * 2012-06-14 [fa900f7](https://github.com/silverstripe/sapphire/commit/fa900f7) jQuery UI tabs memory leak (see ##7258) (Ingo Schommer)
 * 2012-06-14 [980686a](https://github.com/silverstripe/sapphire/commit/980686a) Limiting console.log() output to explicit enabling through window.debug to avoid failing IE (Ingo Schommer)
 * 2012-06-13 [f94f03d](https://github.com/silverstripe/silverstripe-cms/commit/f94f03d) Removed unused jQuery.dialog creation in CMSMain.AddForm.js, which causes mem leaks (now uses dedicated pages/add UI) (Ingo Schommer)
 * 2012-06-13 [e23a758](https://github.com/silverstripe/sapphire/commit/e23a758) Using new jQuery.changetracker.destroy method in LeftAndMain.EditForm.js (Ingo Schommer)
 * 2012-06-13 [0b6d453](https://github.com/silverstripe/sapphire/commit/0b6d453) Added destroy() method to jQuery.changetracker plugin (Ingo Schommer)
 * 2012-06-13 [6581831](https://github.com/silverstripe/silverstripe-cms/commit/6581831) Disable parent node search in CMSPageAddController (Ingo Schommer)
 * 2012-06-13 [2a52ce2](https://github.com/silverstripe/sapphire/commit/2a52ce2) Fixed duplicate help text on Group-&gt;getCMSFields() (Ingo Schommer)
 * 2012-06-13 [01201f0](https://github.com/silverstripe/silverstripe-cms/commit/01201f0) Resetting margin on URLSegment help text (changed due to new .help default styling in core) (Ingo Schommer)
 * 2012-06-13 [db076c0](https://github.com/silverstripe/sapphire/commit/db076c0) Using new setDescription() styling in HtmlEditorField (Ingo Schommer)
 * 2012-06-13 [9e4b526](https://github.com/silverstripe/sapphire/commit/9e4b526) Include the title attribute on tree and readonly fields. (Andrew Short)
 * 2012-06-13 [acc6115](https://github.com/silverstripe/silverstripe-cms/commit/acc6115) Removed extra margin from tools add page button. (Andrew Short)
 * 2012-06-13 [86bb491](https://github.com/silverstripe/sapphire/commit/86bb491) Consistently style tabs in various CMS interfaces. (Andrew Short)
 * 2012-06-13 [5137370](https://github.com/silverstripe/sapphire/commit/5137370) Fixed tab border being shown when tabs were hidden. (Andrew Short)
 * 2012-06-13 [ce3d48e](https://github.com/silverstripe/sapphire/commit/ce3d48e) Supressed dependencies of tree logic on SiteTree elements (not properly isolated to work well with Folder objects) (Ingo Schommer)
 * 2012-06-13 [8976c82](https://github.com/silverstripe/sapphire/commit/8976c82) Fixed nested tab styling. (Andrew Short)
 * 2012-06-12 [e50936f](https://github.com/silverstripe/silverstripe-cms/commit/e50936f) Added caching to SiteTree-&gt;getStatusFlags(), as its called twice for every node now in LeftAndMain-&gt;SiteTreeAsUL() (see #7410) (Ingo Schommer)
 * 2012-06-12 [e1ebb4a](https://github.com/silverstripe/sapphire/commit/e1ebb4a) Fixing broken test for PostgreSQL (Sean Harvey)
 * 2012-06-12 [0a2e877](https://github.com/silverstripe/sapphire/commit/0a2e877) Remove PostgreSQLDatabase boolean workaround in DataObject::__construct() (Sean Harvey)
 * 2012-06-12 [59e68f1](https://github.com/silverstripe/sapphire/commit/59e68f1) Remove MSSQLDatabase date/datetime workarounds from DataObject::__construct() (Sean Harvey)
 * 2012-06-11 [1c5dae9](https://github.com/silverstripe/silverstripe-cms/commit/1c5dae9) Always include tree CSS so tree icons are consistently styled. (Andrew Short)
 * 2012-06-11 [c41ff29](https://github.com/silverstripe/sapphire/commit/c41ff29) Don't rely on singleton() inappropriately in FormScaffolderTest (Sam Minnee)
 * 2012-06-11 [9009d43](https://github.com/silverstripe/sapphire/commit/9009d43) Moved "insert x" dialog styling from generic UploadField.scss to CMS-specific _style.scss (Ingo Schommer)
 * 2012-06-08 [86bdd16](https://github.com/silverstripe/sapphire/commit/86bdd16) oEmbed documentation (Ingo Schommer)
 * 2012-06-08 [f7ac4e3](https://github.com/silverstripe/sapphire/commit/f7ac4e3) Cache oEmbed results for a week (rather than an hour) by default, to avoid synchronous querying of potentially slow and unreliable external services upon page rendering (Ingo Schommer)
 * 2012-06-08 [2ecd8a0](https://github.com/silverstripe/sapphire/commit/2ecd8a0) Hiding "insert media" tabs when editing an image (wrong selector) (Ingo Schommer)
 * 2012-06-08 [210e32d](https://github.com/silverstripe/sapphire/commit/210e32d) Labeling in HtmlEditorField (Ingo Schommer)
 * 2012-06-06 [803aa6b](https://github.com/silverstripe/sapphire/commit/803aa6b) Only applying box-shadow on inactive tabs (Ingo Schommer)
 * 2012-06-06 [eac70b6](https://github.com/silverstripe/sapphire/commit/eac70b6) fixed opera vendor prefix for @mixin hide-text-overflow (Zauberfisch)
 * 2012-06-06 [098d3b6](https://github.com/silverstripe/silverstripe-cms/commit/098d3b6) Changed CMS breadcrumbs markup to fit new inline-block CSS (fixes #6882) (Ingo Schommer)
 * 2012-06-06 [22de5c6](https://github.com/silverstripe/sapphire/commit/22de5c6) Performance improvement and removal of duplicate code in jQuery.ondemand (Ingo Schommer)
 * 2012-06-06 [b3164eb](https://github.com/silverstripe/sapphire/commit/b3164eb) Disabled jQuery.entwine inspector in dev mode, as it causes side effects due to document.write() before other scripts are loaded (Ingo Schommer)
 * 2012-06-06 [91b6bd6](https://github.com/silverstripe/sapphire/commit/91b6bd6) Fixed a small but important docs error in cms-architecture.md (Ingo Schommer)
 * 2012-06-05 [b4fb174](https://github.com/silverstripe/sapphire/commit/b4fb174) Fixed PjaxResponseNegotiatorTest (Ingo Schommer)
 * 2012-06-05 [6ac8363](https://github.com/silverstripe/silverstripe-cms/commit/6ac8363) Fixed tab selection state (changed JS behaviour) (Ingo Schommer)
 * 2012-06-05 [e99b2e9](https://github.com/silverstripe/silverstripe-cms/commit/e99b2e9) Bubbling up GridField row edit event in AssetAdmin.js so default behaviour for files (not folders) can kick in (Ingo Schommer)
 * 2012-06-05 [e643559](https://github.com/silverstripe/sapphire/commit/e643559) Warning about HTML5 compat in CSSContentParser (Ingo Schommer)
 * 2012-06-04 [82a1e7d](https://github.com/silverstripe/sapphire/commit/82a1e7d) Use injector for creating Member_GroupSet object (Marcus Nyeholt)
 * 2012-06-04 [63467b0](https://github.com/silverstripe/silverstripe-cms/commit/63467b0) Moved localised JS messages in correct module (fixes #7393) (Ingo Schommer)
 * 2012-06-04 [69d3497](https://github.com/silverstripe/sapphire/commit/69d3497) Fixed node deselection when changing areas (e.g. "pages" to "edit page") (Ingo Schommer)
 * 2012-06-04 [b525486](https://github.com/silverstripe/silverstripe-cms/commit/b525486) Added feedback after creating page (fixes #7297) (Ingo Schommer)
 * 2012-06-03 [a757c16](https://github.com/silverstripe/sapphire/commit/a757c16) Make tree loading indicator visible on page icon to ensure it shows when drag handles are hidden (in "sidebar view") (fixes #7256) (Ingo Schommer)
 * 2012-06-03 [8e89396](https://github.com/silverstripe/sapphire/commit/8e89396) Updating compass sprites with its changed ordering starting with 0.12 release (see http://compass-style.org/blog/2012/02/01/compass-0-12-is-released/) (Ingo Schommer)
 * 2012-06-03 [31a66e0](https://github.com/silverstripe/sapphire/commit/31a66e0) Returning at least some error feedback when admin/* route isn't found (fixes #7409) (Ingo Schommer)
 * 2012-06-02 [9898cd9](https://github.com/silverstripe/sapphire/commit/9898cd9) Improved testing docs (Ingo Schommer)
 * 2012-06-01 [64c0d2f](https://github.com/silverstripe/sapphire/commit/64c0d2f) add comments to FormField's RightTitle (Mateusz Uzdowski)
 * 2012-06-01 [5462cda](https://github.com/silverstripe/sapphire/commit/5462cda) Removing "." from the end of validation messages (Sean Harvey)
 * 2012-05-30 [460148c](https://github.com/silverstripe/sapphire/commit/460148c) Debug messages for tracking down JS layout sequence issues (disabled by default) (Ingo Schommer)
 * 2012-05-30 [0b7af1a](https://github.com/silverstripe/sapphire/commit/0b7af1a) Fixed PHPDoc on Cookie class (fixes #7404) (Ingo Schommer)
 * 2012-05-30 [5a93ee7](https://github.com/silverstripe/sapphire/commit/5a93ee7) Fixed tab selection state (Ingo Schommer)
 * 2012-05-30 [0eac6ea](https://github.com/silverstripe/sapphire/commit/0eac6ea) Apply loading indicators to all forms, not just .cms-edit-form (which means it includes the "pages list view"). Move to correct place in LeftAndMain.js (not specific to '.cms-content') (Ingo Schommer)
 * 2012-05-30 [1102bbd](https://github.com/silverstripe/sapphire/commit/1102bbd) Removed ability in PjaxResponseNegotiator to send non-JSON responses for single fragments, as we're now relying on the server communicating which segment needs replacement (through the JSON key) (Ingo Schommer)
 * 2012-05-30 [cbf4ad3](https://github.com/silverstripe/sapphire/commit/cbf4ad3) Replace deprecation warnings with Deprecation::notice() instead (Sean Harvey)
 * 2012-05-30 [fa764c7](https://github.com/silverstripe/sapphire/commit/fa764c7) Using Deprecation::notice() for deprecated method in ViewableData (Sean Harvey)
 * 2012-05-30 [f865891](https://github.com/silverstripe/sapphire/commit/f865891) Fixing styling on listChildrenLink in GridField (Sean Harvey)
 * 2012-05-30 [b3d99d5](https://github.com/silverstripe/sapphire/commit/b3d99d5) Retaining case in PjaxResponseNegotiator, in order to pass back to client correctly (Ingo Schommer)
 * 2012-05-30 [9f51c87](https://github.com/silverstripe/silverstripe-cms/commit/9f51c87) Use injector to create controllers in ModelAsController (Marcus Nyeholt)
 * 2012-05-29 [21beb86](https://github.com/silverstripe/sapphire/commit/21beb86) Using localized name rather than model class for GridFieldAddNewButton UI (related to 74d444cf and pull request #452) (Ingo Schommer)
 * 2012-05-29 [c3d8d82](https://github.com/silverstripe/sapphire/commit/c3d8d82) Testing languages without fallbacks (related to #7386) (Ingo Schommer)
 * 2012-05-29 [909c5bd](https://github.com/silverstripe/sapphire/commit/909c5bd) Fixed spelling error (Sean Harvey)
 * 2012-05-29 [f43273f](https://github.com/silverstripe/sapphire/commit/f43273f) Provide a better error if incorrect number of arguments are passed to filter() or exclude() on a DataList (Sean Harvey)
 * 2012-05-28 [9b9bd23](https://github.com/silverstripe/sapphire/commit/9b9bd23) Upgrade TinyMCE dependency to 3.5.1.1 (Sean Harvey)
 * 2012-05-28 [23a3872](https://github.com/silverstripe/sapphire/commit/23a3872) Fixed regression in DataListTest (Sean Harvey)
 * 2012-05-28 [c3eabff](https://github.com/silverstripe/sapphire/commit/c3eabff) Use shorthand {class}::get() syntax instead of DataList::create() in core code. (Sean Harvey)
 * 2012-05-28 [71256ea](https://github.com/silverstripe/sapphire/commit/71256ea) Update class docs for OptionsetField to use short DataList query (Sean Harvey)
 * 2012-05-28 [862d7f2](https://github.com/silverstripe/sapphire/commit/862d7f2) If $containerClass passed in to DataObject::get() isn't DataList, use Deprecation::notice() instead of throwing a notice (Sean Harvey)
 * 2012-05-28 [ad28780](https://github.com/silverstripe/silverstripe-cms/commit/ad28780) Use shorthand syntax for DataList querying (Sean Harvey)
 * 2012-05-28 [ed1373d](https://github.com/silverstripe/sapphire/commit/ed1373d) Use better syntax for querying DataList in 3.0 upgrading guide (Sean Harvey)
 * 2012-05-28 [f3467a3](https://github.com/silverstripe/sapphire/commit/f3467a3) Added test listeners to support TeamCity/PHPUnit executions. (Sam Minnee)
 * 2012-05-28 [4bb7d6a](https://github.com/silverstripe/silverstripe-installer/commit/4bb7d6a) Simplified phpunit files so that they work with PHPUnit 3.5 (Sam Minnee)
 * 2012-05-28 [792df1e](https://github.com/silverstripe/silverstripe-installer/commit/792df1e) Added phpunit config specifically for teamcity (different listeners) (Sam Minnee)
 * 2012-05-11 [aae4f9e](https://github.com/silverstripe/silverstripe-installer/commit/aae4f9e) Adding .DS_Store to .gitignore (Sean Harvey)
 * 2012-04-24 [d2f5fc4](https://github.com/silverstripe/silverstripe-installer/commit/d2f5fc4) adding PHPStorm IDE files to the .gitignore (Julian Seidenberg)

### Other

 * 2012-06-15 [88582e7](https://github.com/silverstripe/sapphire/commit/88582e7) Revert "BUGFIX Aborting marking in Hierarchy-&gt;markPartialTree() before loading nodes, if the expected node count would exceed the totals (regardless of the in-memory marking state)" (Ingo Schommer)
 * 2012-06-07 [377ac50](https://github.com/silverstripe/sapphire/commit/377ac50) ENHNANCEMENT: allow overriding of PJAX fragments included in the response. (Mateusz Uzdowski)
 * 2012-06-04 [119739d](https://github.com/silverstripe/sapphire/commit/119739d) If a DataObject has a many_many to a SiteTree subclass, and that subclass has no database fields defined, and $this-&gt;name is "ID", this function will errantly return "SiteTreeSubClass.ID", which can never exist in a search query, since there is no such table as SiteTreeSubClass. The problem is that DataObject::hasOwnTableDatabaseField() is a little eager when passed an argument of "ID." It doesn't check to see if the object has its own table first. (unclecheese)
 * 2012-06-03 [ae7fc6f](https://github.com/silverstripe/sapphire/commit/ae7fc6f) RECOMMIT This is a recommit of a previously merged, but reverted, commit. The initial commit had problems when running "tests/all flush=all" when dev/build would re-analyse a bunch of stuff; fixes to address this went into https://github.com/silverstripe/sapphire/pull/487, but for some reason the actual base changes didn't, so I'm re-submitting them in a separate pull. (Marcus Nyeholt)
 * 2012-04-18 [5178954](https://github.com/silverstripe/sapphire/commit/5178954) UNFINISHED Processing multiple PJAX responses on CMS JavaScript, introducing data-pjax-fragment attribute to identify reloadable template parts (Ingo Schommer)
