# 2.4.4-rc1

## Changelog

### Features and Enhancements

 * [rev:114572] 'bypassStaticCache' cookie set in Versioned is limited to httpOnly flag (no access by JS) to improve clientside security (from r114568)
 * [rev:114571] Session::start() forces PHPSESSID cookies to be httpOnly (no access by JS) to improve clientside security (from r114567)
 * [rev:114499] Added !RandomGenerator for more secure CRSF tokens etc. (from r114497)
 * [rev:114467] PHP requirements in installer now check for date.timezone correctly being set for PHP 5.3.0+. This option is *required* to be set starting with 5.3.0 and will cause an error during installation if not
 * [rev:114083] Added SS_HTTPResponse->setStatusDescription() as equivalent to setStatusCode(). Added documentation.
 * [rev:113963] Split temp directory check and writability into two checks
 * [rev:113961] #6206 Installer additional checks for module existence by checking _config.php exists, in addition to the directory
 * [rev:113919] Allowing i18nTextCollector to discover entities in templates stored in themes/ directory (thanks nlou) (from r113918)
 * [rev:113871] Update Asset's left and right panels with filders and files after 'Look for new files' was triggered (open #5543)

### API Changes

 * [rev:114474] Using i18n::validate_locale() in various Translatable methods to ensure the locale exists (as defined through i18n::$allowed_locales) (from r114470)

### Bugfixes

 * [rev:114783] Removed switch in !MySQLDatabase->query() to directly echo queries with 'showqueries' parameter when request is called via ajax (from r114782)
 * [rev:114774] Disallow web access to sapphire/silverstripe_version to avoid information leakage (from r114773)
 * [rev:114771] Disallow web access to cms/silverstripe_version to avoid information leakage (from r114770)
 * [rev:114760] Avoid potential referer leaking in Security->changepassword() form by storing Member->!AutoLoginHash in session instead of 'h' GET parameter (from r114758)
 * [rev:114719] Fallback text for "Password" in !ConfirmedPasswordField when no translation found
 * [rev:114683] Populates the page with fake data in order to pass subsequent unit tests
 * [rev:114654] Test if form is the right class (if a class decorates the content controller, this test would break ie sphinx)
 * [rev:114516] Escaping $locale values in Translatable->augmentSQL() in addition to the i18n::validate_locale() input validation (from r114515)
 * [rev:114512] Limiting usage of mcrypt_create_iv() in !RandomGenerator->generateEntropy() to *nix platforms to avoid fatal errors (specically in IIS) (from r114510)
 * [rev:114507] Using !RandomGenerator class in Member->logIn(), Member->autoLogin() and Member->generateAutologinHash() for better randomization of tokens. Increased VARCHAR length of '!RememberLoginToken' and '!AutoLoginHash' fields to 1024 characters to support longer token strings. (from r114504)
 * [rev:114506] Using !RandomGenerator class in !PasswordEncryptor->salt() (from r114503)
 * [rev:114500] Using !RandomGenerator class in !SecurityToken->generate() for more random tokens
 * [rev:114473] Check for valid locale in i18n::set_locale()/set_default_locale()/include_locale_file()/include_by_locale() (as defined in i18n::$allowed_locales). Implicitly sanitizes the data for usage in controllers. (from r114469)
 * [rev:114445] Don't allow HTML formatting in !RequestHandler->httpError() by sending "Content-Type: text/plain" response headers. (from r114444)
 * [rev:114208] Including template /lang folders in i18n::include_by_locale() (implementation started in r113919)
 * [rev:114195] Added !SecurityToken to !PageCommentInterface->!DeleteAllLink() (fixes #6223, thanks Pigeon)
 * [rev:114083] Strip newlines and carriage returns from SS_HTTPResponse->getStatusDescription() (fixes #6222, thanks mattclegg) (from r114082)
 * [rev:114081] Removed double quoting of $where parameter in Translatable::get_existing_content_languages() (fixes #6203, thanks cloph) (from r114080)
 * [rev:114036] Fixed case where !AssetAdmin would throw an error if $links was not an object in !AssetAdmin::getCustomFieldsFor()
 * [rev:113976] #6201 Use of set_include_path() did not always include sapphire paths in some environments
 * [rev:113962] Installer now checks temporary directory is writable, in addition to it being available.
 * [rev:113809] #6197 simon_w: Fixed Internal Server Error when accessing assets on Apache without mod_php.
 * [rev:113692] Avoid reloading CMS form twice after certain saving actions (fixes #5451, thanks muzdowski)

### Minor changes

 * [rev:114751] Setting Content-Type to text/plain in various error responses for !RestfulServer (from r114750)
 * [rev:114749] Reverting Member "!AutoLoginHash", "!RememberLoginToken" and "Salt" to their original VARCHAR length to avoid problems with invalidated hashes due to shorter field length (from r114748)
 * [rev:114745] Partially reverted r114744
 * [rev:114744] Reduced VARCHAR length from 1024 to 40 bytes, which fits the sha1 hashes created by !RandomGenerator. 1024 bytes caused problems with index lengths on MySQL (from r114743)
 * [rev:114720] Code formatting change in !ConfirmedPasswordField::__construct()
 * [rev:114454] Added exception handling if !ClassName is null in search results
 * [rev:114334] Checking for class_exists() before !SapphireTest::is_running_tests() to avoid including the whole testing framework, and triggering PHPUnit to run a performance-intensive directory traversal for coverage file blacklists (from r114332)
 * [rev:114079] Reverted r108515
 * [rev:114078] Documentation for Aggregate caching (from r114077)
 * [rev:114062] fixed visual glitch in CMS access tab for IE
 * [rev:114036] Defined $backlinks as an array before adding entries to it
 * [rev:114016] Fixed php tag in !SecurityTokenTest, should be "<?php" not "<?"
 * [rev:113984] Installer now writes "!SetEnv HTTP_MOD_REWRITE On" in .htaccess to be consistent with the original .htaccess file that comes with the phpinstaller project
 * [rev:113968] Fixed PHP strict standard where non-variables cannot be passed by reference
 * [rev:113967] Fixed undefined variable $groupList
 * [rev:113964] Re-use variable instead of check temp folder again
 * [rev:113956] Make sure that Translatable creates a translated parent of !SiteTree only when the parent is not translated (from r113955)
 * [rev:113937] don't trigger notice but Debug::show it
 * [rev:113936] don't trigger notice but Debug::show it
 * [rev:113933] test doesn't fail anymore due to time differences between db and php. The test now issues notices, warnings and errors depending on the severity of the offset
 * [rev:113924] Fixed spaces with tabs in Core
 * [rev:113923] Fixed spaces with tabs for Core::getTempFolder()
 * [rev:113696] call jquery-ui from thirdparty folder instead google api (see ticket 5915) (from r113656)
 * [rev:113695] Typo in !AssetAdmin (fixes #6191, thanks Juanitou)
 * [rev:113690] Updated cs_CZ and sk_SK translations in sapphire/javascript (fixes #6085, thanks Pike)
 * [rev:113689] Making some !JavaScript strings in cms/javascript translatable, and updated their cs_CZ and sk_SK translations (fixes #6085, thanks Pike)


### Other

 * [rev:114464] FIX: Revert last commit
 * [rev:114463] FIX: Revert last commit