# 2.4.0-rc1 (2010-04-01)

## Changelog

###  Features and Enhancements

 * [rev:101871] Updated automatic regression tests (Salad)
 * [rev:101670] RedirectorPage ExternalURL field now defaults to http:// to be consistent with the "Another website" option for HtmlEditorField LinkForm
 * [rev:101661] tidied up installer process to streamline process. Moved requirements to top and button to bottom and added visual seperation of the individual steps
 * [rev:101381] refactored requirements section to hide successful tests
 * [rev:101378] Added links to installation introduction text for sources of help and suggested web hosts
 * [rev:101246] Improved wording and styling in installer. Added links to server requirements, themes download, tutorial. Decreased vertical space before the "install" button to make it more obvious.
 * [rev:101127] Added 'Dependent pages' tab to CMS, to show virtuals, redirectors, and backlinks that point to this page.


###  API Changes

 * [rev:102012] Changed MySQLFulltextSearchable class to FulltextSearchable (applies to all databases)
 * [rev:102003] Disallow methods/actions in RequestHandler->checkAccessAction() which are implemented on parent classes (e.g. ViewableData and Object), unless access is controlled through $allowed_actions. This limits information exposure from getters used in template contexts.
 * [rev:101833] Allow cached blocks within control and if blocks, as long as that control or if block is contained within an uncached block, not a cached block
 * [rev:101155] Add option for DataObjectDecorator::onAfterSkippedWrite()
 * [rev:101137] Partial cache adjustments - now supports nested cache blocks (which are independant of their containing cache block), conditionals to control if a given cache block is active, and includes hash of template code in key (so template changes mean cache is invalidated). Changes template control for cache block to `<% cached %>`, to which the now deprecated `<% cacheblock %>` is aliased, and an additional template control `<% uncached %>` has been added.
 * [rev:101127] Added SiteTree::VirtualPages() and SiteTree::DependentPages() accessors.


###  Bugfixes

 * [rev:102038] #5255 LeftAndMain should include the correct editor.css file so typography from user selected theme in SiteConfig is shown in TinyMCE
 * [rev:102026] Fixed SiteTree::page_type_classes() removal of base class (was broken if database driver returned classes in arbitrary order, e.g. in Postgres)
 * [rev:102004] Prevent handling of controller actions which return $this avoid infinite loops in RequestHandler->handleRequest (thanks Hamish!)
 * [rev:101975] Resetting image sidepanel fields when opening the panel instead of inserting an image, to avoid losing focus of TinyMCE in IE. Using getBookmark() in TinyMCE to save the original location. (fixes #5263)
 * [rev:101969] Stop IE6/IE7 from redirecting in admin/assets after deleting multiple folders (fixes #5208)
 * [rev:101958] Checking for existing redirections in FormResponse::respond (fixes #5208)
 * [rev:101956] Fixed "object not found" javascript error  in SecurityAdmin_right.js when changing group nodes (fixes #5179)
 * [rev:101939] Ensure that DataObject IDs are numbers and no string equivalents of numbers - 3 not '3'
 * [rev:101869] Update Salad tests to match behaviour
 * [rev:101867] #4188 simon_w: Let require tags in templates be conditional
 * [rev:101866] Recover if a manifestClassParse file doesn't have the necessary content.
 * [rev:101812] Added allowed_actions to  ContentControllerSearchExtension
 * [rev:101810] #5295: Update CMS site name in LHS via Ajax after siteconfig save.
 * [rev:101807] fixed undefined error in CTFs. BUGFIX: added action class to actions to allow the popup hook to open links
 * [rev:101795] keep ModelAdmin from importing data twice
 * [rev:101794] avoid call to non-object
 * [rev:101793] preserve the port value if given in HTTP::setGetVar (#5280). BUGFIX: allow username only input rather than user:pass combo.
 * [rev:101792] disable function re-enabled
 * [rev:101791] deprecated split function replaced
 * [rev:101758] fix #5320
 * [rev:101747] Always including "Locale" field in Translatable->getCMSFields() regardless of "excluded" page types. Necessary to enable form state serialization for fields like TreeSelectorField on a VirtualPage (fixes #5269)
 * [rev:101739] Versioned->publish() with $createNewVersion=TRUE now increases version number of in-memory object (fixes #5261)
 * [rev:101737] RedirectorPage types shouldn't appear in "Pages with no content" side report in the CMS Pages tab
 * [rev:101724] #5277 Sort of default SiteTree records is now explicitly set to avoid strange ordering set by SiteTree::onBeforeWrite for default records
 * [rev:101719] Only show "Roles" tab in admin/security if user has APPLY_ROLES permissions (fixes #5258)
 * [rev:101711] Don't replace "home/" URLSegment in SiteTree->RelativeLink() if Translatable is enabled and the homepage is not on the root level (nested URLs allows you to have homepages called "en/home" and "ru/home") (fixes #5244)
 * [rev:101668] #5259 RedirectorPage and HtmlEditorField TinyMCE integration now prefixes http:// if no prefix is found
 * [rev:101657] #5245 Sometimes page records will have a NULL ParentID value, it should be a number even if it's 0 (thanks wrossiter!)
 * [rev:101638] #5243 Undefined Convert functions in ViewableData replaced with working versions. Thanks benediktb!
 * [rev:101631] test that the class exists before running subclass tests
 * [rev:101623] put back into the SSNavigator the archived site link (#5251)
 * [rev:101608] Explicitly specify the many_many's join table name in the join's ON match statement in ManyManyComplexTableField
 * [rev:101604] remove the unnecessary DOM manipulation, this is legacy code due to SilverStripeNavigator changes (open #5250)
 * [rev:101603] the function makes an assumption we are working on Draft site, and breaks if we are not. Rewritten to be stage-independent, as get_version (open #5231)
 * [rev:101602] IE does not accept TD element without a table, repacking into DIV (open #5228)
 * [rev:101592] get a object inside transaction block will alway exist
 * [rev:101554] tables and column quoted properly
 * [rev:101493] tables and column quoted properly
 * [rev:101492] results sorted alphabetically for consistency
 * [rev:101491] results sorted alphabetically for consistency
 * [rev:101392] HTTP::setGetVar() returns a relative URL if a relative URL is passed, to make behaviour closer to 2.3
 * [rev:101380] disabling unused file list as feature is still buggy.
 * [rev:101375] Fixed closing `</div>` which should have been a `</td>` for dragfile in AssetTableField
 * [rev:101302] Fixed SiteTree->Content link shortcode parsing introduced in r101093 (#5227)
 * [rev:101267] #5222 Fixed TreeDropdownField not working on FileIFrameField/ImageField
 * [rev:101266] Fixed Folder writing by overloading validate() (was inheriting File->validate() which does extension checks)
 * [rev:101266] Fixed Folder::findOrMake() not to create "new-folder" through File->setName() if using a trailing slash in the path (which causes an empty name). Added FolderTest to verify this.
 * [rev:101264] Checking for existence of "ShowInMenus" property in Folder->liveChildren() and stageChildren() (#5190)
 * [rev:101227] Don't delete index.php after successful installation - in ContentController->deleteinstallfiles(). URL routing might rely on it without mod_rewrite.
 * [rev:101227] Require ADMIN permissions for ContentController->deleteinstallfiles() - together with retaining index.php this removed a vulnerability where unauthenticated users can disrupt mod_rewrite-less URL routing.
 * [rev:101220] TeamComment table added to dataobjects list
 * [rev:101189] Make SS_ReportWrapper::sourceRecords()' arguments optional
 * [rev:101175] Fixed quotes around Folder::hasChildFolders() ParentID column
 * [rev:101173] Don't run click() on all inputs, but input:radio only
 * [rev:101171] Pass correct class to allowPrimaryKeyEditing in yaml fixture
 * [rev:101170] Don't recreate a missing draft page when calling SiteTree::doUnpublish()
 * [rev:101167] #5216 Installer has issues with click handlers applied to the entire li, be more specific and apply it to the label and input instead
 * [rev:101165] Fixed versioning of pages
 * [rev:101155] Prevent failed migrateVersion writes from breaking versioning system in future writes.
 * [rev:101155] MAke site tree pages go green when you save a new draft.
 * [rev:101154] #5214 ViewableData::obj() was creating a DBField without a fieldname argument and caused problems, one example is the version panel of the CMS
 * [rev:101153] Ensure that Versioned works on classes with underscores in the names. (from r100905)
 * [rev:101138] Fixed issues with broekn link tracking
 * [rev:101131] Allow classes to be referred to with casing that differs from their definition.
 * [rev:101129] Fixed FileLinkTrackingTest to cope with the empty alt="" and title="" attributes that are created
 * [rev:101127] Improved reliabilty of broken link tracking.
 * [rev:101127] Don't mark a page as changed on stage if the only thing that has changed is broken link metadata


###  Minor changes

 * [rev:102045] Fixed spelling mistake in ConfigureFromEnv class documentation
 * [rev:102018] Fixed VersionedTest arguments in test case
 * [rev:102010] Fixed regression from r101752 (adding permission roles button was missing)
 * [rev:102009] Fixed indentation
 * [rev:101974] Saving TinyMCE editor focus in tinymce_ssbuttons plugin when sidepanel is opened (see #5263)
 * [rev:101971] Fixed indentation
 * [rev:101970] Fix tests to cope with ID type cleanup changed recently
 * [rev:101889] removed duplication of variable and conditional that would never pass
 * [rev:101883] take advantage of an alternate path for error pages
 * [rev:101882] TreeTitle really should return title, not name.
 * [rev:101870] Make Salad accept "login" or "log in"
 * [rev:101868] Added missing file for r101867
 * [rev:101811] Fixed JSONDataFormatter excaping (fixes #5309, thanks briley)
 * [rev:101782] Marked DataObject::has_own_table() as static
 * [rev:101754] Removed unnecessary console.*() from cms javascript files
 * [rev:101753] Removed unnecessary console.*() from sapphire javascript files
 * [rev:101752] Removed unnecessary "show" icons in "Roles" and "Member" ComplexTableFields
 * [rev:101751] Removed unnecessary "show" icons in "Roles" and "Member" ComplexTableFields
 * [rev:101729] use red font instead of gray when displaying error
 * [rev:101723] Fixed getElementsByClassName() usage in AssetTableField.js (fixes #5256)
 * [rev:101718] Fixed tab naming in Group->getCMSFields()
 * [rev:101698] Respecting folder sort order in admin/assets by adding Folder::$default_sort="Sort" (#5235)
 * [rev:101688] Removed fullstop where it wasn't needed
 * [rev:101687] Tidied up the layout of the Themes area of the installer slightly - now consistent helptext as other areas
 * [rev:101686] Updated CMS Admin Account text to be more precise
 * [rev:101683] Altered wording in installer for localised interface
 * [rev:101671] Reverted r101670 as it broke assumptions made in RedirectorPageTest
 * [rev:101638] Updated ViewableDataTest to verify ViewableData changes
 * [rev:101619] Made the default database directory relative to assets ".db" which is more precise than ".sqlitedb"
 * [rev:101618] Made SQLite path in installer use DIRECTORY_SEPARATOR so it shows as correct on Windows using backslashes instead of forwardslashes - this is more of a cosmetic thing, as slashes can be interchanged and still parsed correctly by PHP
 * [rev:101600] fixed notice level error
 * [rev:101353] Removed rewritest.php places in sapphire since it's no longer part of the phpinstaller/branches/2.4 package
 * [rev:101341] Made reinstall message more precise by adding web.config to the files that will get overwritten
 * [rev:101282] Moved "theme" section further down in the installer, its much less likely to be changed than the database connection and admin account fields.
 * [rev:101254] Fixed missing closing `<div>` in ContentController->successfullyinstalled()
 * [rev:101251] Fixed regression in install.js option selection (see r101173)
 * [rev:101172] Fix output format of buildbot test runs to not include colour control codes.
 * [rev:101166] versioning test for SiteTree
 * [rev:101135] Fixed multifile.js non-standard forEach() reference, using jQuery.each() instead
 * [rev:101134] Localized "dependent pages" features in SiteTree->getCMSFields()
 * [rev:101132] Fixed test that was relying on bug fixed in r101116


###  Other

 * [rev:101314] ENHNACEMENT Installer no longer asks for firstname and surname for default CMS admin account, this can be changed later on and doesn't need to be entered for installation

`./sscreatechangelog --version 2.4.0-rc1 --branch branches/2.4 --stoprevision 101127`