# 3.1.0-beta2 #

## Overview ##

 * Changed action handling and allowed_actions to make more secure by default
 * Moved dev/tests/startsession to a module
 * Security: Undefined or empty `$allowed_actions` overrides parent definitions
 * Security: Information leakage through web access on YAML configuration files
 * Security: Information leakage through web access on composer files
 * Security: Require ADMIN permissions for `?showtemplate=1`
 * Security: Reflected XSS in custom date/time formats in admin/security
 * Security: Stored XSS in the "New Group" dialog
 * Security: Reflected XSS in CMS status messages

## Upgrading

See [3.1.0 release notes](/changelogs/3.1.0)

## Changelog

### API Changes

 * 2013-02-18 [5fd55a5](https://github.com/silverstripe/sapphire/commit/5fd55a5) Tighten up allowed_actions (Hamish Friedlander)
 * 2013-02-12 [d969e29](https://github.com/silverstripe/sapphire/commit/d969e29) Require ADMIN for ?showtemplate=1 (Ingo Schommer)
 * 2013-02-12 [45c68d6](https://github.com/silverstripe/sapphire/commit/45c68d6) Require ADMIN for ?showtemplate=1 (Ingo Schommer)
 * 2013-02-13 [53feb3a](https://github.com/silverstripe/sapphire/commit/53feb3a) Add possibility to combine media-targeting stylesheets. (Mateusz Uzdowski)
 * 2013-02-12 [f931b8d](https://github.com/silverstripe/sapphire/commit/f931b8d) Data corruption on Versioned due to lazy loading (Julian Seidenberg)
 * 2013-02-05 [18c9a95](https://github.com/silverstripe/sapphire/commit/18c9a95) Removed 'BadLoginURL' session var from MemberLoginForm (Ingo Schommer)
 * 2013-01-27 [e8da9c9](https://github.com/silverstripe/sapphire/commit/e8da9c9) Use HTMLText as default for RSS Description (jonom)
 * 2013-01-25 [4b54383](https://github.com/silverstripe/sapphire/commit/4b54383) request handling to be more orthogonal (Hamish Friedlander)
 * 2013-01-24 [1ca15d0](https://github.com/silverstripe/sapphire/commit/1ca15d0) HTTP::urlRewriter with (string)$code deprecated in 3.1. Fixed regressions and CSS urls. (Damian Mooyman)
 * 2013-01-23 [c69381c](https://github.com/silverstripe/sapphire/commit/c69381c) Remove Content-Length setting from HTTPResponse (fixes #8010) (Ingo Schommer)
 * 2013-01-09 [f07ad30](https://github.com/silverstripe/sapphire/commit/f07ad30) Removed non-functional $join argument from DataObject::get() and other APIs (Ingo Schommer)
 * 2012-12-19 [d487a42](https://github.com/silverstripe/sapphire/commit/d487a42) Default to Upload::$uploads_dir in UploadField (Nathan J. Brauer)
 * 2012-12-19 [2e1a508](https://github.com/silverstripe/sapphire/commit/2e1a508) Remove dev/tests/startsession etc, use new "testsession" module (Ingo Schommer)
 * 2012-11-29 [f49f1ff](https://github.com/silverstripe/sapphire/commit/f49f1ff) Rename Transliterator to SS_Transliterator to remove conflict with Intl extension (Simon Welsh)
 * 2012-11-09 [22095da](https://github.com/silverstripe/sapphire/commit/22095da) Hash autologin tokens before storing in the database. (Mateusz Uzdowski)
 * 2011-03-16 [d8bfc0b](https://github.com/silverstripe/sapphire/commit/d8bfc0b) Added Security::set_login_url() so that you can define an alternative log-in page if you have made one yourself. (Sam Minnee)
 * 2011-03-16 [f546979](https://github.com/silverstripe/sapphire/commit/f546979) Add a PermissionFailureException that can be thrown to trigger a log-in. (Sam Minnee)

### Features and Enhancements

 * 2013-02-14 [2335c07](https://github.com/silverstripe/sapphire/commit/2335c07) Make shortcode parser more clever about placement (Hamish Friedlander)
 * 2013-02-12 [54237d5](https://github.com/silverstripe/sapphire/commit/54237d5) Return $this on setters in DataObject (Zauberfisch)
 * 2013-02-05 [f0621cd](https://github.com/silverstripe/sapphire/commit/f0621cd) Added ability to query size of Varchar (Daniel Hensby)
 * 2013-02-05 [1acb416](https://github.com/silverstripe/sapphire/commit/1acb416) Don't load CMS preview iframe if not visible (fixes #8247) (Ingo Schommer)
 * 2013-02-04 [00097a5](https://github.com/silverstripe/silverstripe-cms/commit/00097a5) Clickable URL preview in CMS (Ingo Schommer)
 * 2013-02-01 [119d8aa](https://github.com/silverstripe/silverstripe-cms/commit/119d8aa) Do not display SilverStripeNavigator_CMSLink when in a LeftAndMain extension not just CMSMain extensions (UndefinedOffset)
 * 2013-02-01 [0cb6b46](https://github.com/silverstripe/sapphire/commit/0cb6b46) Storing page preview states (fixes #8092) (Kirk Mayo)
 * 2013-01-15 [ca84ddc](https://github.com/silverstripe/sapphire/commit/ca84ddc) Preview size and default mode configurability (Ingo Schommer)
 * 2013-01-15 [16efd74](https://github.com/silverstripe/sapphire/commit/16efd74) Add grid field save handler. (Andrew Short)
 * 2013-01-14 [76aeec7](https://github.com/silverstripe/silverstripe-cms/commit/76aeec7) SiteTree-&gt;PreviewLink() for fine grained URL control (Ingo Schommer)
 * 2013-01-11 [5b450f7](https://github.com/silverstripe/sapphire/commit/5b450f7) Added replaceExistingFile setting for UploadField. (Sam Minnee)
 * 2013-01-11 [cc7318f](https://github.com/silverstripe/sapphire/commit/cc7318f) Added canAttachExisting config option for UploadField. (Sam Minnee)
 * 2013-01-10 [5e6f5f9](https://github.com/silverstripe/sapphire/commit/5e6f5f9) Allow configuration of send_all_emails_to, ccs_all_emails_to, and bcc_all_emails_to via the config system. (Sam Minnee)
 * 2013-01-09 [43601d6](https://github.com/silverstripe/sapphire/commit/43601d6) Global default config for UploadField (Ingo Schommer)
 * 2013-01-09 [67c5db3](https://github.com/silverstripe/sapphire/commit/67c5db3) Global default config for UploadField (Ingo Schommer)
 * 2013-01-09 [2dfd427](https://github.com/silverstripe/sapphire/commit/2dfd427) Restrict upload abilities in UploadField (Ingo Schommer)
 * 2013-01-09 [9310b8d](https://github.com/silverstripe/sapphire/commit/9310b8d) Restrict upload abilities in UploadField (Ingo Schommer)
 * 2013-01-07 [abbee41](https://github.com/silverstripe/sapphire/commit/abbee41) Add ReadonlyField::setIncludeHiddenField() (Sam Minnee)
 * 2012-12-19 [561e629](https://github.com/silverstripe/sapphire/commit/561e629) Show the allowed extensions as a toggle tip as per trac 7993 (Kirk Mayo)
 * 2012-12-17 [f9504ee](https://github.com/silverstripe/silverstripe-cms/commit/f9504ee) Writing caching metadata as HTML comments in FilesystemPublisher (through StaticPublisher::$include_caching_metadata) (ischommer) (Andrew O'Neil)
 * 2012-12-13 [8066376](https://github.com/silverstripe/sapphire/commit/8066376) LeftAndMain breadcrumbs to use MenuTitle (Loz Calver)
 * 2012-10-17 [7f605cf](https://github.com/silverstripe/sapphire/commit/7f605cf) Disable items in DropdownField and GroupedDropdownField (micschk)
 * 2012-10-16 [c4dde90](https://github.com/silverstripe/sapphire/commit/c4dde90) Allow hashes to be passed as ArrayList items; the will be turned into ArrayData objects. (Sam Minnee)
 * 2011-09-29 [2916f20](https://github.com/silverstripe/sapphire/commit/2916f20) Improve HTTP caching logic to automatically disable caching for requests that use the session. (Hamish Friedlander)
 * 2011-03-02 [c3a3ff4](https://github.com/silverstripe/sapphire/commit/c3a3ff4) Added Email::send_all_emails_from() setting. (Sam Minnee)

### Bugfixes

 * 2013-02-18 [baf894d](https://github.com/silverstripe/sapphire/commit/baf894d) CDATA sections in HTML5 are invalid so remove from test (Hamish Friedlander)
 * 2013-02-18 [1f4c817](https://github.com/silverstripe/sapphire/commit/1f4c817) new ShortcodeParser handling of empty strings and escapes (Hamish Friedlander)
 * 2013-02-17 [ede3813](https://github.com/silverstripe/sapphire/commit/ede3813) Secure composer files from web access (fixes #8011) (Ingo Schommer)
 * 2013-02-17 [e21bd49](https://github.com/silverstripe/sapphire/commit/e21bd49) TimeField respects user choice (fixes #8260) (Ingo Schommer)
 * 2013-02-14 [d3629be](https://github.com/silverstripe/sapphire/commit/d3629be) Pass named include argument as objects. (ajshort)
 * 2013-02-13 [ff19f3b](https://github.com/silverstripe/sapphire/commit/ff19f3b) Fixed the injection of named services. (ajshort)
 * 2013-02-12 [d52d5f7](https://github.com/silverstripe/sapphire/commit/d52d5f7) Adjust Session::setFormMessage to fit with underlying API. (Mateusz Uzdowski)
 * 2013-02-07 [79eacb2](https://github.com/silverstripe/sapphire/commit/79eacb2) Group-&gt;canEdit() correct non-admin checks (fixes #8250) (Ingo Schommer)
 * 2013-02-07 [2e77e87](https://github.com/silverstripe/sapphire/commit/2e77e87) fix for broken layout in insert media dialog - Trac #8232 (Jeremy Bridson)
 * 2013-02-05 [8dae8a3](https://github.com/silverstripe/silverstripe-cms/commit/8dae8a3) Fixed limiting of URLs on RebuildStaticCacheTask (Ingo Schommer)
 * 2013-02-05 [23eeb99](https://github.com/silverstripe/silverstripe-cms/commit/23eeb99) Clear Requirements before in-memory HTTP request for ErrorPage (Ingo Schommer)
 * 2013-02-04 [b4c9c18](https://github.com/silverstripe/silverstripe-cms/commit/b4c9c18) Prevent conflict when using multiple SiteTreeURLSegmentField's in CMS edit form (Ryan Wachtl)
 * 2013-02-04 [857d8bb](https://github.com/silverstripe/sapphire/commit/857d8bb) Don't escape values on TreeDropdownField readonly views (Ingo Schommer)
 * 2013-02-04 [97fbfd3](https://github.com/silverstripe/silverstripe-cms/commit/97fbfd3) Respect escaping rules on readonly fields in CMS history view (Ingo Schommer)
 * 2013-02-04 [e56a78b](https://github.com/silverstripe/silverstripe-cms/commit/e56a78b) updateCMSFields not accepting var by reference (Michael Andrewartha)
 * 2013-02-04 [866bb07](https://github.com/silverstripe/sapphire/commit/866bb07) validate doesn't take var by reference (Michael Andrewartha)
 * 2013-02-04 [1960df8](https://github.com/silverstripe/sapphire/commit/1960df8) Strict error warnings on DataExtension (Michael Andrewartha)
 * 2013-02-04 [82099f6](https://github.com/silverstripe/sapphire/commit/82099f6) fixed pagination for "upload from CMS" grid field pagination open/8085 (Jeremy Bridson)
 * 2013-02-04 [0fade6c](https://github.com/silverstripe/sapphire/commit/0fade6c) fixed styling of asset upload page and dialog in the asset admin and media insert via WYSIWYG editor open/8231. (Jeremy Bridson)
 * 2013-02-01 [aa3eb98](https://github.com/silverstripe/sapphire/commit/aa3eb98) Assiging width to caption instead of container (Hamish Friedlander)
 * 2013-01-31 [1bb1090](https://github.com/silverstripe/sapphire/commit/1bb1090) Node updates in IE without non-object error (Ingo Schommer)
 * 2013-01-31 [4681673](https://github.com/silverstripe/sapphire/commit/4681673) TinyMCE context menu displaying default dialogs instead of our one (Hamish Friedlander)
 * 2013-01-31 [6f93774](https://github.com/silverstripe/sapphire/commit/6f93774) Not being able to remove, add or edit the caption on an image properly (Hamish Friedlander)
 * 2013-01-30 [eb7fed9](https://github.com/silverstripe/sapphire/commit/eb7fed9) Prevent defocus on first change in CMS HTMLEditorField (fixes #8217) (Ingo Schommer)
 * 2013-01-30 [38e930d](https://github.com/silverstripe/sapphire/commit/38e930d) Blocking of preview screen (regression) (Ingo Schommer)
 * 2013-01-30 [3111ad1](https://github.com/silverstripe/sapphire/commit/3111ad1) Remove extraneous &lt;/div&gt; breaking IE8 image embedding (os#8218) (Mateusz Uzdowski)
 * 2013-01-30 [9f822d1](https://github.com/silverstripe/sapphire/commit/9f822d1) Not calling updateFromNode on re-opening an image (Hamish Friedlander)
 * 2013-01-30 [c9f728f](https://github.com/silverstripe/sapphire/commit/c9f728f) Only check the remember token if a user exists (Simon Welsh)
 * 2013-01-29 [6c78bf9](https://github.com/silverstripe/sapphire/commit/6c78bf9) Flush editors on form submission (os#8222) (Mateusz Uzdowski)
 * 2013-01-25 [649de6e](https://github.com/silverstripe/silverstripe-cms/commit/649de6e) Reinstated CMS "History" Preview (fixes ##8089) (Ingo Schommer)
 * 2013-01-25 [3457f43](https://github.com/silverstripe/sapphire/commit/3457f43) Respect CMS preview active state (related to #8089) (Ingo Schommer)
 * 2013-01-24 [e1e6483](https://github.com/silverstripe/sapphire/commit/e1e6483) Replaced extendedSQL/buildSQL with DataList as per ticket 8183 (Kirk Mayo)
 * 2013-01-24 [81cd0e6](https://github.com/silverstripe/silverstripe-cms/commit/81cd0e6) Replaced extendedSQL with DataList as per ticket 8183 (Kirk Mayo)
 * 2013-01-24 [f574979](https://github.com/silverstripe/sapphire/commit/f574979) Exception handling and email notification mechanism now correctly considers the stacktrace as provided by the exceptionHandler function, instead of attempting to perform a debug_backtrace further down the reporting chain (which ends up generating an unnecessarily nested stacktrace). Debug was cleaned up so that errorHandler and exceptionHandler both act consistently. As a result, the LogErrorEmailFormatter class could be simplified. (Damian Mooyman)
 * 2013-01-23 [437914d](https://github.com/silverstripe/sapphire/commit/437914d) PHPUnit latest not working with composer installed builds (Hamish Friedlander)
 * 2013-01-23 [45eb0f9](https://github.com/silverstripe/sapphire/commit/45eb0f9) PHPUnit latest not working with composer installed builds (Hamish Friedlander)
 * 2013-01-21 [5d37d55](https://github.com/silverstripe/sapphire/commit/5d37d55) Form session message clearing regression (Ingo Schommer)
 * 2013-01-21 [1571d35](https://github.com/silverstripe/silverstripe-cms/commit/1571d35) Only use $.button in onunmatch if init'ed (fixes #8181) (Kirk Mayo)
 * 2013-01-18 [0c9b216](https://github.com/silverstripe/sapphire/commit/0c9b216) Escape the -f argument passed to mail() (Sam Minnee)
 * 2013-01-17 [e74ec57](https://github.com/silverstripe/sapphire/commit/e74ec57) Permission checkbox display on members (fixes #8193) (Ingo Schommer)
 * 2013-01-15 [a70df3e](https://github.com/silverstripe/sapphire/commit/a70df3e) PaginatedList deprecated method was calling non-existent method (Jeremy Thomerson)
 * 2013-01-15 [014f541](https://github.com/silverstripe/sapphire/commit/014f541) Regression in Form-&gt;clearMessage() (fixes #8186) (Ingo Schommer)
 * 2013-01-15 [64d3a3d](https://github.com/silverstripe/sapphire/commit/64d3a3d) Don't double unescape URLs in history.js (fixes #8170) (Ingo Schommer)
 * 2013-01-15 [420c639](https://github.com/silverstripe/sapphire/commit/420c639) Properly show link for showing and hiding class spec in model admin (jean)
 * 2013-01-15 [f06ba70](https://github.com/silverstripe/sapphire/commit/f06ba70) Undefined `$allowed_actions` overrides parent definitions, stricter handling of $allowed_actions on Extension (Ingo Schommer)
 * 2013-01-15 [a93f884](https://github.com/silverstripe/sapphire/commit/a93f884) fixed broken styling of iframe in IE for member and group import (Jeremy Bridson)
 * 2013-01-11 [e020c7b](https://github.com/silverstripe/sapphire/commit/e020c7b) doSave() and doDelete() should use translated singular name (uniun)
 * 2013-01-11 [f8758ba](https://github.com/silverstripe/sapphire/commit/f8758ba) Fixed margins so that margin is displayed between preview images and their title. (Sam Minnee)
 * 2013-01-11 [2fdd9a3](https://github.com/silverstripe/sapphire/commit/2fdd9a3) Allow images attached to UploadFields to be unlinked without File::canEdit() or File::canDelete() permission. (Sam Minnee)
 * 2013-01-11 [f4efaee](https://github.com/silverstripe/sapphire/commit/f4efaee) Fix DataObject::get_one() when the classname is passed with improper casing. (Sam Minnee)
 * 2013-01-09 [5f8115f](https://github.com/silverstripe/sapphire/commit/5f8115f) Hard fallback to en_US.js in Requirements (Ingo Schommer)
 * 2013-01-09 [ffc6d6f](https://github.com/silverstripe/silverstripe-cms/commit/ffc6d6f) Disable CMS preview for RedirectorPage (fixes #7127) (Ingo Schommer)
 * 2013-01-08 [f674af0](https://github.com/silverstripe/silverstripe-cms/commit/f674af0) dependentPages grid field not showing necessary columns and their values. (Normann Lou)
 * 2013-01-07 [383ae8f](https://github.com/silverstripe/silverstripe-cms/commit/383ae8f) SiteTree_Information.ss was not making use if i18n translations (Kirk Mayo)
 * 2013-01-06 [30096ee](https://github.com/silverstripe/sapphire/commit/30096ee) Keep Member.PasswordEncryption setting on empty passwords (Ingo Schommer)
 * 2013-01-04 [f8bbc0a](https://github.com/silverstripe/sapphire/commit/f8bbc0a) Escape HTML in DropdownField and ListboxField (Ingo Schommer)
 * 2013-01-04 [604ede3](https://github.com/silverstripe/sapphire/commit/604ede3) Escape HTML in CMS status messages (Ingo Schommer)
 * 2013-01-04 [7bb0bbf](https://github.com/silverstripe/sapphire/commit/7bb0bbf) Fixed XSS in admin/security and "My Profile" forms (Ingo Schommer)
 * 2013-01-02 [63dbb1c](https://github.com/silverstripe/sapphire/commit/63dbb1c) removed null FormField value. fixes #8088 (g4b0)
 * 2012-12-21 [f0f83b2](https://github.com/silverstripe/sapphire/commit/f0f83b2) Graceful handling of sprintf with too few params in i18n::_t() (Ingo Schommer)
 * 2012-12-20 [7a6ce01](https://github.com/silverstripe/sapphire/commit/7a6ce01) Skip pagination on UnsavedRelationList in GFPaginator (Ingo Schommer)
 * 2012-12-20 [e53280c](https://github.com/silverstripe/sapphire/commit/e53280c) SQLQuery::aggregate() with limit, groupBy and orderBy (fixes #8148) (g4b0)
 * 2012-12-19 [22efd38](https://github.com/silverstripe/sapphire/commit/22efd38) Calling DataObject::relField() on a object with an empty relation list (Stig Lindqvist)
 * 2012-12-18 [4388433](https://github.com/silverstripe/sapphire/commit/4388433) Right click on LeftAndMain menu caused CMS preview window to open (Loz Calver)
 * 2012-12-18 [6aba24b](https://github.com/silverstripe/sapphire/commit/6aba24b) removeRequiredField() should use array_splice() instead of unset() (uniun)
 * 2012-12-18 [d5a1c3d](https://github.com/silverstripe/sapphire/commit/d5a1c3d) SS has problems handling + in URLs. Filter them out. (Mateusz Uzdowski)
 * 2012-12-18 [94be5c6](https://github.com/silverstripe/sapphire/commit/94be5c6) Handle namespaced classes in Object::parse_class_spec() (Simon Welsh)
 * 2012-12-17 [8779e9b](https://github.com/silverstripe/sapphire/commit/8779e9b) Fixed changetracking for radio and checkbox field types (Ingo Schommer)
 * 2012-12-18 [b01b91f](https://github.com/silverstripe/sapphire/commit/b01b91f) When selecting stage_unique from Versioned the augmentSQL function would permanantly alter the DataQuery while doing a recursive augmentSQL. This fix correctly maintains the correct Versioned.mode so that subsequent calls to this function exhibit the same expected behaviour. (Damian Mooyman)
 * 2012-12-17 [6aa16e1](https://github.com/silverstripe/sapphire/commit/6aa16e1) Test case for versioned now correctly checks IDs returned from Versioned::get_including_deleted BUG Issue with deleted records not being queried properly. API DataQuery::expressionForField no longer requires a second parameter. Rather the query object is inferred from the DataQuery itself. This should improve consistency of use of this function. (Damian Mooyman)
 * 2012-12-14 [55b611d](https://github.com/silverstripe/sapphire/commit/55b611d) Hardcoded project name in include_by_locale() (uniun)
 * 2012-12-13 [0ee7bbf](https://github.com/silverstripe/sapphire/commit/0ee7bbf) Removed !important attribute of #Remember margin (Justin Martin)
 * 2012-12-11 [f431b35](https://github.com/silverstripe/sapphire/commit/f431b35) Confirmed Password Field now copies attributes to child fields. (Justin Martin)
 * 2012-12-06 [1a4eaaa](https://github.com/silverstripe/sapphire/commit/1a4eaaa) Ensure  has length before using string index access. (Simon Elvery)
 * 2012-11-21 [41aec54](https://github.com/silverstripe/silverstripe-cms/commit/41aec54) Consistently use FormResponse in CMS JavaScript (fixes #8036) (Ingo Schommer)
 * 2012-02-09 [c048a01](https://github.com/silverstripe/sapphire/commit/c048a01) Avoid infinite redirection when logging out and when showing a custom login page after displaying the draft version of a page. (jean)
 * 2011-12-12 [1e1df8c](https://github.com/silverstripe/sapphire/commit/1e1df8c) Improved detection of empty HTMLText fields. (Sam Minnee)
 * 2011-09-30 [f41a7d8](https://github.com/silverstripe/sapphire/commit/f41a7d8) Fix issue with not being able to log out on Chrome when caching enabled because of Chrome bug (Hamish Friedlander)
 * 2011-09-01 [9a2ba48](https://github.com/silverstripe/sapphire/commit/9a2ba48) Made CSRF-error wording friendlier. (Sam Minnee)
 * 2011-08-31 [729bcc9](https://github.com/silverstripe/sapphire/commit/729bcc9) Don't clear form messages unless forTemplate() is actually called. BUGFIX: Clear session-stored form data as well as form error message. (Sam Minnee)
 * 2011-08-18 [5f9348b](https://github.com/silverstripe/sapphire/commit/5f9348b) Ensure that Security views respect redirections triggered by Page_Controller::init() (Sam Minnee)
 * 2011-07-07 [b114aa2](https://github.com/silverstripe/sapphire/commit/b114aa2) Added X-Forwarded-Protocol and User-Agent to Vary header. (Sam Minnee)
 * 2011-05-26 [55f3ec1](https://github.com/silverstripe/sapphire/commit/55f3ec1) Added error message fields to default search form (Jean-Fabien)
 * 2011-05-23 [7026a48](https://github.com/silverstripe/sapphire/commit/7026a48) for date manipulation use the SS_Datetime::now, otherwise it does not respect the mock date. (Mateusz Uzdowski)
 * 2011-05-21 [b7a1db7](https://github.com/silverstripe/sapphire/commit/b7a1db7) Set up the test mailer before loading the fixture, in case fixture-creation causes emails to be generated. (Sam Minnee)
 * 2011-04-29 [47e037e](https://github.com/silverstripe/sapphire/commit/47e037e) Removed notice-level error after forms w/ required fields are made readonly. (Sam Minnee)
 * 2011-04-20 [33a1fc7](https://github.com/silverstripe/sapphire/commit/33a1fc7) Fixed operation of inlined images in Mailer, when no inlined images actually attached. (Carlos Barberis)
 * 2011-04-18 [f8206d1](https://github.com/silverstripe/sapphire/commit/f8206d1) Prevent notice-level error in Session code when non-array is turned into an array. (Sam Minnee)
 * 2011-03-15 [6fcbad1](https://github.com/silverstripe/sapphire/commit/6fcbad1) Updated SilverStripe error handler so that log_errors still works. (Sam Minnee)
 * 2011-03-11 [82988d4](https://github.com/silverstripe/sapphire/commit/82988d4) Better error message when 401 response is corrupted. (Sam Minnee)

### Other

 * 2013-02-18 [37b8034](https://github.com/silverstripe/sapphire/commit/37b8034) Fixed changelog (Ingo Schommer)
 * 2013-02-18 [ad9f26a](https://github.com/silverstripe/sapphire/commit/ad9f26a) Updated changelog (Ingo Schommer)
 * 2013-02-18 [eafafb3](https://github.com/silverstripe/sapphire/commit/eafafb3) Fixed screen.css (wrong compilation) (Ingo Schommer)
 * 2013-02-18 [e809e07](https://github.com/silverstripe/silverstripe-cms/commit/e809e07) Updated translations (Ingo Schommer)
 * 2013-02-18 [d3d0b21](https://github.com/silverstripe/sapphire/commit/d3d0b21) Updated translations (Ingo Schommer)
 * 2013-02-18 [6298713](https://github.com/silverstripe/sapphire/commit/6298713) Updated changelog (Ingo Schommer)
 * 2013-02-17 [889e39c](https://github.com/silverstripe/sapphire/commit/889e39c) Support running namespaced build tasks. (ajshort)
 * 2013-02-15 [5d3ed12](https://github.com/silverstripe/sapphire/commit/5d3ed12) Nginx docs for denying composer file access (fixes #8011) (Ingo Schommer)
 * 2013-02-13 [923ad88](https://github.com/silverstripe/sapphire/commit/923ad88) Layout regression in "add pages" (Ingo Schommer)
 * 2013-02-11 [8ea805e](https://github.com/silverstripe/sapphire/commit/8ea805e) Long drop area title overlaps upload icon (uniun)
 * 2013-02-11 [a4096ec](https://github.com/silverstripe/sapphire/commit/a4096ec) Add a self method to the SSViewer scope. (ajshort)
 * 2013-02-08 [7ff8d35](https://github.com/silverstripe/sapphire/commit/7ff8d35) Force preview window to refresh on every save (Robert Curry)
 * 2013-02-07 [537b0c6](https://github.com/silverstripe/silverstripe-cms/commit/537b0c6) Define $allowed_actions consistently (Ingo Schommer)
 * 2013-02-07 [f2a9a26](https://github.com/silverstripe/sapphire/commit/f2a9a26) Fixed error in documentation (g4b0)
 * 2013-02-08 [5e6813c](https://github.com/silverstripe/sapphire/commit/5e6813c) Use the injector for creating tasks. (ajshort)
 * 2013-02-07 [1a43ad5](https://github.com/silverstripe/sapphire/commit/1a43ad5) Removed widths on DatetimeField children (Ingo Schommer)
 * 2013-02-07 [048f6b1](https://github.com/silverstripe/sapphire/commit/048f6b1) Removed DatetimeField-&gt;setDescription() proxying (Ingo Schommer)
 * 2013-02-07 [cc1a582](https://github.com/silverstripe/sapphire/commit/cc1a582) Fix deprecated use of has_extension (Robert Curry)
 * 2013-02-06 [a0e965b](https://github.com/silverstripe/silverstripe-cms/commit/a0e965b) Revert "FIX: updateCMSFields not accepting var by reference" (Ingo Schommer)
 * 2013-02-06 [a1beda1](https://github.com/silverstripe/sapphire/commit/a1beda1) Removed explicit pass-by-ref in DataExtension-&gt;validate() (Ingo Schommer)
 * 2013-02-06 [bb223bb](https://github.com/silverstripe/sapphire/commit/bb223bb) Update admin/javascript/lang/de_DE.js (senglmann)
 * 2013-02-05 [8c3f87b](https://github.com/silverstripe/silverstripe-cms/commit/8c3f87b) Results returned from FSP-&gt;publishPages() (Ingo Schommer)
 * 2013-02-05 [b19a82b](https://github.com/silverstripe/silverstripe-cms/commit/b19a82b) SiteTree on*() callbacks now consistently invoke on subclasses as well (Ingo Schommer)
 * 2013-02-05 [d289016](https://github.com/silverstripe/sapphire/commit/d289016) DataObject on*() callbacks now consistently invoke on subclasses as well (Ingo Schommer)
 * 2013-02-05 [e249799](https://github.com/silverstripe/sapphire/commit/e249799) Incorrect Contant-Type header for RSS feeds (uniun)
 * 2013-02-05 [b350ded](https://github.com/silverstripe/sapphire/commit/b350ded) Fixed DatetimeField formatting (single row, smaller field) (Ingo Schommer)
 * 2013-02-05 [6c22545](https://github.com/silverstripe/sapphire/commit/6c22545) DatetimeField-&gt;setDateField()/setTimeField() (Ingo Schommer)
 * 2013-02-05 [d320247](https://github.com/silverstripe/sapphire/commit/d320247) Trigger delete confirmation popup when deleting a GridFieldDetailForm record (Sean Harvey)
 * 2013-02-05 [ba825ce](https://github.com/silverstripe/sapphire/commit/ba825ce) Remove whitespace from LeftAndMain_Menu (Sean Harvey)
 * 2013-02-05 [632e0e8](https://github.com/silverstripe/sapphire/commit/632e0e8) Simplify sentence on shortcodes (Sean Harvey)
 * 2013-02-04 [fe74051](https://github.com/silverstripe/sapphire/commit/fe74051) Loading "OR" in admin/assets for Chrome (fixes #8245) (Ingo Schommer)
 * 2013-02-05 [d741aa9](https://github.com/silverstripe/sapphire/commit/d741aa9) Move the shortcode docs to documentation, add examples. (Mateusz Uzdowski)
 * 2013-02-04 [accbd7f](https://github.com/silverstripe/sapphire/commit/accbd7f) Revert "FIX: Strict error warnings on DataExtension" This reverts commit 1960df8bc30ecb0467a33275810fd121a0125733. (Ingo Schommer)
 * 2013-02-04 [0e6912c](https://github.com/silverstripe/sapphire/commit/0e6912c) Re-added 'auto' sizing for CMS preview (Ingo Schommer)
 * 2013-02-04 [1c045b5](https://github.com/silverstripe/sapphire/commit/1c045b5) Smaller styling for minor actions in CMS (Ingo Schommer)
 * 2013-02-04 [aa81333](https://github.com/silverstripe/sapphire/commit/aa81333) adjusted position of "OR" on the asset upload field and removed right margin from "choose files to upload…" button on the insert media dialog - open/8231 (Jeremy Bridson)
 * 2013-02-01 [b381e99](https://github.com/silverstripe/sapphire/commit/b381e99) Include "media" attr for module customCSS() (fixes #8219) (Ingo Schommer)
 * 2013-01-31 [920fd71](https://github.com/silverstripe/sapphire/commit/920fd71) Adding default curl options (Daniel Hensby)
 * 2013-02-01 [fd71a3d](https://github.com/silverstripe/sapphire/commit/fd71a3d) Consistently exposed ManyManyList information through getters. (ajshort)
 * 2013-01-30 [f003359](https://github.com/silverstripe/sapphire/commit/f003359) RestfulService_Response now gets response headers (Daniel Hensby)
 * 2013-01-30 [7c18973](https://github.com/silverstripe/sapphire/commit/7c18973) Better cache key generation (Daniel Hensby)
 * 2013-01-30 [77476de](https://github.com/silverstripe/sapphire/commit/77476de) Change to how environment file is found (Daniel Hensby)
 * 2013-01-30 [74a4493](https://github.com/silverstripe/silverstripe-cms/commit/74a4493) Excluded Postgres from Travis (breaks build due to internal errors) (Ingo Schommer)
 * 2013-01-30 [b25063b](https://github.com/silverstripe/silverstripe-cms/commit/b25063b) Extracted ErrorPage default data to getter (Ingo Schommer)
 * 2013-01-30 [3dab996](https://github.com/silverstripe/sapphire/commit/3dab996) Excluded Postgres from Travis (breaks build due to internal errors) (Ingo Schommer)
 * 2013-01-30 [7f4c173](https://github.com/silverstripe/sapphire/commit/7f4c173) Fixed indentation in Mailer (Ingo Schommer)
 * 2013-01-30 [7327f12](https://github.com/silverstripe/sapphire/commit/7327f12) Re-added wrapImagesInline and wrapImagesInline_rewriter to Mailer class (Ingo Schommer)
 * 2013-01-29 [416178b](https://github.com/silverstripe/silverstripe-cms/commit/416178b) Reduced code duplication in ErrorPage (no functional changes) (Ingo Schommer)
 * 2013-01-29 [b15b983](https://github.com/silverstripe/silverstripe-cms/commit/b15b983) Using new "Security.login_url" configuration value (Ingo Schommer)
 * 2013-01-29 [048ba5b](https://github.com/silverstripe/sapphire/commit/048ba5b) Formatting fix (drzax)
 * 2013-01-29 [bec5ae1](https://github.com/silverstripe/sapphire/commit/bec5ae1) Include code to block yaml files in installer generated .htaccess (Hamish Friedlander)
 * 2013-01-29 [acfc0be](https://github.com/silverstripe/sapphire/commit/acfc0be) Document that yaml files shouldnt be served directly (Hamish Friedlander)
 * 2013-01-28 [d51e0bc](https://github.com/silverstripe/sapphire/commit/d51e0bc) Improved docs on $allowed_actions (Ingo Schommer)
 * 2013-01-25 [ebe41cd](https://github.com/silverstripe/sapphire/commit/ebe41cd) CSS fixes for Batchactions. (uniun)
 * 2013-01-25 [f4f2862](https://github.com/silverstripe/sapphire/commit/f4f2862) Fix up /dev/build which should really have ever worked, but used to (Hamish Friedlander)
 * 2013-01-24 [3439e30](https://github.com/silverstripe/sapphire/commit/3439e30) Corrects indentation and line length (Simon Welsh)
 * 2013-01-24 [1f1b115](https://github.com/silverstripe/sapphire/commit/1f1b115) Fixing code formatting (Sean Harvey)
 * 2013-01-24 [657c14f](https://github.com/silverstripe/sapphire/commit/657c14f) Added test cases for exception error logging (Damian Mooyman)
 * 2013-01-24 [3aa2cdc](https://github.com/silverstripe/sapphire/commit/3aa2cdc) Fixing code formatting in rich-text-editing docs (Sean Harvey)
 * 2013-01-24 [9ac3cde](https://github.com/silverstripe/sapphire/commit/9ac3cde) Fix typo in templates/Controller.ss (Nicolaas)
 * 2013-01-24 [141538f](https://github.com/silverstripe/sapphire/commit/141538f) Add docs on how to customise the TinyMCE editor. (Mateusz U)
 * 2013-01-22 [317977a](https://github.com/silverstripe/silverstripe-cms/commit/317977a) More useful default cols on "Pages" list (fixes #8199) (Ingo Schommer)
 * 2013-01-22 [4892c11](https://github.com/silverstripe/sapphire/commit/4892c11) Clarified docs on isDev usage in dev/build (Ingo Schommer)
 * 2013-01-22 [f833226](https://github.com/silverstripe/sapphire/commit/f833226) Updated issue reporting guidelines (Ingo Schommer)
 * 2013-01-21 [6c7e3af](https://github.com/silverstripe/sapphire/commit/6c7e3af) Updated translations (Ingo Schommer)
 * 2013-01-21 [f7c8778](https://github.com/silverstripe/sapphire/commit/f7c8778) Breadcrumb/back nav in ModelAdmin now retains search params (Ingo Schommer)
 * 2013-01-21 [d0585e4](https://github.com/silverstripe/silverstripe-cms/commit/d0585e4) Updated translations (Ingo Schommer)
 * 2013-01-21 [8717dec](https://github.com/silverstripe/sapphire/commit/8717dec) HTMLEditorField undefined $dimensionsField (fixes #7494) (Ingo Schommer)
 * 2013-01-21 [89176e8](https://github.com/silverstripe/sapphire/commit/89176e8) Unescaped breadcrumbs for inline groups display (fixes #7936) (Ingo Schommer)
 * 2013-01-21 [e151704](https://github.com/silverstripe/sapphire/commit/e151704) Application Name fix (Tony Air)
 * 2013-01-21 [d12ae82](https://github.com/silverstripe/sapphire/commit/d12ae82) Bug fix for open/8181 which stops the HTML source editor window saving/publishing (Kirk Mayo)
 * 2013-01-20 [3d921e7](https://github.com/silverstripe/sapphire/commit/3d921e7) Update docs/en/reference/form-field-types.md (Will Rossiter)
 * 2013-01-19 [7523fe4](https://github.com/silverstripe/sapphire/commit/7523fe4) Update admin/code/ModelAdmin.php (Nicolaas)
 * 2013-01-18 [be78098](https://github.com/silverstripe/sapphire/commit/be78098) Arbitrary placement of _ss_environment.php in parent folders (Daniel Hensby)
 * 2013-01-18 [7f4541e](https://github.com/silverstripe/sapphire/commit/7f4541e) Update docs/en/changelogs/3.0.0.md (Nicolaas)
 * 2013-01-17 [cfc976b](https://github.com/silverstripe/silverstripe-cms/commit/cfc976b) Grammar error (unclecheese)
 * 2013-01-17 [8a9acaa](https://github.com/silverstripe/silverstripe-cms/commit/8a9acaa) Fixed "add page" type icons (fixes #8190) (Ingo Schommer)
 * 2013-01-15 [e9ba54d](https://github.com/silverstripe/sapphire/commit/e9ba54d) Impossible to unselect TreeDropdownField (uniun)
 * 2013-01-15 [2e6e0de](https://github.com/silverstripe/sapphire/commit/2e6e0de) Clarified DataList-&gt;limit() docs (Ingo Schommer)
 * 2013-01-15 [27d2f75](https://github.com/silverstripe/sapphire/commit/27d2f75) Added test for DataList filters with array and modifiers (see #8162) (Ingo Schommer)
 * 2013-01-14 [80feb8c](https://github.com/silverstripe/sapphire/commit/80feb8c) Respect displayFields in GridFieldPrintButton (Ingo Schommer)
 * 2013-01-14 [93bee94](https://github.com/silverstripe/silverstripe-cms/commit/93bee94) Don't duplicate SS_Report title in GridField (Ingo Schommer)
 * 2013-01-14 [703c10a](https://github.com/silverstripe/sapphire/commit/703c10a) Restored inlined styling of .fieldgroup (same UI as in 2.x) (Ingo Schommer)
 * 2013-01-14 [0a00fea](https://github.com/silverstripe/sapphire/commit/0a00fea) Removed .fieldgroup styles specific to one UI use case (Ingo Schommer)
 * 2013-01-11 [9e82d8e](https://github.com/silverstripe/sapphire/commit/9e82d8e) Fixed line lengths (Ingo Schommer)
 * 2013-01-11 [212c4f1](https://github.com/silverstripe/sapphire/commit/212c4f1) Fixed UploadField regression from 4da1af9c3 (Ingo Schommer)
 * 2013-01-11 [4da1af9](https://github.com/silverstripe/sapphire/commit/4da1af9) Show label-less input#file field in UploadField with canUpload=false (Ingo Schommer)
 * 2013-01-11 [7306d02](https://github.com/silverstripe/sapphire/commit/7306d02) Show label-less input#file field in UploadField with canUpload=false (Ingo Schommer)
 * 2013-01-10 [b918487](https://github.com/silverstripe/sapphire/commit/b918487) Fixed preview overlay showing by default (Ingo Schommer)
 * 2013-01-10 [f30277c](https://github.com/silverstripe/sapphire/commit/f30277c) Split out getLinkAttributes() in .htmleditor JavaScript for more flexibility (Ingo Schommer)
 * 2013-01-10 [f922321](https://github.com/silverstripe/sapphire/commit/f922321) ManyManyList-&gt;getExtraFields() (Ingo Schommer)
 * 2013-01-09 [e8bfc24](https://github.com/silverstripe/sapphire/commit/e8bfc24) Setting SapphireTest::is_running_test() in PHPUnit bootstrap (Ingo Schommer)
 * 2013-01-09 [76e233d](https://github.com/silverstripe/sapphire/commit/76e233d) Only show preview switch if states are available (Ingo Schommer)
 * 2013-01-09 [80ee913](https://github.com/silverstripe/sapphire/commit/80ee913) Correct dimensions for preview overlay (Ingo Schommer)
 * 2013-01-09 [f6ab5a4](https://github.com/silverstripe/sapphire/commit/f6ab5a4) Update docs/en/topics/i18n.md (drzax)
 * 2013-01-08 [5bd8619](https://github.com/silverstripe/sapphire/commit/5bd8619) Add pointer to expand/collapse tree icons (Ingo Schommer)
 * 2013-01-08 [f564592](https://github.com/silverstripe/sapphire/commit/f564592) Fix tree arrows in TreeDropdownField (Ingo Schommer)
 * 2013-01-08 [abfb3c7](https://github.com/silverstripe/sapphire/commit/abfb3c7) Default TreeDropdownField to TreeTitle (Ingo Schommer)
 * 2013-01-08 [61cc033](https://github.com/silverstripe/sapphire/commit/61cc033) Fluent interface for TreeDropdownField (Ingo Schommer)
 * 2013-01-08 [001e58c](https://github.com/silverstripe/sapphire/commit/001e58c) Update docs/en/tutorials/1-building-a-basic-site.md (James Cocker)
 * 2013-01-08 [a8904e3](https://github.com/silverstripe/sapphire/commit/a8904e3) Removed incorrect line from contact form docs. (Will Rossiter)
 * 2013-01-06 [44c4108](https://github.com/silverstripe/sapphire/commit/44c4108) Copying request params before Core.php exec in PHPUnit bootstrap (Ingo Schommer)
 * 2013-01-05 [9dcace9](https://github.com/silverstripe/sapphire/commit/9dcace9) upgrading 'Setting up an environment for contributing to SilverStripe' to heading 1 (Nicolaas)
 * 2013-01-04 [3033529](https://github.com/silverstripe/sapphire/commit/3033529) 3.0.4 changelog update (Ingo Schommer)
 * 2013-01-04 [5d9819b](https://github.com/silverstripe/sapphire/commit/5d9819b) Clearer docs on using composer for contributions (Ingo Schommer)
 * 2013-01-03 [d872202](https://github.com/silverstripe/sapphire/commit/d872202) Support for X-Reload header (Ingo Schommer)
 * 2013-01-02 [9dafc83](https://github.com/silverstripe/sapphire/commit/9dafc83) Fixed DateField phpdocs (Ingo Schommer)
 * 2012-12-27 [a32451f](https://github.com/silverstripe/sapphire/commit/a32451f) adding extension hook in GridFieldDetailForm.php (Nicolaas)
 * 2012-12-26 [3fca288](https://github.com/silverstripe/sapphire/commit/3fca288) Update forms/TextareaField.php (Nicolaas)
 * 2012-12-21 [3fd1769](https://github.com/silverstripe/sapphire/commit/3fd1769) Added docs about which branch to choose (Ingo Schommer)
 * 2012-12-21 [661a4a2](https://github.com/silverstripe/sapphire/commit/661a4a2) Removed direct sprintf() usage from _t() calls (Ingo Schommer)
 * 2012-12-21 [cb96255](https://github.com/silverstripe/silverstripe-cms/commit/cb96255) Removed direct sprintf() usage from _t() calls (Ingo Schommer)
 * 2012-12-21 [68eb367](https://github.com/silverstripe/sapphire/commit/68eb367) Remove unncessary variable from TreeDropdownField (Sean Harvey)
 * 2012-12-20 [d918c26](https://github.com/silverstripe/sapphire/commit/d918c26) Allow recursive includes in i18nTextCollector (fixes #8133) (Ingo Schommer)
 * 2012-12-20 [aa3b358](https://github.com/silverstripe/sapphire/commit/aa3b358) Adding test for SortColumn to SQLQueryTest (Sean Harvey)
 * 2012-12-20 [e20f15d](https://github.com/silverstripe/sapphire/commit/e20f15d) Remove /e option due to preg_replace_callback use (Simon Welsh)
 * 2012-12-20 [c56a80d](https://github.com/silverstripe/sapphire/commit/c56a80d) Use preg_replace_callback over preg_replace with e modifier (Simon Welsh)
 * 2012-12-19 [86940aa](https://github.com/silverstripe/sapphire/commit/86940aa) Made hyphen escaping clearer in FileNameFilter and URLSegmentFilter (Ingo Schommer)
 * 2012-12-18 [3a555d2](https://github.com/silverstripe/sapphire/commit/3a555d2) Set 'active' correctly for accordion widget (Adam Judd)
 * 2012-12-19 [775567d](https://github.com/silverstripe/sapphire/commit/775567d) Allow &lt;button type='submit'&gt; for the benifit of IE&lt;=7 (Simon Elvery)
 * 2012-12-18 [07fb756](https://github.com/silverstripe/sapphire/commit/07fb756) Fix edge case in which uninitialized buttons are being destroyed. (unclecheese)
 * 2012-12-18 [9b3aebd](https://github.com/silverstripe/sapphire/commit/9b3aebd) Allow HTML in FormField-&gt;setDescription() (Ingo Schommer)
 * 2012-12-18 [e53257b](https://github.com/silverstripe/silverstripe-cms/commit/e53257b) Relaxing composer dependencies (Ingo Schommer)
 * 2012-12-18 [f72a024](https://github.com/silverstripe/sapphire/commit/f72a024) Updated changelog notes (Ingo Schommer)
 * 2012-12-18 [618a3d0](https://github.com/silverstripe/sapphire/commit/618a3d0) Requirements acces to files with query strings (fixes #7735) (Ingo Schommer)
 * 2012-12-17 [6cb7710](https://github.com/silverstripe/silverstripe-cms/commit/6cb7710) Remove "changed" style from buttons if fields are reset (Ingo Schommer)
 * 2012-12-17 [894d487](https://github.com/silverstripe/silverstripe-cms/commit/894d487) String casting in SimpleXML tests for older phpunit versions (Ingo Schommer)
 * 2012-12-17 [8f239d6](https://github.com/silverstripe/sapphire/commit/8f239d6) SimpleXML string casting in tests for older PHPUnit (Ingo Schommer)
 * 2012-12-17 [9ffd252](https://github.com/silverstripe/sapphire/commit/9ffd252) Don't complain about pre-replaced YAML fixture relations (Ingo Schommer)
 * 2012-12-17 [dc43a6b](https://github.com/silverstripe/sapphire/commit/dc43a6b) Wider sidebar to accommodate "add" and "edit" buttons (Ingo Schommer)
 * 2012-12-17 [0dd6ded](https://github.com/silverstripe/silverstripe-cms/commit/0dd6ded) Moving "edit tree" button next to "add new" (fixes #8119) (Ingo Schommer)
 * 2012-12-17 [432ff75](https://github.com/silverstripe/sapphire/commit/432ff75) Wider side panel to fit "add" and "edit" button (Ingo Schommer)
 * 2012-12-17 [77212c0](https://github.com/silverstripe/sapphire/commit/77212c0) CMS Titles does not support UTF-8 (uniun)
 * 2012-12-14 [4b182d3](https://github.com/silverstripe/sapphire/commit/4b182d3) Update documentation of nginx configuration (Fred Condo)
 * 2012-12-14 [78d21b5](https://github.com/silverstripe/sapphire/commit/78d21b5) Update documentation of nginx configuration (Fred Condo)
 * 2012-12-14 [bdc1719](https://github.com/silverstripe/sapphire/commit/bdc1719) tinymce language portuguese is not working (João Martins)
 * 2012-12-14 [c23df51](https://github.com/silverstripe/sapphire/commit/c23df51) Improve class naming and docs for DataList::applyFilterContext() (Sean Harvey)
 * 2012-12-13 [51c6a87](https://github.com/silverstripe/sapphire/commit/51c6a87) Fix for ie8 styles for preview switch and modes (Paul Clarke)
 * 2012-12-12 [af6ecce](https://github.com/silverstripe/sapphire/commit/af6ecce) Fixing typo in Requirements allowing access to files requested with query strings (Matt Lewis)
 * 2012-12-04 [4c525fe](https://github.com/silverstripe/silverstripe-cms/commit/4c525fe) Fixed composer.json dependencies (Ingo Schommer)
 * 2012-12-04 [3fad49e](https://github.com/silverstripe/sapphire/commit/3fad49e) 2.4.9 changelog (Ingo Schommer)
 * 2012-12-04 [3be9499](https://github.com/silverstripe/sapphire/commit/3be9499) Fixed HTML syntax in config-form.html (Ingo Schommer)
 * 2012-12-04 [d1e65b5](https://github.com/silverstripe/sapphire/commit/d1e65b5) Support for composer-created themes dir structure (Ingo Schommer)
 * 2012-12-04 [f86bd97](https://github.com/silverstripe/sapphire/commit/f86bd97) Fixed DateTest timezone settings (Ingo Schommer)
 * 2012-12-04 [75e58c9](https://github.com/silverstripe/silverstripe-cms/commit/75e58c9) More graceful handling of missing GET data in ModelAdmin (Ingo Schommer)
 * 2012-12-04 [449cce9](https://github.com/silverstripe/sapphire/commit/449cce9) Fixing .htaccess to ignore rewriting PHP files directly (Sean Harvey)
 * 2012-11-28 [326036a](https://github.com/silverstripe/sapphire/commit/326036a) Excluded or removed tests relying on actual webserver routing (Ingo Schommer)
 * 2012-11-21 [6eb597a](https://github.com/silverstripe/silverstripe-cms/commit/6eb597a) Fixed travis.yml paths (Ingo Schommer)
 * 2012-11-09 [7db928b](https://github.com/silverstripe/sapphire/commit/7db928b) Added cms to travis requirements (Ingo Schommer)
 * 2012-11-09 [3f24b0f](https://github.com/silverstripe/silverstripe-cms/commit/3f24b0f) Added README with build status (Ingo Schommer)
 * 2012-11-09 [0a63f44](https://github.com/silverstripe/sapphire/commit/0a63f44) Added README with build status (Ingo Schommer)
 * 2012-11-09 [65793e2](https://github.com/silverstripe/silverstripe-cms/commit/65793e2) Added travis support (Ingo Schommer)
 * 2012-11-09 [21791e4](https://github.com/silverstripe/sapphire/commit/21791e4) Added travis support (Ingo Schommer)
 * 2012-11-01 [59680b5](https://github.com/silverstripe/sapphire/commit/59680b5) Added composer.json (Ingo Schommer)
 * 2012-11-01 [7abb6ec](https://github.com/silverstripe/silverstripe-cms/commit/7abb6ec) Added composer.json (Ingo Schommer)
 * 2012-11-01 [fd80c4f](https://github.com/silverstripe/sapphire/commit/fd80c4f) Issue #7818: Making sure UploadField can find the form/SecurityID on direct page load/refresh (Nathan Cox)
 * 2011-08-30 [b43bf68](https://github.com/silverstripe/sapphire/commit/b43bf68) Minor fixes to FunctionalTest (Sam Minnee)
 * 2011-08-18 [b6fd276](https://github.com/silverstripe/sapphire/commit/b6fd276) Don't throw redirection warning if redirection to the same place. (Sam Minnee)
 * 2011-04-01 [f72c77e](https://github.com/silverstripe/sapphire/commit/f72c77e) Fixed a glitch that causes warnings in cli-script execution. (Sam Minnee)
