# 3.0.0-beta3 #

## Overview ##

### CMS ###

 * Media insertion from the web, including YouTube, Vimeo, Flickr, and more, via oEmbed.
 * Lots of smaller usability changes resulting from our tests
 * More user friendly editing of page URLs, through explicit "edit" button
 * Changed tab paths in `SiteTree->getCMSFields()` (see [upgrade notes](/changelogs/3.0.0#tab-paths)
 * Combined "Content" and "Metadata" tabs in "Pages"
 * Auto-hiding second level tabs if one one tab is available
 
### Framework ###

 * SQL Server and PostgreSQL core support
 * Improved API for creating queries programmatically (through `SQLQuery`)
 * Dependency injection API for more flexible code customization (early stage) 
 * PHPUnit 3.6 compatibility

## Removed from release milestone ##

 * Move SilverStripe classes into PHP namespaces.
 * Gallery view for files.
 * New batch action system with interactive dialogs.
 
## Upgrading ##

See [3.0.0](/changelogs/3.0.0) for previous details.

## Changelog ##

### API Changes

 * 2012-05-24 [c7e0cee](https://github.com/silverstripe/sapphire/commit/c7e0cee) Add Form-&gt;getController() and use this instead of Controller::curr() in FileIFrameField API CHANGE Add Form-&gt;getName() and deprecate Form-&gt;Name(), use getName() instead. (Sean Harvey)
 * 2012-05-23 [60c72c4](https://github.com/silverstripe/sapphire/commit/60c72c4) Use of the DropdownField $emptyString argument is now properly deprecated (has been marked as deprecated since 2.3). Please use setEmptyString() on the DropdownField instance instead. (Sean Harvey)
 * 2012-05-23 [f7f67d9](https://github.com/silverstripe/sapphire/commit/f7f67d9) Static functions Director::redirect(), Director::redirectBack(), Director::set_status_code(), Director::get_status_code() and Director::redirected_to() are now deprecated. Use Controller-&gt;redirect(), Controller-&gt;redirectBack(), Controller-&gt;getResponse()-&gt;setStatusCode(), Controller-&gt;getResponse()-&gt;getStatusCode() and Controller-&gt;redirectedTo() respectively. (Sean Harvey)
 * 2012-05-19 [94f50f5](https://github.com/silverstripe/sapphire/commit/94f50f5) Changes to make Director rules set through the new config system. Includes the addition of a new AdminRootController to take over handling of routing /admin/* routes to the correct LeftAndMain panel. (Hamish Friedlander)
 * 2012-05-18 [1025524](https://github.com/silverstripe/sapphire/commit/1025524) Added $insertBefore argument to GridFiedlConfig::addComponent() (Sam Minnee)
 * 2012-05-18 [7201f06](https://github.com/silverstripe/sapphire/commit/7201f06) Added new config option Money.default_currency. (Sam Minnee)
 * 2012-05-14 [9da92e0](https://github.com/silverstripe/sapphire/commit/9da92e0) Renamed setContainerFieldSet() to setContainerFieldList() to match the FieldList API. API CHANGE Renamed rootFieldSet() to rootFieldList() to match the FieldList API. (Sean Harvey)
 * 2012-05-11 [dffae1a](https://github.com/silverstripe/sapphire/commit/dffae1a) Do not rely on a specific OS mime type detection, use PHP finfo (Stig Lindqvist)
 * 2012-05-11 [8a46e38](https://github.com/silverstripe/sapphire/commit/8a46e38) Removed old HTTP::sendRequest() and HTTP::sendPostRequest() functions which are sparsely used, and not maintained or tested. Use custom code instead. (Sean Harvey)
 * 2012-05-09 [42d404f](https://github.com/silverstripe/silverstripe-cms/commit/42d404f) Restructured SiteTree-&gt;getCMSFields() tabs from "Root.Content.Main" to "Root.Main", merged "Root.Content.Metadata" tab into "Root.Main" (fixes #7261) (Ingo Schommer)
 * 2012-05-09 [b1e1757](https://github.com/silverstripe/sapphire/commit/b1e1757) Removed assertType() and assertEmpty() workarounds. Use assertInstanceOf() instead of assertType(), assertEmpty() is available in PHPUnit 3.5+. PHPUnit 3.4 is no longer supported, so please upgrade your version to work. (Sean Harvey)
 * 2012-05-08 [1e174b3](https://github.com/silverstripe/sapphire/commit/1e174b3) Made LeftAndMain::getResponseNegotiator() public so extensions can use it. (Andrew Short)
 * 2012-05-07 [89fc8e5](https://github.com/silverstripe/sapphire/commit/89fc8e5) PasswordEncryptor::check() allows for more powerful password checking, deprecating PasswordEncryptor::compare() (Andrew O'Neil)
 * 2012-05-05 [d4154da](https://github.com/silverstripe/sapphire/commit/d4154da) Deprecate Member::sendInfo(), use Member_ChangePasswordEmail and Member_ForgotPasswordEmail class directly instead. (Sean Harvey)
 * 2012-05-04 [fd0ec1c](https://github.com/silverstripe/sapphire/commit/fd0ec1c) Removed Member_SignupEmail, use your own custom sign up Email class instead. (Sean Harvey)
 * 2012-05-03 [051d9de](https://github.com/silverstripe/sapphire/commit/051d9de) Deprecated internal access to SQLQuery properties, update core code to reflect these changes. Using set/add instead in accessor methods, and use Database::sql*ToString() to allow easier per-database adapter SQL overloading. (Sean Harvey)
 * 2012-05-03 [3b3b515](https://github.com/silverstripe/sapphire/commit/3b3b515) Read-only fields no longer include companion hidden fields (see pull request #399) BUGFIX Remove legacy code and template which is never picked-up so that TextareaField becomes 'readonly' when it is transfered to readonly field. Change TextareaFieldTest test cases to address a 'readonly' textarea field displaying the special html characters correctly. (Normann Lou)
 * 2012-05-01 [2207e3d](https://github.com/silverstripe/sapphire/commit/2207e3d) Add SQLQuery::prepareSelect(), to further remove the need for direct property access. API CHANGE: Change the format of SQLQuery::$select to use aliases as keys. (Sam Minnee)
 * 2012-05-01 [8661164](https://github.com/silverstripe/sapphire/commit/8661164) Add SQLQuery::clearSelect(), SQLQuery::selectField() and SQLQuery::itemisedSelect() to make it easier for other subsystems to use SQLQuery without resorting to direct property access. API CHANGE: Remove DataQuery::select() in place of DataQuery::selectField(). BUGFIX: Remove direct property access to SQLQuery::$select (Sam Minnee)
 * 2012-05-01 [0882741](https://github.com/silverstripe/sapphire/commit/0882741) Renamed setModel for DataModel instances to setDataModel for semantics, and also to allow a field name called "Model" (Sean Harvey)
 * 2012-05-01 [c84254c](https://github.com/silverstripe/sapphire/commit/c84254c) Rename SQLQuery prepareSelect to prepareWhere (Sean Harvey)
 * 2012-04-30 [c2339d2](https://github.com/silverstripe/sapphire/commit/c2339d2) Removed FormResponse handling for erroneous ajax requests in Form-&gt;validate(), use javascript validation instead, or reload the whole form with new HTML including the error messages (Ingo Schommer)
 * 2012-04-20 [6469d83](https://github.com/silverstripe/sapphire/commit/6469d83) add a remote relation class getter to DataObject (Mateusz Uzdowski)
 * 2012-03-16 [8bbfa97](https://github.com/silverstripe/sapphire/commit/8bbfa97) Remove Controller::Now(), as it was only ever a template global provider, and use the new TemplateGlobalProvider interface on SS_Datetime instead. (Sam Minnee)
 * 2012-03-16 [6c35588](https://github.com/silverstripe/sapphire/commit/6c35588) Rename 'PastMember' to 'IsRepeatMember' in templates. API CHANGE: Move Controller::PastMember() to Member::is_repeat_member() in code. API CHANGE: Removed Controller::CurrentMember(), it was only ever intended as a template global provider. (Sam Minnee)

### Features and Enhancements

 * 2012-05-28 [0952df4](https://github.com/silverstripe/sapphire/commit/0952df4) Allow calling setButtonName() on a GridFieldAddNewButton to customise the button name (Sean Harvey)
 * 2012-05-24 [5b84524](https://github.com/silverstripe/sapphire/commit/5b84524) add test to Oembed (Mateusz Uzdowski)
 * 2012-05-23 [ecf847b](https://github.com/silverstripe/sapphire/commit/ecf847b) Re-instate pinging every 5 minutes in the CMS as a measure to keep sessions alive. Moved Security/ping to admin/security/ping (Sean Harvey)
 * 2012-05-22 [9a7980e](https://github.com/silverstripe/sapphire/commit/9a7980e) Design fixes in insert media pop-up (Naomi Guyer)
 * 2012-05-22 [28e43bd](https://github.com/silverstripe/sapphire/commit/28e43bd) File/Image UI fixes (Naomi Guyer)
 * 2012-05-22 [bb29ff3](https://github.com/silverstripe/sapphire/commit/bb29ff3) Allow adding media to the CMS using oEmbed (Simon Welsh)
 * 2012-05-22 [d522b81](https://github.com/silverstripe/sapphire/commit/d522b81) gridfield styling improvements, asset admin style improvements (Paul Clarke)
 * 2012-05-21 [a9cbea3](https://github.com/silverstripe/sapphire/commit/a9cbea3) gridfield colours simplified to use base colours, css tidy up around actions & icons (Paul Clarke)
 * 2012-05-21 [16982ba](https://github.com/silverstripe/sapphire/commit/16982ba) Make GridFieldAddNewButton Content more specific (Naomi Guyer)
 * 2012-05-21 [1747298](https://github.com/silverstripe/sapphire/commit/1747298) Make GridFieldButtonRow more adaptable (Naomi Guyer)
 * 2012-05-21 [84bf5e2](https://github.com/silverstripe/sapphire/commit/84bf5e2) tabs text-shadow direction change, improve visibility for IE (Paul Clarke)
 * 2012-05-21 [5edf447](https://github.com/silverstripe/sapphire/commit/5edf447) visual enhancements, cms tabs, main menu drop shadow adjusted, actions panel top gradient replaced (Paul Clarke)
 * 2012-05-18 [aa7bc23](https://github.com/silverstripe/silverstripe-cms/commit/aa7bc23) refactoring template "control" loops into "loop" and "with" to fit with the new template syntax (Julian Seidenberg)
 * 2012-05-18 [5290b81](https://github.com/silverstripe/sapphire/commit/5290b81) don't show the paginating elements in the paginator when only one page, and keep 'view 1 - 5 of 5' there (Normann Lou)
 * 2012-05-16 [458171f](https://github.com/silverstripe/sapphire/commit/458171f) Gridfield usability (fixes 7215) (Naomi Guyer)
 * 2012-05-14 [7f05add](https://github.com/silverstripe/sapphire/commit/7f05add) Make jQuery.Entwine inspector available in admin panels in dev mode (Hamish Friedlander)
 * 2012-05-12 [f561264](https://github.com/silverstripe/silverstripe-cms/commit/f561264) Update URLSegment from Title (closes #6981) (Ryan Wachtl)
 * 2012-05-11 [05cde92](https://github.com/silverstripe/sapphire/commit/05cde92) Implemented a view action for GridField, and a record viewing GridFieldConfig. (Andrew Short)
 * 2012-05-10 [1863bb0](https://github.com/silverstripe/silverstripe-cms/commit/1863bb0) Refactored SiteTreeURLSegmentField JS to a more selector based approach (future proof field for reusability e.g. in ModelAdmin with custom DataObject URL previews) (Ingo Schommer)
 * 2012-05-10 [2753744](https://github.com/silverstripe/sapphire/commit/2753744) Moving X-Status message handling in CMS from global ajaxError to ajaxComplete handler, to allow success messages being passed this way as well. (Ingo Schommer)
 * 2012-05-09 [11f4756](https://github.com/silverstripe/sapphire/commit/11f4756) Auto-hiding tab bar in CMS forms if only a single tab is available (to save screen space and reduce UI clutter) (see #7261) (Ingo Schommer)
 * 2012-05-09 [8c9560d](https://github.com/silverstripe/sapphire/commit/8c9560d) FieldList-&gt;setTabPathRewrites() for better backwards compatibility (see #7261) (Ingo Schommer)
 * 2012-05-09 [b269bad](https://github.com/silverstripe/sapphire/commit/b269bad) Added dependency injector for managing creation of new objects and their dependencies. API CHANGE: Pass Object::create() calls to Injector::create(). API CHANGE: Add "RequestProcessor" injection point in Director, that Director will call preRequest() and postRequest() on. (Marcus Nyeholt)
 * 2012-05-09 [d642eee](https://github.com/silverstripe/sapphire/commit/d642eee) UI Changes to FileUpload Area (TRAC-7219) (Naomi Guyer)
 * 2012-05-08 [77e52d6](https://github.com/silverstripe/silverstripe-cms/commit/77e52d6) Url encoding URLSegments before matching them against database records in ModelAsController, to match behaviour of SiteTree with URLSegmentFilter::$default_allow_multibyte=true. Not an API change because all encodable characters have been removed by the default URLSegmentFilter already (see http://www.w3.org/International/articles/idn-and-iri/#iriproblem) (Ingo Schommer)
 * 2012-05-08 [9052cdc](https://github.com/silverstripe/sapphire/commit/9052cdc) Making "Users", "Groups" and "Roles" tabs in SecurityAdmin bookmarkable. ENHANCEMENT Fixed SecurityAdmin-&gt;Breadcrumbs() to include link to individual tab, and disable backlink (signed off by Paul) (Ingo Schommer)
 * 2012-05-08 [a2dbd69](https://github.com/silverstripe/sapphire/commit/a2dbd69) Allow Controllers to opt-out or modify the back link behaviour in GridFieldDetailForm (Ingo Schommer)
 * 2012-05-08 [6d999aa](https://github.com/silverstripe/sapphire/commit/6d999aa) addExtraClass() support for Tab and TabSet (Ingo Schommer)
 * 2012-05-07 [bb9ffd2](https://github.com/silverstripe/sapphire/commit/bb9ffd2) SQLQuery::selectField() returns a SQLQuery object to be consistent with how the other add/set methods work. MINOR Fixing DbDatetimeTest to use the correct selectField to select an alias (Sean Harvey)
 * 2012-05-07 [85a69c0](https://github.com/silverstripe/silverstripe-cms/commit/85a69c0) add page icons for tree dropdown field when creating a  new page and setting its parent (Normann Lou)
 * 2012-05-07 [5cf3720](https://github.com/silverstripe/sapphire/commit/5cf3720) Use the best blowfish encryption available - this fixes fragility between PHP versions and system installations (Andrew O'Neil)
 * 2012-05-07 [4b6c21b](https://github.com/silverstripe/silverstripe-cms/commit/4b6c21b) use the grid field compoent GridFieldLevelup for pages listveiw when the view is the children listing of a page (Normann Lou)
 * 2012-05-07 [7324712](https://github.com/silverstripe/sapphire/commit/7324712) add Levelup component to GridField as GridFieldLevelup (Normann Lou)
 * 2012-05-06 [304c3cd](https://github.com/silverstripe/sapphire/commit/304c3cd) Fields can be excluded from change tracking using a ".no-change-track" class. (Andrew Short)
 * 2012-05-04 [abb5719](https://github.com/silverstripe/sapphire/commit/abb5719) Style change to buttons for preview states. Removed open in new window (TRAC-7214) (Ryan O'Hara)
 * 2012-05-04 [9248458](https://github.com/silverstripe/sapphire/commit/9248458) Add disabled state to preview buttons and add watermark for the current state being viewed (TRAC:7214) (Ryan O'Hara)
 * 2012-05-04 [ad1f7c1](https://github.com/silverstripe/silverstripe-cms/commit/ad1f7c1) Add Watermark for preview states (TRAC-7214) (Ryan O'Hara)
 * 2012-05-03 [7c25754](https://github.com/silverstripe/silverstripe-cms/commit/7c25754) Localization of installation success screen (Ingo Schommer)
 * 2012-05-03 [2fdc4e5](https://github.com/silverstripe/silverstripe-cms/commit/2fdc4e5) Section icons in CMS (#7269) (Ingo Schommer)
 * 2012-05-03 [4029f96](https://github.com/silverstripe/sapphire/commit/4029f96) Section icons in CMS (#7269) (Ingo Schommer)
 * 2012-05-03 [826878b](https://github.com/silverstripe/sapphire/commit/826878b) add header icon to CMSFileAddController when uploading file and SecurityAdmin when editing a member record (Normann Lou)
 * 2012-05-03 [3cdca3e](https://github.com/silverstripe/silverstripe-cms/commit/3cdca3e) Trac 7266 - added an icon to the 'sync files' button in AssetAdmin + regenerated css files. (Jeremy Bridson)
 * 2012-05-03 [7f1e6de](https://github.com/silverstripe/sapphire/commit/7f1e6de) Trac 7266 - added an icon to the 'sync files' button in AssetAdmin + regenerated css files. (Jeremy Bridson)
 * 2012-05-02 [e29bb3c](https://github.com/silverstripe/sapphire/commit/e29bb3c) Allow opt-out of autofocus in CMS editor form, to avoid browser "auto scrolling" to bring the focused element into view (fixes #7242) (Ingo Schommer)
 * 2012-05-02 [f812e56](https://github.com/silverstripe/silverstripe-cms/commit/f812e56) Moving action buttons in AssetAdmin to "details" tab (fixes #7221) (Ingo Schommer)
 * 2012-05-02 [fa60f9e](https://github.com/silverstripe/sapphire/commit/fa60f9e) Implement blowfish encryption and use it by default. (#7111) (Andrew O'Neil)
 * 2012-05-02 [bc36406](https://github.com/silverstripe/sapphire/commit/bc36406) changed gallery icon to an edit icon for assetAdmin + regenerated UnitTesting.css (Jeremy Bridson)
 * 2012-05-02 [a895d0b](https://github.com/silverstripe/silverstripe-cms/commit/a895d0b) changed gallery icon to an edit icon for assetAdmin (Jeremy Bridson)
 * 2012-05-01 [e949b6f](https://github.com/silverstripe/sapphire/commit/e949b6f) Backwards compatible $priority parameter for i18n::_t(): Allow numeric arrays as parameters, as well as %s style replacements with a named parameter map (easier transition to new system with existing translation strings) (Ingo Schommer)
 * 2012-05-01 [84045cc](https://github.com/silverstripe/silverstripe-cms/commit/84045cc) Make filter closed (#7210) (Naomi Guyer)
 * 2012-05-01 [af5bd4d](https://github.com/silverstripe/sapphire/commit/af5bd4d) Close filter panel(Track#7210) (Naomi Guyer)
 * 2012-04-30 [a73e457](https://github.com/silverstripe/silverstripe-cms/commit/a73e457) Titles for lozenges in page tree for more context (fixes #7206) (Ingo Schommer)
 * 2012-04-30 [f873707](https://github.com/silverstripe/sapphire/commit/f873707) Prepopulating group on new members (fixes #7217) (Ingo Schommer)
 * 2012-04-30 [72eadef](https://github.com/silverstripe/sapphire/commit/72eadef) GridFieldDetailForm-&gt;setItemEditFormCallback() (Ingo Schommer)
 * 2012-04-30 [fdd5e71](https://github.com/silverstripe/sapphire/commit/fdd5e71) Remove unnecessary NULL check. (Dominik Beerbohm)
 * 2012-04-30 [fed2785](https://github.com/silverstripe/sapphire/commit/fed2785) Per-instance customisation of GridFieldDetailForm_ItemRequest (Ingo Schommer)
 * 2012-04-27 [bd6ca59](https://github.com/silverstripe/sapphire/commit/bd6ca59) Adding list-style in addition to list-style-image for URL rewrites (Sean Harvey)
 * 2012-04-26 [f63d137](https://github.com/silverstripe/sapphire/commit/f63d137) Session::start() now only called when there is changed session data to be saved, and started on Director::direct() when there is a cookie (or request var) containing the current PHP session name. (Sean Harvey)
 * 2012-04-26 [4faf02e](https://github.com/silverstripe/silverstripe-cms/commit/4faf02e) added folder icons to assetAdmin tree view (Jeremy Bridson)
 * 2012-04-26 [92f3d62](https://github.com/silverstripe/sapphire/commit/92f3d62) add extra &lt;span&gt; DOM with 'jstree-foldericon' class for tree view of folders (Normann Lou)
 * 2012-04-24 [322d392](https://github.com/silverstripe/silverstripe-installer/commit/322d392) adding checkout for the simple theme to the Phing checkout script (Julian Seidenberg)
 * 2012-04-23 [614f307](https://github.com/silverstripe/silverstripe-cms/commit/614f307) When loading CMS, ensure that "Parent page" tree dropdown is either hidden or shown depending on initial "Page location" state (Sean Harvey)
 * 2012-04-20 [e1372b3](https://github.com/silverstripe/sapphire/commit/e1372b3) toggle header and action label for image dialog popups (from content TinyMCE image icon) (Normann Lou)
 * 2012-04-20 [47e3052](https://github.com/silverstripe/sapphire/commit/47e3052) allow folder selection when attaching files from the CMS (Mateusz Uzdowski)
 * 2012-04-20 [ff6909d](https://github.com/silverstripe/sapphire/commit/ff6909d) Add lazy loading to DataQuery. (Robert Curry)
 * 2012-04-20 [bb20587](https://github.com/silverstripe/sapphire/commit/bb20587) GridFieldExportButton allows an anon function to return the value of a related object. Useful for handling has_many/many_many data in a single CSV column. (Sean Harvey)
 * 2012-04-15 [9938b64](https://github.com/silverstripe/sapphire/commit/9938b64) implement SS_Sortable-&gt;reverse() API CHANGE: SQLQuery:: now an array object rather than string. Existing strings will continue to work (Will Rossiter)

### Bugfixes

 * 2012-05-28 [7968013](https://github.com/silverstripe/sapphire/commit/7968013) SecurityAdmin shows incorrect breadcrumbs for viewing Roles GridField. Partially reverts 16982ba17c. (Sean Harvey)
 * 2012-05-28 [74d444c](https://github.com/silverstripe/sapphire/commit/74d444c) Ensure "Add [modelClass]" is shown instead of using the field name of the GridField, partially reverts 16982ba17c which broke breadcrumbs in SecurityAdmin (Sean Harvey)
 * 2012-05-27 [b7ce610](https://github.com/silverstripe/sapphire/commit/b7ce610) Fixed ModelAdmin not working when managed models was defined as an array. (Andrew Short)
 * 2012-05-25 [b6ca328](https://github.com/silverstripe/silverstripe-cms/commit/b6ca328) Fixed add page context menu, replacing references to .pagetype with .ssclass. (#7398) (Sam Minnee)
 * 2012-05-25 [d8fdda7](https://github.com/silverstripe/sapphire/commit/d8fdda7) Add comments and fix IE problems (class is a reserver JS word). (Mateusz Uzdowski)
 * 2012-05-24 [30ecb9f](https://github.com/silverstripe/sapphire/commit/30ecb9f) Provide a default width and height of 100px for those endpoints that don't provide one. (Simon Welsh)
 * 2012-05-24 [32817b4](https://github.com/silverstripe/sapphire/commit/32817b4) replace foreach loop with a core function call (Mateusz Uzdowski)
 * 2012-05-24 [1c8d39b](https://github.com/silverstripe/sapphire/commit/1c8d39b) add comments, make the code more readable (Mateusz Uzdowski)
 * 2012-05-24 [808819e](https://github.com/silverstripe/silverstripe-cms/commit/808819e) Themes dropdown in SiteConfig::getCMSFields() should use setEmptyString() as the $emptyString argument is now deprecated. (Sean Harvey)
 * 2012-05-24 [63ed0cb](https://github.com/silverstripe/sapphire/commit/63ed0cb) return a meaningful translatable string when resource is invalid (Mateusz Uzdowski)
 * 2012-05-24 [9074f52](https://github.com/silverstripe/sapphire/commit/9074f52) Fixing regression in Boolean::scaffoldSearchField() (Sean Harvey)
 * 2012-05-23 [a172a2e](https://github.com/silverstripe/sapphire/commit/a172a2e) Handle consecutive shortcodes. (Simon Welsh)
 * 2012-05-23 [be2c811](https://github.com/silverstripe/silverstripe-cms/commit/be2c811) Adding missing onunmatch in AssetAdmin.DragDrop (Sean Harvey)
 * 2012-05-23 [bbb08df](https://github.com/silverstripe/sapphire/commit/bbb08df) cater for elements without href (Mateusz Uzdowski)
 * 2012-05-23 [50cbef7](https://github.com/silverstripe/silverstripe-cms/commit/50cbef7) remove unnecessary class that breaks the tab opening. (Mateusz Uzdowski)
 * 2012-05-23 [77dbcee](https://github.com/silverstripe/sapphire/commit/77dbcee) i18n::include_by_locale() doesn't include a fallback language, _t() instead will include the language if it's not available. This fixes en_GB translations not being picked up. i18n::get_translators() will always have a fallback of "en" language without the region, and "en_US" as the locale. (Sean Harvey)
 * 2012-05-22 [7ed0991](https://github.com/silverstripe/silverstripe-cms/commit/7ed0991) Fixing incorrect URL to edit canonical page on VirtualPage (Sean Harvey)
 * 2012-05-22 [ae1a106](https://github.com/silverstripe/sapphire/commit/ae1a106) Ensure that CMSMain rule doesn't override the CMSPagesController rule in AdminRootController::add_rule_for_controller() (Sean Harvey)
 * 2012-05-22 [0d4f7a0](https://github.com/silverstripe/sapphire/commit/0d4f7a0) Fixing incorrect arguments to submitForm() in LeftAndMain.AddForm.js (Sean Harvey)
 * 2012-05-22 [ce7a96b](https://github.com/silverstripe/sapphire/commit/ce7a96b) Fixed missing comma in LeftAndMain.AddForm (Sean Harvey)
 * 2012-05-22 [78b7836](https://github.com/silverstripe/sapphire/commit/78b7836) add missing onunmatch (Mateusz Uzdowski)
 * 2012-05-22 [b0a026b](https://github.com/silverstripe/silverstripe-cms/commit/b0a026b) Fixed url_segment undefined error in CMSMain.EditForm, assuming *all* title fields have a URLSegment field associated with them, which they don't. (Sean Harvey)
 * 2012-05-22 [5eaca34](https://github.com/silverstripe/sapphire/commit/5eaca34) Versioned's constructor doesn't provide suitable defaults. Previously a bug/feature in singleton, where it would pass null,true as params to strong_create, which would then get passed through as params to Versioned's constructor, meant that the code still executed fine (as  was set to something that wasn't an array, so the null and true were instead taken as args). The fact that the usage of singleton(Versioned) never really used the classes code, purely for value lookup, meant that this never propagated errors. I've now switched singleton() to use the injector for retrieving values, which means these dud values are no longer passed through (Marcus Nyeholt)
 * 2012-05-22 [b2468eb](https://github.com/silverstripe/silverstripe-cms/commit/b2468eb) add missing selectors and namespace qualifiers (Mateusz Uzdowski)
 * 2012-05-22 [ac25677](https://github.com/silverstripe/sapphire/commit/ac25677) add missing selectors and namespace qualifiers (Mateusz Uzdowski)
 * 2012-05-21 [2f4a033](https://github.com/silverstripe/sapphire/commit/2f4a033) CMS tabs were hidden in ie7, changed css to make them appear far right (Paul Clarke)
 * 2012-05-20 [dd924f1](https://github.com/silverstripe/sapphire/commit/dd924f1) Removed duplicate 'change' event trigger from TreeDropdownField.js (fixes #7329) (Ingo Schommer)
 * 2012-05-20 [fedb337](https://github.com/silverstripe/sapphire/commit/fedb337) Less strict checks for relative URL normalization in SS_HTTPRequest (regression from recent security fixes to Director::is_absolute_url()) (fixes #7359) (Ingo Schommer)
 * 2012-05-19 [f410ccf](https://github.com/silverstripe/silverstripe-cms/commit/f410ccf) Make Page panel the default again after the recent addition of AdminRootController (Hamish Friedlander)
 * 2012-05-19 [563e0cf](https://github.com/silverstripe/silverstripe-cms/commit/563e0cf) Make CMSes Director rules use new yaml config fragments system (Hamish Friedlander)
 * 2012-05-19 [18ddae3](https://github.com/silverstripe/sapphire/commit/18ddae3) Make config yaml fragments merge following the same rules as other config sources (Hamish Friedlander)
 * 2012-05-19 [aaf9115](https://github.com/silverstripe/sapphire/commit/aaf9115) If there is *any* error connecting to MySQL, expose this to the installer. (Sean Harvey)
 * 2012-05-18 [8b4b896](https://github.com/silverstripe/sapphire/commit/8b4b896) add capability of redirecting form actions. (Mateusz Uzdowski)
 * 2012-05-18 [7112032](https://github.com/silverstripe/silverstripe-cms/commit/7112032) fixing the look of Settings tab in the CMS if it has multiple tabs (Julian Seidenberg)
 * 2012-05-18 [1e47b0f](https://github.com/silverstripe/sapphire/commit/1e47b0f) Don't include ._-prefixed config files. (Sam Minnee)
 * 2012-05-18 [b65dff0](https://github.com/silverstripe/sapphire/commit/b65dff0) Allowing actions related to coverage tests (Sean Harvey)
 * 2012-05-18 [38e4bfd](https://github.com/silverstripe/sapphire/commit/38e4bfd) Force iOS Safari to send through click events on gridfield rows. (fixes #6993) (Robert Curry)
 * 2012-05-18 [c8e994d](https://github.com/silverstripe/sapphire/commit/c8e994d) Allow modification of a config's components after the grid field is instantiated. (Sam Minnee)
 * 2012-05-18 [7036abb](https://github.com/silverstripe/sapphire/commit/7036abb) Make WithinRangeFilter work with dates and related columns. (Sam Minnee)
 * 2012-05-18 [aaeebd6](https://github.com/silverstripe/silverstripe-cms/commit/aaeebd6) change namespace for the tree so all matchers are executed (Mateusz Uzdowski)
 * 2012-05-18 [6e436b5](https://github.com/silverstripe/sapphire/commit/6e436b5) change namespace for the tree so all matchers are executed (Mateusz Uzdowski)
 * 2012-05-18 [78423c1](https://github.com/silverstripe/sapphire/commit/78423c1) Ensure HTTP::get_mime_type() checks the full path in file_exists() before using the finfo class (Sean Harvey)
 * 2012-05-17 [c9bcfd4](https://github.com/silverstripe/sapphire/commit/c9bcfd4) Only use finfo if the file exists, otherwise the MIME type detection won't work, such as in the case of HTTPRequest::send_file() (Sean Harvey)
 * 2012-05-17 [e2aa635](https://github.com/silverstripe/sapphire/commit/e2aa635) Ensure GridFieldExportButton uses "text/csv" as the MIME type (Sean Harvey)
 * 2012-05-17 [a412aa0](https://github.com/silverstripe/sapphire/commit/a412aa0) Filter IDs Change ID of action buttons in the filter panel to be unique (Naomi Guyer)
 * 2012-05-17 [f0c61c2](https://github.com/silverstripe/sapphire/commit/f0c61c2) GridField filter (Naomi Guyer)
 * 2012-05-16 [d23e8ec](https://github.com/silverstripe/sapphire/commit/d23e8ec) Fixed cms menu expansion logic when shown alongside preview panel, retain cookie preference (Ingo Schommer)
 * 2012-05-16 [b2fc117](https://github.com/silverstripe/sapphire/commit/b2fc117) Re-add status for successful upload (Naomi Guyer)
 * 2012-05-16 [7363d8b](https://github.com/silverstripe/sapphire/commit/7363d8b) Fix pagination buttons (Naomi Guyer)
 * 2012-05-16 [6c8dbe1](https://github.com/silverstripe/sapphire/commit/6c8dbe1) Fix where filter appears (Naomi Guyer)
 * 2012-05-16 [becdd85](https://github.com/silverstripe/sapphire/commit/becdd85) Fix checking for flawed blowfish encryption (Andrew O'Neil)
 * 2012-05-15 [b9cae47](https://github.com/silverstripe/silverstripe-cms/commit/b9cae47) Don't link to views in CMS tabs, use data-href instead to avoid jQuery.tabs() interfering with its own ajax load magic (specifically fixes a problem where admin/pages/edit/99 was detected as different from admin/pages/edit/99/?locale=de_DE) (Ingo Schommer)
 * 2012-05-15 [9326d9e](https://github.com/silverstripe/sapphire/commit/9326d9e) Fixing SQLQuery-&gt;getFilter() usage of non-existent method (removed during refactoring of pull request), more accurate deprecation notice (Ingo Schommer)
 * 2012-05-16 [c04b01f](https://github.com/silverstripe/sapphire/commit/c04b01f) Changed Date.php and DateTime.php to use DateTime-&gt;Format instead of strtotime to handle extended dates on 32bit environment(fixes #7311) (Yuki Awano)
 * 2012-05-15 [b1104da](https://github.com/silverstripe/sapphire/commit/b1104da) Don't try lazy loading fields when the record ID is set to something non-numeric, otherwise you'll get a SQL error. (Sean Harvey)
 * 2012-05-14 [d42ea5a](https://github.com/silverstripe/sapphire/commit/d42ea5a) Encoding multibyte characters in custom X-Status HTTP headers used in CMS (headers don't allow multibyte data) (Ingo Schommer)
 * 2012-05-14 [20af440](https://github.com/silverstripe/silverstripe-cms/commit/20af440) Decode URLSegment before showing it through SiteTreeURLSegmentField, to separate presentation from its internal url encoded value (Ingo Schommer)
 * 2012-05-14 [73e5c34](https://github.com/silverstripe/silverstripe-cms/commit/73e5c34) Encoding multibyte characters in custom X-Status HTTP headers used in CMS (headers don't allow multibyte data) (Ingo Schommer)
 * 2012-05-14 [e095950](https://github.com/silverstripe/sapphire/commit/e095950) Installer checks: warn if finfo class not available, re-instating hash check, and remove duplicate iconv check. (Sean Harvey)
 * 2012-05-14 [00734f5](https://github.com/silverstripe/silverstripe-cms/commit/00734f5) add missing onunmatches causing exceptions in entwine (Mateusz Uzdowski)
 * 2012-05-13 [3f3e34a](https://github.com/silverstripe/sapphire/commit/3f3e34a) Director::protocol() was returning https when $_SERVER['HTTPS'] was an empty value. (Simon Welsh)
 * 2012-05-11 [8e7d221](https://github.com/silverstripe/sapphire/commit/8e7d221) Trigger change event on hidden input in TreeDrodpownField.js (Ingo Schommer)
 * 2012-05-11 [b75483e](https://github.com/silverstripe/silverstripe-cms/commit/b75483e) add missing _super calls to all matchers and unmatchers (Mateusz Uzdowski)
 * 2012-05-11 [97e00a3](https://github.com/silverstripe/sapphire/commit/97e00a3) add missing onunmatches causing exceptions in entwine (Mateusz Uzdowski)
 * 2012-05-11 [37399f8](https://github.com/silverstripe/sapphire/commit/37399f8) add missing _super calls to all matchers and unmatchers (Mateusz Uzdowski)
 * 2012-05-11 [b28a625](https://github.com/silverstripe/sapphire/commit/b28a625) clean up Chosen classess, so the cached panel can be rebuilt (os7304) (Mateusz Uzdowski)
 * 2012-05-11 [3d0876c](https://github.com/silverstripe/sapphire/commit/3d0876c) put all CMS JS code into 'ss' namespace. (Mateusz Uzdowski)
 * 2012-05-11 [9844328](https://github.com/silverstripe/sapphire/commit/9844328) Fix error notification on files (fixes: 7295) (Naomi Guyer)
 * 2012-05-11 [39bd898](https://github.com/silverstripe/sapphire/commit/39bd898) Setting MIME type for TableListField export explicitly, as HTTP::get_mime_type() requires a path to an actual file, in this case we're exporting data directly to the browser. (Sean Harvey)
 * 2012-05-11 [ab34688](https://github.com/silverstripe/sapphire/commit/ab34688) Looping over a PaginatedList in the template caused a seg fault/bus error. (Simon Welsh)
 * 2012-05-11 [905115b](https://github.com/silverstripe/sapphire/commit/905115b) Update the batch action select state also on load (os7304) (Mateusz Uzdowski)
 * 2012-05-11 [9b39acb](https://github.com/silverstripe/silverstripe-cms/commit/9b39acb) Check the drag and drop radio by default. (Mateusz Uzdowski)
 * 2012-05-11 [28a1d0d](https://github.com/silverstripe/silverstripe-cms/commit/28a1d0d) Change styles on tabs to new format. (Robert Curry)
 * 2012-05-10 [2945f9d](https://github.com/silverstripe/silverstripe-cms/commit/2945f9d) Updating URLSegment from Title field when new page is created (Ryan Wachtl)
 * 2012-05-10 [a5355a7](https://github.com/silverstripe/sapphire/commit/a5355a7) DateField with calender do not format the date correctly after it's picked from the calendar. (Stig Lindqvist)
 * 2012-05-10 [f2411cf](https://github.com/silverstripe/sapphire/commit/f2411cf) Uploads save button not visible (Trac #7294) (Naomi Guyer)
 * 2012-05-10 [c1f7e0e](https://github.com/silverstripe/sapphire/commit/c1f7e0e) #7298 Fixed incorrect message in GridFieldDetailForm from en.yml language file. (Sean Harvey)
 * 2012-05-10 [6c52552](https://github.com/silverstripe/sapphire/commit/6c52552) typeof undefined error fix (Naomi Guyer)
 * 2012-05-10 [106bd47](https://github.com/silverstripe/sapphire/commit/106bd47) #7295 Long Filenames break layout (Naomi Guyer)
 * 2012-05-10 [f30a3bd](https://github.com/silverstripe/sapphire/commit/f30a3bd) Database::doesSchemaNeedUpdating() if schemaUpdateTransaction is NULL, then return FALSE. If schemaUpdateTransaction is an array, then return TRUE. This replaces the automatic casting which is not clear. (Sean Harvey)
 * 2012-05-10 [bbe3879](https://github.com/silverstripe/sapphire/commit/bbe3879) Member::mapInGroups() throws SQL error (Stig Lindqvist)
 * 2012-05-10 [68f9cde](https://github.com/silverstripe/sapphire/commit/68f9cde) 7219-feedback-changes-file-upload (Naomi Guyer)
 * 2012-05-10 [ce5684c](https://github.com/silverstripe/sapphire/commit/ce5684c) Throwing an InvalidArgumentException without the new keyword results in a Fatal error (Stig Lindqvist)
 * 2012-05-09 [a1d676d](https://github.com/silverstripe/sapphire/commit/a1d676d) Ensure PHPUnit 3.6 is available, show a nice message if not (Sean Harvey)
 * 2012-05-09 [8b607db](https://github.com/silverstripe/sapphire/commit/8b607db) Fixing bootstrap.php to work with FakeController properly for running tests using phpunit.xml file. (Sean Harvey)
 * 2012-05-09 [21dda5f](https://github.com/silverstripe/silverstripe-installer/commit/21dda5f) Fixing including of thirdparty tests when using phpunit.xml (requires PHPUnit 3.6, so marking that as the minimum requirement in comments) (Sean Harvey)
 * 2012-05-09 [82db288](https://github.com/silverstripe/sapphire/commit/82db288) Show progress indicator when uploads are added to AssetUploadField, to ensure that failed uploads (e.g. exceeding max filesize) can actually show their error message to the user (Ingo Schommer)
 * 2012-05-09 [1671b9c](https://github.com/silverstripe/sapphire/commit/1671b9c) Checking for mbstring PHP extension support in installer, as it has been a documented installation requirement for a while. Removing method_exists() checks from mbstring usage in core for the same reasons (Ingo Schommer)
 * 2012-05-09 [7d5e46c](https://github.com/silverstripe/sapphire/commit/7d5e46c) IE Colours (Naomi Guyer)
 * 2012-05-09 [fdebedd](https://github.com/silverstripe/sapphire/commit/fdebedd) Ensure the form inside htmleditorfield-dialog element is redrawn when the form is lazy loaded by AJAX. (Sean Harvey)
 * 2012-05-09 [1f992c5](https://github.com/silverstripe/silverstripe-cms/commit/1f992c5) unify the response method for record deletions (os7212) (Mateusz Uzdowski)
 * 2012-05-08 [18dbdd2](https://github.com/silverstripe/sapphire/commit/18dbdd2) Loosened character replacement in static-main.php, to allow for multibyte paths (see URLSegmentFilter::$default_allow_multibyte) (Ingo Schommer)
 * 2012-05-08 [8563322](https://github.com/silverstripe/silverstripe-cms/commit/8563322) Fixed publication of multibyte URLSegment in SiteTree-&gt;onBeforeWrite(), was wrongly detecting a change and double encoding (Ingo Schommer)
 * 2012-05-08 [181ea6c](https://github.com/silverstripe/sapphire/commit/181ea6c) colour Adjustments (Naomi Guyer)
 * 2012-05-07 [6ec6b10](https://github.com/silverstripe/silverstripe-cms/commit/6ec6b10) Don't require ParentModeField in CMSpageAddController submissions, to allow for easier programmatical submission of "add page" form (via CMS tree). Reset any selected parent nodes in the interface instead (Ingo Schommer)
 * 2012-05-07 [e50f90b](https://github.com/silverstripe/sapphire/commit/e50f90b) Ensure end bracket for HAVING clause is put in the right place (Sean Harvey)
 * 2012-05-07 [cd13c0e](https://github.com/silverstripe/sapphire/commit/cd13c0e) updating the value of a tree dropdown field, its title is not updated accordingly if using TreeTitle as the drropdown item title (Normann Lou)
 * 2012-05-07 [f6c98b1](https://github.com/silverstripe/sapphire/commit/f6c98b1) Increase size of varchar fields on MemberPassword to match those defined in Member. This fixes issues when the password hash is longer than 50 characters, and was being truncated when saved in MemberPassword. (Andrew O'Neil)
 * 2012-05-05 [4e18cc5](https://github.com/silverstripe/sapphire/commit/4e18cc5) Ensure MySQLi is used consistently in MySQLDatabaseConfigurationHelper, not old mysql functions (Sean Harvey)
 * 2012-05-04 [1f7f8b8](https://github.com/silverstripe/sapphire/commit/1f7f8b8) Don't' set 'Referer' header in FunctionalTest-&gt;get()/post() if its explicitly passed to the method (Ingo Schommer)
 * 2012-05-04 [440c96e](https://github.com/silverstripe/silverstripe-cms/commit/440c96e) replace "&lt;!-- --&gt;" with "&lt;%-- --%&gt;" for the blocks that are definately not needed to be processed by SSViewer to limit the chances of producing nested html comment tag "&lt;!--&lt;!-- --&gt;--&gt;" (Normann Lou)
 * 2012-05-04 [de4a865](https://github.com/silverstripe/sapphire/commit/de4a865) Fixed blowfish encryption for PHP &lt; 5.3.7 (#7276) (Sam Minnee)
 * 2012-05-03 [f7e19ca](https://github.com/silverstripe/sapphire/commit/f7e19ca) i18nTextCollector finds templates recursively, not only in &lt;module&gt;/templates folder. Added master language entities which were previously overlooked due to this bug. (Ingo Schommer)
 * 2012-05-03 [42bc5ff](https://github.com/silverstripe/sapphire/commit/42bc5ff) Returning File-&gt;getTreeTitle() with user input XML escaped, mirroring functionality in SiteTree-&gt;getTreeTitle() (Ingo Schommer)
 * 2012-05-03 [8eb0814](https://github.com/silverstripe/sapphire/commit/8eb0814) Put all php file inclusions/exclusions into a single file, because some servers don't seem to allow reenabling of file access in a subdirection .htaccess file. (Sam Minnee)
 * 2012-05-03 [37369ab](https://github.com/silverstripe/sapphire/commit/37369ab) Fixing SortColumn alias to be recognised by MSSQL/PGSQL (Sean Harvey)
 * 2012-05-02 [0068b6d](https://github.com/silverstripe/sapphire/commit/0068b6d) Showing only actually available languages for selection during install (fixes #7260) (Ingo Schommer)
 * 2012-05-02 [c732354](https://github.com/silverstripe/sapphire/commit/c732354) Return consistent data from ModelAdmin-&gt;getManagedModels(), fixing custom 'title' settings in $managed_models (fixes #7243) (Ingo Schommer)
 * 2012-05-02 [7fdfd4d](https://github.com/silverstripe/sapphire/commit/7fdfd4d) Changing CheckboxField_holder_small template order back to 2.4 ordering: Show checkbox before label (Ingo Schommer)
 * 2012-05-02 [db9806a](https://github.com/silverstripe/sapphire/commit/db9806a) Trac#7196 - Fixed styling issues with CMS page settings. (Jeremy Bridson)
 * 2012-05-01 [ca789ef](https://github.com/silverstripe/sapphire/commit/ca789ef) Disable form submits through "enter" key in CMS, as they might trigger unwanted actions by the browser choosing the default button (Ingo Schommer)
 * 2012-05-01 [431b958](https://github.com/silverstripe/sapphire/commit/431b958) Fixed arguments in global _t() function, added check for $returnValue fallback that its not the injection array as second parameter (Ingo Schommer)
 * 2012-05-01 [dc5e36e](https://github.com/silverstripe/sapphire/commit/dc5e36e) 7117 Fixes (Naomi Guyer)
 * 2012-05-01 [a8e8a60](https://github.com/silverstripe/sapphire/commit/a8e8a60) Fixed errors caused by complex raw SQL sort() calls. (#7236) (Sam Minnee)
 * 2012-05-01 [5abf8cf](https://github.com/silverstripe/sapphire/commit/5abf8cf) Don't select *any* column() in DataQuery::initialiseQuery(); leave that until finaliseQuery().  It shouldn't be necessary and just risks field collisions. (Sam Minnee)
 * 2012-05-01 [a610a8c](https://github.com/silverstripe/silverstripe-cms/commit/a610a8c) Fixing ListViewForm using setDisplayFields on GridField, not the component (Sean Harvey)
 * 2012-05-01 [16fae77](https://github.com/silverstripe/sapphire/commit/16fae77) Fix logic error (Naomi Guyer)
 * 2012-05-01 [1663e96](https://github.com/silverstripe/sapphire/commit/1663e96) Fixing stray . in the "Page type: x" tooltip hovering over a page (Sean Harvey)
 * 2012-05-01 [ee360c1](https://github.com/silverstripe/sapphire/commit/ee360c1) include derived classes for attaching in the UploadField. (Mateusz Uzdowski)
 * 2012-04-30 [85a331c](https://github.com/silverstripe/sapphire/commit/85a331c) Choose first "action" button on submission of CMS forms via enter key, to avoid a form field button being autoselected (fixes #7151) (Ingo Schommer)
 * 2012-04-30 [98a0331](https://github.com/silverstripe/silverstripe-cms/commit/98a0331) Fixed "add page" action when invoked through tree context menu (and removed URL hardcoding in JS) (fixes #7155) (Ingo Schommer)
 * 2012-04-30 [61c18c5](https://github.com/silverstripe/sapphire/commit/61c18c5) ES: Fixes #7003 (Naomi Guyer)
 * 2012-04-28 [b03cf04](https://github.com/silverstripe/sapphire/commit/b03cf04) Updating MySQLDatabaseConfigurationHelper to check for MySQLi instead of mysql_connect and other old function usage, as we've moved to MySQLi in MySQLDatabase.php now (Sean Harvey)
 * 2012-04-27 [e03d576](https://github.com/silverstripe/silverstripe-installer/commit/e03d576) Tutorial template fixes (Naomi Guyer)
 * 2012-04-27 [f5c26e7](https://github.com/silverstripe/sapphire/commit/f5c26e7) Add padding to settings panel (Naomi Guyer)
 * 2012-04-27 [4dc564b](https://github.com/silverstripe/sapphire/commit/4dc564b) actions panel (Naomi Guyer)
 * 2012-04-27 [b7d4ed8](https://github.com/silverstripe/silverstripe-installer/commit/b7d4ed8) Tutorial theme doctype (Naomi Guyer)
 * 2012-04-27 [8a6671d](https://github.com/silverstripe/sapphire/commit/8a6671d) Member::onChangeGroups() should allow ADMIN permission grant if the logged in user is an ADMIN (Sean Harvey)
 * 2012-04-26 [b822827](https://github.com/silverstripe/sapphire/commit/b822827) Start a PHP session in installer. (Fred Condo)
 * 2012-04-26 [4756b97](https://github.com/silverstripe/sapphire/commit/4756b97) absoluteURLs() rewrites URLs in list-style-image elements (Fred Condo)
 * 2012-04-26 [df6a249](https://github.com/silverstripe/sapphire/commit/df6a249) Change requirement rubrics to remove confusion (Fred Condo)
 * 2012-04-24 [bd74ba4](https://github.com/silverstripe/silverstripe-installer/commit/bd74ba4) updating theme to "Simple" in change log creator and documentation (Julian Seidenberg)
 * 2012-04-23 [647d578](https://github.com/silverstripe/silverstripe-cms/commit/647d578) Cleanup of onclick() being called in onmatch for ParentType field. Use a redraw() function instead which is called in onmatch and onclick (Sean Harvey)
 * 2012-04-23 [e392cc2](https://github.com/silverstripe/sapphire/commit/e392cc2) Pop-up scrolling IE7 (Naomi Guyer)
 * 2012-04-23 [a373703](https://github.com/silverstripe/sapphire/commit/a373703) Fix ?flush=1 not flushing en_US language (Andrew O'Neil)
 * 2012-04-23 [2b9b07a](https://github.com/silverstripe/sapphire/commit/2b9b07a) 7055 Filter buttons in IE9 (Naomi Guyer)
 * 2012-04-22 [bda849a](https://github.com/silverstripe/sapphire/commit/bda849a) Check for SimpleXML support in PHP at the installation step (Sean Harvey)
 * 2012-04-22 [cc339c3](https://github.com/silverstripe/sapphire/commit/cc339c3) Ensure the SS3 installer checks for CType support in PHP, as language YAML parser uses this in framework. (Sean Harvey)
 * 2012-04-20 [ca38b25](https://github.com/silverstripe/sapphire/commit/ca38b25) add CloseButton back, only hidde it when editing an image that loaded from content area. ENHANEMENT: remove call of toogleLooks() from redraw(), only call toggleLooks() when needed. MINOR: code minimazing / code convention. (Normann Lou)
 * 2012-04-20 [fbbdbbc](https://github.com/silverstripe/sapphire/commit/fbbdbbc) list only files the autoset relation supports in UploadField (Mateusz Uzdowski)
 * 2012-04-20 [095b62a](https://github.com/silverstripe/sapphire/commit/095b62a) remove the 'close button' from template used to edit an image detail in HTMLEditor popup (Normann Lou)
 * 2012-04-18 [66d0673](https://github.com/silverstripe/sapphire/commit/66d0673) Fixes #7003 (Naomi Guyer)
 * 2012-04-13 [523c19e](https://github.com/silverstripe/sapphire/commit/523c19e) fixing core error that occurs when there are two or more proxy servers in front of the SilverStripe application server (Julian Seidenberg)
 * 2012-03-16 [acdd07a](https://github.com/silverstripe/sapphire/commit/acdd07a) Allow template globals to be used in both object and value contexts (e.g. $Now.Year) BUGFIX: Allow template globals to return objects as well as values. (Sam Minnee)
 * 2012-02-06 [8281678](https://github.com/silverstripe/sapphire/commit/8281678) Urlencode paths in URLSegmentFilter when $allowMultibyte=true to avoid creating invalid URLs (and breaking assumptions based on ascii-only URLs, such as static publishing filename creation) (Ingo Schommer)
 * 2012-02-06 [08a7bf0](https://github.com/silverstripe/silverstripe-cms/commit/08a7bf0) Remove double URL/filename filtering in FilesystemPublisher to avoid breaking multibyte URLs (now possible through recently introduced URLSegmentFilter class). Multibyte safe url path processing in FilesystemPublisher. (Ingo Schommer)

### Minor changes

 * 2012-05-28 [ddd2d3a](https://github.com/silverstripe/sapphire/commit/ddd2d3a) Fixing broken i18nTest (Sean Harvey)
 * 2012-05-28 [7994b73](https://github.com/silverstripe/sapphire/commit/7994b73) Added i18n to Delete action (Sam Minnee)
 * 2012-05-28 [e3dee85](https://github.com/silverstripe/sapphire/commit/e3dee85) Fix broken test (Sean Harvey)
 * 2012-05-25 [e017813](https://github.com/silverstripe/sapphire/commit/e017813) Updated en langfile (Sam Minnee)
 * 2012-05-25 [9592b28](https://github.com/silverstripe/silverstripe-cms/commit/9592b28) Updated en langfile (Sam Minnee)
 * 2012-05-25 [48212aa](https://github.com/silverstripe/sapphire/commit/48212aa) Adding upgrade docs on deprecated Director::redirect() and Director::redirectBack() (Sean Harvey)
 * 2012-05-25 [fb7cd32](https://github.com/silverstripe/sapphire/commit/fb7cd32) Fixed field naming in SecurityAdminTest (recently changed alongside new GridFieldAddButton commit) (Ingo Schommer)
 * 2012-05-24 [5b07349](https://github.com/silverstripe/sapphire/commit/5b07349) Fixed GridFieldAddNewButton label (Ingo Schommer)
 * 2012-05-24 [15a5dab](https://github.com/silverstripe/sapphire/commit/15a5dab) Add a fallback thumbnail image for oEmbed inserts (Simon Welsh)
 * 2012-05-24 [b325fea](https://github.com/silverstripe/sapphire/commit/b325fea) Fixing "No current controller available" error when TestSession::__destruct() is called (Sean Harvey)
 * 2012-05-24 [a84ef8d](https://github.com/silverstripe/sapphire/commit/a84ef8d) Don't use template method Actions internally in Form (Sean Harvey)
 * 2012-05-23 [d9ee61c](https://github.com/silverstripe/silverstripe-cms/commit/d9ee61c) Use of DropdownField in CMS should call setEmptyString instead of use the $emptyString argument, as it's deprecated. (Sean Harvey)
 * 2012-05-23 [542d727](https://github.com/silverstripe/silverstripe-cms/commit/542d727) Don't use deprecated extraStatics when adding extra statics with DataExtension (Sean Harvey)
 * 2012-05-23 [77c2365](https://github.com/silverstripe/sapphire/commit/77c2365) Replacing deprecated static function calls to Director with current Controller instance replacements. (Sean Harvey)
 *  2012-05-23 [ec3ebc9](https://github.com/silverstripe/silverstripe-cms/commit/ec3ebc9) Use instance methods on current Controller instance for redirect() instead of static Director functions (Sean Harvey)
 * 2012-05-22 [0515555](https://github.com/silverstripe/silverstripe-cms/commit/0515555) Fixing CMSMainTest using old code, updating to new CMS admin/pages URL (Sean Harvey)
 * 2012-05-22 [3ed9c5f](https://github.com/silverstripe/sapphire/commit/3ed9c5f) Removed getitem allowed action, this method no longer exists in LeftAndMain (Sean Harvey)
 * 2012-05-22 [2cb89ed](https://github.com/silverstripe/silverstripe-cms/commit/2cb89ed) Fixing invalid URL (Sean Harvey)
 * 2012-05-22 [f446547](https://github.com/silverstripe/sapphire/commit/f446547) Using Config system instead of Director::addRules() in tests (Sean Harvey)
 * 2012-05-21 [bc4bf9d](https://github.com/silverstripe/sapphire/commit/bc4bf9d) Added 3.0.0-beta3 changelog (Ingo Schommer)
 * 2012-05-21 [063f6bc](https://github.com/silverstripe/sapphire/commit/063f6bc) Updated language master (Ingo Schommer)
 * 2012-05-20 [1614bc4](https://github.com/silverstripe/silverstripe-cms/commit/1614bc4) Removed unknown "cancel draft" button icon (fixes #7333) (Ingo Schommer)
 * 2012-05-20 [69fbdad](https://github.com/silverstripe/sapphire/commit/69fbdad) Removed non-functional "close popup" link from profile editing in CMS (fixes #7343) (Ingo Schommer)
 * 2012-05-20 [607a9e2](https://github.com/silverstripe/sapphire/commit/607a9e2) Reverted removal of horizontal panel scrollbars from dc5e36ec, as it makes important content like nested tree nodes inaccessible. UI elements inside the panel should adjust to the available width if visually required instead (fixes #7347) (Ingo Schommer)
 * 2012-05-20 [bb72037](https://github.com/silverstripe/sapphire/commit/bb72037) Don't double-trigger 'stop' event in UploadField.js (regression from d642eee2, fixes #7355) (Ingo Schommer)
 * 2012-05-20 [0cbb1b1](https://github.com/silverstripe/sapphire/commit/0cbb1b1) Fixed async entwine redraw calls in HtmlEditorField.js (regression from fdebedd1) (Ingo Schommer)
 * 2012-05-20 [7ab47b6](https://github.com/silverstripe/sapphire/commit/7ab47b6) Moved redundant toggleLooks() logic in HtmlEditorField.js to existing redraw() logic (Ingo Schommer)
 * 2012-05-20 [0250524](https://github.com/silverstripe/sapphire/commit/0250524) Indentation (Ingo Schommer)
 * 2012-05-20 [6f55b67](https://github.com/silverstripe/sapphire/commit/6f55b67) Removing duplicate "edit & organize" label from HTMLEditorField upload dialog, as its handled differently from the standard AssetAdmin: Fields go directly into edit mode, no need to duplicate this in a persistent upload status (fixes #7355) (Ingo Schommer)
 * 2012-05-20 [18fa9cd](https://github.com/silverstripe/sapphire/commit/18fa9cd) Fixed _t() message in AssetAdmin (fixes #7363) (Ingo Schommer)
 * 2012-05-19 [1bf6495](https://github.com/silverstripe/sapphire/commit/1bf6495) Partially reverted 4d4f9e08d9 as we don't need to check forTemplate() exists (Sean Harvey)
 * 2012-05-19 [b68e426](https://github.com/silverstripe/sapphire/commit/b68e426) Removing dodgy conditional tests in SSViewerTest (Sean Harvey)
 * 2012-05-19 [4d4f9e0](https://github.com/silverstripe/sapphire/commit/4d4f9e0) Code formatting in SSViewer (Sean Harvey)
 * 2012-05-19 [8e9ae37](https://github.com/silverstripe/sapphire/commit/8e9ae37) Rename & tweak some existing config files to better reflect meaning of various names (Hamish Friedlander)
 * 2012-05-18 [7dc2d61](https://github.com/silverstripe/sapphire/commit/7dc2d61) Removing whitespace (Sean Harvey)
 * 2012-05-18 [60e7a59](https://github.com/silverstripe/silverstripe-cms/commit/60e7a59) Adding default text to SAVEDUP entity (Sean Harvey)
 * 2012-05-18 [9201987](https://github.com/silverstripe/silverstripe-cms/commit/9201987) Removing unused template control (Sean Harvey)
 * 2012-05-18 [a762682](https://github.com/silverstripe/silverstripe-cms/commit/a762682) AssetAdmin tweaks to folder/file thumbnail columns to be tidier (Sean Harvey)
 * 2012-05-18 [6bb1218](https://github.com/silverstripe/sapphire/commit/6bb1218) Update entities via collector script. (Sam Minnee)
 * 2012-05-18 [70a5b49](https://github.com/silverstripe/sapphire/commit/70a5b49) Fixed i18n coding for LeftAndMain save and delete. (Sam Minnee)
 * 2012-05-18 [88a222f](https://github.com/silverstripe/sapphire/commit/88a222f) Updated inline phpdoc while investigating trac/4113 (Russell Michell)
 * 2012-05-18 [d8b5b97](https://github.com/silverstripe/sapphire/commit/d8b5b97) Upgrade notes on TinyMCE upgrade and how to resolve a common issue (Sean Harvey)
 * 2012-05-16 [7c589f0](https://github.com/silverstripe/sapphire/commit/7c589f0) Don't invoke layout() in onmatch() for cms-preview, as it causes a gap above the menu/logo div for some reason. It's also unnecessary processing, since the preview is always hidden by default, and layout() will be triggered through redraw() when required (e.g. preview panel expansion) (Ingo Schommer)
 * 2012-05-16 [e185a9b](https://github.com/silverstripe/sapphire/commit/e185a9b) Adding title to menu items so they can be more easily identified in collapsed mode (Ingo Schommer)
 * 2012-05-16 [8f2ede8](https://github.com/silverstripe/sapphire/commit/8f2ede8) Fixed syntax errors from SQLQuery/DataQuery cleanup (Ingo Schommer)
 * 2012-05-16 [6e99e18](https://github.com/silverstripe/sapphire/commit/6e99e18) Css coding conventions for CMS (Ingo Schommer)
 * 2012-05-16 [3a11c69](https://github.com/silverstripe/sapphire/commit/3a11c69) Updated security documentation (phpdoc and markdown) around new DataList and SQLQuery APIs, additional automatic escaping on some stricter inputs like column names (Ingo Schommer)
 * 2012-05-16 [5b223aa](https://github.com/silverstripe/silverstripe-cms/commit/5b223aa) Use GridFieldToolbarHeader and GridFieldFilterHeader in AssetAdmin GridField, set title of the table to the current folder title. (Sean Harvey)
 * 2012-05-16 [5a023f9](https://github.com/silverstripe/sapphire/commit/5a023f9) SCSS refactoring (Naomi Guyer)
 * 2012-05-16 [f01ca80](https://github.com/silverstripe/sapphire/commit/f01ca80) More robust path concat in HtmlEditorField.js (means it doesn't break with translatable module enabled) (Ingo Schommer)
 * 2012-05-15 [4d97f75](https://github.com/silverstripe/sapphire/commit/4d97f75) Fixed form reset styles (Ingo Schommer)
 * 2012-05-15 [7b40c5f](https://github.com/silverstripe/silverstripe-cms/commit/7b40c5f) Using search parameters in "edit tree" link (which ensures we include decorated parameters like 'locale' from the 'translatable' module) (Ingo Schommer)
 * 2012-05-15 [c185c73](https://github.com/silverstripe/silverstripe-cms/commit/c185c73) More extension points in CMSMain (specifically to allow for 'locale' query parameter and language drop down of the 'translatable' extension) (Ingo Schommer)
 * 2012-05-15 [d57ede8](https://github.com/silverstripe/sapphire/commit/d57ede8) Fixed query param concatenation in LeftAndMain.js (Ingo Schommer)
 * 2012-05-15 [5ff282e](https://github.com/silverstripe/sapphire/commit/5ff282e) Allow extending LeftAndMain-&gt;SiteTreeAsUL() (specifically used to add the language drop down for the 'translatable' module) (Ingo Schommer)
 * 2012-05-15 [8e39e7d](https://github.com/silverstripe/sapphire/commit/8e39e7d) Allow extension of LeftAndMain-&gt;Link() (Ingo Schommer)
 * 2012-05-15 [7d9cf5b](https://github.com/silverstripe/sapphire/commit/7d9cf5b) Use File::get_file_extension for fallback mime-type detection (Stig Lindqvist)
 * 2012-05-15 [ea8eb7b](https://github.com/silverstripe/sapphire/commit/ea8eb7b) Changed the configuration values for mime-type detection (Stig Lindqvist)
 * 2012-05-14 [7b8e254](https://github.com/silverstripe/sapphire/commit/7b8e254) Update jquery.entwine to latest version. Brings speed improvements in onmatch, and an inspector. (Hamish Friedlander)
 * 2012-05-14 [a53cca8](https://github.com/silverstripe/sapphire/commit/a53cca8) Renaming getFieldSet with getFieldList in FormScaffolder (Sean Harvey)
 * 2012-05-14 [c9bc485](https://github.com/silverstripe/sapphire/commit/c9bc485) Failover to configuration if the finfo module doesn't exists when getting file mime-type. (Stig Lindqvist)
 * 2012-05-13 [dc649c1](https://github.com/silverstripe/sapphire/commit/dc649c1) removed wrong icon (Zauberfisch)
 * 2012-05-13 [ad78d9a](https://github.com/silverstripe/sapphire/commit/ad78d9a) fixed missing cancel icon (Zauberfisch)
 * 2012-05-12 [9e6273c](https://github.com/silverstripe/sapphire/commit/9e6273c) Fixed deprecated method usage in ToggleCompositeField. (Andrew Short)
 * 2012-05-12 [368081f](https://github.com/silverstripe/sapphire/commit/368081f) Supressing deprecation warnings in FieldListTest for new FieldList-&gt;rewriteTabPath() invocations (Ingo Schommer)
 * 2012-05-12 [61232ba](https://github.com/silverstripe/sapphire/commit/61232ba) Localization of new UploadField strings (Ingo Schommer)
 * 2012-05-12 [6b87a6e](https://github.com/silverstripe/silverstripe-cms/commit/6b87a6e) Updated getResponseNegotiator visibility to match changed parent API. (Andrew Short)
 * 2012-05-12 [38075d8](https://github.com/silverstripe/sapphire/commit/38075d8) Tweaked the main tab styling to fix the background and make text more readable. (Andrew Short)
 * 2012-05-12 [d17c4d0](https://github.com/silverstripe/sapphire/commit/d17c4d0) Made all icons consistently 16x16, and show them inside .ui-widget-content elements. (Andrew Short)
 * 2012-05-12 [3c6e7bd](https://github.com/silverstripe/sapphire/commit/3c6e7bd) Adding fileinfo extension to server-requirements.md documentation (Sean Harvey)
 * 2012-05-12 [91c356a](https://github.com/silverstripe/sapphire/commit/91c356a) Disabling offending MIME type test case on multiple operating systems. See pull request #432 for more information. (Sean Harvey)
 * 2012-05-12 [20a51d6](https://github.com/silverstripe/sapphire/commit/20a51d6) Ensure finfo class exists in installer checks, we need it for MIME type detection of files. (Sean Harvey)
 * 2012-05-11 [3f19f4c](https://github.com/silverstripe/sapphire/commit/3f19f4c) Removing special case handling for chosen.js from UploadField, using generic change listener (incl. some iframe scoping fixes) (Ingo Schommer)
 * 2012-05-11 [4a5603b](https://github.com/silverstripe/sapphire/commit/4a5603b) Don't show a border below the last field. (Andrew Short)
 * 2012-05-11 [dc1ccfe](https://github.com/silverstripe/sapphire/commit/dc1ccfe) Made the JS class used for gridfield detail actions apply to .action-detail rather than specific actions. (Andrew Short)
 * 2012-05-11 [01f8e38](https://github.com/silverstripe/sapphire/commit/01f8e38) Using correct URL for tutorial in installer (Sean Harvey)
 * 2012-05-11 [aae4f9e](https://github.com/silverstripe/silverstripe-installer/commit/aae4f9e) Adding .DS_Store to .gitignore (Sean Harvey)
 * 2012-05-11 [1616bae](https://github.com/silverstripe/sapphire/commit/1616bae) Adding phpdoc to HTTP::get_mime_type() (Sean Harvey)
 * 2012-05-11 [6f672e5](https://github.com/silverstripe/sapphire/commit/6f672e5) Fixing use of &lt;% control %&gt; with &lt;% with %&gt; or &lt;% loop %&gt; as necessary. (Sean Harvey)
 * 2012-05-11 [46f51d5](https://github.com/silverstripe/sapphire/commit/46f51d5) Fixing deprecated use of SQLQuery (Sean Harvey)
 * 2012-05-11 [23c93b9](https://github.com/silverstripe/sapphire/commit/23c93b9) Fixing ArrayDataTest to use toMap() instead of getArray() which is deprecated. (Sean Harvey)
 * 2012-05-11 [1859070](https://github.com/silverstripe/sapphire/commit/1859070) Fixing use of deprecated getAllFields(), mark field as deprecated properly. (Sean Harvey)
 * 2012-05-11 [6dd94bd](https://github.com/silverstripe/sapphire/commit/6dd94bd) Changed classes on tabset li and a tags to match new standard. (Robert Curry)
 * 2012-05-11 [be06ae7](https://github.com/silverstripe/sapphire/commit/be06ae7) change the tree reorganisation message. (Mateusz Uzdowski)
 * 2012-05-10 [7f4c6e3](https://github.com/silverstripe/sapphire/commit/7f4c6e3) Fixed small button styles (now used in URLSegment "edit" button etc.) (Ingo Schommer)
 * 2012-05-10 [c9900b7](https://github.com/silverstripe/sapphire/commit/c9900b7) Upgrade jQuery UI dependency to 1.8.20 (Sean Harvey)
 * 2012-05-10 [1e8a89d](https://github.com/silverstripe/sapphire/commit/1e8a89d) Upgrade jQuery dependency to 1.7.2 (Sean Harvey)
 * 2012-05-10 [68c5066](https://github.com/silverstripe/sapphire/commit/68c5066) Remove old _ALL_CLASSES from old manifest builder (has been replaced since) (Sean Harvey)
 * 2012-05-09 [6655830](https://github.com/silverstripe/sapphire/commit/6655830) Upgrading notes around tab rewrites (Ingo Schommer)
 * 2012-05-09 [c72bae3](https://github.com/silverstripe/silverstripe-cms/commit/c72bae3) Fixing assertType() assertions with assertInstanceOf() (Sean Harvey)
 * 2012-05-09 [dedb9d0](https://github.com/silverstripe/silverstripe-cms/commit/dedb9d0) Removing use of _t() in test, assert the english text since en_US is the locale set for tests by default. (Sean Harvey)
 * 2012-05-09 [46660e9](https://github.com/silverstripe/silverstripe-cms/commit/46660e9) Fixing broken test (Sean Harvey)
 * 2012-05-09 [0f1f859](https://github.com/silverstripe/sapphire/commit/0f1f859) Updating docs to use Member::get() instead of DataList::create('Member') syntax (Sean Harvey)
 * 2012-05-09 [0af2d87](https://github.com/silverstripe/sapphire/commit/0af2d87) Cleaned up the GridFieldDataColumns to be easier on the eyes and fixed the some method docblocks for the interface (Stig Lindqvist)
 * 2012-05-08 [41b51a1](https://github.com/silverstripe/sapphire/commit/41b51a1) Isolating testRaw2URL settings (Ingo Schommer)
 * 2012-05-08 [ce58e55](https://github.com/silverstripe/silverstripe-cms/commit/ce58e55) Consistent location for CSS classes on CMS tabsets (Ingo Schommer)
 * 2012-05-08 [592d42e](https://github.com/silverstripe/sapphire/commit/592d42e) Stop using deprecated getTabIndex() in CreditCardField (Ingo Schommer)
 * 2012-05-08 [2c878f5](https://github.com/silverstripe/sapphire/commit/2c878f5) Template consistency between TabSet.ss and overloaded LeftAndMain tabsets (Ingo Schommer)
 * 2012-05-08 [f2d2f5b](https://github.com/silverstripe/sapphire/commit/f2d2f5b) Changed CMS section name from "Users" back to its 2.4 label, "Security". Mainly to avoid breadcrumb weirdnesses when having a "Users/Users/My User" path. Signed off by Paul. (Ingo Schommer)
 * 2012-05-08 [2212363](https://github.com/silverstripe/sapphire/commit/2212363) Using new extraClass support in tabs for CMSTabSet (Ingo Schommer)
 * 2012-05-08 [c507efc](https://github.com/silverstripe/sapphire/commit/c507efc) Updated TinyMCE dependency from 3.4.6 to 3.5 (Sean Harvey)
 * 2012-05-08 [f766178](https://github.com/silverstripe/silverstripe-cms/commit/f766178) Added padding to CMSSettingsController view (Ingo Schommer)
 * 2012-05-08 [82cf938](https://github.com/silverstripe/sapphire/commit/82cf938) Reverting padding changes from pull request #377, way too global - solved through a .cms-panel-padded class in CMSSettingsController instead (Ingo Schommer)
 * 2012-05-08 [76dd6d1](https://github.com/silverstripe/sapphire/commit/76dd6d1) Fixed style sprites broken by pull request #402 (Ingo Schommer)
 * 2012-05-08 [0c0a91e](https://github.com/silverstripe/sapphire/commit/0c0a91e) Fix coding conventions (Andrew O'Neil)
 * 2012-05-07 [d8e6222](https://github.com/silverstripe/silverstripe-cms/commit/d8e6222) Tree metadata naming (Ingo Schommer)
 * 2012-05-07 [7e0d0a4](https://github.com/silverstripe/sapphire/commit/7e0d0a4) Tree metadata naming (Ingo Schommer)
 * 2012-05-07 [7c272d3](https://github.com/silverstripe/sapphire/commit/7c272d3) SQLQuery doc cleanup (Sean Harvey)
 * 2012-05-07 [3bc1da0](https://github.com/silverstripe/sapphire/commit/3bc1da0) Tidy up of SQLQuery constructor docs and default args, limit is stored internally as an array, not a string. (Sean Harvey)
 * 2012-05-07 [45810a1](https://github.com/silverstripe/silverstripe-cms/commit/45810a1) Using new API methods after SQLQuery API changes (Sean Harvey)
 * 2012-05-04 [a79032c](https://github.com/silverstripe/sapphire/commit/a79032c) Fixing broken test on Windows (Sean Harvey)
 * 2012-05-04 [f18b2f6](https://github.com/silverstripe/sapphire/commit/f18b2f6) Docs mention of automatic master lang uploads (Ingo Schommer)
 * 2012-05-04 [5702007](https://github.com/silverstripe/sapphire/commit/5702007) Fixing comment to be more concise. (Sean Harvey)
 * 2012-05-04 [20a8379](https://github.com/silverstripe/sapphire/commit/20a8379) Using PHP version constants rather than version_compare() in Object::static_lookup(), since its called 10k times on an average CMS load that makes a difference of about 3% (with APC) (Ingo Schommer)
 * 2012-05-03 [f545f52](https://github.com/silverstripe/silverstripe-cms/commit/f545f52) Updated master lang tables (Ingo Schommer)
 * 2012-05-03 [f6c8468](https://github.com/silverstripe/sapphire/commit/f6c8468) Disabled MainMenu caching in LeftAndMain (Ingo Schommer)
 * 2012-05-03 [d072f71](https://github.com/silverstripe/silverstripe-cms/commit/d072f71) Don't show title on reports GridField (duplicates the section title) (Ingo Schommer)
 * 2012-05-03 [450bc25](https://github.com/silverstripe/sapphire/commit/450bc25) Fixing broken SQLQueryTest cases (Sean Harvey)
 * 2012-05-03 [521d436](https://github.com/silverstripe/sapphire/commit/521d436) Fixing broken test in pgsql (Sean Harvey)
 * 2012-05-03 [e929753](https://github.com/silverstripe/sapphire/commit/e929753) Using correct $locale format in installer (regression from last commit) (Ingo Schommer)
 * 2012-05-02 [8c10539](https://github.com/silverstripe/sapphire/commit/8c10539) Fixed unnecessary background in CMS tabs, causes wrong display in FF, and already implemented on parent "cms-content-header" (#7240) (Ingo Schommer)
 * 2012-05-02 [dc65954](https://github.com/silverstripe/sapphire/commit/dc65954) Correct breadcrumbs in ModelAdmin when managing multiple models (#7240) (Ingo Schommer)
 * 2012-05-02 [a2e9c00](https://github.com/silverstripe/sapphire/commit/a2e9c00) Fix style according to style guidelines, and add a comment about use of "$2y" instead of "$2a" (Andrew O'Neil)
 * 2012-05-01 [0597e91](https://github.com/silverstripe/sapphire/commit/0597e91) Don't fail text collection for modules without any matching PHP files (only _config.php) (Ingo Schommer)
 * 2012-05-01 [7b18d9d](https://github.com/silverstripe/sapphire/commit/7b18d9d) Switching _t() calls from sprintf() to using injection parameters (#7170) (Ingo Schommer)
 * 2012-05-01 [38f1236](https://github.com/silverstripe/silverstripe-cms/commit/38f1236) Switching _t() calls from sprintf() to using injection parameters (#7170) (Ingo Schommer)
 * 2012-05-01 [63cef2a](https://github.com/silverstripe/silverstripe-cms/commit/63cef2a) Disable batch actions in pages list view until we've implemented checkboxes in GridField (Ingo Schommer)
 * 2012-05-01 [9f16685](https://github.com/silverstripe/silverstripe-cms/commit/9f16685) Remove usage of deprecated array access on SQLQuery in SiteTreeFolderExtension (Ingo Schommer)
 * 2012-05-01 [4c2352f](https://github.com/silverstripe/sapphire/commit/4c2352f) Don't trigger on click on construction of view-model toggles, as it bubbles up to the panel, where it causes a toggle action which overrides any previous user choices stored in cookies (fixes #7210) (Ingo Schommer)
 * 2012-05-01 [feab46e](https://github.com/silverstripe/sapphire/commit/feab46e) Marking ModelAdmin tools filters panel as expanded by default (related to #7210) (Ingo Schommer)
 * 2012-05-01 [c6cca21](https://github.com/silverstripe/silverstripe-cms/commit/c6cca21) Removed duplicate HTML ids from tools panels, which meant they were sharing a collapse state cookie (see #7210). Marking AssetAdmin filters and 'edit page" tree sidebar as expanded by default, but the filters on "pages" as collapsed. (Ingo Schommer)
 * 2012-05-01 [f5d1831](https://github.com/silverstripe/silverstripe-cms/commit/f5d1831) Reverting panel collapse changes for filters (see pull requests #383 and #385) (Ingo Schommer)
 * 2012-05-01 [b428fa1](https://github.com/silverstripe/sapphire/commit/b428fa1) Reverting panel collapse changes for filters (see pull requests #383 and #385) (Ingo Schommer)
 * 2012-05-01 [390d3d3](https://github.com/silverstripe/sapphire/commit/390d3d3) Fixed broken notice (Sean Harvey)
 * 2012-05-01 [7c54c60](https://github.com/silverstripe/silverstripe-cms/commit/7c54c60) Rename setModel to setDataModel due to API changes (Sean Harvey)
 * 2012-04-30 [2784891](https://github.com/silverstripe/sapphire/commit/2784891) Fixed anchor markdown in upgrading guide, better formatting for config upgrade instructions (Ingo Schommer)
 * 2012-04-30 [8c1651e](https://github.com/silverstripe/silverstripe-cms/commit/8c1651e) Using GridField instead of TableListField for SiteTree-&gt;getCMSFields() DependentPages (fixes #7239) (Ingo Schommer)
 * 2012-04-30 [517a0c9](https://github.com/silverstripe/sapphire/commit/517a0c9) Moving FakeController class (required for bootstrap.php) into its own file, so that autoloading doesn't execute bootstrap (which is the case when invoking TestRunner-&gt;module()) (Ingo Schommer)
 * 2012-04-30 [ffe698c](https://github.com/silverstripe/sapphire/commit/ffe698c) Placeholder text for adding a group in Member-&gt;getCMSFields() (fixes #7217) (Ingo Schommer)
 * 2012-04-30 [0e8c3ac](https://github.com/silverstripe/sapphire/commit/0e8c3ac) Using SapphireInfo non-statically in RestfulService (fixes #7238) (Ingo Schommer)
 * 2012-04-30 [3ccaa1f](https://github.com/silverstripe/sapphire/commit/3ccaa1f) Supress any error connecting to the database so the installer doesn't show it in the page header (Sean Harvey)
 * 2012-04-27 [c7ca63e](https://github.com/silverstripe/sapphire/commit/c7ca63e) Updated translation-process docs, migrated FAQs from translate.silverstripe.org (Ingo Schommer)
 * 2012-04-27 [7e22239](https://github.com/silverstripe/sapphire/commit/7e22239) Updated docs with getlocalization.com instructions (Ingo Schommer)
 * 2012-04-27 [60b2e69](https://github.com/silverstripe/silverstripe-cms/commit/60b2e69) Regenerating lang master files with fixed entity collection logic (fixes "CMSPagesController" menu title in interface) (Ingo Schommer)
 * 2012-04-27 [f48346d](https://github.com/silverstripe/sapphire/commit/f48346d) Regenerating lang master files with fixed entity collection logic (fixes "CMSPagesController" menu title in interface) (Ingo Schommer)
 * 2012-04-27 [f47cf33](https://github.com/silverstripe/sapphire/commit/f47cf33) Fixed i18nTextCollector module disambiguation, was looking at wrong array key (shifted one due to removed priority setting) (Ingo Schommer)
 * 2012-04-27 [98c2517](https://github.com/silverstripe/sapphire/commit/98c2517) Fixed i18n:;get_owner_module(), broken by changed manifest returns (paths with leading slash) (Ingo Schommer)
 * 2012-04-27 [80575a0](https://github.com/silverstripe/sapphire/commit/80575a0) Re-adding getFilter as a deprecated method instead of removing it (Sean Harvey)
 * 2012-04-27 [6ee7c84](https://github.com/silverstripe/silverstripe-cms/commit/6ee7c84) Updating language master files (slightly different format due to generation through i18nTextCollector, rather than the i18n_yml_converter module) (Ingo Schommer)
 * 2012-04-27 [2c3c410](https://github.com/silverstripe/sapphire/commit/2c3c410) Updating language master files (slightly different format due to generation through i18nTextCollector, rather than the i18n_yml_converter module) (Ingo Schommer)
 * 2012-04-26 [b561786](https://github.com/silverstripe/sapphire/commit/b561786) change the ugly user-facing CSRF message to more friendly (Mateusz Uzdowski)
 * 2012-04-26 [70adfc1](https://github.com/silverstripe/sapphire/commit/70adfc1) Fix chosen Coffeescript files (Naomi Guyer)
 * 2012-04-26 [810b01d](https://github.com/silverstripe/sapphire/commit/810b01d) adjusting documentation according to remove references to 'new-project' script (thanks Ingo) (Julian Seidenberg)
 * 2012-04-24 [227473b](https://github.com/silverstripe/sapphire/commit/227473b) updating documentation to give details about how to install SilverStripe using the Phing script (Julian Seidenberg)
 * 2012-04-24 [e486ec4](https://github.com/silverstripe/sapphire/commit/e486ec4) updating documentation to use "Simple" theme (Julian Seidenberg)
 * 2012-04-24 [d2f5fc4](https://github.com/silverstripe/silverstripe-installer/commit/d2f5fc4) adding PHPStorm IDE files to the .gitignore (Julian Seidenberg)
 * 2012-04-23 [6d38798](https://github.com/silverstripe/sapphire/commit/6d38798) Documentation changes (Sean Harvey)
 * 2012-04-23 [452b2aa](https://github.com/silverstripe/silverstripe-cms/commit/452b2aa) Fix "Pages" CMS title (Andrew O'Neil)
 * 2012-04-21 [b9854df](https://github.com/silverstripe/silverstripe-cms/commit/b9854df) Removing @todo in CMSMain.EditForm.js which has been done (Sean Harvey)
 * 2012-04-21 [e12a82e](https://github.com/silverstripe/sapphire/commit/e12a82e) Documentation on EmailField type attribute change (Sean Harvey)
 * 2012-04-20 [db3332e](https://github.com/silverstripe/silverstripe-cms/commit/db3332e) Modify VirtualPage to work with lazy loading. (Robert Curry)
 * 2012-02-06 [63536af](https://github.com/silverstripe/silverstripe-cms/commit/63536af) Documentation (Ingo Schommer)
 * 2012-02-06 [59d31c2](https://github.com/silverstripe/sapphire/commit/59d31c2) Removed mbstring support checks, its an installation requirement (Ingo Schommer)

### Other

 * 2012-05-16 [eeef41e](https://github.com/silverstripe/sapphire/commit/eeef41e) SECURITY Fixed remote code execution vuln in install.php due to inserting unescaped user data into mysite/_config.php. Not critical because install.php is required to be removed on a SilverStripe installation anyway (fixes #7205) (Ingo Schommer)
 * 2012-05-09 [a58dad8](https://github.com/silverstripe/silverstripe-cms/commit/a58dad8) Compiled CSS without line comments (Ryan Wachtl)
 * 2012-05-09 [bd94c6f](https://github.com/silverstripe/silverstripe-cms/commit/bd94c6f) Trac 6981: Opt-in URL Updating (Ryan Wachtl)
 * 2012-05-04 [d5b3dbc](https://github.com/silverstripe/sapphire/commit/d5b3dbc) SECURITY Return true for Director::is_absolute_url() checks if they're prefixed with two or more slashes (as browsers interpret this as a valid URL) SECURITY More solid URL checks in Director::is_site_url(), using a conservative parse_url() hostname comparison rather than Director::makeRelative(), which is not designed for security purposes (Ingo Schommer)
 * 2012-04-27 [d47821a](https://github.com/silverstripe/sapphire/commit/d47821a) Change git add command to also include the changes to .gitignore (Fred Condo)
 * 2012-04-27 [0e9dd92](https://github.com/silverstripe/sapphire/commit/0e9dd92) Augment/correct phing installation instructions (Fred Condo)
 * 2012-04-20 [611cd53](https://github.com/silverstripe/sapphire/commit/611cd53) inst_clearAll() does not return anything so clear_all() method should not expect any return value from inst_clearAll invocation (joaosantos81)
 * 2012-02-18 [eb5961d](https://github.com/silverstripe/sapphire/commit/eb5961d) added ignore (John Milmine)
