# 3.0.0-beta1 #

## Overview ##

### CMS ###
 
 * The "Files & Images" (`AssetAdmin`) interface shows the file tree next to a flat list.
   It lists images as thumbnails, and allows to search by file category.
 * The CMS editor can insert multiple images as once, finds them more efficiently,
   and shows better previews on what's being inserted. 
 * More extensible architecture for inserting media types other than images or flash objects.
 * All interfaces expose their currently managed content structure as linked breadcrumbs,
   aiding navigation and clarifying content hierachies of e.g. Pages or Group->Member relationships.
 * Removed prototype.js/behaviour.js usage from nearly all core interfaces
 
### Framework ###

 * New `Config` API to standardise configuration contained in objects (early stage)
 * New `GridField` API to replace `TableListField` and `ComplexTableField`.
   More decoupled architecture, using the new ORM.
 * A `GridFieldDetailForm` interface allows editing of master/detail relationships,
   including traversing nested relationships (which wasn't possible before due to popup-in-a-popup problem).
   Detail forms fully support the TinyMCE editor, as they're loaded into the main CMS interface rather than a popup.
 * Redesigned `ModelAdmin` interface building on top of `GridField`.
   Search results show by default, clearer layout of interfaces managing multiple classes.
 * Interfaces like `ModelAdmin` can make use of TinyMCE, including insertion of images and links.
 * New `UploadField` API to replace `ImageField` and `FileIframeField`.
   Allows for multiple file uploads through HTML5 (with fallbacks),
   inline editing of file properties after upload, and management of has_many/many_many file relationships.
 * The "Users' (`SecurityAdmin`) interface manages groups in a list rather than a tree,
   and uses `GridField` to list users/groups/roles. Adding members to groups is now possible
   with standard `GridField` autocomplete components. Roles and groups are assigned
   via an inline autocomplete field, which is quicker and smaller than a dedicated table field.
 * Overloadable templates for most form fields. `FormField->setAttribute()` to enable HTML5 attributes

## TODO ##

A non-exhaustive, high-level list of features we haven’t addressed yet:
 
 * List view for pages
 * Gallery view for files
 * In-content file upload (and "insert from web")
 * Widget editing in CMS (most likely separated into a module)
 * New batch action system with interactive dialogs
 * ReportAdmin
 * Configurable two-level CMS menu
 * SQL Server and PostgreSQL core support
 * Performance fixes for Internet Explorer
 
## Upgrading ##

See [3.0.0](/changelogs/3.0.0) for previous details.
Note that you'll get PHP notice-level errors automatically
when using deprecated functionality (through the new `Deprecation` class).

## Changelog ##

### API Changes

 * 2012-03-12 [2d151b8](https://github.com/silverstripe/sapphire/commit/2d151b8) Deprecated TableListField and ComplexTableField, use GridField instead (Ingo Schommer)
 * 2012-03-10 [7de5bf5](https://github.com/silverstripe/sapphire/commit/7de5bf5) Updated throwExceptionOnBadDataType setter to be standard setThrowExceptionOnBadDataType(), added getThrowExceptionOnBadDataType(). (Sam Minnee)
 * 2012-03-09 [e6be56e](https://github.com/silverstripe/sapphire/commit/e6be56e) Removed FormResponse class, use custom HTTP status codes to communicate state on text/html responses, or use text/json for more structured data responses (Ingo Schommer)
 * 2012-03-09 [fa6142c](https://github.com/silverstripe/sapphire/commit/fa6142c) Removed deprecated TableListField-&gt;ajax_refresh() (Ingo Schommer)
 * 2012-03-09 [01b24da](https://github.com/silverstripe/sapphire/commit/01b24da) Removed Member::isAdmin(), use Permission::check('ADMIN') instead API CHANGE Removed Member-&gt;setByCheckboxes()/setByCheckboxSetField(), Use setByIdList() and/or a CheckboxSetField instead API CHANGE Removed Member-&gt;addManyByGroupID(), Use DataList-&gt;addMany() instead. API CHANGE Removed Member-&gt;removeManyByGroupID(). Use DataList-&gt;removeMany() instead. API CHANGE Removed Member-&gt;getGroupsFromIDs(). Use DataObject::get("Group")-&gt;byIds() instead. API CHANGE Removed Member-&gt;addManyByCodename()/removeManyByCodename(). Don\'t rely on codename (Ingo Schommer)
 * 2012-03-09 [4216a09](https://github.com/silverstripe/sapphire/commit/4216a09) Removed BasicAuth::enable()/disable(), use protect_entire_site() (Ingo Schommer)
 * 2012-03-09 [27fd3e5](https://github.com/silverstripe/sapphire/commit/27fd3e5) Removed Session::load_config() (no longer supported) (Ingo Schommer)
 * 2012-03-09 [1f01e11](https://github.com/silverstripe/sapphire/commit/1f01e11) Removing ScaffoldingComplexTableField, using GridField instead to edit relationships through FormScaffolder and DataObject-&gt;scaffoldFormFields() (Ingo Schommer)
 * 2012-03-09 [e12a3a4](https://github.com/silverstripe/sapphire/commit/e12a3a4) ModelAdmin uses GridField, DataList and new layout. Removed ModelAdmin_CollectionController, ModelAdmin_RecordController and related functionality. API CHANGE Removed ModelAdmin-&gt;ResultColumns()/ColumnSelectionField, selection of own fields no longer possible through the UI, to be replaced by a more generic GridField component (Ingo Schommer)
 * 2012-03-09 [818c341](https://github.com/silverstripe/sapphire/commit/818c341) Created GridFieldAddNewButton, replacing the one that was previously hardcoded in GridFieldToolbarHeader (Sam Minnee)
 * 2012-03-09 [12618e2](https://github.com/silverstripe/sapphire/commit/12618e2) Added targetFragment argument to GridFieldAddExistingAutocompleter, so that its location can be changed.  Updated CSS and HTML to allow for this. (Sam Minnee)
 * 2012-03-09 [d795a55](https://github.com/silverstripe/sapphire/commit/d795a55) Removed 'add new' button from GridFieldToolbarHeader, instead opting to include two HTML fragments: toolbar-header-left and toolbar-header-right. (Sam Minnee)
 * 2012-03-09 [92a3535](https://github.com/silverstripe/sapphire/commit/92a3535) Added targetFragment argument to GridFieldExportButton to control button placement.  Moved search fields to 2nd argument. (Sam Minnee)
 * 2012-03-09 [2cb67ef](https://github.com/silverstripe/sapphire/commit/2cb67ef) DataObject::getComponents() should use default value for limit as NULL (Stig Lindqvist)
 * 2012-03-09 [d0a0df0](https://github.com/silverstripe/sapphire/commit/d0a0df0) Removed Security::$useSalt static, please use a custom PasswordEncryptor instead (Sean Harvey)
 * 2012-03-09 [aca2b2f](https://github.com/silverstripe/sapphire/commit/aca2b2f) Removed deprecated Security::get_encryption_algorithms() - please use PasswordEncryptor::get_encryptors() instead (Sean Harvey)
 * 2012-03-09 [6e58026](https://github.com/silverstripe/sapphire/commit/6e58026) Removed deprecated Security::encrypt_passwords() - please use PasswordEncryptor_None instead. (Sean Harvey)
 * 2012-03-09 [4a52e29](https://github.com/silverstripe/sapphire/commit/4a52e29) Removed deprecated File::getLinkedURL() - please use custom code instead. (Sean Harvey)
 * 2012-03-09 [71c2a22](https://github.com/silverstripe/sapphire/commit/71c2a22) Removed support for extraDBFields method in DataExtension, please ensure you are using extraStatics on your extension classes (Sean Harvey)
 * 2012-03-09 [e9e7655](https://github.com/silverstripe/sapphire/commit/e9e7655) Added SS_Sortable, an extra interface to apply to SS_Lists. (Sam Minnee)
 * 2012-03-09 [f000a47](https://github.com/silverstripe/sapphire/commit/f000a47) Added SS_Filterable, an extra interface to apply to lists. (Sam Minnee)
 * 2012-03-09 [09d6fa7](https://github.com/silverstripe/sapphire/commit/09d6fa7) Renamed GridFieldDefaultColumns to GridFieldDataColumns #6921 (Stig Lindqvist)
 * 2012-03-09 [a55e06f](https://github.com/silverstripe/sapphire/commit/a55e06f) Introduce SS_Limitable class for adding to SS_Lists that have limit capability. API CHANGE: Deprecated SS_List::getRange() in favour of SS_Limitable::limit(). API CHANGE: Introduce SS_Limitable::limit($limit, $offset = 0) as the only modern way of specifying limits; deprecate all others. (Sam Minnee)
 * 2012-03-09 [6d0b0d6](https://github.com/silverstripe/sapphire/commit/6d0b0d6) Removing GridFieldDeleteAction and moved functionality into GridFieldRemoveButton #6921 (Stig Lindqvist)
 * 2012-03-09 [8b82dae](https://github.com/silverstripe/sapphire/commit/8b82dae) Renaming of gridfield components #6921 (Stig Lindqvist)
 * 2012-03-09 [c59c717](https://github.com/silverstripe/sapphire/commit/c59c717) Removed CustomRequiredFields, please use custom validation instead BUGFIX Ensure validators still used in ModelAdmin forms (Sean Harvey)
 * 2012-03-09 [9f3344b](https://github.com/silverstripe/sapphire/commit/9f3344b) Removed built-in behaviour.js client-side form validation. This is no longer supported. Please use custom client-side validation instead. (see 3.0.0 changelog for more information) (Sean Harvey)
 * 2012-03-09 [f86e53b](https://github.com/silverstripe/sapphire/commit/f86e53b) Removed Validator::showError(), Validator::getError() and Validator::getCombinedError(). Use Validator::getErrors() instead (Sean Harvey)
 * 2012-03-08 [c117ef5](https://github.com/silverstripe/sapphire/commit/c117ef5) Removed LeftAndMain-&gt;RootForm(), concept no longer applies in 3.0 UI. Use EmptyForm() or EditForm() (Ingo Schommer)
 * 2012-03-08 [5800db0](https://github.com/silverstripe/sapphire/commit/5800db0) Allow for the creation of custom GridField fragments. (#6911) (Sam Minnee)
 * 2012-03-08 [1fd8d19](https://github.com/silverstripe/sapphire/commit/1fd8d19) FormAction::FieldHolder() now returns just the Field(), so that a FieldList::forTemplate() returns a sensible result for an action list. (Sam Minnee)
 * 2012-03-08 [e4dbf80](https://github.com/silverstripe/sapphire/commit/e4dbf80) Added FieldList::forTemplate(), so that by default a FieldList will be rendered in its template as a concatenation of FieldHolder values. API CHANGE: Removed unnecessary HiddenFieldList class. (Sam Minnee)
 * 2012-03-08 [ba93028](https://github.com/silverstripe/sapphire/commit/ba93028) Added Form::VisibleFields() and FieldList::VisibleFields(), which list everything except hidden fields, to assist with the creation of custom form layouts. (Sam Minnee)
 * 2012-03-07 [391ffde](https://github.com/silverstripe/sapphire/commit/391ffde) Deprecated FormField-&gt;getTabIndex()/setTabIndex(), use getAttribute()/setAttribute() instead. Removed FormField-&gt;getTabIndexHTML() (Ingo Schommer)
 * 2012-03-07 [feca839](https://github.com/silverstripe/sapphire/commit/feca839) Deprecated HasManyComplexTableField and ManyManyComplexTableField, use GridField with GridFieldConfig_RelationEditor instead (Ingo Schommer)
 * 2012-03-07 [55a0fb1](https://github.com/silverstripe/sapphire/commit/55a0fb1) Deprecated FormField-&gt;describe(), use setDescription() instead. Actually use the description in form fields other than FormAction. (Ingo Schommer)
 * 2012-03-05 [0117b32](https://github.com/silverstripe/sapphire/commit/0117b32) Removed MemberTableField, use GridField with GridFieldConfig_RelationEditor instead (Ingo Schommer)
 * 2012-03-05 [3ef957b](https://github.com/silverstripe/sapphire/commit/3ef957b) SSF-53 : add ability to set an customised class of icons for a GridField_Action button (Normann Lou)
 * 2012-03-02 [fda7a6a](https://github.com/silverstripe/sapphire/commit/fda7a6a) Remove custom File::instance_get(), use a custom DataQuery in case you want to exclude large File.Content fields from the query results (Ingo Schommer)
 * 2012-03-02 [fb3c18d](https://github.com/silverstripe/sapphire/commit/fb3c18d) Remove File-&gt;uploadMetadataFields(), use new UploadField instead (Ingo Schommer)
 * 2012-03-02 [424da6a](https://github.com/silverstripe/sapphire/commit/424da6a) Moved NZGovtPasswordValidator to new 'securityextras' module (Ingo Schommer)
 * 2012-03-01 [0ab43cd](https://github.com/silverstripe/sapphire/commit/0ab43cd) Moved "IP Address restrictions for groups" feature to a new "ipaddress-restriction" module (SSF-53) (Ingo Schommer)
 * 2012-02-21 [27cdc40](https://github.com/silverstripe/sapphire/commit/27cdc40) Moved AssetAdmin-specific fields from Folder-&gt;getCMSFields() to AssetAdmin-&gt;getEditForm(). For modifying those fields via DataExtension, please use AssetAdmin-&gt;updateEditForm() instead (Ingo Schommer)
 * 2012-02-21 [374ed19](https://github.com/silverstripe/sapphire/commit/374ed19) Change variable expose method in TemplateGlobalProvider and TemplateIteratorProvider to (a) not clash with each other and, (b) be less generic (Hamish Friedlander)
 * 2012-02-20 [fb246bd](https://github.com/silverstripe/sapphire/commit/fb246bd) Rename getExposedVariables to match coding conventions (Hamish Friedlander)
 * 2012-02-16 [a196135](https://github.com/silverstripe/sapphire/commit/a196135) Replace jQuery.metadata in DateField markup with HTML5 data attributes (Ingo Schommer)
 * 2012-02-16 [5911abc](https://github.com/silverstripe/sapphire/commit/5911abc) Removed prototype.js style $() alias usage for document.getElementById() to avoid confusion with the more common jQuery() alias. API CHANGE Removed several unsed JavaScript globals: sprintf(), Number.prototype.CURRENCIES, Number.prototype.toCurrency(), String.prototype.ucfirst(), jQuery.fn.clearFields(), jQuery.fn.clearInputs() MINOR Removed prototype_improvements.js and jquery_improvements.js files, now contained in individual component code (or removed altogether) (Ingo Schommer)
 * 2012-02-09 [edf6cd6](https://github.com/silverstripe/sapphire/commit/edf6cd6) Remove ArrayData::forTemplate(), because it has little usefulness corrupts ViewableData customisation. (Dominik Beerbohm)
 * 2012-02-03 [b8cc208](https://github.com/silverstripe/sapphire/commit/b8cc208) Deprecated FileIframeField and ImageField, use UploadField instead (Ingo Schommer)
 * 2012-02-02 [9c0a606](https://github.com/silverstripe/sapphire/commit/9c0a606) Deprecated SimpleImageField, use FileField or UploadField with setAllowedExtensions() (Ingo Schommer)
 * 2012-02-01 [d261f44](https://github.com/silverstripe/sapphire/commit/d261f44) silverstripe_version file now contains the plain version number, rather than an SVN path (Ingo Schommer)
 * 2012-01-31 [6ecf7ff](https://github.com/silverstripe/sapphire/commit/6ecf7ff) Deprecated Text-&gt;EscapeXML(), use DBField-&gt;XML() instead (Ingo Schommer)
 * 2012-01-31 [618d767](https://github.com/silverstripe/sapphire/commit/618d767) Removed XML escaping in DBField-&gt;LowerCase() and UpperCase(), in order to consistently allow SSViewer to deal with casting. Affects subclasses like Text, Varchar and HTMLText. API CHANGE Deprecated StringField-&gt;Lower() and Upper(), use String-&gt;LowerCase() and UpperCase() instead. Moved methods from DBField to StringField. (Ingo Schommer)
 * 2012-01-30 [2d898ca](https://github.com/silverstripe/sapphire/commit/2d898ca) Added GridFieldExporter, a GridField component that adds export functionality, and added it to the security admin. (Sam Minnee)
 * 2012-01-26 [7f09b69](https://github.com/silverstripe/sapphire/commit/7f09b69) DataList::subtract and DataQuery::subtract for subtracting a list from another list (Stig Lindqvist)
 * 2012-01-25 [c396c2d](https://github.com/silverstripe/sapphire/commit/c396c2d) Security admin supports adding, removing and searching for members by relations via gridfield (Stig Lindqvist)
 * 2012-01-24 [ed88952](https://github.com/silverstripe/sapphire/commit/ed88952) Added two predefined GridFieldConfigs and removal of unsused accessors (Stig Lindqvist)
 * 2012-01-14 [9451993](https://github.com/silverstripe/sapphire/commit/9451993) Moved DataObject-&gt;writeWithoutVersion() to Versioned extension BUGFIX Don't create new version on related VirtualPage records in SiteTree-&gt;onAfterWrite() when the write was triggered through writeWithoutVersion(). Use a new $_nextWriteWithoutVersion flag replacing the -1 Version number for this purpose (AIR-97) (Ingo Schommer)
 * 2011-12-22 [876f4c5](https://github.com/silverstripe/sapphire/commit/876f4c5) Modify extensions system to support new config system. Statics are now declared directly on extensions, and there is an add_to_class method extensions can hook into to modify class configuration (Hamish Friedlander)
 * 2011-12-22 [0ab171d](https://github.com/silverstripe/sapphire/commit/0ab171d) Add config property on Object as shortcut to objects own properties (Hamish Friedlander)
 * 2011-12-22 [1b05a33](https://github.com/silverstripe/sapphire/commit/1b05a33) Strip out old static accessors from Object (Hamish Friedlander)

### Features and Enhancements

 * 2012-03-13 [5eef837](https://github.com/silverstripe/sapphire/commit/5eef837) Add count of backlinks to file details (Andrew O'Neil)
 * 2012-03-12 [51ff400](https://github.com/silverstripe/sapphire/commit/51ff400) Allowing ajax responses on CMS form submissions to "break out" of the form element they were triggered through, by looking for existence of ".cms-content" node in response (Ingo Schommer)
 * 2012-03-12 [f63497d](https://github.com/silverstripe/sapphire/commit/f63497d) Extension arguments are now passed through to add_to_class() static function on Extension classes. BUGFIX FulltextSearchable didn't pass through arguments, use now available $args parameter with FulltextSearchable::add_to_class() (Sean Harvey)
 * 2012-03-12 [b8f7f4c](https://github.com/silverstripe/sapphire/commit/b8f7f4c) SSF-25 - removed find button when linking existing user - also made SCSS less specific so that it adds styling for the link existing button across the CMS. (jbridson)
 * 2012-03-09 [dd517c4](https://github.com/silverstripe/sapphire/commit/dd517c4) Allowing to override importer instances in ModelAdmin (fixes #2982) (Ingo Schommer)
 * 2012-03-09 [dff6c63](https://github.com/silverstripe/sapphire/commit/dff6c63) Enable config manifest loading in core (Hamish Friedlander)
 * 2012-03-09 [7125cd4](https://github.com/silverstripe/sapphire/commit/7125cd4) Piston in symfony yaml library (Hamish Friedlander)
 * 2012-03-09 [1f7263e](https://github.com/silverstripe/sapphire/commit/1f7263e) Updated default many-many grid field to show "add existing" and "add new" side by side. (Sam Minnee)
 * 2012-03-09 [426f167](https://github.com/silverstripe/sapphire/commit/426f167) GridFieldComponents will now use SS_Filterable, SS_Sortable, and SS_Limitable to determine which features are applicable to the List provided, and either throw an error, or silently disable the feature. API CHANGE: Added throwExceptionOnBadDataType() to GridFilterFilter, GridFieldPaginator, and GridFieldSortableHeader. (Sam Minnee)
 * 2012-03-09 [49267db](https://github.com/silverstripe/sapphire/commit/49267db) Shortcodes now support commas as delimiter for attributes (thanks aoneil for help with the regex!) (trac #6868) BUGFIX HtmlEditorField not inserting shortcodes correctly (trac #6868) (Sean Harvey)
 * 2012-03-08 [2ea7c8d](https://github.com/silverstripe/sapphire/commit/2ea7c8d) SSF-25 : remove GridField filter component for search result in ModelAdmin (Normann Lou)
 * 2012-03-08 [d35d750](https://github.com/silverstripe/sapphire/commit/d35d750) SSF-25 : enable to remove component from a GridFieldConfig. (Normann Lou)
 * 2012-03-08 [d24c2ef](https://github.com/silverstripe/sapphire/commit/d24c2ef) SSF-25 : change to use GridField for showing searched results in stead of TableListField (Normann Lou)
 * 2012-03-08 [649d84a](https://github.com/silverstripe/sapphire/commit/649d84a) SSF-106 - styled the input for pagination and changed measurements to increments of $gf_grid_x and $gf_grid_y (jbridson)
 * 2012-03-08 [bd85d03](https://github.com/silverstripe/sapphire/commit/bd85d03) SSF-53 - hid the find button from the link existing member field on users groups. (jbridson)
 * 2012-03-08 [7673369](https://github.com/silverstripe/sapphire/commit/7673369) SSF-25 : use a title if users/devs has set one instead using a hard-coded one (Normann Lou)
 * 2012-03-08 [fd828fc](https://github.com/silverstripe/sapphire/commit/fd828fc) SSF-53 : change the icon class for "Link Existing" button to 'chain--plus' (Normann Lou)
 * 2012-03-08 [4ad7e8e](https://github.com/silverstripe/sapphire/commit/4ad7e8e) Input box for going to a page in gridfield (Andrew O'Neil)
 * 2012-03-08 [6b910ca](https://github.com/silverstripe/sapphire/commit/6b910ca) Disable batch action selection unless we're in multiselect mode (no way to single select in tree), updating chosen.js and jquery.button state properly (Ingo Schommer)
 * 2012-03-08 [c5a4279](https://github.com/silverstripe/sapphire/commit/c5a4279) SSF-53 - styled the label for the parent group input field on the users groups page. (jbridson)
 * 2012-03-08 [7331a06](https://github.com/silverstripe/sapphire/commit/7331a06) SSF-53 : add gridfield-button-unlink to unlink button that removes a member from a group (Normann Lou)
 * 2012-03-08 [1de30d5](https://github.com/silverstripe/sapphire/commit/1de30d5) SSF-53 : remove literal field for explanation text of Parent dropdown, use a right title for it, instead (Normann Lou)
 * 2012-03-07 [69a8659](https://github.com/silverstripe/sapphire/commit/69a8659) Using 'autoresize' TinyMCE plugin in HTMLEditorField default config, in order to save space when no content is entered into the field (Ingo Schommer)
 * 2012-03-07 [1facb50](https://github.com/silverstripe/sapphire/commit/1facb50) SSF-53 : Change the Labels for "Save" and "Delete" button for an "adding new form" of GridField to "Create" and "Cancel", apply different logic for Cancel (Normann Lou)
 * 2012-03-07 [550cb7d](https://github.com/silverstripe/sapphire/commit/550cb7d) SSF-30 adding the ability to set the parent folder of a file. (Julian Seidenberg)
 * 2012-03-07 [e5ee4c9](https://github.com/silverstripe/sapphire/commit/e5ee4c9) SSF-106 - styled first and last page buttons on datagrid pagination. (jbridson)
 * 2012-03-07 [c0e1500](https://github.com/silverstripe/sapphire/commit/c0e1500) SSF-30 - changed the SCSS so that the styling on the view tabs is more specific to pages and files. (jbridson)
 * 2012-03-07 [d28e32a](https://github.com/silverstripe/sapphire/commit/d28e32a) SSF-30 - moved some code so that the css doesn't override the negative text indent on the view tabs. (jbridson)
 * 2012-03-06 [79d420f](https://github.com/silverstripe/sapphire/commit/79d420f) Member-&gt;DirectGroups() (to complement Group-&gt;DirectMembers(), and aid with relationship saving through Member-&gt;getCMSFields()) (Ingo Schommer)
 * 2012-03-06 [4e9a4bd](https://github.com/silverstripe/sapphire/commit/4e9a4bd) Changed batch action logic, no longer updates applicable pages on batch action drop down selection, as this selection triggers the action itself. To be replaced with a more powerful dialog system in case the action is disallowed on some nodes (Ingo Schommer)
 * 2012-03-06 [ea4bbe5](https://github.com/silverstripe/sapphire/commit/ea4bbe5) Allowing individual parent selection in tree, rather than auto-selecting children (precondition for applying batch actions independently) (Ingo Schommer)
 * 2012-03-06 [51bae9e](https://github.com/silverstripe/sapphire/commit/51bae9e) Allowing to save ManyManyList with multiple foreign keys (e.g. required to add to an overloaded Group-&gt;Members() relationship) (Ingo Schommer)
 * 2012-03-06 [bd1f652](https://github.com/silverstripe/sapphire/commit/bd1f652) Improved focus handling in GridField (Ingo Schommer)
 * 2012-03-06 [ee37adb](https://github.com/silverstripe/sapphire/commit/ee37adb) SSF-33 Binding the 'cms-link-ajax' class to a javascript function that triggers a CMS ajax method and displays a status message (Julian Seidenberg)
 * 2012-03-06 [597b12e](https://github.com/silverstripe/sapphire/commit/597b12e) SSF-53 - Styled the pagination and icons on export to CSV button on User datagrid. (jbridson)
 * 2012-03-06 [ebf23ab](https://github.com/silverstripe/sapphire/commit/ebf23ab) SSF-33 always selecting the first tab (list view) when doing a search (Julian Seidenberg)
 * 2012-03-06 [e0bd5d1](https://github.com/silverstripe/sapphire/commit/e0bd5d1) SSF-106 adding a "no items found" message when returning an empty grid field (Julian Seidenberg)
 * 2012-03-06 [2552bae](https://github.com/silverstripe/sapphire/commit/2552bae) SSF-53 : add a 'filtered' class to filter button and reset button if its input field has filtering value (Normann Lou)
 * 2012-03-06 [a715785](https://github.com/silverstripe/sapphire/commit/a715785) SSF-106 adding the ability to turn off and on the "add new" button on the GridFieldTitle (Julian Seidenberg)
 * 2012-03-05 [6f71186](https://github.com/silverstripe/sapphire/commit/6f71186) Replaced SecurityAdmin tree view for groups with three top-level tabs: "Users", "Groups" and "Roles" (Ingo Schommer)
 * 2012-03-05 [40abab8](https://github.com/silverstripe/sapphire/commit/40abab8) GridFieldPopupForms-&gt;setValidator() (Ingo Schommer)
 * 2012-03-05 [ad5cf1e](https://github.com/silverstripe/sapphire/commit/ad5cf1e) Using ListboxField/chosen.js to assign roles in Group-&gt;getCMSFields(). Improved explanation of groups in the user interface. (Ingo Schommer)
 * 2012-03-05 [e9a2de3](https://github.com/silverstripe/sapphire/commit/e9a2de3) Using GridField to edit roles in SecurityAdmin (Ingo Schommer)
 * 2012-03-05 [5d565dc](https://github.com/silverstripe/sapphire/commit/5d565dc) Added ListboxField-&gt;setDisabledItems() and setDefaultItems() (similar to CheckboxSetField API) (Ingo Schommer)
 * 2012-03-05 [10a85f4](https://github.com/silverstripe/sapphire/commit/10a85f4) Scaffolding GridFieldRelationAdd-&gt;searchFields if required, making constructor argument optional (Ingo Schommer)
 * 2012-03-05 [0762be9](https://github.com/silverstripe/sapphire/commit/0762be9) Renamed GridFieldConfig_ManyManyEditor to GridFieldConfig_RelationEditor, to be more in line with underlying component naming, and more accurate (as it allows editing has_many relations as well). Removed $fieldToSearch argument from its constructor to keep config API consistent, should use getComponentByType() for configuration. Added GridFieldConfig_RecordEditor (Ingo Schommer)
 * 2012-03-05 [375ad46](https://github.com/silverstripe/sapphire/commit/375ad46) GridFieldPaginatior-&gt;itemsPerPage accessors (Ingo Schommer)
 * 2012-03-05 [6e3ceef](https://github.com/silverstripe/sapphire/commit/6e3ceef) Relationship saving in ListboxField (preparing for chosen.js usage), escaping commas in payload when serialising multiple values into a single field (Ingo Schommer)
 * 2012-03-05 [7a97b52](https://github.com/silverstripe/sapphire/commit/7a97b52) SSF-53 : add customised icon class for relational 'Export to CSV' button. (Normann Lou)
 * 2012-03-05 [d26e68c](https://github.com/silverstripe/sapphire/commit/d26e68c) SSF-53 : add customised icon class for relational 'Find' button and 'Link Existing' button (Normann Lou)
 * 2012-03-05 [79d52a2](https://github.com/silverstripe/sapphire/commit/79d52a2) SSF-53: put a unlink button in the "Actions" column rather than holding a separate column for easy styling (Normann Lou)
 * 2012-03-02 [4662872](https://github.com/silverstripe/sapphire/commit/4662872) Using chosen.js for group selection in Member-&gt;getCMSFields() (Ingo Schommer)
 * 2012-03-02 [8fa2664](https://github.com/silverstripe/sapphire/commit/8fa2664) Support numeric array values in CheckboxSetField (?Field[]=val1&Field[]=val2 instead of ?Field[val1]=1&Field[val2]=1) (Ingo Schommer)
 * 2012-03-02 [98e1fed](https://github.com/silverstripe/sapphire/commit/98e1fed) File::$app_categories to replace switch statement in File-&gt;appCategory(), and expose data to other use cases (such as filter drop downs in AssetAdmin) (Ingo Schommer)
 * 2012-03-02 [e5c4b0a](https://github.com/silverstripe/sapphire/commit/e5c4b0a) Hierarchy-&gt;Breadcrumbs() (Ingo Schommer)
 * 2012-03-02 [9f5e26d](https://github.com/silverstripe/sapphire/commit/9f5e26d) Generic search form uses loadPanel() rather than being tied to GridField (requires backend changes, see AssetAdmin), and uses jquery.form to do resets (Ingo Schommer)
 * 2012-03-02 [1175c69](https://github.com/silverstripe/sapphire/commit/1175c69) SSF-53 : add ability to use translated button label for 'Add New' and 'Link Existing' (Normann Lou)
 * 2012-03-02 [45927b9](https://github.com/silverstripe/sapphire/commit/45927b9) SSF-53: add customised class to Member's GridField in SecurityAdmin (Normann Lou)
 * 2012-03-02 [5548c66](https://github.com/silverstripe/sapphire/commit/5548c66) SSF-53 reordering the components that added to group GridField in CMS so that it appears same as the landing view of SecurityAdmin (Normann Lou)
 * 2012-03-02 [58ffbe8](https://github.com/silverstripe/sapphire/commit/58ffbe8) SSF-106 - added padding to non-sortable &lt;th&gt; on gridfield (jbridson)
 * 2012-03-01 [04698ac](https://github.com/silverstripe/sapphire/commit/04698ac) GridFieldRelationAdd-&gt;placeholderText (SSF-53) (Ingo Schommer)
 * 2012-03-01 [a2afe4e](https://github.com/silverstripe/sapphire/commit/a2afe4e) Support multiple search fields in GridFieldRelationAdd, and allowing custom result formatting (SSF-53) (Ingo Schommer)
 * 2012-03-01 [c3f4db1](https://github.com/silverstripe/sapphire/commit/c3f4db1) Using new UploadField in ForeignKey scaffolding, replacing deprecated ImageField/FileField classes (Ingo Schommer)
 * 2012-03-01 [f5c4bc0](https://github.com/silverstripe/sapphire/commit/f5c4bc0) Ensure that broken File links receive an "ss-broken" class, just like broken SiteTree links (Sean Harvey)
 * 2012-03-01 [898c8f5](https://github.com/silverstripe/sapphire/commit/898c8f5) [file_link id=n] shortcode support for file links in HtmlEditorField (Sean Harvey)
 * 2012-03-01 [50119d2](https://github.com/silverstripe/sapphire/commit/50119d2) SSF-106 - added styling for the filter and reset buttons (jbridson)
 * 2012-02-29 [c0f65bf](https://github.com/silverstripe/sapphire/commit/c0f65bf) SSF-106 - changed the edit and delete buttons to match the icons on the design (jbridson)
 * 2012-02-29 [e932be3](https://github.com/silverstripe/sapphire/commit/e932be3) SSF-30 - partially finish - fixed broken layout on edit files 404error.html (jbridson)
 * 2012-02-28 [804e2da](https://github.com/silverstripe/sapphire/commit/804e2da) Breadcrumbs support in GridFieldPopupForms (CMS only) (Ingo Schommer)
 * 2012-02-27 [3936909](https://github.com/silverstripe/sapphire/commit/3936909) working delete button (Julian Seidenberg)
 * 2012-02-24 [58d4858](https://github.com/silverstripe/sapphire/commit/58d4858) Date::DayOfMonth() now supports ordinal argument, so you can get somehing like "10th" or "2nd". Also supported in Date::RangeString (Sean Harvey)
 * 2012-02-24 [550f754](https://github.com/silverstripe/sapphire/commit/550f754) File and Image CMSFields styling (Julian Seidenberg)
 * 2012-02-23 [7a755da](https://github.com/silverstripe/sapphire/commit/7a755da) Trigger event when new or edit link is clicked (Andrew O'Neil)
 * 2012-02-22 [1ebd83d](https://github.com/silverstripe/sapphire/commit/1ebd83d) styled the header of the datagrid (SSF-106) (Felipe Skroski)
 * 2012-02-21 [9df1487](https://github.com/silverstripe/sapphire/commit/9df1487) Allow to batch-add components via GridFieldConfig-&gt;addComponents() (Ingo Schommer)
 * 2012-02-21 [abedf2a](https://github.com/silverstripe/sapphire/commit/abedf2a) Confirming deletion of records in GridField via JavaScript alert (Ingo Schommer)
 * 2012-02-20 [0acaf39](https://github.com/silverstripe/sapphire/commit/0acaf39) "Add" for gridfield (Andrew O'Neil)
 * 2012-02-17 [7602d08](https://github.com/silverstripe/sapphire/commit/7602d08) Fluent interface in Form API by returning instance from all setters (Ingo Schommer)
 * 2012-02-17 [abfa16f](https://github.com/silverstripe/sapphire/commit/abfa16f) Using native jQuery UI buttons and icon styling for a less coupled implementation (e.g. assuming that a "constructive" button always has a specific icon, or one at all). All CMS UI buttons switched to use &lt;button&gt; markup, which allows for inline icons and correctly aligned multi-line button labels. (Ingo Schommer)
 * 2012-02-16 [9190bc4](https://github.com/silverstripe/sapphire/commit/9190bc4) Support for &lt;legend&gt; tags in CompositeField (Ingo Schommer)
 * 2012-02-16 [b417daf](https://github.com/silverstripe/sapphire/commit/b417daf) Custom tags for CompositeField, which allows for nesting &lt;fieldset&gt; elements (not possible through the toplevel-only FieldList/FieldSet class) (Ingo Schommer)
 * 2012-02-15 [f2717f0](https://github.com/silverstripe/sapphire/commit/f2717f0) GridField-based file listing (Ingo Schommer)
 * 2012-02-15 [a1e9c0f](https://github.com/silverstripe/sapphire/commit/a1e9c0f) CMS panels restructured to use two new types of "tools" templates, fetched through LeftAndMain-&gt;Tools() and LeftAndMain-&gt;EditFormTools(). Requires less overloading of template markup. (Ingo Schommer)
 * 2012-02-14 [37dfbb6](https://github.com/silverstripe/sapphire/commit/37dfbb6) LeftAndMain-&gt;Breadcrumbs() (Ingo Schommer)
 * 2012-02-11 [91f4ba1](https://github.com/silverstripe/sapphire/commit/91f4ba1) supporting "current scope" loop and with: (with Children) (loop) $Title (end_loop) (end_with) (Hamish Friedlander)
 * 2012-02-11 [741f104](https://github.com/silverstripe/sapphire/commit/741f104) Allow setting of constant CUSTOM_INCLUDE_PATH in _ss_enivronment.php which is prepended to the include path (Simon Welsh)
 * 2012-02-11 [649f4ce](https://github.com/silverstripe/sapphire/commit/649f4ce) allow left column on LeftAndMain::getEditForm (Will Rossiter)
 * 2012-02-09 [5220a46](https://github.com/silverstripe/sapphire/commit/5220a46) Inserting image via new dialog with ajax field retrieval and GridField file selection. Rewritten to jQuery.entwine and using the new HTML editor abstraction layer. (Ingo Schommer)
 * 2012-02-09 [38bce79](https://github.com/silverstripe/sapphire/commit/38bce79) Add title component (Andrew O'Neil)
 * 2012-02-08 [3866f56](https://github.com/silverstripe/sapphire/commit/3866f56) Using GridField for file selection in "insert image" dialog API CHANGE Combined HTMLEditorField_Toolbar-&gt;FlashForm() and ImageForm() into new MediaForm() to handle both file types (Ingo Schommer)
 * 2012-02-08 [55ddbd3](https://github.com/silverstripe/sapphire/commit/55ddbd3) Replaced custom profile dialog JS with generic ssui-core.js functionality. Removed cookie state saving abilities for now, not a high priority to re-implement) (Ingo Schommer)
 * 2012-02-08 [c00f040](https://github.com/silverstripe/sapphire/commit/c00f040) Attaching files from /assets through UploadField (Ingo Schommer)
 * 2012-02-08 [df716ef](https://github.com/silverstripe/sapphire/commit/df716ef) Allow multiple column providers for a single column (Andrew O'Neil)
 * 2012-02-07 [4126b95](https://github.com/silverstripe/sapphire/commit/4126b95) Allow selection of items in GridField (via JavaScript only) (Ingo Schommer)
 * 2012-02-06 [24e2003](https://github.com/silverstripe/sapphire/commit/24e2003) Allow logging of extra data in SS_Log::log() (currently only displayed through SS_LogEmailWriter) (Ingo Schommer)
 * 2012-02-03 [c0d1870](https://github.com/silverstripe/sapphire/commit/c0d1870) New UploadField class to replace FileIframeField, ImageField and SimpleImageField (Ingo Schommer)
 * 2012-02-03 [041da99](https://github.com/silverstripe/sapphire/commit/041da99) Added generic 'small' form style (Ingo Schommer)
 * 2012-02-03 [2648411](https://github.com/silverstripe/sapphire/commit/2648411) Ensure that forceSSL and protocol detection respects the X-Forwarded-Protocol header. (Sam Minnee)
 * 2012-02-01 [a67c6ce](https://github.com/silverstripe/sapphire/commit/a67c6ce) Added section on security ratings, moved security process description from 'contributing' to 'release process' section (Philipp Krenn)
 * 2012-01-30 [5fe86be](https://github.com/silverstripe/sapphire/commit/5fe86be) Added GridFieldConfig-&gt;getComponentsByType() and getComponentByType() (Ingo Schommer)
 * 2012-01-23 [0444d4e](https://github.com/silverstripe/sapphire/commit/0444d4e) Buttonsets for CMS (fixes #6631), using new jQuery UI button() to style buttons in CMS, moved JavaScript to LeftAndMain.js as the button styles only apply with an .Actions container now (Wolf Vollprecht)
 * 2012-01-10 [b260c63](https://github.com/silverstripe/sapphire/commit/b260c63) Use Folder's Form Tabs to provide the top 3 tabs in the CMS. (Sam Minnee)
 * 2011-12-22 [d355cd5](https://github.com/silverstripe/sapphire/commit/d355cd5) Add config layer - the Config access class itself, and the ConfigManfiest builder which parses in the yaml config files (Hamish Friedlander)
 * 2011-12-14 [30989b5](https://github.com/silverstripe/sapphire/commit/30989b5) Added path manipulation lib from jQuery.mobile, using it to ensure all URLs are made absolute (to fix IE issues) (Ingo Schommer)
 * 2011-08-23 [d3be6ed](https://github.com/silverstripe/sapphire/commit/d3be6ed) Allowing string arguments in SS_Log::log() (Ingo Schommer)

### Bugfixes

 * 2012-03-13 [7ff2732](https://github.com/silverstripe/sapphire/commit/7ff2732) fixed issues with overflow on model and security admin - made changes more specific. (jbridson)
 * 2012-03-13 [3d26cb7](https://github.com/silverstripe/sapphire/commit/3d26cb7) SSF-106 - fixed uneven column widths and overflow issues with datagrid in ie7. (jbridson)
 * 2012-03-13 [2f7fa90](https://github.com/silverstripe/sapphire/commit/2f7fa90) BASE_PATH was trimming trailing whitespace in paths rather than trailing DIRECTORY_SEPARATORs. (Simon Welsh)
 * 2012-03-12 [95f1800](https://github.com/silverstripe/sapphire/commit/95f1800) Resolve local images correctly even with absolute URLs in HTMLEditorConfig_Toolbar, fixed display of remote images (don't try to format the thumbnail, which only works on local images) (fixes #6952) (Ingo Schommer)
 * 2012-03-12 [bac23bc](https://github.com/silverstripe/sapphire/commit/bac23bc) Correctly set $BaseCSSClasses on LeftAndMain content container templates, not only on forms. Fixes $('.cms-menu') handling of "current id" updates (fixes #6997) (Ingo Schommer)
 * 2012-03-12 [a73c8bc](https://github.com/silverstripe/sapphire/commit/a73c8bc) SSF-53 : apply a patch with fix chosen.js messed the width up if the select element is single select and having initial width as percentage (Normann Lou)
 * 2012-03-12 [199dd64](https://github.com/silverstripe/sapphire/commit/199dd64) Fix errors submitting a credit card field (Andrew O'Neil)
 * 2012-03-12 [7ece1d3](https://github.com/silverstripe/sapphire/commit/7ece1d3) fixed buttons in ie7/ie8 added missing background colour. (jbridson)
 * 2012-03-12 [b057315](https://github.com/silverstripe/sapphire/commit/b057315) SSF-25 - fixed styling of model admin filter in ie7 and ie8 (jbridson)
 * 2012-03-12 [00d8188](https://github.com/silverstripe/sapphire/commit/00d8188) SSF-106 - fixed scss for export to csv button so that is more general to all datagrid (jbridson)
 * 2012-03-11 [ab976a9](https://github.com/silverstripe/sapphire/commit/ab976a9) , API CHANGE: Enable setting the DB timezone from the environment. (Fred Condo)
 * 2012-03-10 [d94048c](https://github.com/silverstripe/sapphire/commit/d94048c) Fixed back redirectBack() call in GroupImportForm::doImport (#6969) (Sam Minnee)
 * 2012-03-09 [df050ed](https://github.com/silverstripe/sapphire/commit/df050ed) Correct testSetNullAndZeroValues() of DatetimeTest (Fred Condo)
 * 2012-03-09 [5944484](https://github.com/silverstripe/sapphire/commit/5944484) Don't try to set the title if it hasn't been set for us. (Fred Condo)
 * 2012-03-09 [4b8895c](https://github.com/silverstripe/sapphire/commit/4b8895c) Don't scaffold has_one relations into a DropdownField in ForeignKey-&gt;scaffoldFormField() if more than 100 records would be created, to avoid exceeding PHP memory (fixes #6776) (Ingo Schommer)
 * 2012-03-09 [d04fe07](https://github.com/silverstripe/sapphire/commit/d04fe07) Renamed UploadField::$config to UploadField::$ufConfig to avoid conflicts with the config API. (Sam Minnee)
 * 2012-03-09 [1535ce6](https://github.com/silverstripe/sapphire/commit/1535ce6) Removed used of lcfirst, as it's PHP 5.3 only (Sam Minnee)
 * 2012-03-09 [a34f7cc](https://github.com/silverstripe/sapphire/commit/a34f7cc) Fixed SearchContext::getQuery() to avoid use of deprecated limit() call signature. (Sam Minnee)
 * 2012-03-09 [68d83d1](https://github.com/silverstripe/sapphire/commit/68d83d1) PHP 5.2 doesn't allow calling a static method like $className::$staticMethod() (Stig Lindqvist)
 * 2012-03-09 [d28da56](https://github.com/silverstripe/sapphire/commit/d28da56) Fixed regression where Member::PasswordEncryption field wouldn't be set to the default (Sean Harvey)
 * 2012-03-09 [6d380cd](https://github.com/silverstripe/sapphire/commit/6d380cd) GridFieldPaginator did not work correctly after SS_Limitable was introduced (Stig Lindqvist)
 * 2012-03-09 [9738641](https://github.com/silverstripe/sapphire/commit/9738641) SSF-106 - removed border that appeared after click in ie7 and ie8 (jbridson)
 * 2012-03-09 [5ff095e](https://github.com/silverstripe/sapphire/commit/5ff095e) RequestHandler needs some tricks to make sure it knows when allowed_actions hasnt been provided on a class when it has been provided on an extension, now that statics from extensions isnt a feature specific hack (Hamish Friedlander)
 * 2012-03-09 [bc3f5ac](https://github.com/silverstripe/sapphire/commit/bc3f5ac) DataObjectTest needs its extensions to use the new static-on-object method to keep the ordering as it expects (Hamish Friedlander)
 * 2012-03-09 [c6d7301](https://github.com/silverstripe/sapphire/commit/c6d7301) Change to a page url segment doesn't get saved properly caused by 'disabled' attribute on the field, which is added by url segment suggestion function (ticket #6842) (Saophalkun Ponlu)
 * 2012-03-09 [4bea594](https://github.com/silverstripe/sapphire/commit/4bea594) SSF-106 fixed overlapping edit and delete button on datagrid in ie7. (jbridson)
 * 2012-03-09 [18adfb0](https://github.com/silverstripe/sapphire/commit/18adfb0) SSF-53 : avoid to use ":submit" pseudo class in a jQuery selector (Normann Lou)
 * 2012-03-09 [2644cbb](https://github.com/silverstripe/sapphire/commit/2644cbb) Remove use of encryptPasswords; use PasswordEncryptor_None instead (Sean Harvey)
 * 2012-03-09 [f048b7e](https://github.com/silverstripe/sapphire/commit/f048b7e) Support for gradients in editor in IE9 (Naomi Guyer)
 * 2012-03-08 [595a6dc](https://github.com/silverstripe/sapphire/commit/595a6dc) #6817: FieldList.php: findOrMakeTab () fails for nested TabSets (Fred Condo)
 * 2012-03-09 [627708e](https://github.com/silverstripe/sapphire/commit/627708e) add Director::isDev parameter so we can test if we know we're dev mode already without touching the database. Used in showqueries on MySQL, so that errors are avoided when showing queries on initial switch to dev move (#6856) (Mark Stephens)
 * 2012-03-09 [050afdd](https://github.com/silverstripe/sapphire/commit/050afdd) Make Inputs in Input-Selects take up the whole select box (#6934) (Naomi Guyer)
 * 2012-03-09 [b7f5f91](https://github.com/silverstripe/sapphire/commit/b7f5f91) Open new window for "Help" in CMS nav (Naomi Guyer)
 * 2012-03-09 [64db811](https://github.com/silverstripe/sapphire/commit/64db811) Convert pages from DataList to ArrayList in CMSBatchActionHandler to avoid problems on merge() (Ingo Schommer)
 * 2012-03-09 [63d5927](https://github.com/silverstripe/sapphire/commit/63d5927) Added TemplateGlobalProvider include to installer, as required by i18n. (Ryan O'Hara)
 * 2012-03-09 [ed0e06c](https://github.com/silverstripe/sapphire/commit/ed0e06c) Fix a couple of rebasing-related bugs in GridField. (Sam Minnee)
 * 2012-03-08 [f9323b3](https://github.com/silverstripe/sapphire/commit/f9323b3) Type-safe checks for Controller::join_links(), allowing arguments with a value of "0" (Ingo Schommer)
 * 2012-03-08 [5e92c69](https://github.com/silverstripe/sapphire/commit/5e92c69) SSF-25 : remove CreateForm, using the GridField 'Add New" action, instead (Normann Lou)
 * 2012-03-08 [c80e86f](https://github.com/silverstripe/sapphire/commit/c80e86f) Fix GridField::Field() (Sam Minnee)
 * 2012-03-08 [292bd79](https://github.com/silverstripe/sapphire/commit/292bd79) SSF-53 - fixed filter and reset buttons in ie7 and ie8 plus fixed an array of other ie7/8 styling bugs (jbridson)
 * 2012-03-08 [de69d09](https://github.com/silverstripe/sapphire/commit/de69d09) SSF-25 : $Form is not defined in the context, sine {$Form.Name} always give 'Form' string, we need just have 'Form' string there instead to use {$Form.Name} (Normann Lou)
 * 2012-03-08 [c3a2938](https://github.com/silverstripe/sapphire/commit/c3a2938) SSF-53 - removed hover and active states from unlink button on users groups datagrid (jbridson)
 * 2012-03-08 [4d39813](https://github.com/silverstripe/sapphire/commit/4d39813) SSF-30 - moved tabs SCSS from _style.scss to AssetAdmin.scss (jbridson)
 * 2012-03-07 [5d4d0db](https://github.com/silverstripe/sapphire/commit/5d4d0db) SSF-53 - fixed floating filter and reset buttons on filter under users - roles - no card for this, just came across it. (jbridson)
 * 2012-03-07 [febcff7](https://github.com/silverstripe/sapphire/commit/febcff7) SSF-30 redirect action that sends an edit form back to the root of assets after making a change like changing the parentID of a file, or deleting it. Basically, any action that makes the existing URL reference obsolete. (Julian Seidenberg)
 * 2012-03-07 [676bcbe](https://github.com/silverstripe/sapphire/commit/676bcbe) SSF-30 adding check for null record in the GridFieldPopupForms request handler (Julian Seidenberg)
 * 2012-03-07 [38db2c1](https://github.com/silverstripe/sapphire/commit/38db2c1) Fix state of gridfield pagination (Andrew O'Neil)
 * 2012-03-07 [a284853](https://github.com/silverstripe/sapphire/commit/a284853) Fix pagination when there are no records (Andrew O'Neil)
 * 2012-03-07 [2106aeb](https://github.com/silverstripe/sapphire/commit/2106aeb) SSF-30 - removed weird hover from delete button. (jbridson)
 * 2012-03-07 [829c768](https://github.com/silverstripe/sapphire/commit/829c768) Support for multilevel nested GridFieldPopupForm (in CMS only), fixed breadcrumb linkage (Ingo Schommer)
 * 2012-03-06 [b43bdf3](https://github.com/silverstripe/sapphire/commit/b43bdf3) Allowing to save ListboxField and CheckboxSetField into custom relations (which don't return TRUE for has_many() or many_many()) (Ingo Schommer)
 * 2012-03-06 [f396802](https://github.com/silverstripe/sapphire/commit/f396802) Fixed $('.cms-tree').getNodeByID(), was always returning tree instance instead of node because 'get_node' isn't a public method, hence ignored (Ingo Schommer)
 * 2012-03-06 [723a848](https://github.com/silverstripe/sapphire/commit/723a848) Fixed Group-&gt;Members() overloaded relation getter to avoid filtering on zero-value foreign keys, producing empty rather than inherited results (important for the GridField used in Group-&gt;getCMSFields()) (Ingo Schommer)
 * 2012-03-06 [dc83ace](https://github.com/silverstripe/sapphire/commit/dc83ace) Fixed CSV exporting on GridFieldExporter (was calling action via ajax, which doesn't allow HTTP download responses) (Ingo Schommer)
 * 2012-03-06 [1201f6c](https://github.com/silverstripe/sapphire/commit/1201f6c) Saving records in ListboxField-&gt;saveInto() and PermissionCheckboxSetField-&gt;saveInto() so we have a database ID to relate to (was previously customised in MemberTableField-&gt;saveComplexTableField(), which is now deprecated) (Ingo Schommer)
 * 2012-03-05 [bb6d4c5](https://github.com/silverstripe/sapphire/commit/bb6d4c5) Fixed HasManyList and ManyManyList queries for relationships on new records (was returning all available records due to the SQL filtering ignoring ID=0) (Ingo Schommer)
 * 2012-03-06 [763e644](https://github.com/silverstripe/sapphire/commit/763e644) Dont need (and cant call) iteratorProperties calls as workaround any more (Hamish Friedlander)
 * 2012-03-05 [2abb021](https://github.com/silverstripe/sapphire/commit/2abb021) Restored old permission code model, broken due to new controller structure. Introduced LeftAndMain::$required_permission_codes as a way to control permissions independently of subclasses, and "cluster" multiple classes under a single code. (Ingo Schommer)
 * 2012-03-05 [a5e809b](https://github.com/silverstripe/sapphire/commit/a5e809b) Fixed dev/tests/startsession form action (Sam Minnee)
 * 2012-03-04 [e8f9624](https://github.com/silverstripe/sapphire/commit/e8f9624) Moved window.beforeunload handler out of onmatch(), was applied multiple times and causing unsaved changes confirmation messages on forms which were no longer loaded (Ingo Schommer)
 * 2012-03-03 [8de7b74](https://github.com/silverstripe/sapphire/commit/8de7b74) TinyMCE cache shouldn't be shared between projects. Add SCRIPT_NAME when generating a hash for the cache filename (Sean Harvey)
 * 2012-03-02 [b242bfb](https://github.com/silverstripe/sapphire/commit/b242bfb) Include GET parameters of current URL in GridField on ajax reloads to retain view state (Ingo Schommer)
 * 2012-03-02 [02e728f](https://github.com/silverstripe/sapphire/commit/02e728f) Fixed visibility of admin/myprofile for non-admins by moving it to a new CMSProfileController class and overloaded canView() (Ingo Schommer)
 * 2012-03-02 [b58b281](https://github.com/silverstripe/sapphire/commit/b58b281) SSF-53 : remove the disabled status of 'add button' in according with its sitting environment, ie. does it initialed by jQuery UI. If not, simply remove its 'disabled' attribute (Normann Lou)
 * 2012-03-02 [de75798](https://github.com/silverstripe/sapphire/commit/de75798) SSF-53 Pass through the parameter $itemsPerPage instead of reassign the default value (15) (Normann Lou)
 * 2012-03-01 [e086875](https://github.com/silverstripe/sapphire/commit/e086875) SSF-53 make adding existing member works by enabling the add button correctly (Normann Lou)
 * 2012-03-01 [2dfb414](https://github.com/silverstripe/sapphire/commit/2dfb414) SSF-53: fixed that raw html source appears for "Export to CSV" button(SSF-243) (Normann Lou)
 * 2012-02-29 [e61a786](https://github.com/silverstripe/sapphire/commit/e61a786) changed the colour of the font on the default tabs to match the designs (jbridson)
 * 2012-02-29 [e4496fe](https://github.com/silverstripe/sapphire/commit/e4496fe) SSF-106 added fix for no delete icons in ie7 (jbridson)
 * 2012-02-29 [59df00d](https://github.com/silverstripe/sapphire/commit/59df00d) fixed position of back button in the cms-content-header - adapted design to work around the inclusion of tabs. (jbridson)
 * 2012-02-28 [f67cca3](https://github.com/silverstripe/sapphire/commit/f67cca3) Using RequestHandler-&gt;urlParams rather than HTTPRequest-&gt;param() in LeftandMain-&gt;currentPageId() in order to avoid the wrong ID being chosen on nested controllers like GridField with their own "ID" parameters in the URL signature (Ingo Schommer)
 * 2012-02-28 [34d3f29](https://github.com/silverstripe/sapphire/commit/34d3f29) Fixed TabSet.js initialisation with cookies, default to first tab rather than allowing tab deselects through an index of -1 (Ingo Schommer)
 * 2012-02-28 [2457c4f](https://github.com/silverstripe/sapphire/commit/2457c4f) Eescape / in RegExp. (AngryPHPNerd)
 * 2012-02-27 [8c075da](https://github.com/silverstripe/sapphire/commit/8c075da) Fixed 'undefined offset 10' error (AngryPHPNerd)
 * 2012-02-27 [f7030c5](https://github.com/silverstripe/sapphire/commit/f7030c5) Page tree node reflects any changes made to page (title, publication status) in its edit view, implemented on the level of cms-content dom element, rather than cms-edit-form level (Normann Lou)
 * 2012-02-24 [587d195](https://github.com/silverstripe/sapphire/commit/587d195) Page tree node reflects any changes made to page (title, publication status) in its edit view (Normann Lou)
 * 2012-02-24 [8fdc531](https://github.com/silverstripe/sapphire/commit/8fdc531) Ensure Date and Datetime field types actually set NULL, false, empty string values correctly instead of "1970-01-01" which gets saved to the database instead of NULL. BUGFIX Datetime::Nice() and casting methods return NULL when there is no value, to be consistent with Date::Nice() and so on (Sean Harvey)
 * 2012-02-24 [f4a758e](https://github.com/silverstripe/sapphire/commit/f4a758e) DatetimeField allows non-US style dates with an empty time component to be saved correctly (Sean Harvey)
 * 2012-02-23 [0bc6bff](https://github.com/silverstripe/sapphire/commit/0bc6bff) Changed CSS class structure of GridField to avoid duplication of ".ss-gridfield" selector in different contexts, and make selectors less verbose (no more "fieldset.ss-gridfield"). Added "field" class to GridField container to ensure it displays correctly alongside other form fields (mainly around margins and paddings) (Ingo Schommer)
 * 2012-02-23 [df82dac](https://github.com/silverstripe/sapphire/commit/df82dac) Fallback to sapphire/silverstripe_version if there is no CMS (framework only) (Simon Welsh)
 * 2012-02-22 [8790ba3](https://github.com/silverstripe/sapphire/commit/8790ba3) Retain editor focus when insert images, update attributes on existing image to avoid IE bugs through TinyMCE (Ingo Schommer)
 * 2012-02-22 [5f635d8](https://github.com/silverstripe/sapphire/commit/5f635d8) Don't reload TreeDropdownField title via ajax if no value is set (which causes infinite loops) (Ingo Schommer)
 * 2012-02-22 [9efcb9b](https://github.com/silverstripe/sapphire/commit/9efcb9b) fixed "add new" button outside of the datagrid's title bar in firefox(ssf-106) (Felipe Skroski)
 * 2012-02-21 [c5a1d69](https://github.com/silverstripe/sapphire/commit/c5a1d69) AssetAdmin bugs out when trying to find Folders with ID = 0 when in /assets/ (Stig Lindqvist)
 * 2012-02-21 [2c65d3a](https://github.com/silverstripe/sapphire/commit/2c65d3a) Add casting support to global and iterator variable injection (Hamish Friedlander)
 * 2012-02-17 [76ddb3c](https://github.com/silverstripe/sapphire/commit/76ddb3c) fixed various styling issues in cms (raised in SSF-188) (jbridson)
 * 2012-02-17 [e4675d7](https://github.com/silverstripe/sapphire/commit/e4675d7) Restore ability to pass injected variables right into SSViewer_DataPresenter (Hamish Friedlander)
 * 2012-02-17 [156d222](https://github.com/silverstripe/sapphire/commit/156d222) Replaced deprecated DataObjectSet use with ArrayLists in SSViewerTest (Hamish Friedlander)
 * 2012-02-16 [454b89f](https://github.com/silverstripe/sapphire/commit/454b89f) Fixed FormAction.ss template when used with &lt;button&gt; tag (Ingo Schommer)
 * 2012-02-16 [07f4cd4](https://github.com/silverstripe/sapphire/commit/07f4cd4) Fixed undefined method suser_error() in Cookie::set() (Sean Harvey)
 * 2012-02-15 [4f49c45](https://github.com/silverstripe/sapphire/commit/4f49c45) Return zero file size for folders (mainly to avoid listing it in AssetAdmin tables, but also because it doesn't make sense for folders) (Ingo Schommer)
 * 2012-02-15 [5d7aa8f](https://github.com/silverstripe/sapphire/commit/5d7aa8f) Allow PartialMatchFilter to use an array as search term (Stig Lindqvist)
 * 2012-02-15 [5968205](https://github.com/silverstripe/sapphire/commit/5968205) SSViewer method call for GridFieldItemEditView.ss is not closed (Stig Lindqvist)
 * 2012-02-15 [7658e90](https://github.com/silverstripe/sapphire/commit/7658e90) Convert::html2raw() not correctly stripping script and style tags (Simon Welsh)
 * 2012-02-11 [f55c575](https://github.com/silverstripe/sapphire/commit/f55c575) allowing ssviewer to be called without function arguments (Hamish Friedlander)
 * 2012-02-11 [5bf79f8](https://github.com/silverstripe/sapphire/commit/5bf79f8) Removed tinymce-advcode plugin which breaks with new TinyMCE and newer browsers. Both the plugin and the underlying 'codepress' engine are unmaintained. Fall back to standard (non-highlighted) TinyMCE &lt;textarea&gt; editing (fixes #6779) (Ingo Schommer)
 * 2012-02-11 [591dd4e](https://github.com/silverstripe/sapphire/commit/591dd4e) SS_Map::keys() and SS_Map::values() are identical, keys() should return the *keys* not the values #6818 (Sean Harvey)
 * 2012-02-10 [37156b0](https://github.com/silverstripe/sapphire/commit/37156b0) avoid error accessing Tab ID if TabSet has not been set (Will Rossiter)
 * 2012-02-09 [23af606](https://github.com/silverstripe/sapphire/commit/23af606) Fix edit and delete actions on gridfield (Andrew O'Neil)
 * 2012-02-09 [2670501](https://github.com/silverstripe/sapphire/commit/2670501) Fix HasManyList::removeByID() (Andrew O'Neil)
 * 2012-02-09 [a76c9c3](https://github.com/silverstripe/sapphire/commit/a76c9c3) Fix checkFieldsForAction() when working with tabs (Andrew O'Neil)
 * 2012-02-08 [d1a39b0](https://github.com/silverstripe/sapphire/commit/d1a39b0) Fixed operation of the onlyDeletedFromStage parameter of Hierarchy::liveChildren(). (Sam Minnee)
 * 2012-02-07 [e7f9c2c](https://github.com/silverstripe/sapphire/commit/e7f9c2c) border radius on datagrid (Felipe Skroski)
 * 2012-02-07 [f75537b](https://github.com/silverstripe/sapphire/commit/f75537b) border radius on datagrid (Felipe Skroski)
 * 2012-02-02 [deee8a2](https://github.com/silverstripe/sapphire/commit/deee8a2) SSF-107, Filter bar should be collapsed by default, this fix works with fix of cms repo commit eec833215dcaa7a4510f7b4724413a39160d1ad7 (see gist https://gist.github.com/1720221) MINOR: correct in-line document (Normann Lou)
 * 2012-02-01 [15a641a](https://github.com/silverstripe/sapphire/commit/15a641a) Clear requirements after running a unit test (Andrew O'Neil)
 * 2012-01-31 [e1e5546](https://github.com/silverstripe/sapphire/commit/e1e5546) Casting return values on text helper methods in StringField, Text, Varchar (Ingo Schommer)
 * 2012-01-30 [2485095](https://github.com/silverstripe/sapphire/commit/2485095) Fixed bug in sprintf syntax with GroupImportForm iframe (Sam Minnee)
 * 2012-01-30 [0090009](https://github.com/silverstripe/sapphire/commit/0090009) Added default args to GridFieldPopupForms for AssetAdmin which was casing errors BUGFIX: Added GridFieldFilter() to new GridFieldConfig whuch adds filters and fixes the display MINOR: Added gridfield specific margins to form div to push GridField display down-page (due to GF's sort-fields which will be refactored from new designs) (Russell Michell)
 * 2012-01-27 [056e564](https://github.com/silverstripe/sapphire/commit/056e564) Subtract should not add order by on subselect (Stig Lindqvist)
 * 2012-01-24 [9b3af77](https://github.com/silverstripe/sapphire/commit/9b3af77) It is not possible to use more than one autosuggestion field from GridFieldRelationAdd per view (Stig Lindqvist)
 * 2011-12-22 [7c94caa](https://github.com/silverstripe/sapphire/commit/7c94caa) Fix TokenisedRegularExpression when matching expressions first element is an array (Hamish Friedlander)
 * 2011-12-22 [4315e51](https://github.com/silverstripe/sapphire/commit/4315e51) Fix deprecated and removed static accessor calls (Hamish Friedlander)
 * 2011-12-22 [9c2ebc3](https://github.com/silverstripe/sapphire/commit/9c2ebc3) Replace deprecated extraStatics with new methods on Versioned and Hierarchy (Hamish Friedlander)
 * 2011-12-22 [686b020](https://github.com/silverstripe/sapphire/commit/686b020) Cant use combined_static in FileFinder any more - it falls through to Config system, which doesnt yet exist (Hamish Friedlander)

### Minor changes

 * 2012-03-12 [5003b98](https://github.com/silverstripe/sapphire/commit/5003b98) 3.0.0-beta1 changelog (Ingo Schommer)
 * 2012-03-13 [f367db2](https://github.com/silverstripe/sapphire/commit/f367db2) Remove table filter from modeladmin search results (Andrew O'Neil)
 * 2012-03-13 [54507d7](https://github.com/silverstripe/sapphire/commit/54507d7) Fixed coding style in CreditCardField::Field() (Sean Harvey)
 * 2012-03-12 [2c42ffd](https://github.com/silverstripe/sapphire/commit/2c42ffd) Removed ModelAdmin JS which no longer applies due to rewrite (Ingo Schommer)
 * 2012-03-12 [b246522](https://github.com/silverstripe/sapphire/commit/b246522) Various fixes to get TableListField and ComplexTableField baseline operational (although usage of GridField is encouraged) (Ingo Schommer)
 * 2012-03-12 [d46a450](https://github.com/silverstripe/sapphire/commit/d46a450) Fixed scope problems caused by separating out getTreeConfig() (Ingo Schommer)
 * 2012-03-12 [8f8817b](https://github.com/silverstripe/sapphire/commit/8f8817b) Always set X-ControllerURL in CMS responses, in order to fix menu state after Ajax HTTP redirects (e.g. from CMSPageAddController to CMSPageEditController) (Ingo Schommer)
 * 2012-03-12 [e5ade1b](https://github.com/silverstripe/sapphire/commit/e5ade1b) Making tree config overrideable (Ingo Schommer)
 * 2012-03-12 [73efe85](https://github.com/silverstripe/sapphire/commit/73efe85) Fixed hardcoded fixture IDs in GridFieldDetailFormTest (Ingo Schommer)
 * 2012-03-12 [849b26d](https://github.com/silverstripe/sapphire/commit/849b26d) Added custom save indicator for constructive buttons (green background on animated gif) (Ingo Schommer)
 * 2012-03-12 [d8a5db4](https://github.com/silverstripe/sapphire/commit/d8a5db4) Padding for "parent mode" radio buttons on "add page" panel (Ingo Schommer)
 * 2012-03-12 [44515f5](https://github.com/silverstripe/sapphire/commit/44515f5) Don't link tree root node in CMS views, its not editable any longer (replaced by more specialised views with CMSSettingsController and SecurityAdmin-&gt;EditForm()) (Ingo Schommer)
 * 2012-03-12 [960e342](https://github.com/silverstripe/sapphire/commit/960e342) Avoid wrapping GridField row buttons into multiple lines (Ingo Schommer)
 * 2012-03-12 [0d69126](https://github.com/silverstripe/sapphire/commit/0d69126) Fixed GridField conditional (Ingo Schommer)
 * 2012-03-12 [2ec9de1](https://github.com/silverstripe/sapphire/commit/2ec9de1) Updated GridFieldDetailForm naming (Ingo Schommer)
 * 2012-03-12 [24815ce](https://github.com/silverstripe/sapphire/commit/24815ce) Updated GridField documentation (Andrew O'Neil)
 * 2012-03-12 [3d62832](https://github.com/silverstripe/sapphire/commit/3d62832) Removed session_start() call in installer, as it contradicts the requireFunction check for session_start as part of the installer (Sean Harvey)
 * 2012-03-12 [0c30bfc](https://github.com/silverstripe/sapphire/commit/0c30bfc) Tweak text about display_errors (Sean Harvey)
 * 2012-03-10 [f670576](https://github.com/silverstripe/sapphire/commit/f670576) Fix test to rely less on known test data keys (breaks SQLite) (Sam Minnee)
 * 2012-03-10 [9e6d70b](https://github.com/silverstripe/sapphire/commit/9e6d70b) Moved LeftAndMain-&gt;doAdd() and AddForm() to subclasses where they're actually used (no possible through a combination of architectural and UI changes) (Ingo Schommer)
 * 2012-03-09 [1ba5e79](https://github.com/silverstripe/sapphire/commit/1ba5e79) Re-fetching relationship in ListboxField-&gt;saveInto() when dealing with new records, to avoid errors on RelationList without foreign keys (fixes #6925) (Ingo Schommer)
 * 2012-03-09 [bf6317d](https://github.com/silverstripe/sapphire/commit/bf6317d) Removed unrelated styles from .cms-panel-padded class (which should just do what it says) (Ingo Schommer)
 * 2012-03-09 [67a032c](https://github.com/silverstripe/sapphire/commit/67a032c) Fixed button loading indicator (fixes #6876) (Ingo Schommer)
 * 2012-03-09 [549ebec](https://github.com/silverstripe/sapphire/commit/549ebec) Fixed preview link ($CurrentPage stopped working at some point..) (fixes #6940) (Ingo Schommer)
 * 2012-03-09 [3a068a0](https://github.com/silverstripe/sapphire/commit/3a068a0) Removed references to outdated versions from docs (Ingo Schommer)
 * 2012-03-09 [115ea86](https://github.com/silverstripe/sapphire/commit/115ea86) Added support for preselected tabs in $('.ss-ui-tabs-nav') (Ingo Schommer)
 * 2012-03-09 [d896c7d](https://github.com/silverstripe/sapphire/commit/d896c7d) Removed PHP 5.3-only code from SSViewerTest. (Sam Minnee)
 * 2012-03-09 [3768483](https://github.com/silverstripe/sapphire/commit/3768483) Fixed tests to suit GridField and DataList API changes (Sam Minnee)
 * 2012-03-09 [f288575](https://github.com/silverstripe/sapphire/commit/f288575) Removed obsolete test. (Sam Minnee)
 * 2012-03-09 [05cf5a8](https://github.com/silverstripe/sapphire/commit/05cf5a8) Dump deprecation notices introduced by the config system to 3.1.0 as it breaks heaps of code (Hamish Friedlander)
 * 2012-03-09 [adbcf61](https://github.com/silverstripe/sapphire/commit/adbcf61) Minor fixes after new SS_List interfaces cleanup (Sam Minnee)
 * 2012-03-09 [d89544f](https://github.com/silverstripe/sapphire/commit/d89544f) Disable tests in ObjectStaticTest that break (Hamish Friedlander)
 * 2012-03-09 [fb17f16](https://github.com/silverstripe/sapphire/commit/fb17f16) Remove invalid changes to input.hasDatepicker (Ryan O'Hara)
 * 2012-03-09 [a5666d6](https://github.com/silverstripe/sapphire/commit/a5666d6) Remove 2px margin from create button in New Member area (Ryan O'Hara)
 * 2012-03-09 [033a1e5](https://github.com/silverstripe/sapphire/commit/033a1e5) Fixed naming of test classes (Sean Harvey)
 * 2012-03-09 [d34dca6](https://github.com/silverstripe/sapphire/commit/d34dca6) Fix typographical errors. (Robert Curry)
 * 2012-03-09 [e78419c](https://github.com/silverstripe/sapphire/commit/e78419c) Fixed tests for  GridFieldToolbarHeaderTest (Sean Harvey)
 * 2012-03-09 [9b4b34c](https://github.com/silverstripe/sapphire/commit/9b4b34c) Fixed broken tests in GridFieldDetailFormTest (Sean Harvey)
 * 2012-03-09 [4f1da0a](https://github.com/silverstripe/sapphire/commit/4f1da0a) If the limit clause on DataObject::get() passes a SQL type of limit, modify it for SS_List::limit() (Stig Lindqvist)
 * 2012-03-09 [b6803f6](https://github.com/silverstripe/sapphire/commit/b6803f6) Check that component getActions returns an array before using it (Stig Lindqvist)
 * 2012-03-09 [34e7e9a](https://github.com/silverstripe/sapphire/commit/34e7e9a) Fix of GridFieldDefaultConfigTest (Stig Lindqvist)
 * 2012-03-09 [3d54668](https://github.com/silverstripe/sapphire/commit/3d54668) Added explicit 'public' keyword on functions. (Sam Minnee)
 * 2012-03-09 [0a82b90](https://github.com/silverstripe/sapphire/commit/0a82b90) ListDecorator::limit must exactly match SS_Limitable::limit() (Stig Lindqvist)
 * 2012-03-09 [0df958f](https://github.com/silverstripe/sapphire/commit/0df958f) Fixed tests to use commas as delimiter for shortcodes, also test spaces still work as well (Sean Harvey)
 * 2012-03-09 [a2353f7](https://github.com/silverstripe/sapphire/commit/a2353f7) Fixed misspelled "extension" in DataExtension::load_extra_statics() (Sean Harvey)
 * 2012-03-08 [e5f0233](https://github.com/silverstripe/sapphire/commit/e5f0233) Testing nested detail forms in GridField (Ingo Schommer)
 * 2012-03-08 [66f2244](https://github.com/silverstripe/sapphire/commit/66f2244) Checking for existence of $searchFields in GridFieldRelationAdd (Ingo Schommer)
 * 2012-03-09 [4a6116b](https://github.com/silverstripe/sapphire/commit/4a6116b) fixed use of $grid_x/y variables and documented 'magic' numbers (jbridson)
 * 2012-03-09 [7ea1517](https://github.com/silverstripe/sapphire/commit/7ea1517) Formatted code a little better, at Stig's request. (Sam Minnee)
 * 2012-03-09 [aed9193](https://github.com/silverstripe/sapphire/commit/aed9193) SSF-53 : code convention, use "-" instead of "_" for html class property value (Normann Lou)
 * 2012-03-09 [2cbbdde](https://github.com/silverstripe/sapphire/commit/2cbbdde) SSF-106 - fixed hover and active states to be more general across all buttons in datagrid rows. (jbridson)
 * 2012-03-08 [46a3bbf](https://github.com/silverstripe/sapphire/commit/46a3bbf) Merge error (Ingo Schommer)
 * 2012-03-09 [a688494](https://github.com/silverstripe/sapphire/commit/a688494) SSF-106 - fixed incorrect $gf_grid_x/y variables (jbridson)
 * 2012-03-08 [ae17e97](https://github.com/silverstripe/sapphire/commit/ae17e97) Made GridFieldPopupForms work outside of the CMS again (was assuming existence of Breadcrumbs) (Ingo Schommer)
 * 2012-03-08 [08c3e7e](https://github.com/silverstripe/sapphire/commit/08c3e7e) More flexible form detection in LeftAndMain.Tree.js (Ingo Schommer)
 * 2012-03-08 [b836bce](https://github.com/silverstripe/sapphire/commit/b836bce) Fixed double form submit (in some cases button click events aren't cancelled despite returning FALSE) (Ingo Schommer)
 * 2012-03-08 [b321b9b](https://github.com/silverstripe/sapphire/commit/b321b9b) Don't show GridField pagination when no records are found, and ensure the "no results" message is laid out correctly (Ingo Schommer)
 * 2012-03-08 [174cf08](https://github.com/silverstripe/sapphire/commit/174cf08) Removing special TinyMCE case in LeftAndMain-&gt;doAdd(), feature has been removed (Ingo Schommer)
 * 2012-03-08 [ee2b220](https://github.com/silverstripe/sapphire/commit/ee2b220) Supporting X-ControllerURL in form submits (Ingo Schommer)
 * 2012-03-08 [2ec40f8](https://github.com/silverstripe/sapphire/commit/2ec40f8) Stop using deprecated FormField-&gt;getTabIndex() (Ingo Schommer)
 * 2012-03-08 [9517763](https://github.com/silverstripe/sapphire/commit/9517763) Fixed PHP notice in ModelAdmin (Ingo Schommer)
 * 2012-03-08 [7d956de](https://github.com/silverstripe/sapphire/commit/7d956de) SSF-25 : correct inline document (Normann Lou)
 * 2012-03-08 [72101c2](https://github.com/silverstripe/sapphire/commit/72101c2) SSF-106 - fixed position of pagination on datagrid. (jbridson)
 * 2012-03-08 [2095743](https://github.com/silverstripe/sapphire/commit/2095743) SSF-106 - edited the SCSS so that measurements use increments of $gf_gridy/x (jbridson)
 * 2012-03-08 [349794a](https://github.com/silverstripe/sapphire/commit/349794a) SSF-106 added class="text" to pagination input field for styling (jbridson)
 * 2012-03-08 [91d7f1c](https://github.com/silverstripe/sapphire/commit/91d7f1c) SSF-53 - fixed height of table header when it has no sortable columns (jbridson)
 * 2012-03-08 [3870ba4](https://github.com/silverstripe/sapphire/commit/3870ba4) SSF-53 - changed height of icon on back button in users detail view. (jbridson)
 * 2012-03-08 [8b2213d](https://github.com/silverstripe/sapphire/commit/8b2213d) Added per-record canView, canDelete, canCreate and canEdit  checks on gridfield and gridfield components #6890 (Stig Lindqvist)
 * 2012-03-08 [139ccc3](https://github.com/silverstripe/sapphire/commit/139ccc3) Highlighting modified nodes (basic success visualization) (Ingo Schommer)
 * 2012-03-08 [27d2363](https://github.com/silverstripe/sapphire/commit/27d2363) Disabled browser autocomplete for batch action select (Ingo Schommer)
 * 2012-03-08 [137839a](https://github.com/silverstripe/sapphire/commit/137839a) Fixed BatchAction.js behaviour (Ingo Schommer)
 * 2012-03-08 [8afb867](https://github.com/silverstripe/sapphire/commit/8afb867) Using two_state checkboxes in TreeDropdownField.js (to allow individual node selection without enforcing children selection) (Ingo Schommer)
 * 2012-03-08 [3916e33](https://github.com/silverstripe/sapphire/commit/3916e33) Hide drag icons when tree is in multiselect, and root node checkbox when tree is in multiselect (but limit to content tree) (Ingo Schommer)
 * 2012-03-08 [0ede949](https://github.com/silverstripe/sapphire/commit/0ede949) SSF-53 : typo correction 'unlick' =&gt; 'unlink' (Normann Lou)
 * 2012-03-08 [a59637c](https://github.com/silverstripe/sapphire/commit/a59637c) SSF-30 tweaking comment (Julian Seidenberg)
 * 2012-03-07 [9a96b92](https://github.com/silverstripe/sapphire/commit/9a96b92) Moved $('.cms-panel-link') and $('.cms-link-ajax') behaviours to "higher order" namespace (Ingo Schommer)
 * 2012-03-07 [3b9c939](https://github.com/silverstripe/sapphire/commit/3b9c939) Using base LeftAndMain_EditForm template in GridFieldPopupForms regardless of template overrides on the "root" cms controller (Ingo Schommer)
 * 2012-03-07 [c820692](https://github.com/silverstripe/sapphire/commit/c820692) Ensuring .cms-panel-padded overrides .cms .ui-tabs (Ingo Schommer)
 * 2012-03-07 [bb8bda8](https://github.com/silverstripe/sapphire/commit/bb8bda8) Allowing .cms-content-fields to have its own layout (Ingo Schommer)
 * 2012-03-07 [4590436](https://github.com/silverstripe/sapphire/commit/4590436) SSF-53 changed the class of export to csv icon in scss. (jbridson)
 * 2012-03-07 [ecb7d92](https://github.com/silverstripe/sapphire/commit/ecb7d92) SSF-53 corrected the icon styling on export to csv button - properly implemented the compass sprite. (jbridson)
 * 2012-03-07 [4794195](https://github.com/silverstripe/sapphire/commit/4794195) SSF-53 : change the export button's icon name as per design (Normann Lou)
 * 2012-03-07 [c81bb3b](https://github.com/silverstripe/sapphire/commit/c81bb3b) Change -10/+10 buttons to First and Last (Andrew O'Neil)
 * 2012-03-07 [88a61f9](https://github.com/silverstripe/sapphire/commit/88a61f9) SSF-30 : add extra field to Tabs (listView and TreeView) to LeftAndMain EditForm (Normann Lou)
 * 2012-03-07 [8690e53](https://github.com/silverstripe/sapphire/commit/8690e53) Reverted MemberTest assertion, previously broken by recent ManyManyList and Member foreign key refactoring (Ingo Schommer)
 * 2012-03-07 [13c7c01](https://github.com/silverstripe/sapphire/commit/13c7c01) changing order of save and delete buttons so that they are consistent (Julian Seidenberg)
 * 2012-03-07 [58309cb](https://github.com/silverstripe/sapphire/commit/58309cb) Tests for add and edit forms of GridField (Andrew O'Neil)
 * 2012-03-07 [301c680](https://github.com/silverstripe/sapphire/commit/301c680) SSF-53 changed export to CSV icon to use the button-icon sprite. (jbridson)
 * 2012-03-06 [36ed7d2](https://github.com/silverstripe/sapphire/commit/36ed7d2) Fixed tree title updating after batch action completion (Ingo Schommer)
 * 2012-03-06 [e147971](https://github.com/silverstripe/sapphire/commit/e147971) Don't show status message for normal HTTP responses in BatchActions (Ingo Schommer)
 * 2012-03-07 [8617859](https://github.com/silverstripe/sapphire/commit/8617859) Re-instated the Go button on the actions button for page tree batch actions. (jbridson)
 * 2012-03-06 [746e3ea](https://github.com/silverstripe/sapphire/commit/746e3ea) Avoid applying jstree plugin multiple times when onmatch is called on CSS class changes, rather than DOM insertions (Ingo Schommer)
 * 2012-03-06 [0c6bc2f](https://github.com/silverstripe/sapphire/commit/0c6bc2f) Moving Tree.js entwine rules into namespace (wasn't applying multiple/draggable toggles because of that) (Ingo Schommer)
 * 2012-03-06 [755a9c3](https://github.com/silverstripe/sapphire/commit/755a9c3) Fixed selected node styling in _treee.scss, was styling children as selected as well (Ingo Schommer)
 * 2012-03-06 [8efaf75](https://github.com/silverstripe/sapphire/commit/8efaf75) jQuery UI icons for GridField buttons (with spriting), added new icon to GridFieldRelationDelete to dustinguish it visually from GridFieldAction_Delete (Ingo Schommer)
 * 2012-03-06 [1c344db](https://github.com/silverstripe/sapphire/commit/1c344db) More consistent overloading in GridField_Action, using standard getAttributes() method rather than custom template placeholders, removing setButtonIcon() and setButtonLabel() as those features already exist in the base implementation (Ingo Schommer)
 * 2012-03-06 [0b42282](https://github.com/silverstripe/sapphire/commit/0b42282) Integrating GridFieldSearch.js in GridField.js (and using entwine for it) (Ingo Schommer)
 * 2012-03-06 [ac20bfa](https://github.com/silverstripe/sapphire/commit/ac20bfa) Renamed GridFieldAction_Edit to GridFieldEditAction, GridFieldAction_Delete to GridFieldDeleteAction, to make it clearer that there's no parent class/concept called "GridFieldAction". There's only the GridFieldActionProvider interface, as well as the GridField_FormAction (which is a related, but different kettle of fish). (Ingo Schommer)
 * 2012-03-06 [3e700d7](https://github.com/silverstripe/sapphire/commit/3e700d7) Renaming GridField_Action to GridField_FormAction, to better distinguish it from GridFieldActionProvider and GridFieldAction_Edit. The two are conceptually related, but not through inheritance, as the original naming suggested. (Ingo Schommer)
 * 2012-03-06 [dca1b0d](https://github.com/silverstripe/sapphire/commit/dca1b0d) GridField docs (Ingo Schommer)
 * 2012-03-06 [f691eae](https://github.com/silverstripe/sapphire/commit/f691eae) Docs (Ingo Schommer)
 * 2012-03-06 [d2fa232](https://github.com/silverstripe/sapphire/commit/d2fa232) SSF-30 - added a new png icon for disabled back button. (jbridson)
 * 2012-03-06 [de7167b](https://github.com/silverstripe/sapphire/commit/de7167b) SSF-30 - Changed the back arrow icon to the correct one. (jbridson)
 * 2012-03-06 [1701627](https://github.com/silverstripe/sapphire/commit/1701627) SSF-106 documentation (Julian Seidenberg)
 * 2012-03-06 [3223404](https://github.com/silverstripe/sapphire/commit/3223404) Disabled two SecurityAdmin tests related to CSV export, which is not fully implemented in the new interface yet. Fixed the group URL in another test. (Ingo Schommer)
 * 2012-03-06 [18932b5](https://github.com/silverstripe/sapphire/commit/18932b5) Enforcing SecurityAdmin::$hidden_permissions, refactoring error (Ingo Schommer)
 * 2012-03-06 [a5b7a22](https://github.com/silverstripe/sapphire/commit/a5b7a22) Fixed GridField delete action, was executing row click event after delete, causing a panel load with a non-existent (now deleted) record (Ingo Schommer)
 * 2012-03-06 [4253950](https://github.com/silverstripe/sapphire/commit/4253950) Fixed handleRequest() usage in GridFieldPopupForms (Ingo Schommer)
 * 2012-03-06 [9bbac33](https://github.com/silverstripe/sapphire/commit/9bbac33) Merging SecurityAdmin-&gt;getEditForm() with RootForm(), in order to have the form fields consistently available (there's no longer a distinction between edit/root) (Ingo Schommer)
 * 2012-03-06 [8284fcc](https://github.com/silverstripe/sapphire/commit/8284fcc) SSF-53 : add hover-alike class to "Reset" button for easy css styling while keydown on filter input field (Normann Lou)
 * 2012-03-05 [e2c21cc](https://github.com/silverstripe/sapphire/commit/e2c21cc) "New &lt;record title&gt;" breadcrumb for GridFieldPopupForm (Ingo Schommer)
 * 2012-03-05 [8da89c6](https://github.com/silverstripe/sapphire/commit/8da89c6) Generic .cms-help-toggle implementation to replace MemberDatetimeOptionsetField.js (which also didn't work when loaded via Ajax, and needed a rewrite to jQuery.entwine anyway) (Ingo Schommer)
 * 2012-03-05 [851099d](https://github.com/silverstripe/sapphire/commit/851099d) Fixed default state of PermissionCheckboxSetField (Ingo Schommer)
 * 2012-03-05 [f9f6596](https://github.com/silverstripe/sapphire/commit/f9f6596) Re-instating Member_Validator in SecurityAdmin-&gt;RootForm() and Groups-&gt;getCMSFields() with new GridField implementation (Ingo Schommer)
 * 2012-03-05 [8a4a6ef](https://github.com/silverstripe/sapphire/commit/8a4a6ef) Moving CMS-specific customisations to GridFieldPopupForms into form getter, so it also applies when the form has validation errors (Ingo Schommer)
 * 2012-03-05 [9a02f19](https://github.com/silverstripe/sapphire/commit/9a02f19) .message styling (Ingo Schommer)
 * 2012-03-05 [94d985e](https://github.com/silverstripe/sapphire/commit/94d985e) Only disable chosen.js placeholder if no custom one exists (Ingo Schommer)
 * 2012-03-05 [bfd7adc](https://github.com/silverstripe/sapphire/commit/bfd7adc) Fixed default link styling in CMS, was too little contrast on light grey background (Ingo Schommer)
 * 2012-03-05 [fe29d4e](https://github.com/silverstripe/sapphire/commit/fe29d4e) Updated chosen.js from 0.9.5 to 0.9.7 (Ingo Schommer)
 * 2012-03-05 [ea31e17](https://github.com/silverstripe/sapphire/commit/ea31e17) Don't duplicate pagination defaults from GridFieldPaginator in GridFieldConfig (Ingo Schommer)
 * 2012-03-05 [6798d40](https://github.com/silverstripe/sapphire/commit/6798d40) GridField documentation (Ingo Schommer)
 * 2012-03-05 [e8ad2c2](https://github.com/silverstripe/sapphire/commit/e8ad2c2) Using ListboxField instead of CheckboxSetField in Member-&gt;getCMSFields() for group assignment (Ingo Schommer)
 * 2012-03-05 [eab8401](https://github.com/silverstripe/sapphire/commit/eab8401) Applying chosen.js behaviour to all &lt;select multiple&gt;, rather than arbitrarily limiting to a CheckboxSetField. Also fixed a bug where those fields would get the '.has-chzn' class even if it wasn't applied due to a missing &lt;select&gt; element. (Ingo Schommer)
 * 2012-03-05 [7dd7e60](https://github.com/silverstripe/sapphire/commit/7dd7e60) SSF-53 : add / remove hover-alike class to "Filter" button for easy css styling while keydown on filter input field (Normann Lou)
 * 2012-03-05 [8a56f98](https://github.com/silverstripe/sapphire/commit/8a56f98) SSF-53 : give "Add New" button an 'add' icon class, give "Link Exisiting" button a 'linkexisting' class (Normann Lou)
 * 2012-03-05 [929182f](https://github.com/silverstripe/sapphire/commit/929182f) Adjust pagination to match design (Andrew O'Neil)

...

 * 2012-03-05 [f1579a2](https://github.com/silverstripe/sapphire/commit/f1579a2) Corrected date in installer copyright (open.ss.org #6833) (Sam Minnee)
 * 2012-03-05 [d135c13](https://github.com/silverstripe/sapphire/commit/d135c13) SSF-53 - Changed the icon for the active state of the filter button on user gridfield (jbridson)
 * 2012-03-04 [a6a7b2e](https://github.com/silverstripe/sapphire/commit/a6a7b2e) Fixed viewer/editor groups field widths to work with chosen.js UI component (Ingo Schommer)
 * 2012-03-04 [c69e949](https://github.com/silverstripe/sapphire/commit/c69e949) Show all "can view" options in page settings in their own line, as it makes it easier to scan available options (Ingo Schommer)
 * 2012-03-02 [ef77b70](https://github.com/silverstripe/sapphire/commit/ef77b70) Fixed field label in Folder-&gt;getCMSFields() (Ingo Schommer)
 * 2012-03-02 [4345eaa](https://github.com/silverstripe/sapphire/commit/4345eaa) Sending 'ID' parameter from containing form alongside UploadField uploads, in order to set the correct context in in the controller (in the case of CMSFileAddController, that's the parent folder) (Ingo Schommer)
 * 2012-03-02 [6d89994](https://github.com/silverstripe/sapphire/commit/6d89994) CSS class for GridFieldFilter_Row.ss (Ingo Schommer)
 * 2012-03-02 [3659c63](https://github.com/silverstripe/sapphire/commit/3659c63) Updated jquery.form.js plugin, and re-added it to standard includes (its handy for clearing out forms, and consistently getting form field values) (Ingo Schommer)
 * 2012-03-02 [c7a3015](https://github.com/silverstripe/sapphire/commit/c7a3015) SearchFilter-&gt;setName()/setFullName() (Ingo Schommer)
 * 2012-03-02 [9a381d8](https://github.com/silverstripe/sapphire/commit/9a381d8) Accept null values in SearchContext-&gt;getResults() (Ingo Schommer)
 * 2012-03-02 [7bdc3d1](https://github.com/silverstripe/sapphire/commit/7bdc3d1) SSF-53 : add ability to add customised class to GridField table (Normann Lou)
 * 2012-03-02 [db1854b](https://github.com/silverstripe/sapphire/commit/db1854b) Disable UploadField init on readonly or disabled fields (Ingo Schommer)
 * 2012-03-02 [783de15](https://github.com/silverstripe/sapphire/commit/783de15) Declaring JS requirements for AjaxUniqueTextField (Ingo Schommer)
 * 2012-03-02 [c4e0489](https://github.com/silverstripe/sapphire/commit/c4e0489) Added GridFieldTitle to Group-&gt;getCMSFields() to allow addition of new records (currently that button is hardcoded in the title component) (Ingo Schommer)
 * 2012-03-02 [fce5487](https://github.com/silverstripe/sapphire/commit/fce5487) SFF-106 Gridfield changes to make styling easier (Andrew O'Neil)
 * 2012-03-01 [3ded12e](https://github.com/silverstripe/sapphire/commit/3ded12e) Removed obsolete "add member" button in SecurityAdmin, now handled through GridField (SSF-53) (Ingo Schommer)
 * 2012-03-01 [aa2e610](https://github.com/silverstripe/sapphire/commit/aa2e610) Documentation (Ingo Schommer)
 * 2012-03-01 [3f07b9b](https://github.com/silverstripe/sapphire/commit/3f07b9b) Fixed PermissionCheckboxSetField readonly styles (SSF-53) (Ingo Schommer)
 * 2012-03-01 [4bd5333](https://github.com/silverstripe/sapphire/commit/4bd5333) Editing and relation adding on SecurityAdmin groups (both root and group instances) (SSF-53) (Ingo Schommer)
 * 2012-03-01 [9c95a9a](https://github.com/silverstripe/sapphire/commit/9c95a9a) Removed GridFieldRelationAdd-&gt;useAutoSuggestion flag, as the field doesn't work without it (no current ID is being set via JS) (SSF-53) (Ingo Schommer)
 * 2012-03-01 [88039ff](https://github.com/silverstripe/sapphire/commit/88039ff) GridFieldRelationAddTest (SSF-53) (Ingo Schommer)
 * 2012-03-01 [d02a680](https://github.com/silverstripe/sapphire/commit/d02a680) Catching GridField filter submission to enable usage through enter key in addition to clicking on the filter button (SSF-53) (Ingo Schommer)
 * 2012-03-01 [23bd112](https://github.com/silverstripe/sapphire/commit/23bd112) Ensure global CMS behaviour is applied in dialogs and frames like UploadField as well (they only have the .cms class, not .cms-container) (Ingo Schommer)
 * 2012-03-01 [0b0e24b](https://github.com/silverstripe/sapphire/commit/0b0e24b) Fixed UploadField edit forms falsely expanding by default (Ingo Schommer)
 * 2012-03-01 [f8201c4](https://github.com/silverstripe/sapphire/commit/f8201c4) More generic CSS styles for .cms-file-info: Apply to form.small parent, fixed related UploadField spacing issues (Ingo Schommer)
 * 2012-03-01 [a415034](https://github.com/silverstripe/sapphire/commit/a415034) Changed GridField.js edit click behaviour from event-based to an (subclassable) method class, which means it works outside of the CMS by default. Making the whole row active in case an edit link is present (Ingo Schommer)
 * 2012-03-01 [1b600a0](https://github.com/silverstripe/sapphire/commit/1b600a0) Fixed empty breadcrumbs in AssetAdmin when using non-existent (singleton) record as the "current record" (Ingo Schommer)
 * 2012-03-01 [7f7d6b3](https://github.com/silverstripe/sapphire/commit/7f7d6b3) Remove commented code (Andrew O'Neil)
 * 2012-03-01 [a50fc51](https://github.com/silverstripe/sapphire/commit/a50fc51) SSF-106 Dont hide filter buttons when search isnt selected (Andrew O'Neil)
 * 2012-03-01 [8109a5e](https://github.com/silverstripe/sapphire/commit/8109a5e) phpDoc to methods in Date, small tweaks to DayOfMonth method to be consistent with value checks (Sean Harvey)
 * 2012-02-29 [68914ef](https://github.com/silverstripe/sapphire/commit/68914ef) SSViewer-&gt;testCastingHelpers() (Ingo Schommer)
 * 2012-02-29 [7d10ff7](https://github.com/silverstripe/sapphire/commit/7d10ff7) Fixed JS notice/alerts in CMS (Ingo Schommer)
 * 2012-02-29 [b92676c](https://github.com/silverstripe/sapphire/commit/b92676c) Fixed DatetimeField_Readonly config retrieval (Ingo Schommer)
 * 2012-02-29 [726b9ca](https://github.com/silverstripe/sapphire/commit/726b9ca) Create valid HTML attributes in GridFieldDefaultColumns-&gt;getColumnAttributes() (Ingo Schommer)
 * 2012-02-29 [bc6ea2e](https://github.com/silverstripe/sapphire/commit/bc6ea2e) (SSF-106) started on styling the filter bar on the datagrid (Felipe Skroski)
 * 2012-02-29 [a7304f3](https://github.com/silverstripe/sapphire/commit/a7304f3) SSF-106 made a small change to the positioning of the icons (edit and delete) (jbridson)
 * 2012-02-29 [2dffac7](https://github.com/silverstripe/sapphire/commit/2dffac7) SSF-106 Add classes for gridfield buttons (Andrew O'Neil)
 * 2012-02-29 [98f047e](https://github.com/silverstripe/sapphire/commit/98f047e) Add asc and desc classes to sorted header (Andrew O'Neil)
 * 2012-02-29 [be114b4](https://github.com/silverstripe/sapphire/commit/be114b4) (SSF-106) Added the images of the previous commit (Felipe Skroski)
 * 2012-02-29 [fea1a93](https://github.com/silverstripe/sapphire/commit/fea1a93) (SSF-106) tidied up the datagrid header styling (Felipe Skroski)
 * 2012-02-29 [af59228](https://github.com/silverstripe/sapphire/commit/af59228) fixed the positioning of the viewmode (drag and drop, mulitiselect) on the pages treeview (jbridson)
 * 2012-02-29 [b53a32a](https://github.com/silverstripe/sapphire/commit/b53a32a) SSF-30 changed measures to be multiples of grid-x and grid-y (jbridson)
 * 2012-02-28 [d171b11](https://github.com/silverstripe/sapphire/commit/d171b11) Documented special HTTP response codes in CMS (Ingo Schommer)
 * 2012-02-28 [af9e46a](https://github.com/silverstripe/sapphire/commit/af9e46a) LeftAndMain-&gt;Breadcrumbs() ordering (Ingo Schommer)
 * 2012-02-28 [386bbf8](https://github.com/silverstripe/sapphire/commit/386bbf8) Fixed GridFieldTest (broke due to changes in the default config) (Ingo Schommer)
 * 2012-02-28 [da879da](https://github.com/silverstripe/sapphire/commit/da879da) Styling and structural fixes for File/Image-&gt;getCMSFields() and relates usage in UploadField/HTMLEditorField. (Ingo Schommer)
 * 2012-02-28 [6e9bf88](https://github.com/silverstripe/sapphire/commit/6e9bf88) Force full redraw when panels are initiated (Ingo Schommer)
 * 2012-02-28 [a62881a](https://github.com/silverstripe/sapphire/commit/a62881a) Always padding panels (Ingo Schommer)
 * 2012-02-28 [07abcb1](https://github.com/silverstripe/sapphire/commit/07abcb1) Fixed button styling in CMS content header (tab styles not specific enough) (Ingo Schommer)
 * 2012-02-28 [da57794](https://github.com/silverstripe/sapphire/commit/da57794) Using ":submit" selector instead of ":button" in order to capture &lt;input&gt; tags as well (Ingo Schommer)
 * 2012-02-28 [25d0196](https://github.com/silverstripe/sapphire/commit/25d0196) Merge errors (Ingo Schommer)
 * 2012-02-28 [d0e3129](https://github.com/silverstripe/sapphire/commit/d0e3129) Added new spinner (Felipe Skroski)
 * 2012-02-28 [832d410](https://github.com/silverstripe/sapphire/commit/832d410) Merge errors (Ingo Schommer)
 * 2012-02-27 [f1775b5](https://github.com/silverstripe/sapphire/commit/f1775b5) Backlinks in CMS edit form template, first defined in GridFieldPopupForms (Ingo Schommer)
 * 2012-02-27 [8ff8d32](https://github.com/silverstripe/sapphire/commit/8ff8d32) Adding GridFieldPopupForms to default GridFieldConfig_ManyManyEditor settings (Ingo Schommer)
 * 2012-02-27 [cbfd76d](https://github.com/silverstripe/sapphire/commit/cbfd76d) Documentation (Ingo Schommer)
 * 2012-02-27 [e95a2cf](https://github.com/silverstripe/sapphire/commit/e95a2cf) Pad fields in base CMS template when no tabs exist, to avoid requiring a template overload for this simple view setting (Ingo Schommer)
 * 2012-02-27 [3b53ed1](https://github.com/silverstripe/sapphire/commit/3b53ed1) Moved some CMS-specific template config into GridFieldPopupForms, to make the external API easier to use, and make specific configs less dependent on the instanciation context, and more tuned to the actual execution controller context (Ingo Schommer)
 * 2012-02-27 [ba0d1c6](https://github.com/silverstripe/sapphire/commit/ba0d1c6) Don't require controller on instanciation of GridFieldPopupForms, as it can't be reliably determined e.g. during a getCMSFields() call. Should use existing FormField/Form API to retrieve controller when its required. MINOR Renamed GridFieldPopupForms-&gt;popupFormName to $name to make it clearer that its the component name (which is optional now). (Ingo Schommer)
 * 2012-02-23 [58f5b87](https://github.com/silverstripe/sapphire/commit/58f5b87) Added more fugue sprites (Ingo Schommer)
 * 2012-02-23 [3b72f59](https://github.com/silverstripe/sapphire/commit/3b72f59) Added CSS class for identifying column in GridFieldDefaultColumns (Ingo Schommer)
 * 2012-02-23 [9465df6](https://github.com/silverstripe/sapphire/commit/9465df6) Less specific button selectors in CMS JavaScript to cover &lt;button&gt; tags as well (Ingo Schommer)
 * 2012-02-23 [ddf4791](https://github.com/silverstripe/sapphire/commit/ddf4791) Simplified edit form toggle in UploadField.js, prevent new &lt;button&gt; element trigger from submitting the form (Ingo Schommer)
 * 2012-02-23 [8b6ef65](https://github.com/silverstripe/sapphire/commit/8b6ef65) Updating usage of jQuery.data() to confirm with API changes in 1.6 (camelcased names) (Ingo Schommer)
 * 2012-02-22 [6ffb941](https://github.com/silverstripe/sapphire/commit/6ffb941) JS formatting (Ingo Schommer)
 * 2012-02-22 [b389138](https://github.com/silverstripe/sapphire/commit/b389138) Move gridfield actions HTML to templates (Andrew O'Neil)
 * 2012-02-22 [bb42afe](https://github.com/silverstripe/sapphire/commit/bb42afe) Removed inline CSS styles (Ingo Schommer)
 * 2012-02-21 [39dc5ae](https://github.com/silverstripe/sapphire/commit/39dc5ae) Load breadcrumb links via ajax into panels in CMS (Ingo Schommer)
 * 2012-02-21 [3c29a92](https://github.com/silverstripe/sapphire/commit/3c29a92) AssetUploadField styling (Ingo Schommer)
 * 2012-02-21 [cbc2891](https://github.com/silverstripe/sapphire/commit/cbc2891) Metadata for GridField and Folder-&gt;getCMSFields() to allow opening folder references in the UI (Ingo Schommer)
 * 2012-02-21 [6e6fdaf](https://github.com/silverstripe/sapphire/commit/6e6fdaf) Applying default padding to edit form template rather than the tabs it contains, which allows a more standardised UI even when no tabs are present in the CMS content area (e.g. in "add files") (Ingo Schommer)
 * 2012-02-21 [3cad19a](https://github.com/silverstripe/sapphire/commit/3cad19a) JS formatting (Ingo Schommer)
 * 2012-02-20 [f8edc4b](https://github.com/silverstripe/sapphire/commit/f8edc4b) Add upgrade docs covering the changes to ViewableData (Hamish Friedlander)
 * 2012-02-20 [407913f](https://github.com/silverstripe/sapphire/commit/407913f) Add workaround for hitting XDebugs fairly conservative nesting level limit (Hamish Friedlander)
 * 2012-02-17 [743a26b](https://github.com/silverstripe/sapphire/commit/743a26b) Reverted conditional redraw of preview panel introduced in a1e9c0f4, too unstable (Ingo Schommer)
 * 2012-02-17 [bb7c128](https://github.com/silverstripe/sapphire/commit/bb7c128) JS syntax errors (Ingo Schommer)
 * 2012-02-17 [18131ae](https://github.com/silverstripe/sapphire/commit/18131ae) fixed bug with tabs - created more specific styling for the page view tabs so that they do not affect the tabs sitewide. (jbridson)
 * 2012-02-17 [82748a0](https://github.com/silverstripe/sapphire/commit/82748a0) JS functionality on intercepting injected filtering of gridfields in LeftAndMain inherited Controllers. (Stig Lindqvist)
 * 2012-02-17 [e28afca](https://github.com/silverstripe/sapphire/commit/e28afca) Added FormAction-&gt;setUseButtonTag() and getUseButtonTag() (Ingo Schommer)
 * 2012-02-16 [af4cf3c](https://github.com/silverstripe/sapphire/commit/af4cf3c) Fixed js accessor (thanks AngryPHPNerd) (Ingo Schommer)
 * 2012-02-16 [ad8fe82](https://github.com/silverstripe/sapphire/commit/ad8fe82) Added FormField-&gt;getDescription() to complement FormField-&gt;describe() (Ingo Schommer)
 * 2012-02-16 [fd847dd](https://github.com/silverstripe/sapphire/commit/fd847dd) Customized jQuery.layout.js to support fetching layout type through HTML5, for easier readability and avoiding the $.metadata dependency (which fails to parse HTML5 data attrs correctly) (Ingo Schommer)
 * 2012-02-16 [4e99af7](https://github.com/silverstripe/sapphire/commit/4e99af7) Using HTML5 data attributes for denoting layout in templates (Ingo Schommer)
 * 2012-02-16 [ac56fef](https://github.com/silverstripe/sapphire/commit/ac56fef) Removed jQuery.metadata usage in CMS, use jQuery.data() and HTML5 data attributes instead. Also fixes errors where jQuery.metadata tries to eval() HTML5 data attrs, which isn't always applicable (Ingo Schommer)
 * 2012-02-16 [0e3e290](https://github.com/silverstripe/sapphire/commit/0e3e290) Redraw the whole layout on form submit, instead of relying on .cms-content onmatch() which doesn't get fired on partial refreshes (e.g. in CMSPageEditController) (Ingo Schommer)
 * 2012-02-16 [d41f37f](https://github.com/silverstripe/sapphire/commit/d41f37f) Hiding collapsed panel views by CSS to avoid FOUC, and initialising component without triggering events to avoid redrawing the whole CMS layout twice due to it listening for panel changes (Ingo Schommer)
 * 2012-02-16 [b1acd05](https://github.com/silverstripe/sapphire/commit/b1acd05) Fixed tests using PostgreSQL as the database (Sean Harvey)
 * 2012-02-16 [f1a67a8](https://github.com/silverstripe/sapphire/commit/f1a67a8) Fixed broken test using PostgreSQL as the database (Sean Harvey)
 * 2012-02-15 [a3d8185](https://github.com/silverstripe/sapphire/commit/a3d8185) Click behaviour for special "panel loading" links in the CMS (Ingo Schommer)
 * 2012-02-15 [ca9b78f](https://github.com/silverstripe/sapphire/commit/ca9b78f) Re-apply custom jstree onselect behaviour on partial form refreshes (Ingo Schommer)
 * 2012-02-15 [44d8220](https://github.com/silverstripe/sapphire/commit/44d8220) Improved collapsed panel view by auto-hiding panel headers and avoid ugly cropped overflow effect (Ingo Schommer)
 * 2012-02-15 [51fe1fa](https://github.com/silverstripe/sapphire/commit/51fe1fa) More events for LeftAndMain.Panel.js (Ingo Schommer)
 * 2012-02-14 [92d5138](https://github.com/silverstripe/sapphire/commit/92d5138) Changed $Left placeholder in CMS templates to $Tools, documented it (Ingo Schommer)
 * 2012-02-14 [060e110](https://github.com/silverstripe/sapphire/commit/060e110) Allow expanding a collapsed panel by a click on the visible surface (Ingo Schommer)
 * 2012-02-14 [2acce7b](https://github.com/silverstripe/sapphire/commit/2acce7b) Moved menu-specific panel logic in LeftAndMain.Menu.js to avoid weakening base library (Ingo Schommer)
 * 2012-02-14 [7a8e634](https://github.com/silverstripe/sapphire/commit/7a8e634) Reverted hiding of tab titles (Ingo Schommer)
 * 2012-02-14 [42f3c54](https://github.com/silverstripe/sapphire/commit/42f3c54) Shorter SCSS $grid-* variables to promote wider usage (amended) (Ingo Schommer)
 * 2012-02-14 [4437f9d](https://github.com/silverstripe/sapphire/commit/4437f9d) Shorter SCSS $grid-* variables to promote wider usage (Ingo Schommer)
 * 2012-02-14 [0a75a34](https://github.com/silverstripe/sapphire/commit/0a75a34) Styles for form help text (Cam Findlay)
 * 2012-02-14 [8d9b00a](https://github.com/silverstripe/sapphire/commit/8d9b00a) Docs about HtmlEditorField and rich text editing (Ingo Schommer)
 * 2012-02-13 [f6748f5](https://github.com/silverstripe/sapphire/commit/f6748f5) Merge errors (Ingo Schommer)
 * 2012-02-13 [2c5d71d](https://github.com/silverstripe/sapphire/commit/2c5d71d) New category 'flash' in File-&gt;appCategory() (mainly for usage in "insert flash" logic) (Ingo Schommer)
 * 2012-02-13 [18e5dec](https://github.com/silverstripe/sapphire/commit/18e5dec) Add forceFullTree param for getting a complete tree (SSF-110) (Normann Lou)
 * 2012-02-12 [5ab007d](https://github.com/silverstripe/sapphire/commit/5ab007d) Removed apache_request_headers() usage in Director::direct(), it causes inconsistencies in capitalisation over the default method (inspecting $_SERVER) (Ingo Schommer)
 * 2012-02-11 [f91b5b1](https://github.com/silverstripe/sapphire/commit/f91b5b1) add upgrade note about breadcrumbs (Will Rossiter)
 * 2012-02-11 [c5452a7](https://github.com/silverstripe/sapphire/commit/c5452a7) Fixed broken tests in PostgreSQL (Sean Harvey)
 * 2012-02-11 [753bed5](https://github.com/silverstripe/sapphire/commit/753bed5) Fixed broken tests in PostgreSQL (Sean Harvey)
 * 2012-02-11 [fcf103c](https://github.com/silverstripe/sapphire/commit/fcf103c) Check for display_errors=Off during installation (fixes #5779) (Ingo Schommer)
 * 2012-02-10 [03abde4](https://github.com/silverstripe/sapphire/commit/03abde4) DataDifferenceTest should not test whitespace (Stig Lindqvist)
 * 2012-02-10 [d912da4](https://github.com/silverstripe/sapphire/commit/d912da4) Upgraded Zend framework dependency from 1.11.6 to 1.11.11 (Ingo Schommer)
 * 2012-02-10 [ce4f456](https://github.com/silverstripe/sapphire/commit/ce4f456) Removed unused functionality from prototype_improvements.js (Ingo Schommer)
 * 2012-02-10 [e59976b](https://github.com/silverstripe/sapphire/commit/e59976b) Removed custom TinyMCE image resizer logic, presumably added due to lack of support for retaining aspect ratio in earlier versions of the editor (Ingo Schommer)
 * 2012-02-10 [a96429c](https://github.com/silverstripe/sapphire/commit/a96429c) Removed unused "nullConverter" callback in TinyMCE CMS integration (Ingo Schommer)
 * 2012-02-10 [243d4d4](https://github.com/silverstripe/sapphire/commit/243d4d4) Restored row/col defaults in TextareaField and HtmlEditorField (broken in 1a10e8bc) (Ingo Schommer)
 * 2012-02-09 [9f12c5a](https://github.com/silverstripe/sapphire/commit/9f12c5a) API for clientside reloading of GridField (Ingo Schommer)
 * 2012-02-09 [47ac047](https://github.com/silverstripe/sapphire/commit/47ac047) Setting existing GridState from client during request handling to allow altering it there MINOR Parameter namespacing for GridState to avoid clashes with multiple GridField instances in same form MINOR GridField-&gt;index() to render the field, unify with gridFieldAlterAction() to support state changes (Ingo Schommer)
 * 2012-02-09 [c422e06](https://github.com/silverstripe/sapphire/commit/c422e06) Removed GridField-&gt;requireDefaultCSS() idiom, not used elsewhere (or used for JS in the same class), should be handled through Requirements class instead (Ingo Schommer)
 * 2012-02-08 [1b42b2a](https://github.com/silverstripe/sapphire/commit/1b42b2a) GridField JS API for updating state (Ingo Schommer)
 * 2012-02-08 [c2f201f](https://github.com/silverstripe/sapphire/commit/c2f201f) Fixed profile link (was broken due to admin/ =&gt; admin/pages redirect) (Ingo Schommer)
 * 2012-02-08 [a0d5832](https://github.com/silverstripe/sapphire/commit/a0d5832) Fixed UploadField-&gt;managesRelation() when no record is set (Ingo Schommer)
 * 2012-02-08 [4bd526f](https://github.com/silverstripe/sapphire/commit/4bd526f) Don't follow &lt;a&gt; tag's href if click on page-icon or drag-icon (SSF-109) (Normann Lou)
 * 2012-02-08 [23e7aee](https://github.com/silverstripe/sapphire/commit/23e7aee) Tree and content toolbar styling fixes (SSF-138, SSF-71) (jbridson)
 * 2012-02-07 [5a3242c](https://github.com/silverstripe/sapphire/commit/5a3242c) Allowing custom attributes on GridField, adding more CSS classes to support behaviour (Ingo Schommer)
 * 2012-02-07 [1b4dda4](https://github.com/silverstripe/sapphire/commit/1b4dda4) Moving File-&gt;OwnerID setting to model layer (Ingo Schommer)
 * 2012-02-07 [7718c75](https://github.com/silverstripe/sapphire/commit/7718c75) Removed detection of has_one relationships in UploadField when using the database column name rather than relationship name - too verbose, and not supported by underlying FileField. (Ingo Schommer)
 * 2012-02-07 [feb7c64](https://github.com/silverstripe/sapphire/commit/feb7c64) Updated css (Ingo Schommer)
 * 2012-02-07 [3796ce5](https://github.com/silverstripe/sapphire/commit/3796ce5) Fixed SCSS indentation in UploadField (avoid false sense of specificity without actual SCSS nesting) (Ingo Schommer)
 * 2012-02-06 [c7b02d2](https://github.com/silverstripe/sapphire/commit/c7b02d2) Rewrite stack trace from "In line &lt;line&gt; of &lt;file&gt;" to a more readable and common "&lt;file&gt;:&lt;line&gt;" (Ingo Schommer)
 * 2012-02-06 [5284f90](https://github.com/silverstripe/sapphire/commit/5284f90) Improved email log styling through inline style declaration (which now extends styles to tables), using smaller non-serif font for better readability (Ingo Schommer)
 * 2012-02-04 [5ad2eea](https://github.com/silverstripe/sapphire/commit/5ad2eea) fixed typo (Zauberfisch)
 * 2012-02-03 [4499edc](https://github.com/silverstripe/sapphire/commit/4499edc) Opening the file link in File-&gt;getCMSFields() in a new window to avoid being stuck in UploadField "inline edit" views without a back button (Ingo Schommer)
 * 2012-02-02 [f4c140b](https://github.com/silverstripe/sapphire/commit/f4c140b) Cleaner tree icons (Felipe Skroski)
 * 2012-02-02 [80a08aa](https://github.com/silverstripe/sapphire/commit/80a08aa) Collapsing filter breaks the main navigation (SSF-108) (Normann Lou)
 * 2012-02-02 [db5ac15](https://github.com/silverstripe/sapphire/commit/db5ac15) Fixed spelling mistake in HasManyList (Ingo Schommer)
 * 2012-02-01 [586ae4a](https://github.com/silverstripe/sapphire/commit/586ae4a) GridField column header and sorting styles (Felipe Skroski)
 * 2012-01-31 [6a6aee4](https://github.com/silverstripe/sapphire/commit/6a6aee4) Updated changelog (Ingo Schommer)
 * 2012-01-31 [8e3ce75](https://github.com/silverstripe/sapphire/commit/8e3ce75) Casting return values in HTMLText correctly (followup on security fixes applied to Text, Varchar, StringField) (Ingo Schommer)
 * 2012-01-31 [7464a47](https://github.com/silverstripe/silverstripe-installer/commit/7464a47) Replaced custom verbose logging flags with standard log levels (Ingo Schommer)
 * 2012-01-30 [04a10a4](https://github.com/silverstripe/sapphire/commit/04a10a4) Updated coding conventions to require the 'public' keyword for class methods and variables (Ingo Schommer)
 * 2012-01-30 [0b0d42c](https://github.com/silverstripe/sapphire/commit/0b0d42c) Formatting (Ingo Schommer)
 * 2012-01-30 [008ecf7](https://github.com/silverstripe/sapphire/commit/008ecf7) Fixed GridFieldExporter accessors (undefined $gridField in changed scope) (Ingo Schommer)
 * 2012-01-30 [5faca9c](https://github.com/silverstripe/sapphire/commit/5faca9c) Accessors, documentation and i18n for GridFieldExporter (Ingo Schommer)
 * 2012-01-30 [a135b7c](https://github.com/silverstripe/sapphire/commit/a135b7c) Removed GridField-&gt;getDefaultConfig() in favour of new GridFieldConfig_Base class (and adjusted its components to remove the "edit" component, and add the "filter" component by default, to match the original getDefaultDefaultConfig()) (Ingo Schommer)
 * 2012-01-25 [439ed75](https://github.com/silverstripe/sapphire/commit/439ed75) Removed unused property on GridFieldFilter (Stig Lindqvist)
 * 2012-01-24 [6f2e889](https://github.com/silverstripe/sapphire/commit/6f2e889) Groups in SecurityAdmin was not using Autosuggestion field for adding members to group. (Stig Lindqvist)
 * 2012-01-24 [28906d4](https://github.com/silverstripe/sapphire/commit/28906d4) i18n on GridFieldRelationAdd, GridFieldFilter and GridFieldItemEditVIew template (Stig Lindqvist)
 * 2012-01-23 [0702913](https://github.com/silverstripe/sapphire/commit/0702913) Updated docblocks for GridFieldPaginator (Stig Lindqvist)
 * 2012-01-23 [dc85fa0](https://github.com/silverstripe/sapphire/commit/dc85fa0) SecurityAdmin::getEditForm should have same signature as LeftAndMain::getEditForm (Stig Lindqvist)
 * 2012-01-23 [8ba585b](https://github.com/silverstripe/sapphire/commit/8ba585b) Fixing button whitespace gaps and "interrupted" buttonsets (Ingo Schommer)
 * 2012-01-22 [d456e86](https://github.com/silverstripe/sapphire/commit/d456e86) Name attribute for preview iframe (mainly to facilitate testing) (Ingo Schommer)
 * 2012-01-22 [e18698d](https://github.com/silverstripe/sapphire/commit/e18698d) Wrapping tree title in its own element (mainly to facilitate selectors during testing) (Ingo Schommer)
 * 2012-01-19 [cb74dbc](https://github.com/silverstripe/sapphire/commit/cb74dbc) Removed overzealous value validation in ListboxField, should silently ignore unknown values (lacking better referential integrity measures in the underlying model layer) (Ingo Schommer)
 * 2012-01-14 [a6cc7d8](https://github.com/silverstripe/sapphire/commit/a6cc7d8) Enforce SiteTree::$allowed_children in tree drag'n'drop for VirtualPage originals (Ingo Schommer)
 * 2011-11-30 [ca047b6](https://github.com/silverstripe/sapphire/commit/ca047b6) Removed usage of HiddenFieldSet (Ingo Schommer)

### Other

 * 2012-03-12 [4fc3aaf](https://github.com/silverstripe/sapphire/commit/4fc3aaf) Revert "ENHANCEMENT Using 'autoresize' TinyMCE plugin in HTMLEditorField default config, in order to save space when no content is entered into the field" - causes artificial loading delay, and doesn't detect height correctly due to floated images in paragraphs. These paragraphs can't be clearfix'ed because they'd become contenteditable (resizeable) elements in IE because of this. (Ingo Schommer)
 * 2012-03-12 [d63efeb](https://github.com/silverstripe/sapphire/commit/d63efeb) Revert "MINOR: Remove 2px margin from create button in New Member area" (Sam Minnee)
 * 2012-03-12 [99e376d](https://github.com/silverstripe/sapphire/commit/99e376d) ENHANCMENT: SSF-25 - fixed a couple of styling issues on the ModelAdmin Filter (jbridson)
 * 2012-03-09 [6e6890f](https://github.com/silverstripe/sapphire/commit/6e6890f) Clarify failure messages to distinguish string and numeric zero tests (Fred Condo)
 * 2012-03-09 [10dffd3](https://github.com/silverstripe/sapphire/commit/10dffd3) Revert "BUG FIX: Make Inputs in Input-Selects take up the whole select box (#6934)". It hardcodes a width too globally, and uses magic numbers rather than the $grid-x system. Also, it breaks styling, e.g. in the 'insert image' dialog. (Ingo Schommer)
 * 2012-03-09 [ecb279c](https://github.com/silverstripe/sapphire/commit/ecb279c) Issue #6667: Check for TEMP_FOLDER _ss_envrionment override in install script. (Robert Curry)
 * 2012-03-07 [5967a1c](https://github.com/silverstripe/sapphire/commit/5967a1c) API-CHANGE: SSF-30 adding a method to control a parameter passed to Hierarchy-&gt;getChildrenAsUL() from TreeDropdownField. The parameter is useful for controlling whether the returned UL contains child nodes, or just folders. (Julian Seidenberg)
 * 2012-03-05 [344899a](https://github.com/silverstripe/sapphire/commit/344899a) Revert "ENHANCEMENT Support numeric array values in CheckboxSetField (?Field[]=val1&Field[]=val2 instead of ?Field[val1]=1&Field[val2]=1)" - data handling with numeric/associative arrays too clumsy, fixed up ListboxField instead (Ingo Schommer)
 * 2012-03-04 [c211b7c](https://github.com/silverstripe/sapphire/commit/c211b7c) Added some simple code to show the location of the loaded php.ini file when php configuration or file permision errors exist (Kirk Mayo)
 * 2012-03-02 [b95abee](https://github.com/silverstripe/sapphire/commit/b95abee) Revert "MINOR SSF-53 : add ability to add customised class to GridField table" (introduces duplicate '.ss-gridfield' class in different levels of the DOM hierarchy) (Ingo Schommer)
 * 2012-02-27 [0e2cbb0](https://github.com/silverstripe/sapphire/commit/0e2cbb0) Replace ereg with preg_* (AngryPHPNerd)
 * 2012-02-12 [a8735a3](https://github.com/silverstripe/sapphire/commit/a8735a3) Clean up of trailing ?&gt; per coding standard (Fred Condo)
 * 2012-02-12 [d370423](https://github.com/silverstripe/sapphire/commit/d370423) Clean up trailing ?&gt; per coding standard (Fred Condo)
 * 2012-02-11 [28bb835](https://github.com/silverstripe/sapphire/commit/28bb835) API-CHANGE: moving iterator support from ViewableData to SSViewer. New set of unit tests for iterator support functions. (Hamish Friedlander)
 * 2012-02-11 [927dbbe](https://github.com/silverstripe/sapphire/commit/927dbbe) API-CHANGE: Global template variables can now be called directly using SSViewer_DataPresenter instead of needing to inherit off ViewableData (Hamish Friedlander)
 * 2012-02-08 [0fd8482](https://github.com/silverstripe/sapphire/commit/0fd8482) Button overflow contained to max 100% + outcommented instructions on how button styling can be increased for Webkit & IE9 (Anselm Christophersen)
 * 2012-01-23 [09bb6d4](https://github.com/silverstripe/sapphire/commit/09bb6d4) Use corrected function name from silverstripe-cms project (Jeremy Thomerson)
 * 2012-01-17 [82ef236](https://github.com/silverstripe/sapphire/commit/82ef236) Reset ... (Dominik Beerbohm)
 * 2012-01-17 [09c1f8f](https://github.com/silverstripe/sapphire/commit/09c1f8f) Bad parameter forwarding from SS_ListDecorator (sort,filter,exclude) to i.e. DataList. (Dominik Beerbohm)
 * 2012-01-16 [3a9ea42](https://github.com/silverstripe/sapphire/commit/3a9ea42) Update view/SSViewer.php (Dominik Beerbohm)
 * 2012-01-11 [3c09e9d](https://github.com/silverstripe/sapphire/commit/3c09e9d) ENH: Some webhosters require username/password credentials to test for existing DB server (dompie)