# 2.4.0-beta2 (2010-05-17)

## Changelog

###  Features and Enhancements

 * [rev:101127] Added 'Dependent pages' tab to CMS, to show virtuals, redirectors, and backlinks that point to this page.
 * [rev:101054] Allowing SQLite selection in installer
 * [rev:101054] Moved all Javascript containedin  install.php and config-form.html to install.js, and using jQuery to simplify logic
 * [rev:101054] Allow installer to attach custom form fields based on the install driver (as defined in _register_database.php)
 * [rev:100989] If no arguments specified for cli-script.php/sake, then provide a friendly message to the user on where to get help
 * [rev:100966] MoneyField currency dropdown can be made from an associate array like array('NZD'=>'New Zealand Dollor', 'USD'=>"United States Dollor') as well
 * [rev:100940] Added help text for "locale" setting in installer
 * [rev:100937] Redirecting to translated page when original is requested with a 'locale' GET parameter (e.g. 'about-us/?locale=de_DE' will redirect to 'ueber-uns' with a 301 HTTP response).  Implemented in ContentController->handleRequest(). (see #5001)
 * [rev:100908] Added DatabaseAdapterRegistry::unregister() to remove a database from the registry
 * [rev:100902] Added _register_database.php to sapphire which sets the SS provided databases for DatabaseAdapterRegistry
 * [rev:100893] Added Hebrew (he_IL) language to sapphire (thanks Oren, Yotam, tzvika, Amir, ohad)
 * [rev:100893] Added Lithuanian (lt_LT) language to sapphire (thanks Irmantas, Mindaugas, Donatas, Andrius)
 * [rev:100892] Added Hebrew (he_IL) language to cms (thanks Oren, Yotam, tzvika, Amir, ohad)
 * [rev:100892] Added Lithuanian (lt_LT) language to cms (thanks Irmantas, Mindaugas, Donatas, Andrius)
 * [rev:100884] Using jquery.live instead of livequery for SelectionGroup.js
 * [rev:100852] Updated jquery.ondemand.js to sapphire trunk version, to ensure compatibility with jQuery 1.4.2
 * [rev:100849] Only defining document.getElementsByClassName() in prototype.js if no native implementation exists (which speeds up the CMS). Ported from 'jquery13' module, thanks Hamish
 * [rev:100847] Updated jquery.livequery from v1.0.2 to v1.1.1 (located in sapphire/thirdparty/jquery-livequery/
 * [rev:100846] Updated jquery.metadata from ~v.1.0 to v2.1 (located in sapphire/thirdparty/jquery-metadata
 * [rev:100845] Updated jQuery.form library from v2.08 to v2.40 (located in sapphire/thirdparty/jquery-form
 * [rev:100844] Updated jQuery library from v1.2.6 to v1.4.2 (located in sapphire/thirdparty/jquery/
 * [rev:100799] Creating default "Content Authors" group with limited rights if no other groups exist.
 * [rev:100776] Better editing of roles through SecurityAdmin instead of a new "Roles" tab. Removed (previously unreleased) PermissionRoleAdmin. (see #4757)
 * [rev:100774] Allowing custom popup requirements in ComplexTableField without subclassing through $requirementsForPopupCallback
 * [rev:100771] Respecting SecurityAdmin::$hidden_permissions in PermissionRole->getCMSFields()
 * [rev:100769] you can now choose your site locale at install time
 * [rev:100753] Added 'updateImageForm', 'updateFlashForm', 'updateLinkForm' hooks to HtmlEditorField (the imageform hook was necessary to make the 'pixlr' module work) (see #3938)
 * [rev:100696] show all database systems we support, along with messages if the user cannot use them. Also allow 3rd parties to register their own database classes to appear in this list.
 * [rev:100536] Stored combined files in assets/_combinedfiles by default
 * [rev:100529] Combined files now live in assets/.combinedfiles by default
 * [rev:100528] #3387 Requirements now has a new static function called Requirements::set_combined_files_folder() for setting where the combined files should belong
 * [rev:100453] #4599 DataObjectSet now uses more array functions instead of performing equivalent tasks - thanks simon_w!
 * [rev:100423] Convert JSON functions now use the Services_JSON library where appropriate instead of custom code, and if json_decode() or json_encode() are available these are used
 * [rev:100400] #5072 RSSFeed_Entry::rssField() now respects custom getters on the data class
 * [rev:100327] allow ordering of page commented to be configurabled
 * [rev:100058] AssetAdmin now uses Upload_Validator instead of setting the rules directly on Upload
 * [rev:99954] you can now do coverage tests of single/multiple tests, or entire modules
 * [rev:99942] fixed forward button underneath result form
 * [rev:99929] #4787 Widget now respects updateCMSFields on extension classes so additional fields can be add (or existing ones removed)
 * [rev:99845] #4043 Allow setting the from address for debug information in SS_LogEmailWriter - thanks Hamish!
 * [rev:99841] #5024 Installer now checks that the user has entered a username and password correctly for the default admin, an additional button for re-checking requirements is now found at the bottom of the admin configuration section
 * [rev:99841] Error messages for database AND admin configuration are now in the same place at the top of the installer
 * [rev:99737] Allow DataObjectSet to remove duplicates based on any field  (#5094, thanks mobiusnz) (from r99736)
 * [rev:99692] Disabling/checking permission checkboxes in admin/security when 'ADMIN' permission is selected
 * [rev:99690] Saving group relations on SecurityAdmin->EditForm()/RootForm() through TreeMultiselectField instead of hidden 'Group'/'GroupID' values (from r99579)
 * [rev:99688] Saving MemberTableField through new 'Groups' field added in Member->getCMSFields(). (from r98882)
 * [rev:99679] added new PageCommnet to yml so we have different amounts of moderated/unmodereated
 * [rev:99677] Making  setting optional in MemberTableField. Field instances without  will list all members unfiltered, and remove members from the database rather than the group relation.
 * [rev:99677] Allow disabling of 'inline add' formfields in a MemberTableField through setPermissions(array('inlineadd')) (from r98825)
 * [rev:99667] Only show 'HTML Editor Config' dropdown in Group->getCMSFields() if more than one option exists
 * [rev:99666] Showing checkboxes as disabled for inherited roles in Group->getCMSFields() (from r99597)
 * [rev:99664] Added OptionsetField->setDisabledItems() to allow specifically disabling certain checkboxes
 * [rev:99664] Added CheckboxSetField->setDefaultItems() to tick specified checkboxes regardless of the value passed (from r99596)
 * [rev:99662] Showing (readonly) permissions for a Member record in admin/security popup (from r99586)
 * [rev:99660] PermissionCheckboxSetField_Readonly (with all checkboxes disabled)
 * [rev:99660] Added 'assigned to...' label to group permissions in PermissionCheckboxSetField - used in Member->getCMSFields() readonly permission view (from r99585)
 * [rev:99658] Allowing PermissionCheckboxSetField to inspect multiple group records for existing permissions (from r99584)
 * [rev:99648] View and select groups for a specific member via the member popup in admin/security (requires EDIT_PERMISSIONS) (from r98880)
 * [rev:99361] Allow locale/dateformat specific reordering of day, month, year input fields in DateField
 * [rev:99360] New DatetimeField class (form field wrapper composed of DateField andTimeField)
 * [rev:99360] New DateField and TimeField form classes with more consistent API and easier localization
 * [rev:99360] Using Zend_Date for DateField and TimeField, with more robust date handling, starting localization support. Set globally via i18n::set_locale(), or for a field instance through setLocale(). Note: Javascript validation is not localized yet.
 * [rev:99302] SiteTree::batch_permission_check() populates its own cache (from r97900)
 * [rev:99117] set file metadata on upload. (from r97780)
 * [rev:99106] set file metadata on upload. (from r97780)
 * [rev:99088] Add close link (from r97751)
 * [rev:99080] Add Link to silverstripe navigator (from r97407)
 * [rev:99069] added PageComment for CommentAdminTest
 * [rev:99066] CommentAdmin unitest
 * [rev:99047] Make navigator items more overloadable (from r97376)
 * [rev:99046] Refactor links in $SilverStripeNavigator so modules can add extras (from r97299)
 * [rev:98756] Added help texts for MemberImportForm and GroupImportForm (merged and rewritten from r98750)
 * [rev:98737] Allow extension of LeftAndMain->getEditForm() (and subclasses) through a new updateEditForm() hook (see r98736 for additions to AssetAdmin and CMSMain)
 * [rev:98736] Import groups from CSV in admin/security through the new GroupImportForm class (and GroupCsvBulkLoader) (merged and rewritten from r98711)
 * [rev:98735] Allowing custom 'root forms' when id values '0' or 'root' are passed from the tree selection. (rewritten from r98710)
 * [rev:98732] Import members and their group assignments from CSV in admin/security through the new MemberImportForm class (merged from r98708)
 * [rev:98715] Added GroupCsvBulkLoader class to facilitate group imports with permission codes and hierarchy (merged from r94252)
 * [rev:98714] MemberCsvBulkLoader for easy member import with group associations (merged from r94251)
 * [rev:98713] Added BulkLoader->deleteExistingRecords(), removed unnecessary parameters from BulkLoader->load() (merged from r94250)
 * [rev:98713] Decreased memory usage in BulkLoader->load() when deleting all records before importing  (merged from r94250)
 * [rev:98677] Added checkbox to switch off using the environment during install if it's available
 * [rev:98659] #3903 Initial changes to installer to support selection of different database drivers
 * [rev:98656] you can now pass arbitrary CURL options to the request() method of RestfulService.
 * [rev:98469] Add HTMLCleaner abstract class, and Diff::cleanHTML()
 * [rev:98428] Allow overriding TableListField_Item on TableListField by setting the property itemClass


###  API Changes

 * [rev:101155] Add option for DataObjectDecorator::onAfterSkippedWrite()
 * [rev:101137] Partial cache adjustments - now supports nested cache blocks (which are independant of their containing cache block), conditionals to control if a given cache block is active, and includes hash of template code in key (so template changes mean cache is invalidated). Changes template control for cache block to `<% cached %>`, to which the now deprecated `<% cacheblock %>` is aliased, and an additional template control `<% uncached %>` has been added.
 * [rev:101127] Added SiteTree::VirtualPages() and SiteTree::DependentPages() accessors.
 * [rev:101119] Allow on_db_reset() methods on DataObjects as well as DataObjectDecortators
 * [rev:101093] Replaced eval based creation of extension and field objects with Object::create_from_string().
 * [rev:101093] Introduced new function Object::create_from_string() to instantiate an object from a string like 'Int(50)'
 * [rev:101044] Made MySQL fulltext search optional, activated with MySQLFulltextSearchable::enable()
 * [rev:101043] Pass the full extension string as the 2nd argument to DataObjectDecorator::extraStatics()
 * [rev:100842] Upgraded jQuery UI from v1.6rc1 (r687) to v1.8rc3. This release prefixes all *.js and *.css files with 'jquery', so ui.core.js is now called jquery.ui.core.js.
 * [rev:100842] Upgraded jQuery UI themes from v1.6rc1 to v1.8rc3. Removed 'flora' and 'default' themes, replaced with the 'base' and 'smoothness' themes found in the default distribution
 * [rev:100718] Removed "auto-merging" of member records from Member->onBeforeWrite() due to security reasons - please use DataObject->merge() explicitly if this is desired behaviour (from r100705)
 * [rev:100651] dbDataType function created
 * [rev:100513] Refactored Requirements to use Requirements_Backend at all times - this makes testing far easier. Thanks tobych!
 * [rev:100512] TreeDropdownField no longer requires your object to have the Hierarchy extension
 * [rev:100503] Removed deprecated Email_Template class, please use Email instead!
 * [rev:100498] Removed deprecated Image::loadUploaded() (deprecated from the parent::loadUploaded for which it called), please use Upload directly instead!
 * [rev:100495] Removed deprecated File::loadUploaded(), please use Upload directly instead!
 * [rev:100493] Removed deprecated function RootURLController::get_homepage_urlsegment(), please use RootURLController::get_homepage_link() instead!
 * [rev:100492] Removed deprecated function SiteTree::get_by_url(), please use SiteTree::get_by_link() instead!
 * [rev:100490] Removed deprecated methods DataObjectSet::filter_map() and DataObjectSet::map_multiple() - please use map() instead!
 * [rev:100057] #5107 Upload now uses Upload_Validator to separate the validation rules from the File loading done in the Upload class
 * [rev:99849] SiteTree::validURLSegment extendable (#5907)
 * [rev:99360] Date/time parsing in DateField, TimeField and DatetimeField defaults to i18n::get_locale() ('en_US') instead of using en_NZ/en_GB specific parsing. Use i18n::set_locale('en_NZ') in mysite/_config.php to revert to old behaviour.
 * [rev:99360] $timeformat constructor parameter in TimeField needs to be in ISO date notation (not PHP's date())
 * [rev:99360] TimeField, DateField and related subclasses use Zend_Date for date parsing, meaning they're stricer than the previously used strtotime()
 * [rev:99360] Removed DMYCalendarDateField and CalendarDateField, use DateField with setConfig('showcalendar')
 * [rev:99360] Removed CompositeDateField, DMYDateField, use DateField with setConfig('dmyfields')
 * [rev:99360] Removed DropdownTimeField, use TimeField with setConfig('showdropdown')
 * [rev:99360] Removed PopupDateTimeField, use DatetimeField
 * [rev:99360] Changed 'date', 'month' and 'year' HTML field names to lowercase in DMYDateField
 * [rev:99360] Removed support for ambiguous date formats in DateField, e.g. '06/03/03'. Use DateField->setConfig('dateformat', `<format>`) to revert to this behaviour.
 * [rev:99360] Removed $futureOnly flag from DateField, CalendarDateField etc., use DateField->setConfig('min') and DateField->setConfig('max')
 * [rev:99119] Refactor Versioned so a single state is kept for stage, archived date, or any module specific reading modes (from r98161)
 * [rev:99114] Use the same navigator items in the CMS that are used on the frontend (from r97395)
 * [rev:99079] Use the same navigator items in the CMS that are used on the frontend (from r97395)
 * [rev:99063] Let sitetree extensions prepopulate permisson cache for their own permissions. (from r98650)
 * [rev:99051] Let any DataObjectDecorator define an on_db_reset() method that is called by tests, like in Versioned. (from r97734)
 * [rev:98786] Installer now uses a database configuration helper class which isolates the logic of checking the database away from the installer, this interface can be used by other databases like MSSQL and PostgreSQL. The installer now looks for a specific file inside each database module, provided it's configured in install.php MySQL is provided by default, as it lives in sapphire
 * [rev:98543] Made ComplexTableField not use Object::create() for item and popup classes to be consistent with TableListField. These can be overridden as itemClass and popupClass are public properties on ComplexTableField
 * [rev:98373] HTTP::setGetVar() always returns absolute URLs. Use Director::makeRelative() to make them relative again.
 * [rev:98373] HTTP::setGetVar() combines any GET parameters in PHP array notation (e.g. "foo[bar]=val") instead of replacing the whole array


###  Bugfixes

 * [rev:101175] Fixed quotes around Folder::hasChildFolders() ParentID column
 * [rev:101173] Don't run click() on all inputs, but input:radio only
 * [rev:101171] Pass correct class to allowPrimaryKeyEditing in yaml fixture
 * [rev:101170] Don't recreate a missing draft page when calling SiteTree::doUnpublish()
 * [rev:101167] #5216 Installer has issues with click handlers applied to the entire li, be more specific and apply it to the label and input instead
 * [rev:101165] Fixed versioning of pages
 * [rev:101155] Prevent failed migrateVersion writes from breaking versioning system in future writes.
 * [rev:101155] MAke site tree pages go green when you save a new draft.
 * [rev:101154] #5214 ViewableData::obj() was creating a DBField without a fieldname argument and caused problems, one example is the version panel of the CMS
 * [rev:101153] Ensure that Versioned works on classes with underscores in the names. (from r100905)
 * [rev:101138] Fixed issues with broekn link tracking
 * [rev:101131] Allow classes to be referred to with casing that differs from their definition.
 * [rev:101129] Fixed FileLinkTrackingTest to cope with the empty alt="" and title="" attributes that are created
 * [rev:101127] Improved reliabilty of broken link tracking.
 * [rev:101127] Don't mark a page as changed on stage if the only thing that has changed is broken link metadata
 * [rev:101116] Flush cache after deleting an item.
 * [rev:101116] Fixed databaseFieldsOnly version of DataObject::getChangedFields()
 * [rev:101112] Fixed bugs with copying custom fields into Virtual pages, generally made virtual pages more robust and performant.
 * [rev:101110] Fixed link rewriting to work on other HTMLText fields (from r99517)
 * [rev:101109] Return true if SiteTree:doUnpublish() succeeds. (from r99515)
 * [rev:101105] Update Object::parse_class_spec() to handle arrays.
 * [rev:101099] call_user_func_array changed to PHP 5.1 compatible notation
 * [rev:101087] #5202 Installer now properly populates database configuration inputs from request after user clicks "Re-check requirements"
 * [rev:101080] Fixed TableListField->print() - was unsetting $cachedSourceItems instead of null'ing it, which breaks later access to the property
 * [rev:101068] #5199 Duplicate file uploads have odd numbering attached to end of file
 * [rev:101061] Fixed Upload and checking for size with files that don't have any extension
 * [rev:101051] Allow files with no extensions by setting File::$allowed_extensions with an empty string
 * [rev:101050] #5188 Upload and Folder don't handle the duplicate naming of files that have no extension
 * [rev:101046] Cookies set to a value other than NULL (effectively unsetting the cookie) will now use the httpOnly parameter by default for better XSS protection (from r101045)
 * [rev:101034] Fix static caching file lookup to match file generation.
 * [rev:101005] Image should pass through the title to Image_Cached so that Image::getTag() can produce a more useful alt attribute instead of just the filename (from r101003)
 * [rev:100998] column and table names now quoted properly
 * [rev:100986] Disable javascript date validation via DateField->jsValidation() if locale is not 'en_NZ" (which is the only format it validates for).
 * [rev:100985] HTMLEditorField->saveInto() can now find images with urlencoded information for resample (e.g. spaces in filenames)
 * [rev:100982] Fixed file-write testing issues in requirements combined file generation
 * [rev:100980] Remove cache for Hierarchy::AllChildren() and Hierarchy::AllChildrenIncludingDeleted(), since they increase memory usage unnecessarily.
 * [rev:100979] Don't make CMS loading slow if the combined javascript files can't be written.
 * [rev:100932] SiteTree::getSiteConfig() should always fall back to using a default if an alternate config wasn't found
 * [rev:100924] Allow DatabaseAdmin to run dev/build in live mode when not Security::is_database_ready(), and avoid broken login due to broken db queries (selecting unknown columns before dev/build) (see #4957)
 * [rev:100921] DataObject::hasValue() is now compatible with parent ViewableData::hasValue() (this also fixes E_STRICT standards in PHP)
 * [rev:100919] RequestHandler::handleRequest is now compatible with Controller::handleRequest in that SS_HTTPRequest is the type hint for the $request parameter
 * [rev:100918] ManifestBuilder::up_children() should be declared as static as it's called statically
 * [rev:100904] Produce XHTML compliant URLs in HTTP::setGetVar() by default (regression from r98373, see #5101)
 * [rev:100896] #5138: DataObjectSet::removeDuplicates() removes objects of different classes with the same ID
 * [rev:100866] #5176 Javascript error in IE for the installer - use "this" instead of e.target which doesn't work
 * [rev:100862] Use "wb" argument in ManifestBuilder fopen() calls for better cross-platform compatibility
 * [rev:100861] #5157 If paths are longer than 255 characters, fopen() produces an "Invalid argument" error, shorten the paths by using basename() instead of realpath() on the manifest filename when producing the cache path in ManifestBuilder
 * [rev:100858] Fixed notice level error with folder ID
 * [rev:100854] fixed file uploading not uploading any files at all
 * [rev:100853] Fixed jQuery.ondemand.js script to work with prototype.js (will probably need to be merged back to trunk for legacy purposes)
 * [rev:100848] Fixed variable declaration order in tabstrip.js (necessary due to changed jquery.livequery behaviour
 * [rev:100825] Added single quote as a valid local-part of an email address as per RFC5322. Other symbols still excluded although in the spec
 * [rev:100795] #5157 strftime() %F format parameter does not work on Windows - use %Y-%m-%d instead
 * [rev:100767] Date::now() supplies wrong string - it misses leading zeroes on hours
 * [rev:100763] added uniqueness id, to prevet multiple VirtuaLage reloads on publish
 * [rev:100755] TreeSelectorField doubles up on concating base_url, doesn't include the security ID (#5164, thanks marcus)
 * [rev:100747] #5099 FileIFrameField fails when using it with a locale different to the default
 * [rev:100727] allow selection of database adpater
 * [rev:100726] misspelled variable
 * [rev:100724] some sections dont have a tree at all, but they still use LeftAndMain as their base class (eg report admin). Added a guard.
 * [rev:100723] Fixed SapphireTest->loginWithPermission() and MemberAuthenticatorTest to use existing Members based on their unique_identifier_field (if existing) to accommodate recent Member->onBeforeWrite() changes (see r100705)
 * [rev:100722] reload page if broken link tracking values changed during a save. Ticket #1363
 * [rev:100721] Unsetting 'ID' parameter in MemberTableField->addtogroup() to avoid confusion between Group and Member records (regression from r100716) (from r100720)
 * [rev:100719] Fixed MemberTableField->addtogroup() to fetch existing Member records by ID or $unique_identifier_field instead of relying on the (now removed) "auto-merging" in Member->onBeforeWrite() (see r100705) (from r100716)
 * [rev:100717] Fixing Member_ProfileForm to validate for existing members via Member_Validator to avoid CMS users to switch to another existing user account by using their email address (from r100704)
 * [rev:100701] moving the ajaxupdatesort JS response code from php to js to get rid of eval. Also disable the "loading" on the moved element when we are done, in case we are repositioning other than the selected item - otherwise the progress indicator is displayed indefinitely.
 * [rev:100699] column names quoted properly
 * [rev:100693] column names quoted properly
 * [rev:100692] column names quoted properly
 * [rev:100691] column names quoted properly
 * [rev:100690] column names quoted properly
 * [rev:100689] column name capitalised
 * [rev:100688] column names quoted properly
 * [rev:100687] column names quoted properly
 * [rev:100686] the default value for decimals are now cast as (doubles)
 * [rev:100657] tables and columns now quoted properly
 * [rev:100632] Fixed SiteTree->MetaTags() to either use `<meta name=>` or `<meta http-equiv=>`, and only using the "http-equiv" attribute for valid HTTP headers (see http://www.w3.org/TR/html4/struct/global.html#edef-META) (from r100631)
 * [rev:100627] DB::getConnect() should be properly declared as a static function
 * [rev:100616] Fixed filemtime() check in Requirements_Backend::process_combined_files() not getting the right path
 * [rev:100614] Proper check for combined file path in Requirements_Backend::process_combined_files()
 * [rev:100560] #4572 Fixed Windows failure on SS_Cli::supports_colour() because posix functions are not supported
 * [rev:100548] If fixture file is NULL don't cause the test framework to break down because of it
 * [rev:100527] Set Member default Locale
 * [rev:100525] get TreeMultiselectField working with an array of items, rather than a relation.
 * [rev:100519] add 'var' to local variable 'constructor' inside of function definition which break IE8 (8.0.6001.18702 +)
 * [rev:100508] wrong constructor function name
 * [rev:100496] replacing calls to deprecated Upload functions - using validator instead (related to r100057)
 * [rev:100466] #5012 BasicAuth should check if there's already a current member logged in before asking for a login/password
 * [rev:100438] GD::setQuality() persistence issue because the GD instance is re-created instead of being cloned - thanks Tjofras!
 * [rev:100417] #5121 Fixed cache flushing for FieldSet when removing fields - thanks paradigmincarnate!
 * [rev:100415] #5136 Ensure $coverage argument to TestRunner::runTests() has a strict check before running coverage tests, as sometimes an SS_HTTPRequest object can be passed into this argument
 * [rev:100407] FormAction input tag attributes were being doubly-escaped.
 * [rev:100406] Fix mismatch with $all_locales and $common_locales (#5096)
 * [rev:100394] #5135 LeftAndMain extra requirements loading for "themedcss" should use Requirements::themedCSS() not Requirements::css() - thanks Hamish!
 * [rev:100393] YamlFixture::writeDataObject() - some databases need special allowance to edit the primary key column - do so by using DB::getConn()->allowPrimaryKeyEditing()
 * [rev:100375] Sam's fix for "Unknown column Group.SubsiteID" with new subsites
 * [rev:100370] use localized prefix to compare group codes rather than hard coded english string. MINOR: updated lang file
 * [rev:100367] PHP 5.1 requires an array rather than a string for call_user_func()
 * [rev:100359] Show Language dropdown in English (#5098)
 * [rev:100335] #5023 AssetAdmin::sync() is now used to sync tasks, as it works when the user only has access to the AssetAdmin controller instead of going to dev/tasks/FilesystemSyncTask which can only be run by administrators or if the site is in dev mode
 * [rev:100116] Fix TestRunner coverage pattern to work as documented (Fixes QA scripts too)
 * [rev:100053] SQL Error is a member is not part of any groups
 * [rev:99993] Setting default $groups in MemberTableField::AddForm() in addition to MemberTableField_Popup::__construct() - this was broken by r99777
 * [rev:99960] #2022: Fixed CMS dropdowns in Opera.
 * [rev:99952] Fix #2138, allow modification of existing images
 * [rev:99951] Fix #2138, notify Image Toolbar on TinyMCE node selection change
 * [rev:99942] action buttons always visible (not need to scroll) ticket 5051
 * [rev:99942] got rid of double scroll
 * [rev:99942] do not show action buttons (delete/save) when showing result list
 * [rev:99887] Use underscores in names of combined .js (#3581)
 * [rev:99854] Quoting keys in JSONDataFormatter to ensure valid JSON (#5119) (from r99853)
 * [rev:99850] Fix #5097, Translatable uses augmentValidURLSegment to check that URLSegment is valid
 * [rev:99843] Respect SilverStripe's cache folder
 * [rev:99818] Handle filename deduping when uploading of double-barrelled extensions and files ending in numbers better.
 * [rev:99816] Fixed the code for the unused file list, although the feature is still disabled.
 * [rev:99789] #5073: Fixed CMS version indicator for alpha and beta versions.
 * [rev:99779] make siteconfig work again
 * [rev:99777] #5087: Show default values in CTF 'add' popups.
 * [rev:99745] #3458: Don't show javascript:mctmp(0) URLs in URL editor
 * [rev:99739] tree selector base URL calculation wrong when field is nested
 * [rev:99738] #4974: Improve accuracy of ManifestBuilder::parse_file() cache, to remove a source of upgrade bugs.
 * [rev:99713] Fixed MemberTableField limiting of , wasnt taking children groups into account (regression from r99684) (from r99706)
 * [rev:99711] Setting  ID explicitly in MemberTableField-> to ensure getCsvQuery() correctly filters (the custom group filter was only implemented in sourceItems() before) (from r99684)
 * [rev:99693] Changed sitetree default selection in LeftAndMain.Tree.js to fire on window.load instead of document.ready() through entwine. We need to ensure behaviour.js bindings are available before
 * [rev:99693] Automatically selecting root node in CMS trees (necessary because now we actually have forms on the root node, and its a valid click target) (from r99605)
 * [rev:99679] really testing deletemarked now.
 * [rev:99667] Fixed bogus HTMLEditorConfig instance when get() is called without a valid identifier (due to NULL database columns) (from r99599)
 * [rev:99655] Fixed TreeMultiselectField/TreeDropdownField saving with 'unchanged' default values from constructor (from r99581)
 * [rev:99647] Fixed TreeMultiselectField->Field() to respect  settings, and give them priority over existing relations through getItems(). This is used in MemberTableField to set default groups for 'add member' popups. (from r98879)
 * [rev:99640] Fixed DataObject->fieldLabels() to respect  flag (from r98748)
 * [rev:99638] Folder::findOrMake() will create the assets/ folder if it's missing
 * [rev:99613] Fixed bug in r99552
 * [rev:99595] Fixed Access tab on SiteConfig
 * [rev:99594] Debugged and simplified Access tab javascript
 * [rev:99587] Show 'Inherit' option for edit and view all the time (since we now have SiteConfig)
 * [rev:99572] Pages that you can't edit should always be grey, even if there are unpublished changes.
 * [rev:99553] Remove buttons from display if you load a CMS page that should have no buttons - reverts bug caused by r96551 and fixes the issue it was trying to solve.
 * [rev:99552] Fixed behaviour's ID selector matching when the ID is inside another context - eg 'body.className #ID'
 * [rev:99522] Image::onBeforeDelete() now calls deleteFormattedImages() so resampled images in the filesystem are cleaned up
 * [rev:99506] use the correct method for retrieving the report ID
 * [rev:99490] tablename and columns quoted properly
 * [rev:99479] Setting ID = -1 on Security/lostpassword to avoid showing toplevel navigation (see #5086)
 * [rev:99465] Correct StaticPublisher filenames, now works with nested URLS
 * [rev:99443] batch_permission_check returns null rather than empty array when user has no permissions
 * [rev:99394] Fixed variable existence checks in setValue() in FormField::__construct() by checking for !== NULL (changed from isset($value) to $value in r99360)
 * [rev:99391] Fixed MoneyField constructor - parent (FormField) constructor calls setValue() already, which needs to happen *after* setting certain field instances
 * [rev:99342] Enforcing creation of temp database in SapphireTest->setUp() to avoid writing to production databases. This check should only kick in for single test case runs, as the temp database connection should be set in a dev/tests/all run after the first db-related test anyway. (see #5034)
 * [rev:99303] Disable some permission caching for now, as it was breaking unit tests (from r98504)
 * [rev:99302] SiteTree::batch_permission_check() doesn't recurse with ID=0 calls
 * [rev:99128] Fix not being able to print/export reports (from r98684)
 * [rev:99125] Fixed cache prepopulation on sitetree load. (from r98651)
 * [rev:99124] Make sure navigation links update when urlsegment is changed (from r98649)
 * [rev:99116] Fix navigator links not opening in new windows. (from r97510)
 * [rev:99115] Fixed bug in r97395 (from r97508)
 * [rev:99101] Take into account tablename with custom columns in get_title_sql (from r97003)
 * [rev:99100] use proper quotes for sep (from r96401)
 * [rev:99089] Only show live link when page has been published (from r97839)
 * [rev:99087] Make sure draft/published links go to the right subsite (from r97747)
 * [rev:99086] Fix navigator links not opening in new windows. (from r97510)
 * [rev:99085] Show a hand icon and better title for the 'share link' piece of the navigator toolbar. (from r97439)
 * [rev:99067] Ensure that ModelAsController::init() can trigger redirections. (from r98702)
 * [rev:99065] Fixed SiteTree_versions version numbers for published virtual pages. (from r98675)
 * [rev:99060] fixed query to get number of unmoderated comments
 * [rev:99052] Generate SiteTree_version records for VirtualPages more reliably. (from r98309)
 * [rev:99050] fix incorrect link in CMS (from r97408)
 * [rev:99049] Make sure CMS link knows when its currently in the CMS (from r97403)
 * [rev:99031] Don't show FailedLoginCount field unless Member::$lock_out_after_incorrect_logins is enabled
 * [rev:99005] Development server list should be retained when user submits installer form and gets redirected back
 * [rev:98957] fix for #5076
 * [rev:98946] the ID should be that of untranslated child (it's the middle segment that's from translated version, not the last one)
 * [rev:98944] testing framework needs to be reset to a clean state after each test: now also nested urls and redirection state will be reverted
 * [rev:98897] Fixed strpos() check in BASE_URL check
 * [rev:98895] Installer now opens if mod_rewrite is disabled. Using index.php instead of rewriting the URL didn't quite work with the new BASE_URL, so we need to take this case into account as well
 * [rev:98869] Fixed big problem on Windows when redirecting to install.php - because of SCRIPT_NAME backslashes caused a bit of havoc and need special treatment
 * [rev:98860] restore the original nested_urls state after running the test, so we can enable and disable nested URLs within the tests safely.
 * [rev:98853] Fixed URL generation in TreeSelectorField.js, was failing to detect relative URLs - prefixing with `<base>` URL as a workaround
 * [rev:98852] Added missing Requirements to TreeDropdownField->Field() and TreeMultiSelect->Field()
 * [rev:98847] modified float to have the same database table schema as int. Now defaults to zero and 'not null'
 * [rev:98777] Fixed quoting on ContentController::successfullyinstaller() - this broke certain databases like PostgreSQL
 * [rev:98776] #5053 Aggregate::query() should not set an orderby clause, otherwise databases will complain
 * [rev:98694] columns quoted properly
 * [rev:98693] Fixed ManifestBuilder::has_been_included()
 * [rev:98690] Closing TinyMCE image, link or flash panel when loading form (ticket #4907)
 * [rev:98688] Checkbox for overriding the install from environment now checks for the file existance properly
 * [rev:98678] Fixed initial state of "use environment" checkbox in installer
 * [rev:98671] fallback for changes in r98101, required if TreeDropdownField is used in a widgetarea, and does not know its field
 * [rev:98537] Fixed ManifestBuilder::get_themes() not to assume an existing themes/ folder
 * [rev:98536] Removed obsolete start argument from ComplexTableField_Item constructor.
 * [rev:98534] Make Security/login page's ID give a different number for loggedin vs loggedout, to help with partial caching
 * [rev:98520] Fix virtual pages not returning correct content
 * [rev:98448] Fixed missing third argument to ComplexTableField_Item when the parent class instantiates it
 * [rev:98434] Fixed infinite loop in FILE_TO_URL_MAPPING lookup when calling arbitrary scripts via CLI
 * [rev:98432] Make login form work without any theme loaded.
 * [rev:98403] Fixed Hierarchy->loadDescendantIdList() to call setOwner() on the extension instance. This was necessary due to underlying Object/Extension changes in 2.4.
 * [rev:98382] #5044 Hierarchy::loadDescendantIDListInto() now uses Object::getExtensionInstance('Hierarchy') instead of going through __call(), as PHP 5.3 has issues converting references to values
 * [rev:98373] HTTP::setGetVar() uses parse_url() and http_build_query() to add query parameters to an existing URL, instead of doing its own regex-based parsing. This means existing GET parameters are correctly url encoded.
 * [rev:98324] Fixed ContentController->deleteinstallfiles (added to $allowed_actions, see #5040)


###  Minor changes

 * [rev:101172] Fix output format of buildbot test runs to not include colour control codes.
 * [rev:101166] versioning test for SiteTree
 * [rev:101135] Fixed multifile.js non-standard forEach() reference, using jQuery.each() instead
 * [rev:101134] Localized "dependent pages" features in SiteTree->getCMSFields()
 * [rev:101132] Fixed test that was relying on bug fixed in r101116
 * [rev:101117] Fixed test that was relying on bug fixed in r101116
 * [rev:101111] Fixed wrong default value for AssetAdmin (see r101106)
 * [rev:101107] Documentation relating to r101106
 * [rev:101106] Disabled metadata upload in AssetAdmin by default, configurable through AssetAdmin::$metadata_upload_enabled. Feature needs UI review.
 * [rev:101091] Use castingHelper() rather than castingHelperPair() to look for a field presence.
 * [rev:101076] Fixed merge error from r99117
 * [rev:101071] Updated lang files
 * [rev:101070] Fixed PermissionCheckboxSetField.js checkbox toggling when no previous values have been saved through jQuery.data()
 * [rev:101062] Fixed permission language code regression
 * [rev:101057] Improved wording of SQLite installer
 * [rev:101055] No need for a ternary for in_array check in Upload::isValidExtension()
 * [rev:101053] Update function doc for Upload::isValidExtension()
 * [rev:101052] phpDoc change for Upload
 * [rev:101025] tests can now require default records on classes
 * [rev:100992] Removed unused variable in SiteTree::MetaTags()
 * [rev:100991] UploadTest now cleans up after itself when it creates a custom folder relative to assets
 * [rev:100990] Added tests for Upload_Validator/UploadTest_Validator for allowed extensions validation
 * [rev:100988] Updated required version to 5.1 in php5-required template
 * [rev:100978] Removed whitespace from "Development servers" textarea for installer
 * [rev:100975] Updated r100966 to include spaces on ternary operator for readability and coding conventions
 * [rev:100974] Adjusted CMSMain->getRootForm() to SiteConfig API changes
 * [rev:100967] Renamed SiteTree->getEditFormFields() to getCMSFields() (including new decorator hook for 'updateCMSFields'). Renamed SiteTree->getEditFormActions() to getCMSActions() (including new decorator hook for 'updateCMSActions'). Old API was never released
 * [rev:100965] Fixed "disabled" styling for database options in config-form.html (showed all as green when "use _ss_environment" was ticked
 * [rev:100950] Correction on email address validator, and a unit test for EmailField php validation
 * [rev:100946] Added jQuery requirement to TreeDropdownField (see #5139)
 * [rev:100940] Changed `<div>` hierarchy in config-form.html to allow right-aligned help texts which horizontically align with their respective field sets on the left.
 * [rev:100922] Fixed phpDoc argument in ViewableData::hasValue()
 * [rev:100898] Changed the way DatabaseAdapterRegistry accepts databases
 * [rev:100893] Updated languages in cms from translate.silverstripe.org
 * [rev:100892] Updated languages in cms from translate.silverstripe.org
 * [rev:100891] Updated sapphire/ lang files
 * [rev:100890] Updated cms/ lang files
 * [rev:100888] Using jquery.live instead of livequery in MemberImportForm.js
 * [rev:100887] Using jquery.live and behaviour.js instead of livequery in ModelAdmin.js
 * [rev:100886] Using jquery.live instead of livequery on ImageFormAction.js
 * [rev:100885] Using Behaviour.register instead of jquery.livequery in TabSet.php/tabstrip.js (already replaced with jQuery.entwine in next release, we try to reduce the dependencies to jquery plugins)
 * [rev:100883] SilverStripeNavigator.js used jquery.live instead of livequery, and doesn't include unnecessary behaviour.js
 * [rev:100851] Fixed jquery-ui paths in FileIframeField
 * [rev:100850] Fixed jQuery selector in TreeSelectorField.js to fit jQuery 1.4 syntax
 * [rev:100843] Added jQuery UI license files
 * [rev:100832] Supress notice if $_REQUEST['url'] doesn't exist in Debug::showError()
 * [rev:100801] removed sqlite msg
 * [rev:100799] Moved Permission->requireDefaultRecords() to Group->requireDefaultRecords() and Member->requireDefaultRecords().
 * [rev:100799] Removed outdated checks for CanCMS and CanCMSAdmin from Permission->requireDefaultRecords()
 * [rev:100791] Using PermissionCheckboxSetField.js instead of MemberTableField.js
 * [rev:100790] Moved PermissionCheckboxSetField specific javascript logic from MemberTableField.js to new sapphire/javascript/PermissionCheckboxSetField.js file
 * [rev:100789] Improved help texts around permissions
 * [rev:100784] Improved help texts around permissions
 * [rev:100783] Improved help texts around permissions
 * [rev:100775] Fixed regression from r100774
 * [rev:100774] Added getParentController() to TableListField_ItemRequest and ComplexTableField_Popup
 * [rev:100774] Extending ComplexTableField_ItemRequest from TableListField_ItemRequest to avoid redundant code
 * [rev:100772] dont copy embargo or expiry to virtual page
 * [rev:100771] Setting PermissionRole $singular_name and $plural_name
 * [rev:100770] Removed "only advanced users" notice in Group->getCMSFields() - this field is now sufficiently useable for all admins with access to admin/security without knowing about permission codes
 * [rev:100740] Added more allowed extensions to File::$allowed_extensions
 * [rev:100732] make cache header clearer
 * [rev:100697] remove the sqlite databases from the installer list.
 * [rev:100670] Director::currentPage() is deprecated but shouldn't throw a notice-level error until the next major release.
 * [rev:100669] Added note about other databases
 * [rev:100626] BasicAuth - removed unncessary extending of Object since this class only has a bunch of static functions
 * [rev:100625] Cookie - removed unncessary extending of Object since this class only has a bunch of static functions
 * [rev:100624] Convert - removed unncessary extending of Object since this class only has a bunch of static functions
 * [rev:100623] ArrayLib - removed unncessary extending of Object since this class only has a bunch of static functions
 * [rev:100622] When the installer is using the environment for configuration, disable the development servers textarea as it's automatically configured from environment
 * [rev:100618] Removed double slashes from path in Requirements_Backend::process_combined_files()
 * [rev:100615] Requirements_Backend::process_combined_files() only needs one location where the combined file is
 * [rev:100552] Wording change in installer for database details not correct
 * [rev:100550] Fixed undefined variable $error in MySQLDatabaseConfigurationHelper
 * [rev:100537] Removed underscores from combined files in LeftAndMain, made redundant by r100536
 * [rev:100534] Reverted default location for combined JS/CSS as you can't customise this easily
 * [rev:100533] Removed Requirements:: static call and replace with instance
 * [rev:100530] LeftAndMain combined files don't need to be prefixed with "assets" because default combined folder is set in sapphire/_config.php
 * [rev:100517] Removed whitespace
 * [rev:100514] Removed end php tag for Requirements and RequirementsTest
 * [rev:100513] Updated RequirementsTest to test Requirements_Backend instead of global statics
 * [rev:100511] can always create top level if admin
 * [rev:100499] Made Upload::load() error more useful
 * [rev:100491] Fixed tabbing in DataObjectSet
 * [rev:100487] Changed places of Object::extInstance() to Object::getExtensionInstance() and added a notice if extInstance is used in future
 * [rev:100486] Pushed @deprecated 2.3 items out to 2.5 since they're still in use for now
 * [rev:100485] Reverted r100484 as it was causing too many problems
 * [rev:100484] Replaced locations of Director::is_ajax() and Director::redirectBack() with instance method calls - the latter static function is deprecated
 * [rev:100483] Changed @deprecated note for Director::redirectBack to 2.5 as it's still widely used
 * [rev:100461] Fixed regression of Convert::json2obj() not working when json_decode() is being used
 * [rev:100424] phpDoc bits for Convert Services_JSON functions
 * [rev:100423] Added unit tests for Convert JSON functions
 * [rev:100418] Use "email" instead of username for validation of admin account during install
 * [rev:100409] Geoip class no longer extends Object, as it's not necessary
 * [rev:100387] Updated installer to use "CMS / Framework" instead of just "CMS"
 * [rev:100387] Updated copyright year to current year
 * [rev:100372] added lang file for cs_CZ
 * [rev:100360] add extendability to SecurityAdmin
 * [rev:100323] correct order of OBW
 * [rev:100032] added Rfc2822 method to SS_Datetime. Fixed bug where dates in DataObject would not set times.
 * [rev:100008] LastEdited/Created dates are now mockable via SS_Datetime
 * [rev:99957] Reverted r99843 - we're not modifying thirdparty dependencies
 * [rev:99862] Reinstated UploadTest
 * [rev:99823] Reverted r99522 as this will cause problems if File records are deleted when the resampled images are linked to in the content fields
 * [rev:99801] Added Group->CMSTreeClasses() (required for GroupCsvBulkLoader refresh in SecurityAdmin)
 * [rev:99753] Cleaned up tabbing and code formatting in automated task classes
 * [rev:99750] More tests for array data
 * [rev:99715] Fixed OptionsetField->disabledItems omission from r99596 (from r99708)
 * [rev:99714] Fixed MemberTableField regression from r99706 (from r99710)
 * [rev:99689] Fixed height of MemberTableField 'Groups' tab to allow enough room for TreeMultiSelectField expansion (from r98883)
 * [rev:99687] Moved generic .TreeDropdownField styling from cms/css/cms_right.css to sapphire/css/TreeDropdownField.css (from r98881)
 * [rev:99686] Moved ul.tree rules from cms/css/cms_left.css to sapphire/javascript/tree/tree.css (particularly around multiselect tickbox styling) (see r98854) (merged from r98855) (from r98865)
 * [rev:99668] Placing 'ADMIN' permission in new 'Administrator' group at the top of the permissions list (from r99601)
 * [rev:99663] Localized strings in PermissionCheckboxSetField (from r99590)
 * [rev:99660] Re-adding support for Group and PermissionRole records in PermissionCheckboxSetField
 * [rev:99657] Using localized titles for permission formfields in PermissionRole and Member (from r99583)
 * [rev:99656] Using TreeMultiselectField instead of MemberTableField->relationAutoSetting in Group->getCMSFields() (from r99582)
 * [rev:99654] Added ComponentSetTest (from r99580)
 * [rev:99646] Moved generic .TreeDropdownField styling from cms/css/cms_right.css to sapphire/css/TreeDropdownField.css
 * [rev:99646] Fixed .TreeDropdownField styling (borders and margins) in TreeDropdownField.css (was assumed to be inherited from LeftAndMain/CMS stylesheets) (from r98878)
 * [rev:99645] Added MemberCsvBulkLoaderTest->testCleartextPasswordsAreHashedWithDefaultAlgo() (from r98841)
 * [rev:99644] Allow custom TitleText on TableListField_Item.ss  (e.g. to show a description of the 'delete' button) (from r98828)
 * [rev:99641] Setting new 'inlineadd' permissions on MemberTableField instance in Group->getCMSFields() (from r98827)
 * [rev:99497] add pass thru group and sort methods
 * [rev:99492] Fixed SapphireTest->logInWithPermission() spelling
 * [rev:99491] Fixed SapphireTest->logInWithPermission() spelling
 * [rev:99363] Using DateField in CMSMain->SiteTreeFilterDateField(), as CalendarDateField is now deprecated
 * [rev:99362] Moved cms specific styling in CalendarDateField.css to cms/css/cms_right.css
 * [rev:99359] Moved cms specific styling in CalendarDateField.css to cms/css/cms_right.css
 * [rev:99350] Temporarily disabled nested url specific cases inTranslatableTest->testAlternateGetByLink(), unclear functionality requirements
 * [rev:99347] Fixed FilesystemPublisherTest to have self-contained extension settings, and not rely on static publishing being enable in mysite/_config.php already. Fixed login permissions for doPublish() calls in test case.
 * [rev:99178] Moved timezone coupling in SS_Report labels into timezoneawareness module
 * [rev:99137] Localized reports
 * [rev:99130] Fixed merge error (see r99114)
 * [rev:99127] Bugfix in previous commit (from r98660)
 * [rev:99126] refactored setting/getting strict hierarchy setting. (from r98654)
 * [rev:99123] don't load a report by default (from r98561)
 * [rev:99122] don't remember what report you had selected in ReportAdmin (from r98560)
 * [rev:99121] more unit tests around loose hierarchy (from r98509)
 * [rev:99120] added LiveURLSegment to ignored field in change detection (from r98494)
 * [rev:99118] fixed two reports with links that did not open in new windows (from r97816)
 * [rev:99113] add the ability to link-check the live table too (from r89473) (from r95310)
 * [rev:99112] pingStatus ping frequency reduced
 * [rev:99112] updated lang file for SiteConfig
 * [rev:99112] improved documentation in StaticPublisher
 * [rev:99112] improved documentation in CMSMain surrounding reports and siteconfig
 * [rev:99112] migrated headers in SiteConfig to i18n'd (from r86429)
 * [rev:99111] Localized File->uploadMetadataFields()
 * [rev:99110] Documentation
 * [rev:99099] ability to customize the text that comes out of Member->Title
 * [rev:99099] updated workflow reports (from r96352)
 * [rev:99098] Added Requirements for SilverStripeNavigator (see r99080)
 * [rev:99097] Added Requirements for SilverStripeNavigator (see r99080)
 * [rev:99081] Partially reverted r99079 - SiteTree->getNavigatorItems() was refactored to SilverStripeNavigator::get_for_record()
 * [rev:99076] make static caching smarter around cacheSubdirs
 * [rev:99068] adjustments to ensure that the cached permissions were actually hit (from r98835)
 * [rev:99064] refactored setting/getting strict hierarchy setting. (from r98654)
 * [rev:99062] more unit tests around loose hierarchy (from r98509)
 * [rev:99059] added enforce_strict_hierarchy option, and tests around not cascading deletions (from r98498)
 * [rev:99057] reload the virtual page if you are looking at the current one on save. To prevent overwriting fields (from r98496)
 * [rev:99009] force a specific cache subdirectory
 * [rev:99008] disable real-time static publishing
 * [rev:98980] fix typo
 * [rev:98898] Added brackets around strpos() check just to be sure it works
 * [rev:98872] Fixed clearing issue in installer that was recently removed
 * [rev:98855] Moved ul.tree rules from cms/css/cms_left.css to sapphire/javascript/tree/tree.css (particularly around multiselect tickbox styling) (see r98854)
 * [rev:98854] Moved ul.tree rules from cms/css/cms_left.css to sapphire/javascript/tree/tree.css (particularly around multiselect tickbox styling)
 * [rev:98800] Removed return of connection and changed variables to conincide with r98795
 * [rev:98792] Removed whitespace in textarea value that caused an empty string in the development servers list in installer (regression from recent change)
 * [rev:98781] Styling on installer
 * [rev:98733] Defensive scripting in LeftAndMain.Tree.js (merged from r98709)
 * [rev:98713] Re-enabled CsvBulkloaderTest cases, were disabled by accident (merged from r94250)
 * [rev:98679] Reverted broken variables in installer for checking environment
 * [rev:98670] Install template cleanup
 * [rev:98668] Styling for help text in the installer
 * [rev:98667] Styling fixes for installer
 * [rev:98666] Tidy up of install template
 * [rev:98662] Changed config-form to HTML 4.01 and validated the page minus a few issues with the form field placement
 * [rev:98643] disable form fields if they are set from _ss_environment. See #5054
 * [rev:98544] Removed useless third argument to instantiation of itemClass in TableListField::generateExportFileData()
 * [rev:98538] Fixed caching of login page for tests
 * [rev:98519] Renamed manifest test temp dir as there was some kind of conflict
 * [rev:98480] Removed double brackets from Diff::cleanHTML()
 * [rev:98477] Fix documentation for Diff::cleanHTML
 * [rev:98433] Speed up cache test (1s is as good a test expiry as 8s)
 * [rev:98427] Fixed SiteTreeBacklinksTest on Windows
 * [rev:98409] Fixed HTTPTest->testSetGetVar()
 * [rev:98407] Fixed HTTPTest->testSetGetVar()
 * [rev:98404] Partially reverted r98382 which added unnecessarily defensive checking to Hierarchy->allChildren()
 * [rev:98403] Fixed HierarchyTest assertions around including grand children counts
 * [rev:98390] Removed argument to getDescendantIDList() in ThumbnailStripField that doesn't exist on the method
 * [rev:98383] Fixed HTTPTest when invoked through dev/tests/all or with GET parameters (see r98373)
 * [rev:98376] Testing of grand-children items in HierarchyTest::testLoadDescendantIDListIntoArray() and HierarchyTest::testNumChildren()
 * [rev:98372] Documentation
 * [rev:98370] Fixed test case name in Hierarchy
 * [rev:98369] Added test case for Hierarchy::getDescendantIDList() which also tests Hierarchy::loadDescendantIDListInto()
 * [rev:98341] Removed arguments to Hierarchy::getDescendantIDList() calls, as the method does not have any
 * [rev:98326] Make pass use a password field, dont require call by reference (merged from r72930)
 * [rev:98321] Use 'b' mode for fopen() where possible for better portability
 * [rev:98282] fixed setName()


###  Other

 * [rev:99952] via Image panel, and keep proportions when changing size
 * [rev:99952] in text input boxes.
 * [rev:99849] Uses $this->extend('augmentValidURLSegment')
 * [rev:99849] so that (for instance) Translatable can hook this.
 * [rev:99848] Revert "FEATURE: Use tidied HTML in DataDifferencer"
 * [rev:99848] 
 * [rev:99848] This reverts commit a0d2f7b3e289d12dedcdbd02ae52eec3e6718340.
 * [rev:99732] BUFGFIX: Prevent selection of self as parent (see #5106)
 * [rev:99084] Add missing JS file (from r97410)
 * [rev:98873] REVERT: reverse merging the change, it breaks some tests.