# 2.4.0-beta1 (2010-01-29)

## Changelog

###  Overview

 * Support for SQLite and PostgreSQL databases (via separate module)
 * Partial caching in templates, to allow for faster load times of certain aspects in dynamic pages.
 * Upload controls in the CMS no longer require the Adobe Flash plugin, and work again on Mac OSX.
 * File and page dropdown selections support inline searching, to make handling larger tree structures easier.
 * Fixed password hashing design flaw, which makes SilverStripe databases more portable between different server architectures.
 * Improved reporting API to unify the CMS sidebar reports and full-page reports on their own section. Its easier to add custom filters to reports.
 * Batch action handling handles larger tree structures, provides better visual feedback, and respects permissions on individual pages.
 * Global site configuration is translatable, meaning titles for your website can be in different languages without any switching in your templates.
 * Allow selection of themes through the site configuration interface (in addition to changing the theme via configuration code)
 * More fine-grained translation permissions: A group can be limited to only edit a certain language in the CMS.
 * Added dropdown to choose from existing anchor links when inserting a link from the CMS sidebar.
 * Team members can get permissions to see the draft version of a page in preview mode without requiring CMS access.
 * Pages of type "Virtual Page" have improved stability in regards to their permission control, translation and publication.
 * Improved broken link detection (''talk to Andy for more info'')
 * Removed the jsparty/ toplevel folder, and moved all its dependencies into sapphire/thirdparty and cms/thirdparty
 * More than 350 bugfix and enhancement commits, and 200 minor changes.

###  Features and Enhancements

 * [rev:98268] Moved the log-in validation process from individual authenticators into Member->checkPassword() and canLogIn(), to allow more extensibility and control (trunk, 2.4).
 * [rev:98219] roll batch permissions in to a generic function (from r97748)
 * [rev:98211] batchactions can now implement confirmationDialog() to provide a custom confirmation dialog to the front end.
 * [rev:98180] Allow for custom generation of SSReport::ID() for parameterised reports.
 * [rev:98179] Removed broken links reports from sidebar (in anticipation of adding them to the main reporting area) (from r95954)
 * [rev:98173] Improved look and feel for report filtering
 * [rev:98165] Performance improvement to CMS load time with many pages. (from r95490)
 * [rev:98159] added canAddTopLevel permission to SiteConfig to determine which users/groups can add pages to the root of the sitetree. (from r87279)
 * [rev:98156] audit trails
 * [rev:98156] ability to parameterize SSReport's (from r85903)
 * [rev:98132] Allow sort descending as well as ascending. (from r96054)
 * [rev:98110] Allow user theme selection through SiteConfig, falling back to SSViewer::set_theme() as a default if there are none selected
 * [rev:98104] Improved TableListField header styling. (from r96028)
 * [rev:98102] Add a function to give link to Live site (from r95948)
 * [rev:98091] ManifestBuilder::get_manifest_info() now uses ManifestBuilder::get_themes() instead of doing it's own retrieval of available themes
 * [rev:98080] Removed dev/reset, instead encouraging the use of dev/tests/startsession for tests.
 * [rev:98080] Let people use dev/tests/startsession without a fixture, instead calling requireDefaultRecords
 * [rev:98041] added support for MySQL data type SET used in MultiEnum FEATURE: added datetime helper functions
 * [rev:98025] add 'view site tree as' functionality.
 * [rev:97896] 2.4 tickets (#4670) new permission code to view draft w/o CMS access
 * [rev:97895] 2.4 tickets (#4670), new permission code to view draft stage w/o CMS access
 * [rev:97819] Allow ungrouped retrieval of Permission::get_codes() through new $grouped switch
 * [rev:97793] removed the situation, when the user is left with empty search box and empty dropdown.
 * [rev:97792] use Validator::get_javascript_validator_handler() to check if the handler is turned on before doing either js or php validation
 * [rev:97765] Select the uploaded image after uploading by default. #4962
 * [rev:97745] adapt the page dropdown based off the allowedChildren values
 * [rev:97606] Added hover states to "Available widgets" boxes in the CMS for usability
 * [rev:97602] Added visual elements to aid in the usability of the WidgetAreaEditor
 * [rev:97601] CMS Editor Upload panel now loads the root files directly and allows the user to upload to the root assets dir
 * [rev:97597] Changed menu title from "Site Content" to "Pages" to be consistent with other menu labels
 * [rev:97597] Changed tree root node in CMS to get title from SiteConfig rather than defaulting to "Site Content"
 * [rev:97597] Changed tree panel headline in CMS from "Site Content and Structure" to "Page Tree" to stay consistent with new CMS menu title
 * [rev:97583] Don't set up the test db if database tests aren't being run. From: Sam Minnee
 * [rev:97530] Adjusted "Available Widgets" column to be narrower than "Widgets currently used", allowing more space for configuring widgets
 * [rev:97478] Member->requireDefaultRecords() no longer creates a default administrator based on $_REQUEST data. Moved functionality into Installer->install()
 * [rev:97436] Updated Member->getMemberFormFields() to use scaffolding and to be in line with Member->getCMSFields(). From: Andrew Short  (from r97401)
 * [rev:97391] Add partial caching support to SSViewer.
 * [rev:97390] Add aggregate calculation to DataObject, allowing (cached) calculation of Max, Min, Count, Avg, etc
 * [rev:97389] Add cache factory that provides nice API over top of Zend_Cache
 * [rev:97370] Allowing translation of SiteConfig (including toplevel permission groups)
 * [rev:97207] Added ContentController->ContentLocale() to allow XHTML/HTML specific lang= attribute settings in custom template code (see #4858). Removed `<meta http-equiv="Content-Language"...>` tag in SiteTree->MetaTags().
 * [rev:97207] Updated blackcandy theme to use new $ContentLocale attribute to set the locale of the current page (in Page.ss)
 * [rev:97192] Added RestfulService::set_default_proxy() and RestfulService->setProxy() (#4637, thanks hamish)
 * [rev:97031] upgrading the search functionality of the TreeDropdownTree with pluggable search function
 * [rev:97028] include menu title in default search. PATCH via lubzee #4508
 * [rev:97024] added Session::clearAll() functionality. ENHANCEMENT: Added Unit Tests covering Session API. MINOR: Tided up formatting in session class and included doc comments for API level documentation
 * [rev:97018] Use tidied HTML in DataDifferencer
 * [rev:97017] Try to tidy HTML using external libraries if available
 * [rev:97011] Added TabIndex to FormActions. Ticket: #4905. PATCH: via keeny
 * [rev:96821] Added applicable pages checks to delete from live, delete from draft, and publish (from r94775)
 * [rev:96820] Added 'greyed out' status of batch action checkboxes while applicable pages are being loaded via ajax. (from r94774)
 * [rev:96819] Update the checkboxes available to batch-actions to show only the applicable pages for that particular action.
 * [rev:96800] Let LeftAndMain subclass canView() methods optionally redirect. (from r90018)
 * [rev:96793] Renamed Author column to User in the page version history to better reflect that they might not have been authors, and just iniators of workflow actions. (from r89015)
 * [rev:96792] Added new onRenameLinkAsset() handler to static publishing for better link rewriting. (from r89014)
 * [rev:96778] Files and images section warns if you are deleting a file that is linked to
 * [rev:96752] Recognise HTTP_X_FORWARDED_HOST header and use that in place of HTTP_HOST (from r93148)
 * [rev:96668] Change to TreeDropdownField, giving it filtering behaviour as described in ticket http://open.silverstripe.org/ticket/3007 . Its disabled by default for legacy compatibility, but enabled for HtmlEditorField so that link editor is filterable for local links, via an extra boolean parameter on TreeDowndownField.
 * [rev:96440] Add onLoad callback handler CMSLoadFunctions
 * [rev:96049] Added Date::Rfc3339() for returning an RFC 3339 valid date format (from r96010)
 * [rev:95418] added delete all link to page comments. Patch via #4427. Thanks walec51
 * [rev:95194] added translatable support to mathspamprotection. PATCH via noini (#4755)
 * [rev:94887] added several tests for PermissionCheckboxSetField, PermissionRole and Group
 * [rev:94515] Improved layout of altercation message when called via CLI. Patch via simon_w #4373
 * [rev:94423] Allow passing in an Exception object to SS_Log::log() in addition to an array describing the error context (line number, file, trace etc)
 * [rev:94381] Added FunctionalTest::findAttribute() as a helper for getting an attribute from a SimpleXMLElement object by it's name
 * [rev:94297] Added DataObjectSet::emptyItems() to remove all the items from the set - this is useful for when you are augmenting CMS and front end fields via updateCMSFields() and updateFrontEndFields() on a DataObjectDecorator
 * [rev:94063] Added MultipleOf and Modulus methods to ViewableData - useful for templating work
 * [rev:94062] Loading of tinymce_ssbuttons plugin via relative paths in HtmlEditorConfig rather than using the plugin name as a path spec  (see r94060)
 * [rev:94060] Added support for loading external plugins (with relative paths) in HtmlEditorConfig. This means relative paths can be separate from the plugin name, and fixes a bug where paths containing dashes were ignored by TinyMCE.init().
 * [rev:94060] Changed sapphire/thirdparty/tinymce-advcode to use the original plugin name, and specify its relative path through HtmlEditorConfig instead.
 * [rev:93771] Added  parameter to DBLocale->Nice()
 * [rev:93771] Added DBLocale->getNativeName()
 * [rev:92879] Allowing to hide certain permission from showing in SecurityAdmin? through add_hidden_permission() (refactored from r92428) (from r92866)
 * [rev:91576] Pluggable password encryption through PasswordEncryptor class (#3665) (merged from r90949)
 * [rev:91496] added ability to upload images from site content pane. Merged via r9130, r91347, r91350, r91480


###  API Changes

 * [rev:98373] HTTP::setGetVar() always returns absolute URLs. Use Director::makeRelative() to make them relative again.
 * [rev:98373] HTTP::setGetVar() combines any GET parameters in PHP array notation (e.g. "foo[bar]=val") instead of replacing the whole array
 * [rev:98224] Refactor Versioned so a single state is kept for stage, archived date, or any module specific reading modes (from r98161)
 * [rev:98215] Introduced new API for SS_Report
 * [rev:98191] Added SideReportWrapper to help you tailor report columns for the side reports.
 * [rev:98191] Allow use of 'casting' option on side report columns.
 * [rev:98191] Make 'title' optional on side report columns. (from r96272)
 * [rev:98176] Removed SideReport class, use SSReport as the base-class for them instead.
 * [rev:98176] Use SSReport::register(SideReport) to explicitly register reports on the LHS of the content view.
 * [rev:98175] Added explicit registration of reports with SSReport::register() (from r95857)
 * [rev:98159] Security::permissionFailure(); will no longer tell the client side JS to show the login box if the user is already logged in
 * [rev:98101] Allow passing of an explicit map of dropdown items to a TreeDropdownField.
 * [rev:98096] Refactored test for whether a SQLQuery can be sorted by a particular column into SQLQuery::canSortBy($fieldName) (from r95850)
 * [rev:98056] Decimal now allows setting a default value properly
 * [rev:97996] rename the class "Cache" to "SS_Cache" (ref ticket: #4997)
 * [rev:97827] Added cancelSchemaUpdate() and doesSchemaNeedUpdating() to the Database class
 * [rev:97819] Removed $blankItemText parameter from Permission::get_codes()
 * [rev:97818] Removed Member::init_db_fields(), its no longer needed due to the Member.PasswordEncyrption property changing from an ENUM to Varchar.
 * [rev:97797] Fixed i18n _t() calls without namespaces in template includes: They now default to setting the include filename as namespace, rather than the including template (#4915, #3400 - thanks Henk_Poley, jwalsoe, walec51)
 * [rev:97731] Determine default BASE_PATH/BASE_URL from the __FILE__ content, so that the script that initiated the Sapphire process doesn't matter.  This means that index.php doesn't need to manipulate those variables.
 * [rev:97582] #4929: Add $class argument to DataObjectDecorator::extraStatics()
 * [rev:97489] removed SWFUpload. Refactored Content Editors uploader to use standard uploader.
 * [rev:97478] Security::setDefaultAdmin() no longer writes credentials to any Member database records (created through Security::findAnAdministrator(). This prevents outdated credentials when setDefaultAdmin() code changes after creating the database record (see #4271)
 * [rev:97478] Security::findAnAdministrator() no longer sets 'Email' and 'Password' properties on newly created members. Removed the $username and $password argments from the method.
 * [rev:97475] Moved GSTNumberField from sapphire/forms to new 'formfields_nz' module
 * [rev:97474] Moved BankAccountField from sapphire/forms to new 'formfields_nz' module
 * [rev:97270] Unique_identifier now accepted as the login requirement, allowing alternatives to 'Email'
 * [rev:97207] Deprecated ContentController->LangAttributes(). Use ContentLocale() instead and write attribute names suitable to XHTML/HTML templates directly in the template.
 * [rev:96988] #3600 Inconsistency in File::getURL() which returns an absolute URL, when it should be relative - please use getAbsoluteURL() instead for old behaviour
 * [rev:96988] #3600 Image no longer has an explicit getURL() method, instead it inherits getURL() from File which returns a relative URL
 * [rev:96824] Added capability for batch actions to indicate failure through red checkboxes (from r94868)
 * [rev:96823] Added canView() to CMSBatchAction so that you could hide certain batch actions from some users. (from r94846)
 * [rev:96821] Added applicablePagesHelper to CMSBatchAction to ease the process of creating new applicable page methods.
 * [rev:96819] Allow for an applicablePages($idArray) method to be defined on a CMSBatchAction class. (from r94761)
 * [rev:96810] Added FilesystemPublisher::getExistingStaticCacheFiles(), to help build caching logic methods. (from r91354)
 * [rev:96809] Added numChildrenMethod argument to LeftAndMain::getSiteTreeFor()
 * [rev:96756] Added canDeleteFromLive permission to SiteTree, separate from canPublish (from r93315)
 * [rev:96751] Define VirtualPage::isPublishable() so that people know not to even request publication if it's not allowed. (from r93098)
 * [rev:96749] Added DataObjectDecorator::cacheKeyComponent() to ensure that the cached behind DataObject::get_one() is appropriately specific (from r93095)
 * [rev:96739] Added Hierarchy::numHistoricalChildren() and Versioned::get_including_deleted_query()
 * [rev:96739] Added numChildrenMethod arg to getChildrenAsUL, markPartialTree, markChildren, markingFinished
 * [rev:96734] Don't generate TestOnly DataObjects in the database immediately; instead let test developers specify them in SapphireTest::$extraDataObjects.
 * [rev:96734] Added SapphireTest::resetDBSchema() (from r90054)
 * [rev:96727] Renamed SapphireTest::set_up_once/tear_down_once to setUpOnce/tearDownOnce, and made them instance methods.
 * [rev:96727] Added SapphireTest::$illegalExtensions and SapphireTest::$requiredExtensions for making tests depending on particular extension sets (from r89958)
 * [rev:96725] Moved popupdatetimefields to pop up below the text field instead of next to the icon. (from r89914)
 * [rev:94430] Group::addByGroupName() now creates the group if one does not already exist (from r83010)
 * [rev:94178] Renamed ViewableData->SecurityID() to getSecurityID() in order to get its value loading through Form->loadDataFrom()
 * [rev:94062] Changed cms/javascript/tinymce_ssbuttons plugin name to "ssbuttons" (see r94060)
 * [rev:94062] Changed cms/javascript/tinymce_ssmacron plugin name to "ssmacron" (see r94060)
 * [rev:93785] removed Director::Link(). Use Controller::join_links() instead
 * [rev:93693] removed deprecated RestrictedText fields
 * [rev:93687] removed deprecated LeftAndMain::add_menu_item. Use CMSMenu::add_menu_item()
 * [rev:93685] removed deprecated extend calls (r93632). API CHANGE: removed fieldExists(). Use hasField() (r93633). API CHANGE removed listOfFields() (r93647). API CHANGE: removed Tag() and URL() from Image. Use getTag() and getURL(). BUGFIX: updated Image.php to use getTag() (r93639, r93646). API CHANGE: removed val(). Use XML_val() (r93650). API CHANGE: removed $add_action. Use singlar_name or lang tables (r93658). API CHANGE: removed ConfirmedFormAction (r93674). API CHANGE: removed ajax_render on CTF (r93679).
 * [rev:93660] Removed ComponentSet::removeByFilter() since it's not flexible enough and fixed calls to this from HtmlEditorField::saveInto() to use custom code instead
 * [rev:93640] Removed deprecated static function ContentNegotiator::disable() - it's disabled by default
 * [rev:92878] Refactored hiding of Permissions added in r92428. Added PermissionCheckboxSetField?->setHiddenPermissions() (from r92865)
 * [rev:92428] add the ability to remove some permissions specified by their code in the rendered field html of PermissionChecksetBoxField and full-covered unit tests of this ability.
 * [rev:91612] Replaced BasicAuth::enable() with BasicAuth::protect_entire_site()
 * [rev:91612] BasicAuth::requireLogin() no longer has an option to automatically log you in.  You can call logIn() on the object returned, instead. (from r91603)
 * [rev:91576] Deprecated Security::encrypt_passwords() (merged from r90949)
 * [rev:91576] Deprecated Security::$useSalt, use custom PasswordEncryptor implementation (merged from r90949)
 * [rev:91576] Removed Security::get_encryption_algorithms() (merged from r90949)
 * [rev:91576] MySQL-specific encyrption types 'password' and 'old_password' are no longer included by default. Use PasswordEncryptor_MySQLPassword and PasswordEncryptor_MySQLOldPassword
 * [rev:91576] Built-in number of hashing algorithms has been reduced to 'none', 'md5', 'sha1'. Use PasswordEncryptor::register() and PasswordEncryptor_PHPHash to re-add others. (merged from r90949)


###  Bugfixes

 * [rev:98403] Fixed Hierarchy->loadDescendantIdList() to call setOwner() on the extension instance. This was necessary due to underlying Object/Extension changes in 2.4.
 * [rev:98382] #5044 Hierarchy::loadDescendantIDListInto() now uses Object::getExtensionInstance('Hierarchy') instead of going through __call(), as PHP 5.3 has issues converting references to values
 * [rev:98373] HTTP::setGetVar() uses parse_url() and http_build_query() to add query parameters to an existing URL, instead of doing its own regex-based parsing. This means existing GET parameters are correctly url encoded.
 * [rev:98324] Fixed ContentController->deleteinstallfiles (added to $allowed_actions, see #5040)
 * [rev:98272] Don't force SSL when running from CLI
 * [rev:98265] Don't register member IDs that don't exist in the DB as being logged in.
 * [rev:98263] Updated SiteConfig-based theme selection to remove inappropriate coupling from SSViewer
 * [rev:98257] Check for SubsiteReportWrapper class, not Subsite, so the CMS still works with older versions of Subsites
 * [rev:98252] allow all characters in the anchor's name attributes
 * [rev:98226] Fixed side report seelctor
 * [rev:98221] Let ModelAsController::init() extensions trigger redirections. (from r97767)
 * [rev:98218] More fixes renaming SSReport to SS_Report
 * [rev:98217] Don't allow translations of VirtualPage (until we can reliably copy data between locales) (see #5000)
 * [rev:98205] Better broken reason sorting (from r96989)
 * [rev:98204] Allow changing direction in broken link type (from r96987)
 * [rev:98203] Fix broken reasons sorting (from r96985)
 * [rev:98202] Improvements to sorting of columns on broken links report (from r96979)
 * [rev:98185] Add horizontal scrolling to reports when necessary. (from r96086)
 * [rev:98184] Add horizontal scrolling to reports when necessary. (from r96085)
 * [rev:98183] Add horizontal scrolling to reports when necessary. (from r96075)
 * [rev:98182] Removed unnecessary '?' from report URLs when there are no search criteria (from r96052)
 * [rev:98180] Don't throw an error if there are no report filters.
 * [rev:98180] Don't randomise the order of reports with the same priority. (from r95955)
 * [rev:98177] Only list reports in admin/reports that you can actually view (from r95885)
 * [rev:98176] Updated all cms side reports to use SSReport as the base class. (from r95884)
 * [rev:98170] Fixed bug with report search fields not showing the value that you just searched for. (from r95567)
 * [rev:98168] Fixed report pagination, with or without search params (from r95555)
 * [rev:98152] pagination was being applied (with a limit of NULL) to print and export actions. This was due to $_REQUEST['methodname'] not existing. (from r97114)
 * [rev:98150] TreeMultiselectField_Readonly now posts the correct value to the server (from r97100)
 * [rev:98136] still use the correct methods to get a value, even if we're generating a CSV ($xmlSafe = false) (from r96212)
 * [rev:98134] Don't default to sorted descending if you already have a different column sorted ascending. (from r96061)
 * [rev:98133] Don't make ManifestBuilder choke on empty files. (from r96058)
 * [rev:98132] Make TableListField sort checking use SQLQuery::canSortBy() to let SSReprot_FakeQuery work.
 * [rev:98131] Correct direction of sort arrows in TableListField (from r96051)
 * [rev:98114] fixed test that was trying to do a assertContains between a DataObjectSet and a Member object. Changed it to an assertEquals between Member and the First item in the Set. Also added an inverse test to check that Set doesn't contain the wrong Member.
 * [rev:98111] removing search&replace victim, using unpopulated cache. Reverted to AllChildren, which calls the cache itself.
 * [rev:98103] Fixed readonly transformation of TreeMultiselectField in cases where $this->value is explicitly set. (from r95962)
 * [rev:98101] Allow creation of TreeDropdownFields on forms with querystring URLs.
 * [rev:98101] Make use of the $this->value setting of TreeMultiselectFields. (from r95910)
 * [rev:98095] Let FieldMap access non-data fields too (from r95825)
 * [rev:98094] Make TableListField rely on SQLQuery for its count-generation.
 * [rev:98094] Make SQLQuery return an appropriate count if a HAVING clause is used. (from r95814)
 * [rev:98083] reintroducing the forceValue url param, so the TreeDropdownField value can be set via JS (previously if the item was deep within the tree structure it would not be selected)
 * [rev:98030] fixed member labels not appearing in cms popup. #5025
 * [rev:98018] Fixed incorrect logic in CMSMain::generateTreeStylingJS() stopping different tree icons from working
 * [rev:98001] Ticket #4805
 * [rev:97984] FileIFrameField throws sub-URLs error when changing cms to a non default language (#4767)
 * [rev:97980] #5009: Removed inappropriate field-detection change on multienums with no default
 * [rev:97937] missing comma
 * [rev:97935] can't upload swf file in admin/assets (open ticket #4999)
 * [rev:97926] remove the possibility that Director::isDev() could be recursively called  when putting isDev=1 in $_GET, addressed in ticket #4978 (http://open.silverstripe.org/ticket/4978)
 * [rev:97912] Allowing translations of VirtualPage by not copying over original Locale property (see #5000)
 * [rev:97911] If a Group doesn't have any specific TRANSLATE_`<locale>` edit rights, but has general CMS access (CMS_ACCESS_CMSMain, CMS_ACCESS_LeftAndMain, ADMIN), then assign TRANSLATE_ALL permissions as a default. Necessary to avoid locking out CMS editors from their default language (see #4940 and 4941)
 * [rev:97909] Don't let a user's theme break the CMS.
 * [rev:97881] Checking that URL controller in HTTPRequest->match() is a subclass of Controller, not RequestHandler (which would include nested controllers like Form or FormField subclasses that shouldn't be accessible on their own toplevel URL namespace)
 * [rev:97878] Folder::findOrMake() will call mkdir if needed, even if object already exists in database.
 * [rev:97833] remove serverside Validator::get_javascript_validator_handler() checking when trying to valid the field in serverside.
 * [rev:97783] File don't have method URL(), instead, we use $image->URL, which will call $image->getURL()
 * [rev:97775] removed unneccessary comma (it breaks the IE)
 * [rev:97764] changed the stylesheet path to proper one - #4968
 * [rev:97755] add custom search function, so the search catches also the Titles (search uses DataObject::get, which bypasses the getMenuTitle function)
 * [rev:97746] allow only 2 and 4 digit years.
 * [rev:97731] Use BASE_PATH and BASE_URL instead of data from $_SERVER.
 * [rev:97730] fix front-end validation for DYMCalendarDateField, addressed in open ticket #4967(http://open.silverstripe.org/ticket/4967).
 * [rev:97728] Don't rely on the current working directory for any file access; use BASE_PATH.
 * [rev:97727] Don't rely on the current directory for any logic.
 * [rev:97673] the anchor dropdown now works in IE. Also fixes other anchor-related problems as described in ticket #4961
 * [rev:97653] Fixed Permission::get_members_by_permission() for DB abstractions
 * [rev:97638] Fixed CMS Editor loading in AssetAdmin
 * [rev:97603] Fixed bug when user selects no folder and uses the search box it incorrectly doesnt append the where statements
 * [rev:97599] Use correct paths for requirements
 * [rev:97594] Fixed potential data corruption issue when you are changing the class of a SiteTree subclass between two subclasses that share a fieldname.
 * [rev:97593] Another bugfix for r97583
 * [rev:97589] Fixed bug that was caused by r97583
 * [rev:97586] #4929: Fixed Object::add_static_vars() for uninherited static.s
 * [rev:97581] #4471: Fixed link insertion in Safari.
 * [rev:97545] Fixed widgets not being clickable to use them in IE
 * [rev:97541] Clicking available widgets now applies only to h3 elements
 * [rev:97541] Widgets are now prepended to the available widget stack by use of Insertion.Top
 * [rev:97522] When adding a new widget by clicking one of the available widgets, add it to the top of the currently used widgets instead of the bottom
 * [rev:97507] Fixed incorrect lables "TOADD" etc in WidgetAreaEditor
 * [rev:97482] Fixed NumericField->jsValidation(), now accepts negative numbers, making it more like the equivalent phpValidation(), which is using is_numeric() (see #4874, thanks Allisone)
 * [rev:97480] Checking for presence of all columns in Security::database_is_ready(). This was necessitated by an earlier change to the sapphire ORM which now selects all columns explicitly in a SQL query (instead of SELECT *) (see #4027)
 * [rev:97472] Setting 'Locale' as HiddenField in CMSMain->getEditForm() to support translatable SiteConfig records (see r97370, #4770)
 * [rev:97437] Properly closed a tag in AssetTableField that was hiding content after the back link tracking tab. From: Andrew Short  (from r95036)
 * [rev:97433] Fixed nested URLs operation for pages more than 4 levels deep. From: Andrew Short  (from r95902)
 * [rev:97414] Was using custom_database_fields in Aggregate, not database_fields, and so aggregates for the common fields (LastEdited, Created, ClassName) would fail
 * [rev:97370] Fixed SiteConfig->canView()/canEdit() to respect empty CanViewType/CanEditType assignments.
 * [rev:97357] old 2.3 passwords now handled correctly and migrated accordingly
 * [rev:97307] getByKey replaced with objectForKey
 * [rev:97300] The 5.1 replacement array_fill_keys function now made available to the cron jobs
 * [rev:97267] Let users without a specific TRANSLATE_ permission edit the default locale, so that things don't break when you install the Translatabe module.
 * [rev:97260] Move TreeDropdownField requirements to Field() so requirements are loaded properly in popups
 * [rev:97231] removing hardcoded reference to ModelAdmin_RecordController, also added getters for model controllers.
 * [rev:97211] Fixed URLSegment access for translated homepages in SiteTree->RelativeLink (#4781, thanks martijn)
 * [rev:97210] Language switcher dropdown javascript uses baseHref() to avoid invalid relative links in IE8 (#4891)
 * [rev:97179] Fixed redirection destionation of the modeladmin delete button on the detail form.
 * [rev:97168] now hiding the permissions via SecurityAdmin::add_hidden_permission works also for PermissionRoleAdmin
 * [rev:97073] Attribute escaping in PageCommentInterface?_singlecomment.ss (merged from r97071)
 * [rev:97051] Fixed bug in r97036
 * [rev:97038] Fix display of exception backtrace in CLI view.
 * [rev:97036] Use locally included Zend framework components in favour of those installed with PEAR
 * [rev:97031] the search was only operating on the part of the tree (as returned by markPartialTree), now it searches globally
 * [rev:97023] HTTPResponse has been replaced with SS_HTTPResponse
 * [rev:97016] Comment URL field check is now case insenstive. Included tests for various protocols. PATCH via simon_w. Ticket #4776
 * [rev:97013] removed name attribute from label fields since this is invalid html. Ticket: #4887. PATCH via tobych
 * [rev:96997] Check for an empty list of keys before attempting to create an array with them
 * [rev:96993] #4857 Fixed potential bug where a file would just be uploaded to a random folder, also files can now be uploaded to the assets root properly
 * [rev:96977] reintroduced 96961, build failed for other reason.
 * [rev:96961] loading a subtree was failing - couldn't call getSiteTreeFor reliably on LeftAndMain which is abstract class in its nature. Now using valid subclass instead.
 * [rev:96941] Fixed bug in VirtualPage::isPublishable() when CopyContentFromID not set
 * [rev:96884] Fixed add button overlapping image/flash popups in modeladmin. #4906
 * [rev:96879] fixed onBeforeDuplicate calling before page existed
 * [rev:96868] Fixed a PHP segfault bug with the WidgetAreaEditor
 * [rev:96828] Adjust EncryptAllPasswordsTask test to match API for BuildTask
 * [rev:96822] Removed XSS holes (from r94822)
 * [rev:96818] Don't show obsolete page if you refresh the CMS after deleting a page (from r94242)
 * [rev:96817] Use canDeleteFromLive instead of canPublish for checking delete from live action (from r93316)
 * [rev:96812] Correct labels for "delete from draft" batch actions (from r91838)
 * [rev:96811] Use doDeleteFromLive when deleting pages from live, so that onBeforeUnpublish and onAfterUnpublish are called. (from r91381)
 * [rev:96809] Use the correct numChildrenMethod when showing the 'all children, including deleted' tree (from r91166)
 * [rev:96806] Preserve selection of LHS multiselect tree when switching between filters. (from r90290)
 * [rev:96805] Correct confirmation alert message when rolling back to a specific version. (from r90261)
 * [rev:96799] Updated onAfterUnpublish to republish page from static cache as well as unpublish them. (from r90002)
 * [rev:96798] Removed destroy() calls from static cache builder; with the garbage collection improvements it shouldn't be necessary. (from r89983)
 * [rev:96797] Fixed width of time dropdown fields in the LHS CMS (from r89913)
 * [rev:96796] Don't set the Owner by default on new records. (from r89910)
 * [rev:96795] Fixed viewing of deleted pages. (from r89833)
 * [rev:96790] Don't cut off document.body overflow in CTF popups in the admin, when on test mode. (from r88958)
 * [rev:96785] Ignore elements without a name in change detection.
 * [rev:96782] Fix image tracking not working cross subsite (from r88008)
 * [rev:96781] Fix changing the URLSegment on a page making the Draft Site link
 * [rev:96780] Fix deleting folders in Internet Explorer (from r87390)
 * [rev:96779] Fix highlighting of incorrect page when loading a page in the
 * [rev:96775] Use Controller::join_links() for all TableListField and ComplexTableField link building, to support form URLs with querystrings.
 * [rev:96775] If ComplexTableField::getParentRecord() can't find a record, just return null rather than erroring. (from r96555) (from r96649)
 * [rev:96774] Don't let Versioned archive tables clutter the global state when testing.
 * [rev:96774] Don't let mocked datetimes clutter the global state when testing. (from r96640) (from r96648)
 * [rev:96773] Removed XSS holes (from r94823)
 * [rev:96770] Don't set the nodelete class on the CMS tree on load, since this is now handled by the batch-action system with an Ajax call. (from r94762)
 * [rev:96767] Don't let users edit the location in the Behaviour tab if they don't have sitetree reorganise permission (from r94609)
 * [rev:96765] Fixed readonly form of TreeDropdownField when field is made readonly before value is set (from r94608)
 * [rev:96762] Allow opening of the detail pop-ups of a record on a ComplexTableField attached to a deleted page. (from r94593)
 * [rev:96761] Apply file extension restrictions to extensions properly. (from r93531)
 * [rev:96760] Don't publish virtual pages on regular page publish unless the page has already been published. (from r93529)
 * [rev:96759] Changed default config to restrict file-upload types to ADMINs, since it's protecting against security holes. (from r93327)
 * [rev:96758] Virtual pages can be deleted from the live site even when the're not publishable. (from r93319)
 * [rev:96755] Fixed notice-level errors when checking permissions of pages that don't exist anywhere (from r93166)
 * [rev:96754] Resized images which return null or false are now ignored
 * [rev:96752] Add a default list of allowed extensions so that the CMS works reasonably out of the box.
 * [rev:96752] Allow files that don't have an extension (most notably folders)
 * [rev:96752] Ensure that file URL rewriting works if you rename a page twice without publishing.
 * [rev:96752] Ensure that the page doesn't go green after URLs are rewritten
 * [rev:96750] Fixed bug in r93095 (from r93097)
 * [rev:96748] Update virtual pages semantics to grab content from the published version of the source page when you publish the virtual page, and to not allow publication before their source page is published. (from r92209)
 * [rev:96746] Amended some references to HTTPResponse, replacing with SS_HTTPResponse
 * [rev:96741] Use live permissions if the stage page has been deleted. (from r91761)
 * [rev:96740] Make virtual page broken link detection work across subsites. (from r91311)
 * [rev:96739] Clear the bypassStaticCache cookie when you return to the live site. (from r91165)
 * [rev:96736] Include newly set fields in the differences shown by DataDifferencer (from r90264)
 * [rev:96735] Use draft site permissions over published, if available. (from r90220)
 * [rev:96733] Change EncryptAllPasswords to BuildTask instead of DailyTask
 * [rev:96732] Call onBeforeUnpublish/onAfterUnpublish events in doDeleteFromLive, because they amount to the same thing. (from r90001)
 * [rev:96731] Fixed broken link correction when a page is deleted. (from r89989)
 * [rev:96729] Added better handling of rendering SiteTree objects, to prevent test errors. (from r89963)
 * [rev:96726] Reset the methods applied to classes after adding/removing extensions. (from r89957)
 * [rev:96724] Prevented notice-level error when publishing HTMLText fiels on tables other than SiteTree. (from r89908)
 * [rev:96722] Update file link tracking as part of Filesystem::sync() (from r89907)
 * [rev:96721] Fixed image link rewriting in virtual pages. (from r89904)
 * [rev:96720] Fixed onchange handler for DropdownTimeField (from r89903)
 * [rev:96719] Fixed layout glitch in TreeDropdownField in Firefox (from r89842)
 * [rev:96718] Don't let non ADMINs with permission-editing rights assign themselves ADMIN permissions. (from r89805)
 * [rev:96717] Fixed SiteTree::rewriteFileURL() (from r89804)
 * [rev:96715] Version field weird'ed up rollback functionality (from r89464)
 * [rev:96705] Make sure Linkto Dropdown works right with filter()
 * [rev:96681] alternative function for versions of PHP prior to version 5.2
 * [rev:96680] array_fill_keys function created for version prior to PHP 5.2
 * [rev:96679] Ensure .js variable defined with var keyword
 * [rev:96678] Ensure .js variable defined with var keyword
 * [rev:96663] Allow set objects as properties if the property is not a database field
 * [rev:96623] anchor, target, and title are not set on a link that's inserted without selection. Also when using createElement in that way firefox encodes the spaces within href parameter breaking the shortcodes. Switched to using the 'mctmp' placeholder now.
 * [rev:96566] Fix IE bug with Files&Images (#4912)
 * [rev:96551] getting rid of problem with disappearing buttons on the initial page load (not ajax). The initialization was called twice on the CMSForm, and on the second call the ajaxActionsAtTop was removing the buttons - now the buttons are removed only when there is something to be added.
 * [rev:96443] Check for functions existence
 * [rev:96441] Check for empty
 * [rev:96427] Fixed reloading of TableFields after ajax save. (http://mingle.silverstripe.com/projects/air_nz_cms_enhancements/cards/154) (from r88921)
 * [rev:96363] Fix multiselect tree selection, since changes in r91342
 * [rev:96362] Readonly TreeMultiSelectField has form linked properly
 * [rev:95973] #4140 When clicking a tree node that was just dragged, "Stack overflow" error would be given in IE. Firebug would report "Too much recursion"
 * [rev:95972] when the JS files are combined, swfupload.js gets included in pages where there are no placeholder elements available, failing with exception and killing the javascript for the page. Now the exception is intercepted and ignored.
 * [rev:95968] Fallback for arrays which do not contain 'alreadyLoggedIn' values
 * [rev:95788] fixing CMS_ACCESS_LeftAndMain permission (=access all cms sections). Also added the test.
 * [rev:95558] Show selected row in autocomplete dropdown
 * [rev:95511] Prevent text-selection during drag operation, Firefox-specific
 * [rev:95422] Fixed undefined $this->Parent in SiteTree::getCMSFields()
 * [rev:95388] LessThanFilter uses SearchFilter::getDbFormattedValue, just like GreaterThanFilter
 * [rev:95339] pass $allowHTML through to the parent class
 * [rev:95169] If running a BuildTask via AJAX, e.g. Filesystem::sync() is run from AssetAdmin, don't show the message "Running [task] ..."
 * [rev:95108] Fix fatal error when exporting a csv from a tablefield with a custom query
 * [rev:95093] ComplexTableField - fixed sprintf() not enough arguments when the referrer has a % character in it, the referrer is now an argument instead of being hardcoded in the string
 * [rev:95091] #4847 Fixed ComplexTableField undefined in IE8 when opening a CTF popup in the Security section of the CMS
 * [rev:95088] #4848 Fixed ComplexTableField undefined error in IE8 when it is not available
 * [rev:95084] #4848 FileIFrameField visual problem where the preview image is hidden if the TreeDropdownField gets too long for selecting a file
 * [rev:94885] Fixed ModelAsController::findOldPage() failing on MSSQLDatabase using "sqlsrv" driver
 * [rev:94859] adding onAfterDelete hooks to remove the no longer necessary permissions
 * [rev:94835] orphaned permissions and subsite administrator groups were causing trouble - now with the JOIN the first global administrator group is picked up when ussing the override login.
 * [rev:94810] removing permissions before re-applying them (previously it just removed the components on the relation which resulted in permissions having GroupID set to 0)
 * [rev:94721] fixed typing error
 * [rev:94571] fixed spam not being turned into ham if spamprotection isnt enabled. PATCH via simon_w #4813
 * [rev:94568] check akismet is enabled before saving spam. PATCH via simon_w - #4812
 * [rev:94461] Fix fileiframefields dying when an image is attached and a folder is expanded via ajax
 * [rev:94443] fixed closing action on profiler popup
 * [rev:94437] include customHeadScripts in clear rule.
 * [rev:94416] Fixed undefined function error ip2country() in Geoip::ipcountry_check()
 * [rev:94378] match returns null on not-found, querying raw.length resulted in an error. Now it's possible to add links to the page again.
 * [rev:94369] Make sure findAnAdministrator gets a global administrator when subsites is installed.
 * [rev:94358] #4686 Fixed $member non-object error, and decorated checks from not working in Member::canView(), Member::canEdit() and Member::canDelete()
 * [rev:94353] #4566 Time::Nice() and Time::Nice24() return bad results if there is no value
 * [rev:94350] Fix default inclusion of (theme|project)/css/editor.css into the WYSWIWYG editor.
 * [rev:94349] Don't throw a notice-level error if you access a setting that hasn't been set yet.
 * [rev:94332] convert ImageFormAction form prototype syntax to jQuery syntax, merged from r94304
 * [rev:94319] Cleanup after aborted drag operation in Assets (#4735) (from r93071)
 * [rev:94301] Fixed undefined calls to URL() in SimpleImageField, replacing them with getURL() instead
 * [rev:94238] is tinyMCE is not loaded, we cannot call its function. This is specially important in a pop-up of ComplexTableField
 * [rev:94170] Fixed IE bug in ReportAdmin_left.js
 * [rev:94134] #4661 Fix SS temporary directory bug with Windows environments - the directory would always be "silverstripe-cache" instead of a namespaced one so that multiple SS sites don't conflict with eachother
 * [rev:94100] if SecurityAdmin::add_hidden_permission() is called more than once, the later one is never added due two array operator "+"
 * [rev:94073] Fixed inconsistent default to ViewableData::Modulus() - should be 0 as per ViewableData::MultipleOf()
 * [rev:94071] Modulus and MultipleOf should start at index 0 to match the iterator position, by default
 * [rev:94061] fixed reference to incorrect class
 * [rev:94002] fix some missing langs/en.js loading.
 * [rev:93984] add proper language link broken
 * [rev:93965] Changed paths according to moved thirdparty dependencies. This bit change is merged from r92613.
 * [rev:93955] fix bug that can't find tinymce_ssbuttons under sapphire/thirdpaty. this is a change merged from r92853 http://open.silverstripe.org/changeset/92853#file3
 * [rev:93950] fix bug that can't find tinymce_ssbuttons under sapphire/thirdpaty. this is a change merged from r92853 http://open.silverstripe.org/changeset/92853#file3
 * [rev:93935] merge r92502 from trunk for HtmlEditorConfig.php, merge r93934 from trunk for HtmlEditorField.js, merge r92500 from trunk for sapphire/thirdpart/tinymce-advcode/editor_plugin_src.js, aiming to solve the conflict of folder name tinymce-advcode.
 * [rev:93860] Fixed incorrect hasDatabaseField() in SearchFilter::getDbName() - use hasOwnTableDatabaseField() instead
 * [rev:93777] Fixed SearchContextTest failure
 * [rev:93754] Fixed drag link event handling on ComplexTableField.js (#4737)
 * [rev:93707] Removed code that relied on deprecated functions in MemberTableField
 * [rev:93677] Removed calls to Translatable::is_enabled() since it's deprecated, replaced with Object::has_extension('SiteTree', 'Translatable') instead
 * [rev:93676] Removed calls to Translatable::is_enabled() since it's deprecated, replaced with Object::has_extension('SiteTree', 'Translatable') instead
 * [rev:93673] #4762 Replace Debug::log_errors_to() in ConfigureFromEnv to use SS_Log instead. Thanks simon_w!
 * [rev:93620] Fixed reference to tree.css which doesn't exist because of files moving around
 * [rev:93579] Adjusted YamlFixture to new Spyc API: loadFile() instead of load() (from r92566)
 * [rev:93542] applied patch from #4381. Observable doesnt play nice with jQuery (manual jsparty merge from r90857) (from r92571)
 * [rev:93514] Fix javascript error on IE8 by forcing IE7 compat mode.
 * [rev:93259] Fixed dev/build not redirecting properly on first install of SS website on IIS
 * [rev:93161] Fixed newlines for Windows when logging errors in LogErrorFileFormatter
 * [rev:92411] Fix TreeDropdownFields throwing an exception.
 * [rev:92220] Fixed newlines working properly across different platforms - Windows, for example, won't work properly with just \n so use PHP_EOL for a cross-platform solution
 * [rev:92129] More robust checks on the current member in Member::canEdit() and Member::canDelete() if there is no logged in member
 * [rev:92077] Fixed regexp in anchor link rewriting
 * [rev:91958] FolderID was not present in post, so file would not be uploaded to the correct place.
 * [rev:91775] Fixed Group::collateFamilyIDs() when working with MSSQL
 * [rev:91746] Include salt in legacy password encryptor (from r91743)
 * [rev:91659] Made use of new BasicAuth::protect_entire_site() consistent. (from r91658)
 * [rev:91613] Don't enable site-wide protection by default (from r91609)
 * [rev:91576] Fixed password hashing design flaw in Security::encrypt_password(). Removing base_convert() packing with unsafe precision, but retaining backwards compatibilty through pluggable encryptors: PasswordEncryptor_LegacyPHPHash (#3004) (merged from r90949)
 * [rev:91572] Legacy password hash migration in MemberAuthenticator::authenticate() which fixes the precision problems mentioned in #3004 when a user logs in (from r90950)
 * [rev:91549] changed condition to display uploaded File
 * [rev:91542] fixed order inclusion of js
 * [rev:91444] Fixed PageComment boolean operators in WHERE SQL clauses that break MSSQL
 * [rev:91418] MigrateSiteTreeLinkingTask returns duplicate results from databases like MSSQL - remove any duplicates that may be around


###  Minor changes

 * [rev:98409] Fixed HTTPTest->testSetGetVar()
 * [rev:98407] Fixed HTTPTest->testSetGetVar()
 * [rev:98404] Partially reverted r98382 which added unnecessarily defensive checking to Hierarchy->allChildren()
 * [rev:98403] Fixed HierarchyTest assertions around including grand children counts
 * [rev:98390] Removed argument to getDescendantIDList() in ThumbnailStripField that doesn't exist on the method
 * [rev:98383] Fixed HTTPTest when invoked through dev/tests/all or with GET parameters (see r98373)
 * [rev:98376] Testing of grand-children items in HierarchyTest::testLoadDescendantIDListIntoArray() and HierarchyTest::testNumChildren()
 * [rev:98372] Documentation
 * [rev:98370] Fixed test case name in Hierarchy
 * [rev:98369] Added test case for Hierarchy::getDescendantIDList() which also tests Hierarchy::loadDescendantIDListInto()
 * [rev:98341] Removed arguments to Hierarchy::getDescendantIDList() calls, as the method does not have any
 * [rev:98326] Make pass use a password field, dont require call by reference (merged from r72930)
 * [rev:98321] Use 'b' mode for fopen() where possible for better portability
 * [rev:98285] Fixed SS_HTTPResponse references in CMSBatchActionHandler
 * [rev:98284] Documentation
 * [rev:98282] fixed setName()
 * [rev:98275] Removed message alteration from ValidationResult->error() to make it more predictable for string matching in unit tests like SecurityTest
 * [rev:98274] Fixed unit tests after change Member->checkPassword() to return ValidationResult instead of boolean (see r98268)
 * [rev:98268] Use a ValidationResult to log in a member so that custom errors can be generated. From: Andrew Short  (from r98267)
 * [rev:98264] Only clear theme in CMS if we're not redirecting to the login form (better for testing).
 * [rev:98228] Adding SiteConfig as Translatable dependency in SiteTreeTest and TranslatableTest
 * [rev:98223] make showing virtual pages tab conditional
 * [rev:98223] made virtual page tracking sitetree tablelistfield subsite agnostic (from r98005)
 * [rev:98222] removed redundant method call (from r97817)
 * [rev:98211] added above confiration to batch setting expiry (from r97215)
 * [rev:98210] add pretty warning colors to expiring content warning (from r97151)
 * [rev:98208] set Print flag correctly on TLF
 * [rev:98208] custom print template for SSReport TLF's that exposes the report title, and filters set (from r97138)
 * [rev:98206] fix dropdown labels (from r97063)
 * [rev:98201] fixed typos in the comments
 * [rev:98200] Change page title heading to "Page name" for consistency in CSV export (from r96925)
 * [rev:98199] added quotes
 * [rev:98198] Fixed side report tests to suit new report system. (from r96646)
 * [rev:98197] using better sorting api (from r96483)
 * [rev:98196] fix sorting in this report. (from r96481)
 * [rev:98195] make site checking clearer on broken links report (from r96456)
 * [rev:98193] typo fixes, adding missing columns (from r96433)
 * [rev:98192] remove sort direction when running canSortBy. Also added test coverage for this. (from r96428)
 * [rev:98189] improved wording on reports (from r96258)
 * [rev:98187] added broken links report (from r96139)
 * [rev:98186] Correct sidebar report order. (from r96090)
 * [rev:98180] Added SSReport::dataClass() accessor.
 * [rev:98178] use DB doubles only in MySQL, fall back to float
 * [rev:98174] Added missing template from r95815 (from r95822)
 * [rev:98171] Nicer date formatting (from r95761)
 * [rev:98164] added locking to static publisher to avoid two queues running at the same time. (from r87792)
 * [rev:98163] fixed IE JS errors (from r87420)
 * [rev:98162] apply a sitetree filter when changing subsites (from r87369)
 * [rev:98160] updated detection for an empty report (from r87362)
 * [rev:98158] when you delete a user from a group, they are also removed from any sub groups. (from r87119)
 * [rev:98156] applied correct decorators
 * [rev:98156] Page.ss now takes advantage of the SiteConfig
 * [rev:98156] fixed JS error around concurrent editing
 * [rev:98156] ability to disable sorting on tablelistfield
 * [rev:98156] added default timezone to static-main.php to avoid PHP warnings
 * [rev:98156] only display Roles tab on groups if there are roles in the system
 * [rev:98156] publishing activity report
 * [rev:98155] better error reporting for broken redirector & virtual pages (from r97185)
 * [rev:98154] set Print flag correctly on TLF
 * [rev:98154] custom print template for SSReport TLF's that exposes the report title, and filters set (from r97138)
 * [rev:98153] Fixed TableListField tests that don't set $_REQUEST['url'] (from r97127)
 * [rev:98143] Always position calendars below the entry field - this gives it consistency with PopupDateTimeFields, as well as ensure the popup button isnt hidden. (from r96916)
 * [rev:98142] Fixed PermissionTest assertion (from r96642)
 * [rev:98141] Fixed TableListField test to suit changed behaviour. (from r96639)
 * [rev:98140] if the $fieldname to DOS->sort has a direction in it, split it out, and pass it. (from r96482)
 * [rev:98139] redirector link tracking is more intelligent (from r96461)
 * [rev:98138] remove sort direction when running canSortBy. Also added test coverage for this. (from r96428)
 * [rev:98137] move sort column&direction into their own vars, otherwise, canSortBy(Date DESC) will always return false, since DESC is not part of the column name. (from r96411)
 * [rev:98135] fix field escaping in CSV export of TableListField (from r96157)
 * [rev:98128] Update en_US with SiteConfig.THEME and SiteConfig.DEFAULTTHEME translatable entities
 * [rev:98127] Cleanup test folder after SiteConfigTest::testAvailableThemes() is run
 * [rev:98115] added descriptive text to test assert.
 * [rev:98110] Unit tests for SSViewer::current_theme() and SiteConfig::getAvailableThemes()
 * [rev:98106] Fixed broken tests
 * [rev:98098] Removed specific removal of temporary directory in ManifestBuilderTest::testThemeRetrieval() and replaced it with Filesystem::replaceFolder() which does the same thing
 * [rev:98097] don't HTML-format queries from showqueries if this is an AJAX request. (from r95855)
 * [rev:98092] Initialise variables to fix unit test (from r95754)
 * [rev:98091] Added ManifestBuilderTest::testThemeRetrieval() to test ManifestBuilder::get_themes()
 * [rev:98090] Edit-case checking of data in ViewableData::$failover for better error message. (from r95560)
 * [rev:98089] Don't try and access the ORM from ComplexTableField in situations where it shouldn't. (from r95544)
 * [rev:98088] Boundary condition check in TableListField for more helpful errors. (from r95543)
 * [rev:98086] Fixed FileTest execution if the assets/ directory doesn't exist. (from r88353)
 * [rev:98085] added direct links to items in the backlinks report (from r88277)
 * [rev:98084] unit test for getting members by permission via roles (from r88276)
 * [rev:98079] Partially reverted accidental commit from r97920 (unconditionally requiring ADMIN login via BasicAuth in DevelopmentAdmin)
 * [rev:98059] Changed MySQLDatabase::now() block comment to be more useful
 * [rev:98056] Unit tests for Decimal field type default value through new test class DecimalTest
 * [rev:98055] Allow creating fixture records without any columns by checking the fields exist first before doing a foreach() in YamlFixture::writeDataObject()
 * [rev:98043] niced the way MultiEnums call requireField to give alternative adapter access
 * [rev:98042] use ENUM hack for dealing with SET legacy values
 * [rev:98032] visual tweaks to the widgets area including widget titles can now be spread over multiple lines and padding between columns. #4965
 * [rev:98025] fix permissions
 * [rev:98017] permission code is case sensitive in some cases
 * [rev:97991] Deleted reference to CalendarDateField.js
 * [rev:97991] Year validation (accept just 4 digit, like the error message says).
 * [rev:97985] groupby works for SQLite too
 * [rev:97979] Better error message on bad Enum default
 * [rev:97936] add flv (flash file) to File::$allowed_extensions
 * [rev:97920] Preserve theme settings in tests
 * [rev:97910] Removed debug code
 * [rev:97875] fix call to undefined method when a virtual page picks up the wrong object.
 * [rev:97838] PHP notice error
 * [rev:97825] Removed debug code
 * [rev:97705] replaced proprietary update query with one that is ANSI compliant in doPublish()
 * [rev:97669] #4674 applied patch for special chars in folder titles
 * [rev:97652] Make SecurityDefaultAdminTest when you run it by itself.
 * [rev:97602] Added better help text underneath "Available Widgets" and "Widgets currently used"
 * [rev:97596] fix file iframe upload width
 * [rev:97592] Re-enabled SiteTreePermissionsTest tests
 * [rev:97566] If CurrencyField->setValue() passed a null or empty value, default to 0.00 so number_format() has no issues converting the number
 * [rev:97543] Tree selector expands by default to show selected nodes
 * [rev:97540] Cursor is now a pointer for available widgets, as you need to click them to add to the available widget stack
 * [rev:97532] Removed end php tag from WidgetAreaEditor
 * [rev:97511] Changed wording for WidgetAreaEditor.TOADD advising users to "click" instead of drag widgets
 * [rev:97509] Fixed default wording of WidgetAreaEditor.TOADD "drag them here from the left"
 * [rev:97487] Updated master translation file
 * [rev:97486] Updated master translation file
 * [rev:97485] Backwards compat fix for sprintf() call in CMSMain->providePermissions() (#4764)
 * [rev:97484] Using SiteTree::get_by_link() in SiteTree->requireDefaultRecords() (see #4590)
 * [rev:97483] Fixed setForm() invocation in Form::__construct() (see #4558, thanks ajshort)
 * [rev:97481] Use addExtraClass() in FormField::__construct() instead of direct assignment (see #4607, thanks Tjofras)
 * [rev:97478] Security::findAnAdministrator() names any default administrators 'Default Admin' instead of 'Admin'
 * [rev:97435] Don't include files and folders starting with an underscore in the asset system.
 * [rev:97435] Automatically rename files and folders beginning with an underscore. From: Andrew Short  (from r97400)
 * [rev:97434] Fixed deep-nested-URLs test to work on sites in subfolders (from r96836)
 * [rev:97432] Made ComplexTableField sub-forms testable by returning rather than echoing results. From: Andrew Short  (from r95035)
 * [rev:97431] Allow a validation error to be thrown when a DataObject is saved in ComplexTableField. From: Andrew Short  (from r95034)
 * [rev:97369] Fixed MemberAuthenticatorTest, was setting global state in r97357
 * [rev:97182] Reverted 'single instance only' feature from r79868, delayed until later release (see #4277)
 * [rev:97178] Removed 'print' button from CMSMain->getEditForm() for display of older versions (see #4745)
 * [rev:97072] added comments
 * [rev:97035] folders without children in trees now have the folder icon
 * [rev:97031] renamed 'filter' to 'search'
 * [rev:96942] Removed unnecessary illegalExtensions data from TranslatableTest
 * [rev:96882] Ensure DropdownField option elements have escaped the title correctly
 * [rev:96877] added hooks for extending duplicate page functionality
 * [rev:96830] Added explicit listing of testonly dataobjects for widget tests.
 * [rev:96829] Fixed bugs with test execution.
 * [rev:96827] Fixed CMSMainTest to be more flexible about modules altering the buttons.
 * [rev:96816] moved allowed_extensions and friends to the model layer (from r92046)
 * [rev:96815] moved File validation to the model (from r92044)
 * [rev:96814] implement the allowedExtensions functionality of AssetAdmin when you rename a file (from r92037)
 * [rev:96813] Made delete from draft batch action text more consistent with published. (from r91839)
 * [rev:96808] add a hidden field to attach the subsite ID, rather than relying on the session (from r91014)
 * [rev:96807] no longer assume with batch actions that the child pages of a parent are to be ticked (from r90999)
 * [rev:96804] Fixed notice-level error in rollback. (from r90260)
 * [rev:96803] Updated ModelAdminTest to use extraDataObjects (from r90055)
 * [rev:96802] Removed debugging statements (from r90052)
 * [rev:96801] Fixed testing quirk of static publisher unpublishing. (from r90048)
 * [rev:96794] Make CMSMainTest compatible with cmsworkflow module. (from r89030)
 * [rev:96789] added batch deletion back for workflow (from r88916)
 * [rev:96788] more fix around batch action parameters (from r88837)
 * [rev:96787] fix issue where javascript popup calendar would not fire (from r88836)
 * [rev:96786] rename deleted pages report (from r88333)
 * [rev:96784] create the ability to have some roles only be able to be applied by admins (from r88090)
 * [rev:96783] remove default form actions. Unit tests pass. (from r88065)
 * [rev:96776] fix javscript syntax that can confuse ie (from r86395)
 * [rev:96772] Ensure that cuke can work with --dry-run (from r94819)
 * [rev:96771] when a parent page is unpublished, unpublish all related virtual pages, includes test coverage (from r94777)
 * [rev:96768] track virtual pages that link to the current page (from r94700)
 * [rev:96753] Removed debugging information: (from r93151)
 * [rev:96747] Give all test ADMIN privileges by default (from r92208)
 * [rev:96745] Fixed SiteTree::canEdit() for records not yet saved to DB (from r92193)
 * [rev:96744] can_edit_multiple() should return false, not 0, for permission failure. (from r92192)
 * [rev:96743] moved allowed_extensions and friends to the model layer (from r92046)
 * [rev:96742] moved File validation to the model (from r92044)
 * [rev:96738] if looking at a specific stage, set a cooking to bypass static cacheing (from r91006)
 * [rev:96737] virtual pages are now marked as broken if their pointer page is deleted (from r90996)
 * [rev:96730] Flush get_one cache after rebuilding database schema. (from r89966)
 * [rev:96716] fix syntax error (from r89472)
 * [rev:96714] update merge info, merged in r87119 (from r88839)
 * [rev:96710] changed the method to get a page's siteconfig, it is now subsite aware. (from r89870)
 * [rev:96230] Moved defined variables in AssetAdmin::doUpload() to the top of the method for consistency
 * [rev:95971] Set url variable in TreeAPI.reload as local variable in LeftAndMain_left.js
 * [rev:95966] Added unit test for ViewableData::MultipleOf() when using an offset of 1 (an alternative approach)
 * [rev:95086] make widgetarea/editor more suitable for generic use
 * [rev:95070] remove relic of concurrent editing
 * [rev:95052] remove director rule for removed Image_Uploader in r77012
 * [rev:94986] adding maori macron button back
 * [rev:94856] added comment
 * [rev:94829] fixed bug where widget area editor would not be activated
 * [rev:94711] test support for superglobals in testrequest
 * [rev:94710] test support for superglobals in testrequest
 * [rev:94684] added cookies to Director::test()
 * [rev:94531] Fixed a few glitches in the cuke tests
 * [rev:94529] Added a first cut of some cucumber tests for the CMS
 * [rev:94528] Added db-fixture creation for cucumber-based testing
 * [rev:94438] removed duplicate writes for performance
 * [rev:94432] Don't use test manifest for dev/startsession and dev/endsession (from r93528) (from r94431)
 * [rev:94429] Added small fixture YML that just lets you log in, for bootstrapping browser automation tests.
 * [rev:94420] Fixed misspelled acronym for "Cross-site request forgery"
 * [rev:94418] Documentation updates to SS_Log
 * [rev:94359] Added tests methods for Member::can*() methods to MemberTest
 * [rev:94359] Added test Extension classes for testing decorated can*() methods
 * [rev:94358] Added additional tests to MemberTest
 * [rev:94352] #4973 Automatically generate URLSegment for default records on SiteTree and ErrorPage instead of explicitly setting them
 * [rev:94336] Tweak to test name display on the test runner
 * [rev:94198] fixed widget area
 * [rev:94198] added select box listing anchors in text
 * [rev:94136] Fixed error message for Folder::addUploadToFolder() to be accurate
 * [rev:94135] Less obtrusive tests for testing the SS temp directory
 * [rev:94065] Added a few missing pieces to DataObjectSetTest::testMultipleOf()
 * [rev:93966] Use jquery instead of prototype for silverstripenavigator
 * [rev:93859] Fixed tabs
 * [rev:93762] Javascript variable declarations in CMSMain_left.js (#4741)
 * [rev:93738] Fixed reference to fieldExists() on SearchFilter which was removed from DataObject
 * [rev:93701] reverted r93693 due to the field being required for the CMS
 * [rev:93682] Removed calls to ContentNegotiator::disable() since it's disabled by default
 * [rev:93681] Removed ContentNegotiator::disable() since it's disabled by default (in AssetAdmin)
 * [rev:93662] Removed MemberTableField deprecated methods for adding fields - this should be done by implementing summary fields on a Member decorator instead
 * [rev:93659] Removed ContentNegoitator::disable() from FormResponse - it's disabled already
 * [rev:93641] Moved static functions in ContentNegotiator above the instance methods
 * [rev:93623] Fixed capitalization of JSMin.php include (from r92870)
 * [rev:93622] Fixed path for spyc thirdparty library
 * [rev:93612] Updated paths from jsparty to sapphire/thirdparty, cms/thirdparty and cms/javascript
 * [rev:93611] Updated paths from jsparty to sapphire/thirdparty, cms/thirdparty and sapphire/javascript
 * [rev:93610] Moved jsparty/tiny_mce to sapphire/thirdparty/tinymce
 * [rev:93591] Moved jsparty/greybox to sapphire/thirdparty/greybox
 * [rev:93589] Moved jsparty/jquery/jquery_improvements.js to sapphire/javascript/jquery_improvements.js
 * [rev:93577] Moved jsparty/prototype_improvements.js to sapphire/javascript/prototype_improvements.js
 * [rev:93576] Moved jsparty/prototype15.js to sapphire/thirdparty/prototype/prototype15.js
 * [rev:93575] Moved jsparty/prototype-safe.js to sapphire/thirdparty/prototype/prototype-safe.js
 * [rev:93574] Moved jsparty/prototype.js to sapphire/thirdparty/prototype/prototype.js
 * [rev:93571] Moved jsparty/loader.js to sapphire/javascript/loader.js
 * [rev:93570] Moved jsparty/layout_helpers.js to sapphire/javascript/layout_helpers.js
 * [rev:93569] Moved jsparty/hover.js to cms/javascript/hover.js
 * [rev:93568] Moved jsparty/highlight.js to cms/javascript/highlight.js
 * [rev:93567] Moved jsparty/tiny_mce_improvements.js to sapphire/javascript/tiny_mce_improvements.js
 * [rev:93565] Moved jsparty/tree to sapphire/javascript/tree
 * [rev:93564] Moved jsparty/tinymce_ssmacron to cms/javascript/tinymce_ssmacron
 * [rev:93563] Moved jsparty/tinymce_ssbuttons to cms/javascript/tinymce_ssbuttons
 * [rev:93562] Moved jsparty/tinymce_advcode to sapphire/thirdparty/tinymce-advcode
 * [rev:93560] Moved jsparty/tabstrip to sapphire/thirdparty/tabstrip
 * [rev:93559] Moved jsparty/SWFUpload to cms/thirdparty/swfupload
 * [rev:93557] Copied jsparty/multifile to cms/thirdparty/multifile
 * [rev:93555] Moved jsparty/calendar to sapphire/thirdparty/calendar
 * [rev:93554] Moved jsparty/scriptaculous to sapphire/thirdparty/scriptaculous
 * [rev:93553] Moved jsparty/jquery/plugins/greybox to sapphire/thirdparty/greybox
 * [rev:93552] Moved jsparty/jquery/plugins/livequery to sapphire/thirdparty/jquery-livequery
 * [rev:93551] Moved jsparty/jquery/plugins/metadata to sapphire/thirdparty/jquery-metadata
 * [rev:93550] Moved jsparty/jquery/plugins/form to sapphire/thirdparty/jquery-form
 * [rev:93549] Moved jsparty/jquery/plugins/effen to sapphire/thirdparty/jquery-effen
 * [rev:93548] Added jquery.cookie library to allow saving of last selected jQuery UI tab (from r92507)
 * [rev:93547] Moved jsparty/jquery/themes to sapphire/thirdparty/jquery-ui-themes
 * [rev:93546] Moved jsparty/jquery/ui to sapphire/thirdparty/jquery-ui
 * [rev:93544] Moved jsparty/jquery/jquery.js to sapphire/thirdparty/jquery
 * [rev:93543] Added sapphire/thirdparty/firebug-lite (from r92496)
 * [rev:93541] Added sapphire/thirdparty/behaviour (from r92497)
 * [rev:93532] Added Zend_Log thirdparty dependency (merge from r84322) (merged from r92549)
 * [rev:93530] Replaced sapphire/thirdparty/Zend external with piston-managed version (merged from r92492)
 * [rev:93527] Added simpletest thirdparty library (previously included as an external) (merged from r92857)
 * [rev:93526] Re-added sapphire/thirdparty/spyc library
 * [rev:93525] Re-added sapphire/thirdparty/simplepie library
 * [rev:93524] Re-added sapphire/thirdparty/jsmin library
 * [rev:93521] Re-added sapphire/thirdparty/json dependency
 * [rev:93449] Update the main.php PHP version numbers at the top doc block
 * [rev:92351] Increase size of URL length to be lowest common denominator of maximum length in modern browsers.
 * [rev:92220] Fixed appropriate failing tests to use PHP_EOL
 * [rev:92135] Removed MemberTableField::setController() - this is now redundant from r92134
 * [rev:92134] Added ComplexTableField::setController() which makes testing useful for switching between controllers
 * [rev:91850] added stubs to allow widgets to use treedropdown fields
 * [rev:91564] Moved Security::encryptallpasswords() to EncryptAllPasswordsTask (merged from r90948)
 * [rev:91543] removed debug statements
 * [rev:91541] fixed typo with path
 * [rev:91394] BUGFIX Disabling security token in HtmlEditorField?->FlashForm?(), its not passed in by the ajax request (merged from r91392)
 * [rev:91307] merged in 91306 from trunk
 * [rev:91261] Whitespace change


###  Other

 * [rev:98173] ENHANCEMNT: Added export and print buttons to reports (from r95815)
 * [rev:98172] Nicer dates (from r95776)
 * [rev:98147] Validation for calendardatefields (from r96958)
 * [rev:98093] Add some nice date formats (from r95772)
 * [rev:98001] added a canCreateTopLevel() if there is no parent object in CMSMain.php 
 * [rev:98001] added testCreationOfTopLevelPage toCMSMainTest.php
 * [rev:98001] added the nessessary 'database entries' in the CMSMainTest.yml
 * [rev:97991] Deleted javascript/CalendarDateField.js. The file is empty.
 * [rev:97898] Added values for new permission code 'VIEW_DRAFT_CONTENT' test
 * [rev:97897] Added test for new permission code.
 * [rev:97878] This covers the corner case where DB is out of sync with filesystem.
 * [rev:97384] REVERT: r97017 (Try to tidy HTML...) as causes inconsistent HTML
 * [rev:96966] REVERTED: 96961 fails the test, reverted.
 * [rev:96926] `<a ... />` tag which is not so nice
 * [rev:96781] point to the wrong subsite (from r87776)
 * [rev:96779] admin section via URL (from r87320)
 * [rev:96777] javascript syntax fixes (from r86396)
 * [rev:96712] MERGE merged back a whole bunch of defect fixes from trunk (from r87846)
 *