# 3.0.0-alpha2 #

## Overview ##

 - CMS: CMS JavaScript performance and perceived rendering improvements 
 - CMS: New dedicated "Add page" interface with page type descriptions
 - CMS: Improved "Insert Link" dialog with cleaner styles
 - CMS: Selected tabs and collapsed panels are now stored in a Cookie for a more consistent interface when returning later to the CMS
 - Framework: Support for multibyte page URLs (e.g. with German Umlauts). Flexible URL filtering through new URLSegmentFilter API
 - Framework: Customizeable HTML attributes on Form and FormField (which allows better usage of HTML5 and data attributes)
 - New ORM: All SS_List implementors support filter(), exclude() and sort() methods
 - New ORM: DataQuery and SQLQuery supports whereAny() for doing "OR" queries
 - New ORM: DataList supports canFilterBy()
 - GridField can be altered by attaching components for actions and view output. 
 - Folders are using GridField for CMS (and thereby the Asset admin).

See [3.0.0-alpha1](3.0.0-alpha1) for previous details.

## Details ##

### New ORM Better at handling filtering

DataList handles filtering in a more fluent way than using raw where calls. The below example shows an example

	:::php
	DataList::create('Member')->filter(array('FirstName' => 'Sam'))->exclude('Surname', 'Magnusson')->sort('Age');

When this query is executed it will contain all members with firstname of Sam but not with lastname Magnusson sorted by age ascending

For more information see documentation at [/topics/datamodel](../../topics/datamodel).

### Grid Field 

GridField has changed since 3.0.0-alpha1 to be more flexible. Any previous implementation are broken
and need to be changed according to the new API.

For implementation details see documentation at [/reference/grid-field](../../reference/grid-field).

## Upgrading ##

See [3.0.0 upgrading guide](../3.0.0) for further details.

## Changelog ##

### API Changes

 * 2012-01-10 [3c1d62a](https://github.com/silverstripe/sapphire/commit/3c1d62a) Added ArrayList::dataClass(), which will return the class of the first item in the list. (Sam Minnee)
 * 2012-01-09 [8a8f741](https://github.com/silverstripe/sapphire/commit/8a8f741) Returning image without links or subtitle from File-&gt;CMSThumbnail() for better compatibility with existing Image-&gt;getThumbnail() as well as new GridField viewing in AssetAdmin (Ingo Schommer)
 * 2012-01-09 [93eb2dd](https://github.com/silverstripe/sapphire/commit/93eb2dd) Added ArrayList::byID(), to improve its compatibility with DataList. (Sam Minnee)
 * 2012-01-09 [cb13299](https://github.com/silverstripe/sapphire/commit/cb13299) Added GridField_URLHandler component interface. (Sam Minnee)
 * 2012-01-02 [3c5c04c](https://github.com/silverstripe/sapphire/commit/3c5c04c) Removed $maxlength constructor argument from PasswordField, use setMaxlength() instead (Ingo Schommer)
 * 2012-01-02 [1a10e8b](https://github.com/silverstripe/sapphire/commit/1a10e8b) Removed $rows and $cols constructor arguments on TextareaField and HtmlEditorField, use setRows() and setCols() instead (Ingo Schommer)
 * 2012-01-02 [27ec98c](https://github.com/silverstripe/sapphire/commit/27ec98c) Removed $rightTitle and $folderName constructor arguments for FileField and SimpleImageField, use setRightTitle() and setFolderName() instead (Ingo Schommer)
 * 2012-01-02 [cc32957](https://github.com/silverstripe/sapphire/commit/cc32957) Don't allow specifying $form as constructor argument in various form fields, use setForm() instead (to achieve a cleaner API with less confusing parameter order) (Ingo Schommer)
 * 2012-01-02 [d678c12](https://github.com/silverstripe/sapphire/commit/d678c12) Removed FormAction-&gt;extraData() and $extraData constructor argument, use setAttribute() instead (Ingo Schommer)
 * 2012-01-02 [b3c08db](https://github.com/silverstripe/sapphire/commit/b3c08db) Deprecated FieldSet-specific methods from Form, namely dateFieldByName(), unsetDataFieldByName(), unsetFieldFromTab(), resetField() (Ingo Schommer)
 * 2012-01-01 [7179f04](https://github.com/silverstripe/sapphire/commit/7179f04) Deprecate Director::set_dev_servers() and Director::set_test_servers() in favour of Director::set_environment_type() or an _ss_environment.php file. (simonwelsh)
 * 2011-12-22 [b4d7e51](https://github.com/silverstripe/sapphire/commit/b4d7e51) Deprecated ImageFormAction, use FormAction with setAttribute('src', 'myimage.png') (Ingo Schommer)
 * 2011-12-17 [5a157a6](https://github.com/silverstripe/sapphire/commit/5a157a6) Deprecate SubstringFilter in favour of PartialMatchFilter. (Sam Minnee)
 * 2011-12-09 [9bf247c](https://github.com/silverstripe/sapphire/commit/9bf247c) Introduced DataQuery::whereAny() and SQLQuery::whereAny() (Stig Lindqvist)
 * 2011-12-09 [aafdb8e](https://github.com/silverstripe/sapphire/commit/aafdb8e) All SS_List implementators supports filter, exclude and sort methods (Stig Lindqvist)
 * 2011-12-06 [3c516b7](https://github.com/silverstripe/sapphire/commit/3c516b7) Refactored GridField modifiers into GridField_ColumnProvider, GridField_HTMLProvider, GridField_ActionProvider, and GridField_DataModifier interfaces, all added as components in the config. (Stig Lindqvist)
 * 2011-03-23 [9e548f5](https://github.com/silverstripe/sapphire/commit/9e548f5) FormField::Field() and FormField::FieldHolder() now render into templates on each FormField instead of creating HTML from PHP (Sean Harvey)
 * 2011-03-18 [3d8079c](https://github.com/silverstripe/sapphire/commit/3d8079c) Removed GeoIP functionality from sapphire. This now belongs in a separate "silverstripe-geoip" GitHub repository: https://github.com/silverstripe-labs/silverstripe-geoip (Sean Harvey)

### Features and Enhancements

 * 2012-01-10 [06605ff](https://github.com/silverstripe/sapphire/commit/06605ff) Provide a default Controller::Link() method, meaning that Controller objects can be constructed to help with testing forms. (Sam Minnee)
 * 2012-01-10 [7d87fa0](https://github.com/silverstripe/sapphire/commit/7d87fa0) Show 10 images per page in the AssetAdmin (Stig Lindqvist)
 * 2012-01-09 [60129f6](https://github.com/silverstripe/silverstripe-cms/commit/60129f6) Added new CMSFileAddController (Ingo Schommer)
 * 2012-01-09 [a06300f](https://github.com/silverstripe/sapphire/commit/a06300f) GridFieldItemEditView (and specific view and behaviour for usage in CMS) (Ingo Schommer)
 * 2012-01-09 [d9538d3](https://github.com/silverstripe/sapphire/commit/d9538d3) Migrating AssetAdmin fields to File/Folder/Image-&gt;getCMSFields() (Ingo Schommer)
 * 2012-01-09 [5a0eef5](https://github.com/silverstripe/sapphire/commit/5a0eef5) Replaced AssetTableField with GridField in Folder-&gt;getCMSFields() (and thereby in AssetAdmin) (Ingo Schommer)
 * 2012-01-06 [e7747b0](https://github.com/silverstripe/sapphire/commit/e7747b0) Saving panel collapse UI state in cookie (Ingo Schommer)
 * 2012-01-06 [5ec6aa5](https://github.com/silverstripe/sapphire/commit/5ec6aa5) GZipped/combined file loading for TinyMCE, which reduces number of HTTP requests in the standard CMS by a third (and decreases file size due to loading pre-compressed files by default) (Ingo Schommer)
 * 2012-01-06 [a633326](https://github.com/silverstripe/sapphire/commit/a633326) Allow Requirements::add_i18n_javascript() to return its files more optimised inclusion, using it in LeftAndMain (Ingo Schommer)
 * 2012-01-05 [6edf055](https://github.com/silverstripe/sapphire/commit/6edf055) Added children toggle actions to CMS menu, fixed menu link update behaviour when records change (Ingo Schommer)
 * 2012-01-05 [d91f76a](https://github.com/silverstripe/sapphire/commit/d91f76a) Created TinyMCE wrapper for link insertion dialogs in order to support other editors (Ingo Schommer)
 * 2012-01-04 [bb7edf8](https://github.com/silverstripe/silverstripe-cms/commit/bb7edf8) Marking "link" and "unlink" buttons in SilverStripe's TinyMCE as disabled if no link is selected (see 4646efe84 in sapphire for details) (Ingo Schommer)
 * 2012-01-04 [9885267](https://github.com/silverstripe/sapphire/commit/9885267) Simplified "insert link" interface and logic by reverting to TinyMCE's standard behaviour: Only allow linking on an existing selection, don't allow modifying the link content in the "insert" interface. Now that we're presenting this interface as a dialog rather than persistent sidebar its no longer necessary to have "unselected link creation+insertion". (Ingo Schommer)
 * 2012-01-04 [6bafc76](https://github.com/silverstripe/sapphire/commit/6bafc76) Updating TreeDropdownField title when hidden form value is changed (Ingo Schommer)
 * 2012-01-04 [b5c739e](https://github.com/silverstripe/sapphire/commit/b5c739e) Refactored TinyMCE LinkForm from behaviour.js to jQuery.entwine. Fixed clearing of fields when popup is closed. (Ingo Schommer)
 * 2011-12-29 [2ccda56](https://github.com/silverstripe/sapphire/commit/2ccda56) #6579 Show page status in page tree (pull request #142 from wolfv/sapphire) (wolfv)
 * 2011-12-26 [5242ed1](https://github.com/silverstripe/sapphire/commit/5242ed1) Added GroupedList for grouping lists into sub-lists by common values of a field. (ajshort)
 * 2011-12-26 [3478e4f](https://github.com/silverstripe/sapphire/commit/3478e4f) Made the form enctype configurable via a method Form-&gt;setEncType(). API CHANGE: Deprecated Form-&gt;FormEncType() in favour of Form-&gt;getEncType(). MINOR: Added enctypes as constants to the Form class. (ajshort)
 * 2011-12-22 [72694d8](https://github.com/silverstripe/sapphire/commit/72694d8) Custom form attributes through Form-&gt;setAttribute() (Ingo Schommer)
 * 2011-12-22 [afecc6b](https://github.com/silverstripe/silverstripe-cms/commit/afecc6b) #6579 Show page status in page tree (Wolf Vollprecht)
 * 2011-12-22 [b5421d9](https://github.com/silverstripe/sapphire/commit/b5421d9) Allowing custom attributes in (most) FormField implementations, which allows for HTML5 data attributes (Ingo Schommer)
 * 2011-12-20 [0d008b6](https://github.com/silverstripe/silverstripe-cms/commit/0d008b6) Allowing to add pages from main interface, in addition to dialog triggered from admin/pages (through CMSPageAddController) (Ingo Schommer)
 * 2011-12-20 [ac96375](https://github.com/silverstripe/sapphire/commit/ac96375) Support for fake "redirects" in ajax responses via History.replaceState() (used e.g. for an add form loading the record for editing afterwards, under its own URL) (Ingo Schommer)
 * 2011-12-19 [0587195](https://github.com/silverstripe/sapphire/commit/0587195) Allowing to inject &lt;style&gt; tags via ajax responses in LeftAndMain.js (used for the CMS page tree icons) (Ingo Schommer)
 * 2011-12-17 [075cb5d](https://github.com/silverstripe/sapphire/commit/075cb5d) keep Cookie::forceExpiry() consistent with Cookie::set() for preventing cookies from not being deleted. Fixes #56 (Will Rossiter)
 * 2011-12-17 [3e6a91a](https://github.com/silverstripe/sapphire/commit/3e6a91a) Allow ClassManifest to handle classes with namespaces, or that extend classes in namspaces or that implement interfaces in namespaces. (Simon Welsh)
 * 2011-12-17 [6977484](https://github.com/silverstripe/sapphire/commit/6977484) scale cms dialog popups based on browser. BUGFIX: #6760 ensure scrolling is supported in cms dialogs (Will Rossiter)
 * 2011-12-17 [30f049b](https://github.com/silverstripe/sapphire/commit/30f049b) ArrayList and DataList now show a nice view of the items inside when using Debug::show() (Sean Harvey)
 * 2011-12-15 [a6e2316](https://github.com/silverstripe/sapphire/commit/a6e2316) Created $('.cms-container').loadPanel() as a wrapper around History.pushState() to allow for global change tracking (Ingo Schommer)
 * 2011-12-14 [1c20213](https://github.com/silverstripe/sapphire/commit/1c20213) Hide "edit page" menu entry in CMS when no page is opened for editing (for usability reasons) (Ingo Schommer)
 * 2011-11-14 [e649082](https://github.com/silverstripe/silverstripe-cms/commit/e649082) Replaced client side URL filtering in CMS with ajax callbacks to new SiteTreeURLSegmentField, in order to align with extended server side logic (and avoid pre-filtering values too heavily before passing them to the server). Removed suggestions from client side user confirmation. (Ingo Schommer)
 * 2011-11-14 [b4eda40](https://github.com/silverstripe/silverstripe-cms/commit/b4eda40) Replaced client side URL filtering in CMS with ajax callbacks to new SiteTreeURLSegmentField, in order to align with extended server side logic (and avoid pre-filtering values too heavily before passing them to the server). Removed suggestions from client side user confirmation. (Ingo Schommer)
 * 2011-11-14 [0b5d205](https://github.com/silverstripe/silverstripe-cms/commit/0b5d205) Using new URLPathFilter API in SiteTree-&gt;generateURLSegment(), allowing customisation of URL filtering and transliteration (Ingo Schommer)
 * 2011-11-14 [81aeb8d](https://github.com/silverstripe/silverstripe-cms/commit/81aeb8d) Using new URLPathFilter API in SiteTree-&gt;generateURLSegment(), allowing customisation of URL filtering and transliteration (Ingo Schommer)
 * 2011-11-14 [9b27a4c](https://github.com/silverstripe/sapphire/commit/9b27a4c) More flexible URL filtering through new URLSegmentFilter API.  Support for multibyte URL segments through URLPathFilter::$default_allow_multibyte. Abstraction from Convert::raw2url() (and SiteTree-&gt;generateURLSegment()) (Ingo Schommer)
 * 2011-04-18 [288369f](https://github.com/silverstripe/sapphire/commit/288369f) Updated the template language documentation, based on work done by mrmorphic. (Mark Stephens)
 * 2011-04-12 [ac79934](https://github.com/silverstripe/silverstripe-cms/commit/ac79934) Render page tree icons as stylesheets rather than $_TREE_ICONS JS definitions. Removed file/folder swapping of SiteTree::$icon, use relative file path including extension instead. (phalkunz)

### Bugfixes

 * 2012-01-10 [c0d891c](https://github.com/silverstripe/sapphire/commit/c0d891c) Fixed GridField::getModelClass() not to access protected property. (Sam Minnee)
 * 2012-01-10 [489191b](https://github.com/silverstripe/sapphire/commit/489191b) Fixed notice-level errors in GridField, exposed by test failures. (Sam Minnee)
 * 2012-01-10 [7de5851](https://github.com/silverstripe/silverstripe-cms/commit/7de5851) Can't upload files to root folder (Stig Lindqvist)
 * 2012-01-10 [1f190eb](https://github.com/silverstripe/silverstripe-cms/commit/1f190eb) Return a RootForm for AssetAdmin so Form get the correct Fields on POST (Stig Lindqvist)
 * 2012-01-10 [ce6d24c](https://github.com/silverstripe/sapphire/commit/ce6d24c) Remvoed unused method Security::authenticate() (Sam Minnee)
 * 2012-01-10 [284360e](https://github.com/silverstripe/sapphire/commit/284360e) Prevented horizontal scrollbar apearing, irresective of screen-res. MINOR: Removed box-shadow for gridfield .field elements. Previous fix revealed this extending beyond GridField table's right-side (Russell Michell)
 * 2012-01-09 [c82bae1](https://github.com/silverstripe/sapphire/commit/c82bae1) Prepopulating relation list in FormScaffolder (Ingo Schommer)
 * 2012-01-09 [d4bde47](https://github.com/silverstripe/sapphire/commit/d4bde47) Fixed GridField-&gt;setFieldFormatting() (Ingo Schommer)
 * 2012-01-09 [3937249](https://github.com/silverstripe/sapphire/commit/3937249) GridField_Actions did not work in more complex Forms with tabsets (i.e SecurityAdmin) when using GridField_Action BUGFIX Empty GridState data causes isset error BUGFIX Last field of GridFieldFilter outputs wrong label (Stig Lindqvist)
 * 2012-01-09 [3bd0566](https://github.com/silverstripe/sapphire/commit/3bd0566) Fixed strange-looking borders on filter-inputs in Opera (Russell Michell)
 * 2012-01-06 [6dd3dc9](https://github.com/silverstripe/sapphire/commit/6dd3dc9) Support for commas in URLs processed by Requirements and jQuery.ondemand (which uses commas to serialise its dependency data into HTTP headers) (Ingo Schommer)
 * 2012-01-02 [4baef3b](https://github.com/silverstripe/sapphire/commit/4baef3b) Using objects rather than arrays for TreeDropdownField ajax search params, fixed selectors stuffed up in e385bbcb (Ingo Schommer)
 * 2012-01-02 [e31851b](https://github.com/silverstripe/sapphire/commit/e31851b) Correctly mark DatetimeField, MoneyField and PhoneNumberField composites as disabled or readonly (Ingo Schommer)
 * 2012-01-02 [4056b94](https://github.com/silverstripe/sapphire/commit/4056b94) Improved ClassInfo::ancestry() performance through in-memory caching and removal of unnecessary is_object() check - get_class() will complain if its not passed an object already) (Ingo Schommer)
 * 2011-12-23 [dd546a9](https://github.com/silverstripe/sapphire/commit/dd546a9) Merge request arrays recursively (Simon Welsh)
 * 2011-12-23 [f751648](https://github.com/silverstripe/sapphire/commit/f751648) Sanitise keys and tags before using them with Zend_Cache. (Simon Welsh)
 * 2011-12-23 [27a51ed](https://github.com/silverstripe/sapphire/commit/27a51ed) Namespaced classes were always having their namespace prepended to their base class (Simon Welsh)
 * 2011-12-21 [475f376](https://github.com/silverstripe/sapphire/commit/475f376) Using separate template for readonly version of Textarea (mainly to avoid SSViewer bugs, but also for more granular customisation) (Ingo Schommer)
 * 2011-12-18 [20554b1](https://github.com/silverstripe/sapphire/commit/20554b1) DataQuery::orderby() don't sort relations DESC (Stig Lindqvist)
 * 2011-12-17 [ae0ec63](https://github.com/silverstripe/silverstripe-cms/commit/ae0ec63) Fixes #6809. Updates page title heading when page title changes on edit page in CMS. (Frank Mullenger)
 * 2011-12-17 [160f712](https://github.com/silverstripe/sapphire/commit/160f712) Update the page title heading on edit page in CMS (fixes #6809) (Frank Mullenger)
 * 2011-12-17 [04c8e2b](https://github.com/silverstripe/sapphire/commit/04c8e2b) Generate valid PHP when $includeDebuggingComments is true. (Simon Welsh)
 * 2011-12-17 [28dff01](https://github.com/silverstripe/silverstripe-cms/commit/28dff01) prevent refreshing the history panel when reloading versions (Will Rossiter)
 * 2011-12-17 [60ced3b](https://github.com/silverstripe/sapphire/commit/60ced3b) Added default value for limit on LimitCharacters() to prevent backwards-compat issue (fixes 0c3af805) (Sam Minnee)
 * 2011-12-17 [fece61c](https://github.com/silverstripe/sapphire/commit/fece61c) Use numeric literal for numeric less-than filter. (Sam Minnee)
 * 2011-12-17 [a04c141](https://github.com/silverstripe/sapphire/commit/a04c141) update admin menu links when current page ID updates. Fixes #6768. (Will Rossiter)
 * 2011-12-17 [8e58529](https://github.com/silverstripe/sapphire/commit/8e58529) Don't throw errors if older modules aren't aware of the DataModel argument. (Sam Minnee)
 * 2011-12-17 [da2ac79](https://github.com/silverstripe/sapphire/commit/da2ac79) Check for the correct type for $data['namespace'] (Simon Welsh)
 * 2011-12-17 [1d92172](https://github.com/silverstripe/sapphire/commit/1d92172) Returning 'first last' in ViewableData-&gt;FirstLast() if item is both at the same time (Ingo Schommer)
 * 2011-12-17 [97f8cc4](https://github.com/silverstripe/sapphire/commit/97f8cc4) Skip NamespacedClassManifestTest on PHP versions before 5.3 (Simon Welsh)
 * 2011-12-17 [0c3af80](https://github.com/silverstripe/sapphire/commit/0c3af80) Better handling of multibyte strings in LimitCharacters(), removed code duplication by more flexible base implementation at StringField-&gt;LimitCharacters() (Merge pull request #121 from edlund/sapphire) (Ingo Schommer)
 * 2011-12-17 [70d40cf](https://github.com/silverstripe/sapphire/commit/70d40cf) Removed use of base "Exception" class in order to avoid failures on PHPUnit 3.6. (Sam Minnee)
 * 2011-12-16 [e102d9d](https://github.com/silverstripe/sapphire/commit/e102d9d) Corrected use of ENT_QUOTES/UTF8 on htmlentities in installer introduced by r3a7ac9759ab8f98eee0bb15db4618fd0ee146ab6. fixes #6806 (Mark James)
 * 2011-12-15 [64f6b46](https://github.com/silverstripe/sapphire/commit/64f6b46) Fixed change tracking of checkboxes and radiobuttons in jquery.changetracker plugin (Ingo Schommer)
 * 2011-12-15 [482324b](https://github.com/silverstripe/sapphire/commit/482324b) Fixed form change tracking in the CMS, integrated it into menu changes. Reduced TinyMCE coupling. (Ingo Schommer)
 * 2011-12-14 [d3477cc](https://github.com/silverstripe/sapphire/commit/d3477cc) Fixed CMS panel expansion after changing links in the CMS (needed to retain the layout settings of the old panel to keep the preview expanded) (Ingo Schommer)
 * 2011-12-14 [15e9d08](https://github.com/silverstripe/silverstripe-cms/commit/15e9d08) Making HTML5 History support optional, so we can disable HTML4 hash change fallback (Ingo Schommer)
 * 2011-12-14 [e8ecdf6](https://github.com/silverstripe/sapphire/commit/e8ecdf6) Disabling HTML5 history hash change fallbacks due to infinite loops on changing hash values (Ingo Schommer)
 * 2011-12-14 [9c6cbf7](https://github.com/silverstripe/sapphire/commit/9c6cbf7) Making HTML5 History support optional, so we can disable HTML4 hash change fallback (Ingo Schommer)
 * 2011-12-13 [f2ec8b0](https://github.com/silverstripe/sapphire/commit/f2ec8b0) Enforcing TinyMCE textarea call on window.load in addition to entwine/DOMReady to ensure TinyMCE.init() has been called and all plugins are loaded. (Ingo Schommer)
 * 2011-12-12 [c380af6](https://github.com/silverstripe/silverstripe-cms/commit/c380af6) Including HTMLEditorConfig::include_js() in LeftAndMain instead of CMSMain for loading consistency. (Ingo Schommer)
 * 2011-12-12 [02d1ff8](https://github.com/silverstripe/sapphire/commit/02d1ff8) Removed synchronous entwine mode when loading CMS UIs via ajax, which effectively brings down IE (e.g. roughly 10x as many "events" in DynaTrace for IE8) (Ingo Schommer)
 * 2011-12-12 [2170835](https://github.com/silverstripe/sapphire/commit/2170835) Using faster entwine selectors (class/attr rather than CSS3 pseudo selectors) (Ingo Schommer)
 * 2011-12-09 [671c8b7](https://github.com/silverstripe/sapphire/commit/671c8b7) NegationFilter and SubstringFilter did not set the DataModel on apply() (Stig Lindqvist)
 * 2011-12-08 [e22eaec](https://github.com/silverstripe/sapphire/commit/e22eaec) Restfulserver should use the correct way when sorting SS_Lists (Stig Lindqvist)
 * 2011-12-04 [755663a](https://github.com/silverstripe/sapphire/commit/755663a) Set default mbstring encoding in Core.php instead of main.php and cli-script.php so phpunit binary test runs behave consistently (same as running through TestRunner+cli-script.php). Fixes URLSegmentFilterTest (Ingo Schommer)
 * 2011-12-04 [34686ca](https://github.com/silverstripe/sapphire/commit/34686ca) Restoring system error handlers in bootstrap.php so running tests through the phpunit binary behaves the same way as TestRunner (specifically to fix DeprecationTest on our CI infrastructure) (Ingo Schommer)
 * 2011-12-02 [1553c3e](https://github.com/silverstripe/sapphire/commit/1553c3e) Fixed ModelAdmin.js dropdown panel selection (Ingo Schommer)
 * 2011-11-29 [3a7ac97](https://github.com/silverstripe/sapphire/commit/3a7ac97) Consistently using multibyte-safe htmlentities() (Ingo Schommer)
 * 2011-11-14 [d1ebe1c](https://github.com/silverstripe/sapphire/commit/d1ebe1c) Fixed double negation of transliterator checks in FileNameFilter, which meant it wasn't used by default when filtering SiteTree-&gt;URLSegment (Ingo Schommer)
 * 2011-11-13 [d30b4b1](https://github.com/silverstripe/sapphire/commit/d30b4b1) Respecting api_access on has_one relations in RestfulServer BUGFIX Limiting fields according to api_access on relation object (rather than the "root" object) in RestfulServer BUGFIX Limit listing of has_one relations in RestfulServer to actual relation (was listing all objects before) BUGFIX Creating correct object instances in RestfulServer-&gt;getHandler() for relation queries (Ingo Schommer)
 * 2011-11-08 [fc400d9](https://github.com/silverstripe/silverstripe-cms/commit/fc400d9) Removed use of deprecated join function from RemoveOrphanedPagesTask (Sam Minnee)
 * 2011-10-31 [735e646](https://github.com/silverstripe/silverstripe-cms/commit/735e646) $date is not set on SilverStripeNavigatorItem_ArchiveLink (Stig Lindqvist)
 * 2011-03-24 [19e9b19](https://github.com/silverstripe/sapphire/commit/19e9b19) Ensure TextareaField template is encoding characters correctly (Sean Harvey)

### Minor changes

 * 2012-01-10 [b311fbf](https://github.com/silverstripe/sapphire/commit/b311fbf) Always flush the manifest when using sapphire/test/bootstrap.php (Sam Minnee)
 * 2012-01-10 [65299af](https://github.com/silverstripe/sapphire/commit/65299af) Removed database coupling from GridFieldTest. (Sam Minnee)
 * 2012-01-10 [6a08a82](https://github.com/silverstripe/sapphire/commit/6a08a82) Removed notice-level errors from form field construction. (Sam Minnee)
 * 2012-01-10 [e2661df](https://github.com/silverstripe/sapphire/commit/e2661df) Fixes for IE&lt;8 (Russell Michell)
 * 2012-01-10 [3555ef2](https://github.com/silverstripe/sapphire/commit/3555ef2) Re-instated &lt;td&gt; horizontal borders (Russell Michell)
 * 2012-01-10 [8b8e49e](https://github.com/silverstripe/sapphire/commit/8b8e49e) Fixed odd-looking borders on filter buttons in Opera (Russell Michell)
 * 2012-01-10 [ade3f5b](https://github.com/silverstripe/sapphire/commit/ade3f5b) Typo in language file (Russell Michell)
 * 2012-01-10 [eb77c4b](https://github.com/silverstripe/sapphire/commit/eb77c4b) Disabled sort-input focus+button move if only 1 such field exists (Russell Michell)
 * 2012-01-10 [34cc18e](https://github.com/silverstripe/sapphire/commit/34cc18e) Added a test for GridField_URLHandler components. (Sam Minnee)
 * 2012-01-10 [bc58684](https://github.com/silverstripe/sapphire/commit/bc58684) Make sake executable (Sam Minnee)
 * 2012-01-09 [a1c63a2](https://github.com/silverstripe/sapphire/commit/a1c63a2) Only setting style attributes in LeftAndMain panel handling if it was previously set (Ingo Schommer)
 * 2012-01-09 [f50e11b](https://github.com/silverstripe/sapphire/commit/f50e11b) Separating menu entries for "add file" and "edit file" (Ingo Schommer)
 * 2012-01-09 [b01b9b9](https://github.com/silverstripe/sapphire/commit/b01b9b9) Removed button styling for GridField, as its preliminary and doesn't apply to any action other than "delete" (Ingo Schommer)
 * 2012-01-09 [e34f56d](https://github.com/silverstripe/silverstripe-cms/commit/e34f56d) Better failsafes for tree hints (allows add if hint for class is if not defined) (Ingo Schommer)
 * 2012-01-09 [0caf199](https://github.com/silverstripe/sapphire/commit/0caf199) Better failsafes for tree hints (allows move if hint for class is if not defined) (Ingo Schommer)
 * 2012-01-09 [213cfb0](https://github.com/silverstripe/silverstripe-cms/commit/213cfb0) Added routing for AssetAdmin to cms/_config.php (required for GridField?) (Ingo Schommer)
 * 2012-01-09 [24a37da](https://github.com/silverstripe/sapphire/commit/24a37da) Added GridFieldAction_Delete (Ingo Schommer)
 * 2012-01-09 [1e1e3a2](https://github.com/silverstripe/sapphire/commit/1e1e3a2) Fixed a few layout glitches on the grid field documentation. (Sam Minnee)
 * 2012-01-09 [740f501](https://github.com/silverstripe/sapphire/commit/740f501) Added documentation for the grid field, including information on how to extend it. (Sam Minnee)
 * 2012-01-07 [9eac776](https://github.com/silverstripe/sapphire/commit/9eac776) Using SCSS/Compass for sapphire/css (Ingo Schommer)
 * 2012-01-07 [7e34721](https://github.com/silverstripe/sapphire/commit/7e34721) Only use cookie storage in TabSet.js if the element has a unique ID to correlate the cookie to (Ingo Schommer)
 * 2012-01-07 [ef514b9](https://github.com/silverstripe/sapphire/commit/ef514b9) Fixed SecurityAdmin styling (Ingo Schommer)
 * 2012-01-07 [09bfe93](https://github.com/silverstripe/sapphire/commit/09bfe93) Updated the docblocks for GridField (Stig Lindqvist)
 * 2012-01-07 [ea4b9fe](https://github.com/silverstripe/sapphire/commit/ea4b9fe) Added tests for GridField with minor changes to support them (Stig Lindqvist)
 * 2012-01-06 [aff72e7](https://github.com/silverstripe/sapphire/commit/aff72e7) Simpler field alignment of OptionsetField (and some specifics for member-profile-form) (Ingo Schommer)
 * 2012-01-06 [d88075e](https://github.com/silverstripe/silverstripe-cms/commit/d88075e) Disabling empty requirement in CMSMain (Ingo Schommer)
 * 2012-01-06 [9d1822e](https://github.com/silverstripe/silverstripe-cms/commit/9d1822e) Don't allow page type selection in add form when radio button is disabled (Ingo Schommer)
 * 2012-01-06 [14d3dea](https://github.com/silverstripe/silverstripe-cms/commit/14d3dea) Added panel identifiers to enable cookie support, added collapsed panel view (Ingo Schommer)
 * 2012-01-06 [c6e1937](https://github.com/silverstripe/sapphire/commit/c6e1937) Rotated labels for collapsed panels (Ingo Schommer)
 * 2012-01-06 [6bff691](https://github.com/silverstripe/silverstripe-cms/commit/6bff691) Better combination of i18n JS files in CMSMain (Ingo Schommer)
 * 2012-01-06 [fcc01a3](https://github.com/silverstripe/sapphire/commit/fcc01a3) More spriting in CMS styles (Ingo Schommer)
 * 2012-01-06 [850ea4c](https://github.com/silverstripe/sapphire/commit/850ea4c) Don't combine CMS-related CSS files in LeftAndMain, as it breaks relative image paths (Ingo Schommer)
 * 2012-01-06 [66d01d6](https://github.com/silverstripe/sapphire/commit/66d01d6) Deselected menu toggles (Ingo Schommer)
 * 2012-01-05 [e517abf](https://github.com/silverstripe/sapphire/commit/e517abf) Unselect a selected node in TreeDropdownField (for lack of better unselect UI) (Ingo Schommer)
 * 2012-01-05 [6dd0535](https://github.com/silverstripe/silverstripe-cms/commit/6dd0535) Only set current record in CMSMain-&gt;AddForm() if its not the homepage - not ideal, but root is the more likely default given the information at hand (Ingo Schommer)
 * 2012-01-05 [6887b88](https://github.com/silverstripe/silverstripe-cms/commit/6887b88) Selection bugfixes for CMSMain.AddForm.js, more efficient tree metadata (Ingo Schommer)
 * 2012-01-05 [167bc04](https://github.com/silverstripe/silverstripe-cms/commit/167bc04) Making page drop down searchable on CMS add form, and ensuring that the default page option is showing first (Ingo Schommer)
 * 2012-01-05 [095602b](https://github.com/silverstripe/sapphire/commit/095602b) TreeDropdownField-&gt;setShowInSearch() (Ingo Schommer)
 * 2012-01-05 [d8388b7](https://github.com/silverstripe/sapphire/commit/d8388b7) Improved .cms-add-form styling (Ingo Schommer)
 * 2012-01-04 [39dd90d](https://github.com/silverstripe/sapphire/commit/39dd90d) Fixed relative dialog.html reference in tinymce-advcode (it assumes to be in main TinyMCE folder structure) (Ingo Schommer)
 * 2012-01-04 [7a29a4a](https://github.com/silverstripe/silverstripe-cms/commit/7a29a4a) Using entwine calls in ssbuttons TinyMCE plugin (Ingo Schommer)
 * 2012-01-04 [4140dda](https://github.com/silverstripe/silverstripe-cms/commit/4140dda) Using new DataList API for DependentPages in SiteTree-&gt;getCMSFields() (Ingo Schommer)
 * 2012-01-04 [4d12803](https://github.com/silverstripe/sapphire/commit/4d12803) Quoting jQuery selectors in TreeDropdownField.js to allow for non-numeric identifiers (Ingo Schommer)
 * 2012-01-03 [e4d65ab](https://github.com/silverstripe/sapphire/commit/e4d65ab) Adding step indicators to "insert link" dialog (Ingo Schommer)
 * 2012-01-03 [8da0def](https://github.com/silverstripe/silverstripe-cms/commit/8da0def) Using new triangle/step markup in AddForm (Ingo Schommer)
 * 2012-01-03 [97bff7e](https://github.com/silverstripe/sapphire/commit/97bff7e) More robust way to style "triangle"/"flyout"/"step indicator" in forms, via background image rather than CSS3 with hard-to-maintain dimension and positioning tweaks. Use inline-block to have it working within other elements (+titles) rather than standalone (Ingo Schommer)
 * 2012-01-03 [d9ad1e6](https://github.com/silverstripe/sapphire/commit/d9ad1e6) Cache link forms for a couple of minutes, as they don't contain any record/interface specific settings and generally only change when the underlying PHP is changed (Ingo Schommer)
 * 2012-01-03 [1ec694d](https://github.com/silverstripe/sapphire/commit/1ec694d) Moved EditorToolbar() from CMSMain to LeftAndMain (as we don't support loading link forms via ajax) (Ingo Schommer)
 * 2012-01-03 [f8d1523](https://github.com/silverstripe/silverstripe-cms/commit/f8d1523) Moved EditorToolbar() from CMSMain to LeftAndMain (as we don't support loading link forms via ajax) (Ingo Schommer)
 * 2012-01-03 [a4494d4](https://github.com/silverstripe/silverstripe-cms/commit/a4494d4) Triggering parent field expansion on click (on change doesn't work in IE) (Ingo Schommer)
 * 2012-01-03 [e35991b](https://github.com/silverstripe/silverstripe-cms/commit/e35991b) Misc styling fixes around dialogs and "add page" styling (Ingo Schommer)
 * 2012-01-03 [b4b6e5a](https://github.com/silverstripe/sapphire/commit/b4b6e5a) Cleaned up CMS dialog styling (now works with/without tabs, in iframe and inline markup), removed superfluous SCSS variable declarations (Ingo Schommer)
 * 2012-01-03 [3202d12](https://github.com/silverstripe/sapphire/commit/3202d12) Moved ModelAdmin styles into separate file (Ingo Schommer)
 * 2012-01-03 [8dd64bd](https://github.com/silverstripe/sapphire/commit/8dd64bd) Using box-sizing to lay out form fields rather than relying on hacky 90% widths + pixel-based paddings, which makes it impossible to align anything outside of the field container the these elements. Using conditional CSS to disable field padding if box-sizing is not available. Generalized "stacked" form pattern in _form.scss, fixed CMS actions padding to align with fields. (Ingo Schommer)
 * 2012-01-03 [66a6047](https://github.com/silverstripe/sapphire/commit/66a6047) Close open TreeDropdownField panels if user clicks outside of the field (emulate behaviour of chosen.js and most native OS dropdowns) (Ingo Schommer)
 * 2012-01-03 [c0c073e](https://github.com/silverstripe/sapphire/commit/c0c073e) Disable 'preview' button if not applicable (Ingo Schommer)
 * 2012-01-03 [a24675c](https://github.com/silverstripe/sapphire/commit/a24675c) Updated chosen.js to 0.9.5 (Ingo Schommer)
 * 2012-01-03 [4a8acb9](https://github.com/silverstripe/sapphire/commit/4a8acb9) Fixed anchor selector initialisation for HtmlEditorField (Ingo Schommer)
 * 2012-01-03 [0cf6421](https://github.com/silverstripe/sapphire/commit/0cf6421) Button styling for "insert" dialogs (Ingo Schommer)
 * 2012-01-03 [7af52b1](https://github.com/silverstripe/sapphire/commit/7af52b1) Applying button behaviour to .cms namespace in order to include dialogs as well (Ingo Schommer)
 * 2012-01-02 [6d2b519](https://github.com/silverstripe/sapphire/commit/6d2b519) Auto-expanding nodes in TreeDropdownField, unsetting default titles when search field is focused (Ingo Schommer)
 * 2012-01-02 [c0fddf2](https://github.com/silverstripe/sapphire/commit/c0fddf2) Fixed regression on missing return value in CompositeField-&gt;FieldHolder() (Ingo Schommer)
 * 2012-01-02 [eb5716f](https://github.com/silverstripe/sapphire/commit/eb5716f) Using instanceof rather than is_a in CheckboxSetField (Ingo Schommer)
 * 2012-01-02 [7f9ced2](https://github.com/silverstripe/sapphire/commit/7f9ced2) Docs on github collab (Ingo Schommer)
 * 2012-01-01 [7d46e7e](https://github.com/silverstripe/sapphire/commit/7d46e7e) Added CMS architecture documentation (Ingo Schommer)
 * 2011-12-29 [7a1e25b](https://github.com/silverstripe/silverstripe-cms/commit/7a1e25b) Shorter tree title badges (Ingo Schommer)
 * 2011-12-29 [ee2c800](https://github.com/silverstripe/silverstripe-cms/commit/ee2c800) Merge error (Ingo Schommer)
 * 2011-12-26 [d692c22](https://github.com/silverstripe/sapphire/commit/d692c22) Fixed FileField-&gt;Value() erroring when files value not set. (ajshort)
 * 2011-12-26 [6aa90e6](https://github.com/silverstripe/sapphire/commit/6aa90e6) Replaced is_a with instanceof to fix bugs with the changed is_a behaviour in PHP 5.3.7. (ajshort)
 * 2011-12-23 [7d245c3](https://github.com/silverstripe/sapphire/commit/7d245c3) Reduced unnecessary autoloading (Ingo Schommer)
 * 2011-12-22 [d535847](https://github.com/silverstripe/sapphire/commit/d535847) Making $title optional in TreeMultiselectField to comply with parent implementation (Ingo Schommer)
 * 2011-12-22 [0dab75c](https://github.com/silverstripe/sapphire/commit/0dab75c) Making SecurityAdminTest more resilient against markup order changes (Ingo Schommer)
 * 2011-12-22 [1eaf45a](https://github.com/silverstripe/sapphire/commit/1eaf45a) Documentation for FormField-&gt;setTemplate() and FormField-&gt;setAttribute() (Ingo Schommer)
 * 2011-12-22 [c77f4e8](https://github.com/silverstripe/sapphire/commit/c77f4e8) Allowing usage of FormField-&gt;Type() on base implementation (Ingo Schommer)
 * 2011-12-22 [639caea](https://github.com/silverstripe/sapphire/commit/639caea) Using FieldList instead of FieldSet on SelectionGroup to comply with parent implementation (Ingo Schommer)
 * 2011-12-21 [2a429c9](https://github.com/silverstripe/sapphire/commit/2a429c9) Added Member Profile Popup Styling MINOR: Better button styles MINOR: Now compass for button sprites (Wolf Vollprecht)
 * 2011-12-21 [b36ad3b](https://github.com/silverstripe/sapphire/commit/b36ad3b) Testing nested if blocks in SSViewerTest (Ingo Schommer)
 * 2011-12-21 [1f3b0d2](https://github.com/silverstripe/sapphire/commit/1f3b0d2) Fixed link form prepopulation of selected text in CMS (Ingo Schommer)
 * 2011-12-21 [53506f3](https://github.com/silverstripe/sapphire/commit/53506f3) Don't remove checkboxes from page tree after batch actions, as it causes an inconsistent UI ('multi-select' view is still enabled) (fixes #6758) (Ingo Schommer)
 * 2011-12-21 [0d26776](https://github.com/silverstripe/sapphire/commit/0d26776) Deselecting tree items after swtiching back from multi-select (fixes #6810, thanks wolfv) (Ingo Schommer)
 * 2011-12-20 [1914f0b](https://github.com/silverstripe/silverstripe-cms/commit/1914f0b) Checking for existence of defaultParent in CMSMain-&gt;SiteTreeHints() (Ingo Schommer)
 * 2011-12-20 [cdedbb8](https://github.com/silverstripe/sapphire/commit/cdedbb8) ModelAdmin styling (Anselm Christophersen)
 * 2011-12-20 [30377f2](https://github.com/silverstripe/sapphire/commit/30377f2) Update CMS menu state on form submission (as well as history state change) (Ingo Schommer)
 * 2011-12-20 [2257763](https://github.com/silverstripe/sapphire/commit/2257763) Allow overwriting of 'X-Controller' and 'X-Title' HTTP headers in CMS (Ingo Schommer)
 * 2011-12-20 [dccbb8b](https://github.com/silverstripe/silverstripe-cms/commit/dccbb8b) Removing compass asset_cache_buster functionality, as it wrongly changes the hashes even if files haven't changed, causing merging hassles - leave cache control to the webserver (Ingo Schommer)
 * 2011-12-20 [c70e70b](https://github.com/silverstripe/sapphire/commit/c70e70b) Removing compass asset_cache_buster functionality, as it wrongly changes the hashes even if files haven't changed, causing merging hassles - leave cache control to the webserver (Ingo Schommer)
 * 2011-12-20 [2211fc1](https://github.com/silverstripe/sapphire/commit/2211fc1) Added reuseable .cms-panel-padded style (Ingo Schommer)
 * 2011-12-20 [47f53df](https://github.com/silverstripe/sapphire/commit/47f53df) Reverted special styling of preview button in CMS, too hard to keep consistent alignment (Ingo Schommer)
 * 2011-12-20 [068fcb2](https://github.com/silverstripe/sapphire/commit/068fcb2) Added temporary, hardcoded "add page" menu links (Ingo Schommer)
 * 2011-12-19 [11b3b43](https://github.com/silverstripe/sapphire/commit/11b3b43) Only load preview panel if its visible, to avoid unnecessary asset loads and processing. Only refresh edit form view from preview events when its visible. (Ingo Schommer)
 * 2011-12-19 [f1f8dcd](https://github.com/silverstripe/sapphire/commit/f1f8dcd) Improved CMS UI context by showing breadcrumbs in form record title, using current record instead of form field to determine values (Ingo Schommer)
 * 2011-12-18 [023ac99](https://github.com/silverstripe/silverstripe-cms/commit/023ac99) Making allowed_actions explicit on some core controllers (thanks cbarberis, fixes pull request #1) (Ingo Schommer)
 * 2011-12-18 [68a3944](https://github.com/silverstripe/sapphire/commit/68a3944) Fixed usage of FieldSet-&gt;insertFirst() in ModelAdmin, no longer present in FieldList (Ingo Schommer)
 * 2011-12-18 [0bfc0bc](https://github.com/silverstripe/sapphire/commit/0bfc0bc) Cleaning $Content property explicitly for SecurityAdmin-&gt;groupimport() iframe (Ingo Schommer)
 * 2011-12-18 [4c8f6e7](https://github.com/silverstripe/silverstripe-cms/commit/4c8f6e7) Reduced HTML validation errors in CMS (Ingo Schommer)
 * 2011-12-18 [4d28b79](https://github.com/silverstripe/sapphire/commit/4d28b79) Reduced HTML validation errors in CMS and FieldGroup (Ingo Schommer)
 * 2011-12-18 [bc2bb53](https://github.com/silverstripe/sapphire/commit/bc2bb53) Fixed drag'n'drop in SecurityAdmin (thanks frankmullenger) (Ingo Schommer)
 * 2011-12-18 [f59d11c](https://github.com/silverstripe/sapphire/commit/f59d11c) DataList::sort() can sort by relation name (Stig Lindqvist)
 * 2011-12-17 [e17b4a1](https://github.com/silverstripe/silverstripe-cms/commit/e17b4a1) update PageTypes to use updated tab path for CMS fields. Fixes #6811 (Will Rossiter)
 * 2011-12-17 [0bdfc0c](https://github.com/silverstripe/sapphire/commit/0bdfc0c) On PHPUnit 3.6, show the output of tests. (Sam Minnee)
 * 2011-12-17 [4d0d579](https://github.com/silverstripe/sapphire/commit/4d0d579) merged edlinklater/master into master. Fixes #134 (Will Rossiter)
 * 2011-12-17 [0154148](https://github.com/silverstripe/sapphire/commit/0154148) code formatting (Will Rossiter)
 * 2011-12-17 [d407f4c](https://github.com/silverstripe/sapphire/commit/d407f4c) Revert special formatting of preview button, fix Action button icons in IE8 (=)
 * 2011-12-17 [45c25e9](https://github.com/silverstripe/sapphire/commit/45c25e9) Disable PhpSyntaxTest until we decide whether to re-write it or remove it (Hamish Friedlander)
 * 2011-12-17 [10b0942](https://github.com/silverstripe/sapphire/commit/10b0942) Change error reporting level to explicitly exclude values rather than using XOR. (Simon Welsh)
 * 2011-12-17 [9540e24](https://github.com/silverstripe/silverstripe-cms/commit/9540e24) Removed unnecessary variable declaration in SiteTree (thanks mattclegg) (Ingo Schommer)
 * 2011-12-17 [e5e7511](https://github.com/silverstripe/sapphire/commit/e5e7511) Patching prototype.js connection closing to avoid JS errors (see pull request #106) (Ingo Schommer)
 * 2011-12-17 [3f28582](https://github.com/silverstripe/sapphire/commit/3f28582) Added URLSegmentFilterTest-&gt;testReplacements() (Ingo Schommer)
 * 2011-12-16 [7a80e6d](https://github.com/silverstripe/silverstripe-cms/commit/7a80e6d) Ensuring assets/ folder is created before using it in FileLinkTrackingTest (and using ASSETS_PATH constant instead of hardcoding it) (Ingo Schommer)
 * 2011-12-15 [bad1b88](https://github.com/silverstripe/sapphire/commit/bad1b88) Fixed change detection false positives for TinyMCE in IE, use TinyMCE.isDirty() rather than string comparison (Ingo Schommer)
 * 2011-12-15 [bf11a32](https://github.com/silverstripe/sapphire/commit/bf11a32) Fixed button layout height adjustment in CMS, reduced redraw() invocations on cms-edit-form (Ingo Schommer)
 * 2011-12-15 [adb5acc](https://github.com/silverstripe/sapphire/commit/adb5acc) Hiding panel while redrawing via ajax (for repaint/reflow performance), enforcing redraw of tabs before their own onmatch() to avoid layout glitches (Ingo Schommer)
 * 2011-12-15 [d732a78](https://github.com/silverstripe/sapphire/commit/d732a78) Don't toggle CMS panels if state is already correct (to avoid the CMS UI doing three expensive redraw() invocation in its event listeners where one is sufficient) (Ingo Schommer)
 * 2011-12-15 [7253746](https://github.com/silverstripe/sapphire/commit/7253746) Fixed IE6 compat note styling (Ingo Schommer)
 * 2011-12-15 [ddad7fb](https://github.com/silverstripe/sapphire/commit/ddad7fb) Fixed jquery.changetracker JSpec tests, added support for calling public methods as string arguments on plugin (which was already assumed to be the case in the JSpec tests) (Ingo Schommer)
 * 2011-12-15 [0563018](https://github.com/silverstripe/sapphire/commit/0563018) Moved autocomplete logic from LeftAndMain.js to LeftAndMain.EditForm.js where it belongs (Ingo Schommer)
 * 2011-12-14 [2777637](https://github.com/silverstripe/sapphire/commit/2777637) Fixed preview behaviour blacklist, was including "CMSMain" which is applied to every CMS panel (so it didn't re-load the CMS edit forms on any clicks in the preview iframe) (Ingo Schommer)
 * 2011-12-14 [e6b12ff](https://github.com/silverstripe/sapphire/commit/e6b12ff) Removed alpha note from CMS (Ingo Schommer)
 * 2011-12-14 [f349483](https://github.com/silverstripe/sapphire/commit/f349483) Improved CMS loading spinner visibility by enforcing a higher z-index in its own element (Ingo Schommer)
 * 2011-12-14 [f57a301](https://github.com/silverstripe/sapphire/commit/f57a301) Improved perceived UI feedback by hiding various elements until they're styled properly (TinyMCE, tree) (Ingo Schommer)
 * 2011-12-14 [1b7c335](https://github.com/silverstripe/sapphire/commit/1b7c335) Fixed JSON parsing error when no ss-ui-dialog cookie is defined (Ingo Schommer)
 * 2011-12-14 [8d3d710](https://github.com/silverstripe/silverstripe-cms/commit/8d3d710) Remove JavaScript validation handler from CMS, it doesn't work with ajax (Ingo Schommer)
 * 2011-12-13 [483704c](https://github.com/silverstripe/sapphire/commit/483704c) Setting entwine warning level outside of entwine block, as it changes the meaning of the $ alias and doesn't apply the new level (Ingo Schommer)
 * 2011-12-13 [f57caec](https://github.com/silverstripe/sapphire/commit/f57caec) Updated history-js dependency (Ingo Schommer)
 * 2011-12-12 [a17e1c2](https://github.com/silverstripe/sapphire/commit/a17e1c2) Suppress inline JS validation scripts in CMS (they don't work with ajax-loaded content) (Ingo Schommer)
 * 2011-12-12 [020f480](https://github.com/silverstripe/silverstripe-cms/commit/020f480) Using &lt;span&gt; instead of &lt;del&gt;/&lt;ins&gt; in SiteTree-&gt;getTreeTitle() to avoid conflicting styles with jstree (Ingo Schommer)
 * 2011-12-12 [a37ea52](https://github.com/silverstripe/silverstripe-cms/commit/a37ea52) More supporting selectors in templates (for JS performance reasons) (Ingo Schommer)
 * 2011-12-12 [0dd32ba](https://github.com/silverstripe/sapphire/commit/0dd32ba) Changed execution order in preview JS to fix layout issues with collapsed preview panel in IE7 (SSF-42) (Ingo Schommer)
 * 2011-12-10 [3a006b7](https://github.com/silverstripe/sapphire/commit/3a006b7) Use json_decode() instead of the Services_JSON class if the function exists. (simonwelsh)
 * 2011-12-07 [2306ec9](https://github.com/silverstripe/sapphire/commit/2306ec9) Updated inline documentation and added visibility keywords to methods for SS_List, DataList and ArrayList (Stig Lindqvist)
 * 2011-12-04 [e203042](https://github.com/silverstripe/sapphire/commit/e203042) Remove php-peg third party PHPUnit tests to avoid them being executed in default phpunit binary test runs (which auto-discover tests ignoring _manifest_exclude). (Ingo Schommer)
 * 2011-12-04 [1b544a4](https://github.com/silverstripe/sapphire/commit/1b544a4) Backported bootstrap.php changes from CI setup (creates a FakeController to avoid empty controller stacks, fake empty session global) (Ingo Schommer)
 * 2011-12-04 [f71781d](https://github.com/silverstripe/sapphire/commit/f71781d) Using require_once in SSTemplateParser instead of require to avoid class declaration errors when running tests through phpunit binary (Ingo Schommer)
 * 2011-12-03 [719bb18](https://github.com/silverstripe/sapphire/commit/719bb18) Added documentation about the new File.ShowInSearch property (Ingo Schommer)
 * 2011-12-03 [880a9ac](https://github.com/silverstripe/sapphire/commit/880a9ac) Fixed site-search docs (Ingo Schommer)
 * 2011-11-25 [5e9db04](https://github.com/silverstripe/sapphire/commit/5e9db04) ModelAdmin search and create panel fixes (see #6782) (Anselm Christophersen)
 * 2011-11-22 [1fec67e](https://github.com/silverstripe/sapphire/commit/1fec67e) Doc whitespace (Ingo Schommer)
 * 2011-11-22 [bd59602](https://github.com/silverstripe/sapphire/commit/bd59602) Updated "Extend the CMS" howto (Ingo Schommer)
 * 2011-11-18 [b2cd254](https://github.com/silverstripe/silverstripe-cms/commit/b2cd254) Updated translation master strings (Ingo Schommer)
 * 2011-11-18 [8df562f](https://github.com/silverstripe/sapphire/commit/8df562f) Updated translation master strings (Ingo Schommer)
 * 2011-11-15 [dec86b7](https://github.com/silverstripe/sapphire/commit/dec86b7) Using assertType() for PHPUnit 3.4 compat in DataListTest (Ingo Schommer)
 * 2011-11-15 [322d983](https://github.com/silverstripe/sapphire/commit/322d983) Whitespace (Ingo Schommer)
 * 2011-11-14 [ea7310c](https://github.com/silverstripe/sapphire/commit/ea7310c) Specifically turning off Transliterator in FileNameFilterTest, was assumed to be on regardless of setting (surfaced by d1ebe1ce9) (Ingo Schommer)
 * 2011-11-14 [4a2fe98](https://github.com/silverstripe/sapphire/commit/4a2fe98) Disabled styling for form fields in CMS (Ingo Schommer)
 * 2011-11-13 [ec47cc1](https://github.com/silverstripe/sapphire/commit/ec47cc1) Whitespace (Ingo Schommer)
 * 2011-11-08 [5addb00](https://github.com/silverstripe/silverstripe-cms/commit/5addb00) Fixed SearchFormTest to run last, and to recreate the test database so that MyISAM tables are used. (Sam Minnee)
 * 2011-11-08 [f1480c2](https://github.com/silverstripe/sapphire/commit/f1480c2) Amended PHPUnit execution to work with PHPUnit 3.6 (Sam Minnee)
 * 2011-10-29 [0a3de45](https://github.com/silverstripe/sapphire/commit/0a3de45) User error was assuming $templateList is always an array when it can also be a string. (Frank Mullenger)
 * 2011-09-22 [7d6ebe1](https://github.com/silverstripe/sapphire/commit/7d6ebe1) - Correct BreadCrumb include (Howard Grigg)

### Other

 * 2012-01-10 [f1542ed](https://github.com/silverstripe/sapphire/commit/f1542ed) Unicode actually fixed... (James Miller)
 * 2012-01-10 [3f59f13](https://github.com/silverstripe/sapphire/commit/3f59f13) Fixed odd unicode character issue (James Miller)
 * 2012-01-10 [80e2985](https://github.com/silverstripe/sapphire/commit/80e2985) Wrap the Last Edited Date in single quotes, doesn't work otherwise. (Aatch)
 * 2012-01-10 [32b067f](https://github.com/silverstripe/sapphire/commit/32b067f) BUGIX: Cant rename folders in AssetAdmin (Stig Lindqvist)
 * 2012-01-10 [bf2ba12](https://github.com/silverstripe/sapphire/commit/bf2ba12) Allowed the fixture to overwrite the LastEdited field on an object (James Miller)
 * 2012-01-03 [add3dfa](https://github.com/silverstripe/sapphire/commit/add3dfa) merge concat (Ingo Schommer)
 * 2011-12-29 [889bcf7](https://github.com/silverstripe/sapphire/commit/889bcf7) Currently, the time format does not allow differentiate the AM/PM hours since the format choosen is 12h and no AM/PM label is added to each log line. So, my suggestion is to convert to 24h format (using a H instead of h) to fix this issue. (joaosantos81)
 * 2011-12-22 [5d5b5ed](https://github.com/silverstripe/silverstripe-cms/commit/5d5b5ed) Tabbed out if (Wolf Vollprecht)
 * 2011-12-21 [a6148c3](https://github.com/silverstripe/sapphire/commit/a6148c3) MERGE Using FormField-&gt;template in most fields (Ingo Schommer)
 * 2011-12-21 [0194080](https://github.com/silverstripe/silverstripe-cms/commit/0194080) merge (Ingo Schommer)
 * 2011-12-18 [05d19d9](https://github.com/silverstripe/sapphire/commit/05d19d9) Revert "MINOR Use json_decode() instead of the Services_JSON class if the function exists." - it breaks assumptions around Convert::json2array() only converting the *first* level of an object structure into an array, which in turn fails CMSMainTest and LeftAndMainTest (as well as some UI functionality relying on it). In order to introduce this change we have to fix these issues in a backwards compatible manner. (Ingo Schommer)
 * 2011-12-15 [40f0fde](https://github.com/silverstripe/sapphire/commit/40f0fde) Adding in the 'RS' =&gt; "Republic of Serbia", into this list of Counties. Will continue to add more as I come across countries not added. (Colin Burns)
 * 2011-12-09 [a642a29](https://github.com/silverstripe/sapphire/commit/a642a29) DOC Update the documentation for the datamodel to describe the SS_List sort, filter and exclude methods (Stig Lindqvist)
 * 2011-11-14 [77f5ea7](https://github.com/silverstripe/sapphire/commit/77f5ea7) Fix for bug when destroying a session with a domain cookie. See http://www.silverstripe.org/general-questions/show/18539 for more details (joaosantos81)