# 3.1.5

## Upgrading

 * If running an application in an environment where user security is critical, it may be necessary to
   assign the config value `Security.remember_username` to false. This will disable persistence of
   user login name between sessions, and disable browser auto-completion on the username field.
   Note that users of certain browsers who have previously autofilled and saved login credentials
   will need to clear their password autofill history before this setting is properly respected.
 * Test cases that rely on updating and restoring `[api:Injector]` services may now take advantage
   of the new `Injector::nest()` and `Injector::unnest()` methods to sandbox their alterations.
 * If errors could potentially be raised by any `[api:RequestHandler]` class such as a `[api:Form]` or
   `[api:Controller]`, you may now add the new `[api:ErrorPageControllerExtension]` to this class to
   transform plain text error messages into `ErrorPage` rendered HTML errors. In the past this
   behaviour was limited to subclasses of `[api:ContentController]`. By default this extension is now
   added to the `Security` controller, and if this is not desirable then it should be removed
   explicitly via the Config system.

## Security

 * 2014-04-16 [bde16f0](https://github.com/silverstripe/sapphire/commit/bde16f0) Potential DoS exploit in TinyMCE - See [announcement SS-2014-009](http://www.silverstripe.org/ss-2014-009-potential-dos-exploit-in-tinymce/)
 * 2014-05-05 [d9bc352](https://github.com/silverstripe/silverstripe-framework/commit/d9bc352) Injection / Filesystem vulnerability in generatesecuretoken - See [announcement SS-2014-010](http://www.silverstripe.org/ss-2014-010-injection-filesystem-vulnerability-in-generatesecuretoken/)
 * 2014-05-02 [8e841cc](https://github.com/silverstripe/sapphire/commit/8e841cc) Folder filename injection - See [announcement SS-2014-011](http://www.silverstripe.org/ss-2014-011-folder-filename-injection/)
 * 2014-05-05 [df28ccb](https://github.com/silverstripe/sapphire/commit/df28ccb) Upload fileexists vulnerability - See [announcement SS-2014-013](http://www.silverstripe.org/ss-2014-013-upload-fileexists-vulnerability/)

### API Changes

 * 2014-05-02 [f9cb880](https://github.com/silverstripe/silverstripe-cms/commit/f9cb880) Error page support for Security controller errors (Damian Mooyman)
 * 2014-05-01 [3162d0e](https://github.com/silverstripe/silverstripe-cms/commit/3162d0e) Update ErrorPage to respect new HTTP Error codes (Damian Mooyman)
 * 2014-04-28 [0285322](https://github.com/silverstripe/silverstripe-cms/commit/0285322) Ability to configure paging for assets / pages (Damian Mooyman)
 * 2014-04-22 [d06d5c1](https://github.com/silverstripe/sapphire/commit/d06d5c1) Injector supports nesting BUG Resolve issue with DirectorTest breaking RequestProcessor Injector::nest and Injector::unnest are introduced to better support sandboxing of testings. Injector and Config ::nest and ::unnest support chaining Test cases for both Injector::nest and Config::nest (Damian Mooyman)
 * 2014-04-17 [a6017a0](https://github.com/silverstripe/sapphire/commit/a6017a0) HTTP 429 Allowed for use with rate limiting methods (Damian Mooyman)
 * 2014-04-11 [892b440](https://github.com/silverstripe/sapphire/commit/892b440) Make default gridfield paging configurable Documentation improved (Damian Mooyman)
 * 2014-04-09 [997077a](https://github.com/silverstripe/sapphire/commit/997077a) Security.remember_username to disable login form autocompletion (Damian Mooyman)

### Features and Enhancements

 * 2014-03-28 [a502c9d](https://github.com/silverstripe/silverstripe-cms/commit/a502c9d) Fixes #966. Ability to filter pages on page status. - New filters for statuses normally found through SiteTree::getStatusFlags(). - Refactored menu sorting. Now alphabetical, as it wasn't previously. (Russell Michell)
 * 2014-04-11 [3765030](https://github.com/silverstripe/silverstripe-cms/commit/3765030) Filter by date created for files Added test cases Do not merge before https://github.com/silverstripe-labs/silverstripe-behat-extension/pull/32 (Damian Mooyman)

### Bugfixes
 
 * 2014-05-05 [c5d5d10](https://github.com/silverstripe/silverstripe-cms/commit/c5d5d10) Behat now uses explicit radio button behaviour (Damian Mooyman)
 * 2014-05-01 [bd5abb6](https://github.com/silverstripe/sapphire/commit/bd5abb6) parent::init is not called first (Michael Parkhill)
 * 2014-05-01 [4fd3015](https://github.com/silverstripe/sapphire/commit/4fd3015) corrected link to CMS Alternating Button Page (James Pluck)
 * 2014-04-29 [8673b11](https://github.com/silverstripe/sapphire/commit/8673b11) Fix ImageTest Image test would erroneously reset the Image::$backend to null if the test was skipped, breaking subsequent test cases (Damian Mooyman)
 * 2014-04-29 [89fbae2](https://github.com/silverstripe/silverstripe-cms/commit/89fbae2) Fix encoding of SiteTree.MetaTags (Damian Mooyman)
 * 2014-04-25 [ff5f607](https://github.com/silverstripe/sapphire/commit/ff5f607) Docs for DataList::filter() (Daniel Hensby)
 * 2014-04-24 [5e9ae57](https://github.com/silverstripe/sapphire/commit/5e9ae57) Fix edge case IE8 / dev / ssl / download file crash Prevents issue at http://support.microsoft.com/kb/323308 appearing on dev (Damian Mooyman)
 * 2014-04-17 [bec8927](https://github.com/silverstripe/sapphire/commit/bec8927) Allow PHPUnit installation with composer / Fix travis (Will Morgan)
 * 2014-04-16 [396fd9a](https://github.com/silverstripe/silverstripe-cms/commit/396fd9a) Broken file link tracking (fixes #996) (Loz Calver)
 * 2014-04-14 [0b4f62d](https://github.com/silverstripe/sapphire/commit/0b4f62d) Fix jstree when duplicating subtrees (Damian Mooyman)
 * 2014-04-11 [a261f22](https://github.com/silverstripe/sapphire/commit/a261f22) Delete Character \x01 (Stevie Mayhew)
 * 2014-04-09 [91034d1](https://github.com/silverstripe/sapphire/commit/91034d1) HTMLText whitelist considers text nodes Minor improvement to #2853. If a list of whitelisted elements are specified, text nodes no longer evade the whitelist (Damian Mooyman)
 * 2014-04-09 [a3c8a59](https://github.com/silverstripe/sapphire/commit/a3c8a59) Fix data query not always joining necessary tables Fixes #2846 (Damian Mooyman)
 * 2014-04-08 [a060784](https://github.com/silverstripe/sapphire/commit/a060784) - missing link url for composer (camfindlay)
 * 2014-04-07 [3204ab5](https://github.com/silverstripe/silverstripe-cms/commit/3204ab5) Fix orphaned pages reporting they can be viewed (Damian Mooyman)
 * 2014-04-01 [84d8022](https://github.com/silverstripe/sapphire/commit/84d8022) Fix Date and SS_DateTime::FormatFromSettings This issue is caused by the odd default behaviour of Zend_Date, which attempts to parse yyyy-mm-dd format date and times as though they were yyyy-dd-mm. (Damian Mooyman)
 * 2014-03-12 [b4a1aa4](https://github.com/silverstripe/silverstripe-cms/commit/b4a1aa4) Fixes #965. Allow user date-settings to show on GridField Page admin (Russell Michell)
 * 2014-03-04 [ae573f8](https://github.com/silverstripe/sapphire/commit/ae573f8) Fix Versioned stage not persisting in Session. Fixes #962 BUG Disabled disruptive test case in DirectorTest API RequestProcessor and VersionedRequestFilter now both correctly implement RequestFilter Better PHPDoc on RequestFilter and implementations (Damian Mooyman)
 * 2013-06-20 [f2c4a62](https://github.com/silverstripe/sapphire/commit/f2c4a62) ConfirmedPasswordField used to expose existing hash (Hamish Friedlander)

## Changelog

 * [framework](https://github.com/silverstripe/silverstripe-framework/releases/tag/3.1.5)
 * [cms](https://github.com/silverstripe/silverstripe-cms/releases/tag/3.1.5)
 * [installer](https://github.com/silverstripe/silverstripe-installer/releases/tag/3.1.5)
