# 2.4.7 (2012-02-01)

## Overview

 * Security: Cross-site scripting (XSS) on text transformations in templates
 * Security: Cross-site scripting (XSS) related to page titles in the CMS
 
## Upgrading Notes ##

### Security: Cross-site scripting (XSS) on text transformations in templates

The default casting for `Text` and `Varchar` database field classes usually auto-escapes
field values when they are inserted into a template. For some text transformations
on those fields, this wasn't correctly applied. The following methods are affected:

 * `AbsoluteLinks()`,
 * `BigSummary()`,
 * `ContextSummary()`,
 * `EscapeXML()`,
 * `FirstParagraph()`,
 * `FirstSentence()`,
 * `Initial()`,
 * `LimitCharacters()`,
 * `LimitSentences()`,
 * `LimitWordCount()`,
 * `LimitWordCountXML()`,
 * `Lower()`
 * `LowerCase()`
 * `NoHTML()`,
 * `Summary()`,
 * `Upper()`
 * `UpperCase()`
 * `URL()`

 If you have used any of these transformations with untrusted values
 (e.g. from a user-submitted form), please consider updating.
 More info about SilverStripe's casting logic is available in the "[security](../topics/security)" documentation.

### Security: Cross-site scripting (XSS) related to page titles in the CMS

The page title data wasn't escaped correctly in the `SilverStripeNavigator`
as well as the updated page title in the CMS tree after saving.

## Changelog ##

### Bugfixes

 * 2012-01-31 [0085876](https://github.com/silverstripe/sapphire/commit/0085876) Casting return values on text helper methods in StringField, Text, Varchar (Ingo Schommer)

### Other

 * 2012-01-31 [252e187](https://github.com/silverstripe/sapphire/commit/252e187) SECURITY Escape links for SilverStripeNavigatorItem (Ingo Schommer)
 * 2012-01-31 [5fe7091](https://github.com/silverstripe/sapphire/commit/5fe7091) SECURITY Sanitize messages passed to generated JS calls in FormResponse::status_message(), e.g. to avoid XSS on 'Successfully published &lt;page title&gt;' messages (Ingo Schommer)
 * 2011-09-24 [d0af084](https://github.com/silverstripe/sapphire/commit/d0af084) Fixes tag syntax (should end with %&gt;, not &gt;%) (simonwelsh)
 * 2011-06-09 [aa74811](https://github.com/silverstripe/silverstripe-cms/commit/aa74811) CZ translation for tinymce_ssbuttons plugin (Ladislav Kubes)