# 2.4.10 (2013-02-19)

## Overview

 * Security: Undefined `$allowed_actions` overrides parent definitions
 * API: More restrictive `$allowed_actions` checks for `Controller` when used with `Extension`

## Details

### Security: Undefined `$allowed_actions` overrides parent definitions

Severity: Important

Description: `Controller` (and subclasses) failed to enforce `$allowed_action` restrictions
on parent classes if a child class didn't have it explicitly defined.

Impact: Depends on the used controller code. For any method with public visibility,
the flaw can expose the return value of the method (unless it fails due to wrong arguments).
It can also lead to unauthorized or unintended execution of logic, e.g. modifying the
state of a database record.

Fix: Apply the 2.4.10 update. In addition, we strongly recommend to define `$allowed_actions`
on all controller classes to ensure the intentions are clearly communicated.

### API: More restrictive `$allowed_actions` checks for `Controller` when used with `Extension`

Controllers which are extended with `$allowed_actions` (through an `Extension`)
now deny access to methods defined on the controller, unless this class also has them in its own
`$allowed_actions` definition.

## Changelog

### API Changes

 * 2013-02-15 [2352317](https://github.com/silverstripe/silverstripe-installer/commit/2352317) Filter composer files in IIS and Apache rules (fixes #8011) (Ingo Schommer)
 * 2013-02-12 [45c68d6] Require ADMIN for ?showtemplate=1 (Ingo Schommer)

### Bugfixes

 * 2013-02-17 [c7b0666](https://github.com/silverstripe/silverstripe-cms/commit/c7b0666) Escape page titles in CommentAdmin table listing (Ingo Schommer)
 * 2013-01-15 [50995fb] Undefined `$allowed_actions` overrides parent definitions, stricter handling of $allowed_actions on Extension (Ingo Schommer)
 * 2013-01-06 [eecd348] Keep Member.PasswordEncryption setting on empty passwords (Ingo Schommer)