#  2.4.1 (2010-07-23)

##  Overview

 * Fixed a security issue where logged-in CMS authors were allowed to rename files with harmful extensions in the "Files & Images" section
 * Improved installer security by disallowing re-installation when a configuration file is already present. 
 * Installing in "live mode" instead of "dev mode" by default, and avoid setting certain domains as "dev mode" by default. This fixes an issue where attackers were able to force a site into "dev mode" by spoofing the domain name on certain server configurations.
 * Fixed password encryption when saving members through the "Add Member" dialog in the "Security" admin. The saving process was disregarding password encyrption and saving them as plaintext (issue was introduced in 2.4.0)
 * Fixed potential information disclosure on misconfigured servers by disallowing direct execution of *.php files in "sapphire", "cms" and "mysite" folders. If PHP was configured to show errors on screen (development setting), attackers could find out server paths and other environment information.
 * Allow CMS authors to set their own localized date and time formats, independently from the defaults set through their interface language.
 * More useable date picker (jQuery UI) for date form fields (both in the CMS and in website forms)
 * Better URL "transliteration" of special characters like Umlauts or Macrons (Example title: "Brötchen für alle!", URL in 2.4.0: "brtchen-fr-alle", URL in 2.4.1: "broetchen-fuer-alle")
 * Better batch editing of comments in the admin interface (e.g. marking multiple comments as "spam")
 * More sophisticated access control for decorators on page types (tri-state permissions checks: allow, deny, ignore).

## Upgrading

See [API Changes](http://open.silverstripe.org/wiki/ChangeLog/2.4.1-rc1?version=2#APIChanges).
###  Security: File->setName() and File->Filename handling 

Setting properties on *File* and *Image* are not reflected on the filesystem until *write()* is called. This was a
necessary change to fix a security vulnerability around File->setName() and file extension validation. This
vulnerability requires a user to be logged-in to the CMS (see [#5693](http://open.silverstripe.org/ticket/5693)).

This means that CMS users with access to "Files & Images" can no longer rename uploaded files to invalid extensions in
2.4.1. In SilverStripe 2.3.8, this restriction only applies when *AssetAdmin::$apply_restrictions_to_admin* is set to
TRUE.

###  Security: Installation in "live mode" by default 

SilverStripe used to allow setting the [environment type](/topics/environment-management) ("dev mode", "test mode" or "live
mode") from within the installer, through *Director::set_dev_servers()*, *Director::set_test_servers()* and
*Director::set_live_servers()*. 

On webservers with direct IP to domain mapping (e.g. no *VirtualHost* directives in Apache), it is possible to spoof
domain information in HTTP requests. This can lead to "live" environments being set to "dev" mode, allowing
administrative actions like *dev/build* without access control. 
Note: The CMS is still secured through login in "dev mode".

We recommend setting environment types through a [_ss_environment.php](/topics/environment-management) file instead:

	:::php
	<?php
	define('SS_ENVIRONMENT_TYPE', 'dev');
	// ...


To put a "live" or "test" environment into "dev mode" temporarily (when logged in as an administrator),
you can append *?isDev=1* to any SilverStripe URL. This should give you more information than the common
"Website Error" that is shown when the website is in "live mode".

IMPORTANT: If you have an existing installation, we advise to remove any *Director::set_dev_servers()* directives from
your *mysite/_config.php*.

###  Security: Disallow direct execution of *.php files 

The only PHP file that should be executable through the webserver
is *sapphire/main.php*, our main bootstrapper which kicks of URL routing.
All other PHP files in SilverStripe core and modules are included
by this bootstrapper, and don't need direct access through a URL.

On misconfigured webservers, accessing these files directly through URL can lead to
information disclosure through PHP error messages. The production configuration 
recommended by [php.net](http://www.php.net/manual/en/errorfunc.configuration.php#ini.display-errors) 
will fix this issue:

	:::php
	display_errors = 0


For additional protection, we now include *.htaccess* files in all SilverStripe core folders
disallowing access to **.php* files. Note: This only applies to webservers that understand
the *.htaccess* format, mainly Apache.

''Important'': Consider copying *mysite/.htaccess* to any other SilverStripe
modules and folders you might have created in your own project.

### Security: New members might be saved without password encryption

Fixed password encryption when saving members through the "Add Member" dialog in the "Security" admin. The saving
process was disregarding password encyrption and saving them as plaintext
([#5772](http://open.silverstripe.org/ticket/5772)). The issue was introduced in 2.4.0 - if you have created any new
members through "Add Member" since then (not the inline member table), please re-encrypt all existing passwords using
this task:

	http://localhost/dev/tasks/EncryptAllPasswordsTask

###  Date/Time format handling in CMS 

Classes like DateField, TimeField and DatetimeField are now aware of member-specific formats which can be set in
*admin/myprofile* (linked on the lower right footer in the CMS interface). See [i18n](/topics/i18n) for more details.

Example: Setting German date formats in *mysite/_config.php*:

	:::php
	i18n::set_locale('de_DE');
	i18n::set_date_format('dd.MM.YYYY');
	i18n::set_time_format('HH:mm');


Please note that these form fields use [ISO date
format](http://framework.zend.com/manual/en/zend.date.constants.html#zend.date.constants.selfdefinedformats), not PHP's
built-in [date()](http://nz.php.net/manual/en/function.date.php).

To set the locale and date/time formats for all existing members, use the following SQL (adjust to your preferred
formats):

	UPDATE `Member` SET `Locale` = 'de_DE', `DateFormat` = 'dd.MM.YYYY', `TimeFormat` = 'HH:mm';


### Changed permission checks for decorators on DataObject->can*() 

Access checks in the SiteTree class can have their access checks extended, for example to influence SiteTree->canEdit().
In 2.4.0, it was only possible to explicitly deny an action by returning FALSE, returning TRUE wouldn't have any effect.
The new behaviour has three states:

  * FALSE: Disallow this permission, regardless of what other decorators say 
  * TRUE: Allow this permission, as long as no other decorators return false 
  * NULL: Don't affect the outcome

To clarify: Leaving existing decorators unchanged might mean that you allow actions that were previously denied (See
[r104669](http://open.silverstripe.org/changeset/104669)).

	// In mysite/_config.php
	:::php
	Object::add_extension('SiteTree', 'MyDecorator');
	
	// 2.4.0
	:::php
	class MyDecorator extends DataObjectDecorator {
		function canEdit($member) {
			if(Permission::checkMember($member, 'MYPERMISSION')) {
				return true;
			} else {
				return false;
			}
		}
	}
	
	// 2.4.1
	:::php
	class MyDecorator extends DataObjectDecorator {
		function canEdit($member) {
			if(Permission::checkMember($member, 'MYPERMISSION')) {
				return null; // Means the permission check will be ignored, instead of forced to TRUE
			} else {
				return false;
			}
		}
	}


### Removed image editor sourcecode

This feature was disabled for a while, and has now been removed from the source tree as well. Please please use
thirdparty modules instead, e.g. "[silverstripe-pixlr](http://github.com/nyeholt/silverstripe-pixlr)"
([r104987](http://open.silverstripe.org/changeset/104987)).

### URL Transliteration

Non-ASCII characters like [macrons](http://en.wikipedia.org/wiki/Macron) or
[umlauts](http://en.wikipedia.org/wiki/Germanic_umlaut) URLs are now transliterated. This means that special characters
are replaced with their ASCII equivalents rather than just removed. This does not affect existing URLs, but will impact
existing pages when their title is changed.

	Title: "Brötchen für alle!"
	URL in 2.4.0: "brtchen-fr-alle"
	URL in 2.4.1: "broetchen-fuer-alle"

###  Removed Classes 

 * AutocompleteTextField


## Changelog

###  Features and Enhancements

 * [rev:108024] Show a warning inside the the CMS if you've neglected to delete install.php
 * [rev:108012] added getter to get array back out of an !ArrayData instance. MINOR: updated docblocks in !ArrayData
 * [rev:107877] Added Latvian (Latvia) translation to sapphire (thanks Kristaps and Andris!)
 * [rev:107875] Added Latvian (Latvia) translation to cms (thanks Kristaps and Andris!)
 * [rev:107867] Allowing custom messages and permission codes in !BasicAuth::protect_entire_site()
 * [rev:107867] Making $permissionCode argument optional for !BasicAuth::requireLogin(). If not set the logic only checks for a valid account (but no group memberships)
 * [rev:107867] Using SS_HTTPResponse_Exception instead of header()/die() in !BasicAuth::requireLogin() to make it more testable
 * [rev:107810] Added class to time icon in !TimeField so it can be styled
 * [rev:107443] html2raw now properly replace strong tag with asterix #5494
 * [rev:107438] Using jQuery UI datepicker in !DateField and !DatetimeField instead of outdated DHTML calendar.js (fixes #5397)
 * [rev:107438] Abstracted optional !DateField->setConfig('showcalendar') logic to !DateField_View_JQuery
 * [rev:107434] allow adding a new a field to !ArrayData
 * [rev:107429] Added documentation and changed static names
 * [rev:107426] Added static to set regeneration of default pages (ticket #5633)
 * [rev:107415] Added Security::$force_database_is_ready to mock database_is_ready() state
 * [rev:107415] Added permission check exception in !TaskRunner and !DatabaseAdmin if !SapphireTest::is_running_test() returns TRUE (necessary for !DevelopmentAdminTest)
 * [rev:107380] Use array_combine() instead of custom logic for !ArrayLib::valuekey() (thanks paradigmincarnate!)
 * [rev:107365] Member_!DatetimeOptionsetField toggle text is now translatable
 * [rev:107334] #5352 Translatable entities for help text in Member_!DatetimeOptionsetField::getFormattingHelpText()
 * [rev:107327] #5352 CMS now uses the user's preferred date and time formatting in !DateField and !TimeField
 * [rev:107326] #5352 Decouple date display from i18n locales, users now have access to change their date and time formats in Member::getCMSFields() using Member_!DatetimeOptionsetField field
 * [rev:107094] abstracted protocol detection out to Director::protocol() #5450
 * [rev:107091] in referencing a file in combine_files() it should fall back to standard requirement tags if combining has been disabled eg dev mode
 * [rev:107088] throw user error when not passing correctly formatted array rather than simply passing
 * [rev:107086] added setDisabled() to set !DropdownField::$disabled
 * [rev:106877] Added !TestRunner::$coverage_filter_dirs to exclude certain directories from PHPUnit test coverage reports
 * [rev:106705] Calling Image->deleteFormattedImages() in Image->onBeforeWrite() (#5423)
 * [rev:106200] added prefix and suffix support to !ContextSummary
 * [rev:106194] Prevent image search queries all images in the site initially when the page is loaded
 * [rev:106178] Enable switch between legacy image search and new version
 * [rev:106118] added setRows() and setColumns() to customize the size of the textarea field outside of the controller
 * [rev:105890] Added method for $this->request->latestParam() backwards compatibility with Director::urlParam()
 * [rev:105732] Ability to hide form by className or for the whole !ModelAdmin
 * [rev:105712] Added !MySQLDatabaseConfigurationHelper::getDatabaseVersion() which abstracts the version number away from the version check the installer requires
 * [rev:105275] Preserve sort options in pagination links in !TableListField
 * [rev:105271] 'Select all' and 'Select none' checkboxes for !CommentTableField for easier batch handling of comments, improved its styling in !CommentAdmin
 * [rev:105269] Showing 20 comments in tabular view for !CommentAdmin (and making the setting configurable via !CommentAdmin::set_comments_per_page())
 * [rev:105268] Abbreviating comment text display in !CommentAdmin to first 150 characters
 * [rev:105266] Allowing batch checkbox selection of !TableListField rows with !TableListField->Markable and !TableListField->addSelectOptions()
 * [rev:105126] Added CSSContentParser->getByXpath()
 * [rev:105028] Added variable for the server configuration file so the config-form can display it for the installation
 * [rev:104968] Added !PageComment->canView()/canEdit()/canDelete(), and using these permissions in !PageCommentInterface. Caution: canCreate() actions are still determined by !PageCommentInterface::$comments_require_login/$comments_require_permission
 * [rev:104935] added Month function for consistency
 * [rev:104827] added plugins to i18n to support modules that provide custom translations.
 * [rev:104707] Installer now supports requireDatabaseVersion() on each database configuration helper implementation, e.g. !MySQLDatabaseConfigurationHelper. If it's not defined, the test is skipped.
 * [rev:104706] Added !MySQLDatabaseConfigurationHelper::requireDatabaseVersion() to check whether the connected instance is using version 5.0+
 * [rev:104671] Macrons, umlauts, etc, are now transliterated when inserted into URLS. API CHANGE: Added Transliterator class, which uses iconv() or strtr() to convert characters with diacritical marks to their ASCII equivalents. API CHANGE: Added Extension hook updateURLSegment for !SiteeTree.
 * [rev:104515] initial commit
 * [rev:104232] Add 'Given I load the fixture file "app/tests/xyz.yml"' step to salad
 * [rev:104231] Add dev/tests/sessionloadyml to load a yml fixture into an existing test session
 * [rev:104162] Added cs_CZ javascript translations (#5540, thanks Pike)


### API Changes

 * [rev:107439] Using !FieldHolder() instead of Field() for subfields in !DatetimeField->!FieldHolder(), in order to get configuraton settings for javascript !DateField
 * [rev:107273] Don't reflect changes in File and Folder property setters on filesystem before write() is called, to ensure that validate() applies in all cases. This fixes a problem where File->setName() would circumvent restrictions in File::$allowed_extensions (fixes #5693)
 * [rev:107273] Removed File->resetFilename(), use File->updateFilesystem() to update the filesystem, and File->getRelativePath() to just update the "Filename" property without any filesystem changes (emulating the old $renamePhysicalFile method argument in resetFilename())
 * [rev:107273] Removed File->autosetFilename(), please set the "Filename" property via File->getRelativePath()
 * [rev:107268] Deprecated File->getLinkedURL()
 * [rev:107054] Deprecated !AutocompleteTextField, use third-party solutions
 * [rev:106217] moved Group::addToGroupByName to $member->addToGroupByCode.
 * [rev:105756] refactored methods in session to use coding conventions
 * [rev:104987] Removed !ImageEditor functionality, please use thirdparty modules, e.g. "silverstripe-pixlr" (http://github.com/nyeholt/silverstripe-pixlr)
 * [rev:104923] Added interface method !DatabaseConfigurationHelper::requireDatabaseVersion(), all database helpers that implement !DatabaseConfigurationHelper must now have this method, which as of now is MySQL, PostgreSQL, SQL Server and SQLite
 * [rev:104673] Added !RsyncMultiHostPublisher::set_excluded_folders().
 * [rev:104669] Moved site tree permission extension to a 3-state system (true, false, null, where null means "no effect")


### Bugfixes

 * [rev:108207] Re-allowing direct execution in sapphire/thirdparty/tinymce/plugins/spellchecker/rpc.php (necessary for cms spellchecker, was disabled by global .htaccess rule)
 * [rev:108195] #5837 cache_dir not writable by Zend when accessing the CMS, because of Windows default which should be the sapphire TEMP_FOLDER
 * [rev:108193] Bypass !BasicAuth when in CLI mode so unit tests can run (regression from r104962)
 * [rev:108099] Fixing default group selection in 'add member' dialog (in !MemberTableField) (fixes #5836)
 * [rev:108096] AssetAdmin->doUpload() shows JS alert *before* triggering a page reload, as this seems to mess up TinyMCE in Firefox on subsequent page loads (fixes #5838)
 * [rev:108032] Fixed CLI installation.
 * [rev:108031] Don't set any dev servers by default, host-based dev-server selection is unreliable.
 * [rev:108030] Don't allow reinstalling without first making the user manually delete mysite/_config.php
 * [rev:108029] Don't allow direct access to PHP files in mysite module.
 * [rev:108028] Don't allow direct access to PHP files in cms module.
 * [rev:108027] Don't have any host-based dev servers set by default.
 * [rev:108026] Don't allow reinstalling without first making the user manually delete mysite/_config.php
 * [rev:108023] Don't allow direct access to PHP files in sapphire module, except for main.php and static-main.php
 * [rev:108001] #5833 Duplicate IDs when two similar date formats in Member_!DatetimeOptionsetField containing different delimiters (e.g / and .) replaced to an empty string
 * [rev:107940] tests now pass when the locale is set to something other than 'en_US' in the mysite's _config.php file
 * [rev:107831] dev/build always reporting index change because of a whitespace in the index column names
 * [rev:107812] Styling fixes for !DateField/!TimeField/!DatetimeField in the CMS
 * [rev:107811] Added a clearing div after the date and time fields, not the best way of doing it but the only way as the overflow css trick for clearing fields doesn't work with the time dropdown
 * [rev:107789] Fixed !DateField->validate() with keyed, but empty array values
 * [rev:107786] Using actual date format settings in !DateField/!TimeField->validate() messages
 * [rev:107785] Limit 'showcalendar' javascript option to !DateField instances (rather than applying to all available)
 * [rev:107585] fixed inclusion of environment file when document root is the web root
 * [rev:107539] Case insensitive extension checks in File::validate() (fixes #5781, thanks simon_w)
 * [rev:107537] Remove dummy entry created by Versioned if record is first written to Live stage (fixes #5596, thanks muzdowski)
 * [rev:107532] Fixed Member->!PasswordEncryption defaults when writing new Member without setting a password. Fixes critical issue with !MemberTableField saving in admin/security, where new members are stored with a cleartext password by default instead of using the default SHA1 (see #5772)
 * [rev:107441] Allowing !DatetimeField->saveInto() to save a partial array notation with missing 'time' value
 * [rev:107428] Added quotes for postgres
 * [rev:107423] Only highlight strings more than 2 characters long. #4949
 * [rev:107417] Reverted 107414, wrong patch
 * [rev:107415] Allowing dev/build in "live" mode when Security::database_is_ready() returns FALSE (typically happens when an existing !SilverStripe project is upgraded and database columns in Member/Permission/Group have been added) (fixes #4957)
 * [rev:107414] TableListField headings i18n translation (ticket #5742)
 * [rev:107390] Added Locale hidden field to HTMLEditorField->!LinkForm() in order to show correct context in "page on the site" dropdown (fixes #5743)
 * [rev:107369] Fixed spelling error of $databaseConfig in cli-script.php causing database configuration to not load (thanks aimcom!)
 * [rev:107116] Undo commit to wrong place
 * [rev:107115] Undo incorrect commit
 * [rev:107095] check the $removeAll var before removing cache files. PATCH via ajshort (#5672)
 * [rev:107090] prevented HTTPRequest->shift() throwing notices when shifting multiple elements. APICHANGE: SS_HTTPRequest->shift($multiple) no longer returns an array of size $multiple spaced with nulls, it returns an array up to the size of $multiple.
 * [rev:107089] fixed notice level errors getting through
 * [rev:106867] Making status description in Debug::friendlyError() compatible to HTTP 1.1 spec (removing any markup and newlines)
 * [rev:106777] Re-enabling theme in !ErrorPage->doPublish() (it's usually disabled in the publication context through !LeftAndMain->init())
 * [rev:106755] Stricter checking that a relation exists on !ComplexTableField::saveComplexTableField()
 * [rev:106671] Fixed !ImageField->!EditFileForm() to list subclasses of Image in tree dropdown (fixes #5708, thanks keeny)
 * [rev:106666] Prevent !DateField->performReadonlyTransformation() from segfaulting on PHP 5.2 due to broken __toString() casting (fixes #5713, thanks charden)
 * [rev:106360] re-enable broken link notification using !BackLinkTracking() (this was broken since r101127
 * [rev:106351] Apply AJShort's patch to fix !SiteConfig (trac 5671)
 * [rev:106225] Checking for the same combined filename in Requirements::combine_files() to avoid irrelevant error messages
 * [rev:106205] updated tests for Text
 * [rev:106183] fix query error when image search doesn't use legacy search
 * [rev:106154] if running in cli do not output html tags when rebuilding the db
 * [rev:106122] Fixed caching of homepage.
 * [rev:106121] Open help in a new tab.
 * [rev:106120] Replaced Versioned's unique index definition with an array syntax.
 * [rev:106096] Setting 'ID' field on CMSMain->!RootForm() so it can work with formfields that require it (fixes #5671, thanks ajshort)
 * [rev:106086] image search was not honouring the selected folder, so could only search in root folder
 * [rev:106082] Fixed !SiteTree::!IsModifiedOnStage() for an edge-case that was identified when deleteFromStage() stopped manipulating the current record.
 * [rev:106080] Don't let deleteFromStage() kill the ID of the original record.
 * [rev:106079] Add a unique index to !SiteTree_versions.RecordID+Version.  Fix saving methods to support this.
 * [rev:106078] Throw an exception if you try an delete an unsaved or already-deleted record
 * [rev:106071] MySQLDatabaseConfigurationHelper::getVersion() will fallback to trying to get the version using a query if mysql_get_server_info() returns nothing
 * [rev:105907] fixed phpunit directive
 * [rev:105903] reverted revision 105890 to fix build
 * [rev:105889] invalid use of @covers annotation
 * [rev:105876] TableListField_Item::!SelectOptionClasses() can not use it parent protected variable.
 * [rev:105875] rollback r105858 which introducesa bug
 * [rev:105872] updated select options classes to work with the dataobjectset returned by selectoptions rather than the array previously
 * [rev:105868] fixed select all link using incorrect function
 * [rev:105858] TableListField_Item::!SelectOptionClasses() can use it parent protected variable.
 * [rev:105833] fixed incorrect include path
 * [rev:105732] validate file in import from CSV form
 * [rev:105726] If database version can't be determined, just use the database adapter class
 * [rev:105711] Install now supports sending database version if available from the helper
 * [rev:105705] ss2stat URL not generated correctly (has NULL values)
 * [rev:105668] Moved !SiteTree->ParentID property to Hierarchy extension (fixes #5638)
 * [rev:105667] More specific regex in Requirements->includeInHTML() to avoid duplicating information by matching HTML5-style <header> tags instead of <head> (fixes #5640)
 * [rev:105665] Can't set width or height on !MemberTableField popup (fixes #5625, thanks smurkas)
 * [rev:105514] if moderation on comments is enabled then redirect the user back down to the comment section to view the message rather than trying to direct to selector which doesnt exist
 * [rev:105505] avoid adding loading class to TinyMCE add link, image, flash buttons
 * [rev:105468] #5349: Use TEMP_FOLDER for Zend's cache temp dir.
 * [rev:105337] get_title_sql has string concat hardcoded as ||, fixed for MSSQL which uses +, fix for #5613
 * [rev:105278] Stricter object type checks in !ViewableData->hasValue() and !ViewableData->XMLval(). Broke in cases when SS_HTTPResponse is returned which doesn't extend from Object, hence doesn't have an exist() method (fixes #5524, thanks hamish)
 * [rev:105264] addFieldToTab segfaulting under PHP 5.2
 * [rev:105225] force dateformat to en_NZ if showcalendar is enabled as calendar is compatibile with en_NZ only
 * [rev:105030] Fixed correct input ID in install.js due to change in r105029
 * [rev:105029] Fixed inconsistent styling of reinstall actions at the bottom of the installer, and if using IIS, warn that this will overwrite the web.config file, not .htaccess
 * [rev:104995] Fixed i18nTextCollector when used with i18nEntityProvider - class manifest is now stored lowercase, which means i18n::get_owner_module() didnt work reliably
 * [rev:104972] TestSession::submitForm throws proper error if form not found
 * [rev:104968] Requiring CMS_ACCESS_!CommentAdmin instead of ADMIN permissions in !PageCommentInterface and !CommentAdmin administrative actions
 * [rev:104962] Fixed bug in basicauth failover to session member.
 * [rev:104962] Don't use session member for test site protection feature.
 * [rev:104847] catch case of plugin not returning translations for the locale
 * [rev:104793] Installer now checks the database version AFTER it has determined a connection can be established, which some databases require first
 * [rev:104793] Database version check failures are now a warning, so a user can install at their own risk
 * [rev:104745] after reset password, the site redirect to non-exisit page (SC #1)
 * [rev:104720] Fixed installation problem where version error didn't show
 * [rev:104679] Make URLs lowercase
 * [rev:104678] Fixed Translatable::canEdit() to suit new permission customisation scheme
 * [rev:104675] Prevent !DataDifferencer from creating empty `<ins />` and `<del />` takes that confuse the browser.
 * [rev:104672] Make !RsyncMultiHostPublisher protected; give default value.
 * [rev:104670] Director::test() shouldn't break if $_SESSION isn't set.
 * [rev:104666] Removed references to php5 binary in Makefile
 * [rev:104608] check if a request is present before using it to prevent undefined errors
 * [rev:104581] Generate stage/live links using Controller::join_links() instead of string concatenation.
 * [rev:104580] Fixed Controller::join_links() handling of fragment identifiers
 * [rev:104552] when using custom Member title, the join was failing - it had wrong parameters. Now changed to correctly handle the ansi sql join for all Member columns.
 * [rev:104533] Fix !ModelAdmin Import hang (ticket 5569)
 * [rev:104468] When finding an old page in the 404 handler, favour existing subpages over historical ones.
 * [rev:104463] Fix legacy URL redirection for pre-nestedurls URLs, after it has been enabled.
 * [rev:104436] Removed erroneous default config for unused templates module.
 * [rev:104403] Wrong HTML syntax in !LeftAndMain.ss (fixes #5552, thanks simon_w)


### Minor changes

 * [rev:108246] Removed unncessary end PHP tag from cms/_config.php
 * [rev:108208] Disallowing more potentially active file extensions in mysite/.htaccess
 * [rev:108207] Disallowing more potentially active file extensions in cms/.htaccess
 * [rev:108206] Disallowing more potentially active file extensions in cms/.htaccess
 * [rev:108196] Removed debug
 * [rev:108049] Added warning about Director::set_dev_servers()
 * [rev:108048] Documentation in CSVBulkLoader
 * [rev:108025] Added test for #5662 (calling delete twice)
 * [rev:108002] Fixed incorrect word "colon" with "dot"
 * [rev:107878] Updated translations
 * [rev:107876] Updated translations
 * [rev:107838] Reverted r107831
 * [rev:107789] Fixed !DateField/!TimeField validation message translation (wrong sprintf() nesting)
 * [rev:107787] Fixed !TimeField validation _t() entity name
 * [rev:107784] Disabled 'showcalendar' option on CMSMain->!SiteTreeFilterDateField() - it causes the CMS to load jQuery UI javascript just for this (rarely used field). To be re-enabled once we work with jQuery UI on a broader scale.
 * [rev:107726] Moved class-specific documentation from doc.silverstripe.org back into class-level PHPDoc
 * [rev:107725] Moved class-specific documentation from doc.silverstripe.org back into class-level PHPDoc
 * [rev:107586] removed whitespace
 * [rev:107525] Removed debug code in !MemberTableField
 * [rev:107442] Fixed !DatetimeField display in cms
 * [rev:107442] Removed obsolete .calendardate styles from cms_right.css
 * [rev:107440] Using Google CDN for jQuery dependencies in !FileIFrameField
 * [rev:107437] Better error handling in i18n::get_language_name()
 * [rev:107430] Fixed Documentation
 * [rev:107415] Using Object::create() in !DevelopmentAdmin to make objects mockable
 * [rev:107400] Documentation in !DataObjectSet
 * [rev:107394] Changed "no_NO" locale for Norwegian into the more commonly used "nb_NO" in i18n class, meaning translations from translate.silverstripe.com can actually be selected now (fixes #5746)
 * [rev:107366] Tweaking of installer text to avoid misleading information about "exists" when there's actually an error
 * [rev:107307] Reverted r107305
 * [rev:107305] Code formatting fix for setting Member locale in !LeftAndMain::init()
 * [rev:107276] Checking that Folder::findOrMake() can create an assets/assets/ folder
 * [rev:107275] Using Filesystem::makeFolder() instead of mkdir() in Folder for file operations
 * [rev:107274] Better presentation of extension error message in File and !UploadValidator
 * [rev:107273] Added unit tests to !FileTest and !FolderTest (some of them copied from !FileTest, to test Folder behaviour separately)
 * [rev:107272] Changed !ImageTest to use fixture files located in assets/ folder, the filesystem API doesn't support Folder objects with "sapphire/..." paths, which leads to inconsistent results
 * [rev:107271] Making !FileTest->setUp()/tearDown() more resilient against in-test file/folder renames
 * [rev:107270] More identifiable file naming in !FileTest
 * [rev:107269] Using File::get_file_extension() instead of substr() magic in File->setName()
 * [rev:107269] Using exceptions instead of user_error() in File->setName()
 * [rev:107268] Avoiding duplication by using existing getFullPath() in File->getAbsoluteURL()
 * [rev:107267] Made File::get_file_extension() more readable, and added unit test
 * [rev:107266] Removed File->setField(), doesn't have any overloaded functionality
 * [rev:107265] Documentation in File and Folder class
 * [rev:107214] updated generator tag URL
 * [rev:107175] force exclusive connection
 * [rev:107104] Added initial docs
 * [rev:107030] return false rather than error out in case SS_Query:: is not a resource
 * [rev:106938] mysql_fetch_row() expects resource, this will fatal if query was e.g. UPDATE when iterating a result because !MySQLQuery::nextRecord() is used by Iterator::valid() and !MySQLQuery:: is bool in this case
 * [rev:106876] Making $Email available in Security_passwordsent.ss template (fixes #5737)
 * [rev:106805] Added !FileTest->testValidateExtension() (related to #5693)
 * [rev:106804] Documentation
 * [rev:106777] Reverted r88633, it breaks <base> tag in static HTML for !ErrorPage->doPublish()
 * [rev:106694] Removed trailing slash in BackURL, fixed error message sentence structure in !PageCommentInterface.ss (fixes #5520)
 * [rev:106687] Fixed hardcoded error message in !PasswordValidator (fixes #5734)
 * [rev:106687] Added !PasswordValidatorTest
 * [rev:106568] Provide a default message for FIELDISREQUIRED
 * [rev:106313] Correct typo in comments
 * [rev:106248] Made CMSMainTest more resilient against database ID changes (Postgres doesn't have auto-increment resets across tests at the moment)
 * [rev:106190] Fixed memory limit setting in !SapphireTest (regression from r106128)
 * [rev:106187] Better checking of safe_mode in !MemoryLimitTest
 * [rev:106180] Add comments for !ThumbnailStripField
 * [rev:106156] Don't run memory limit tests in safe mode,
 * [rev:106128] Preserve memory_limit between tests (for better PHP5.1 behaviour)
 * [rev:106119] Added test for Database::hasTable().
 * [rev:106090] Fixed test that required a separate Page table.
 * [rev:106083] Removed db/build legacy wording in !DevelopmentAdmin (fixes #5676)
 * [rev:106081] Added test for #5657
 * [rev:105985] add text/plain to the list of accepted mime types
 * [rev:105912] Better error handling in Form::__construct() (fixes #5649)
 * [rev:105732] Clear DB checkbox unchecked by default
 * [rev:105517] Installer should not repeat "Could not determine your database version" twice in slightly varied words
 * [rev:105516] Show better message if couldn't find MySQL version in !MySQLDatabaseConfigurationHelper
 * [rev:105305] More solid markup testing in !TableListFieldTest through xpath
 * [rev:105297] Fixed !TableListFieldTest->testSelectOptionsRendering()
 * [rev:105282] Using ASSETS_DIR and THEMES_DIR constant in Image, !ManifestBuilder, Requirements, File (fixes #5619)
 * [rev:105281] Using ASSETS_DIR constant in !StaticPublisher (fixes #5619)
 * [rev:105277] Translations
 * [rev:105276] Translations
 * [rev:105274] Reverted r105264, breaks !CompositeFieldTest, !FieldSetTest, !TranslatableTest
 * [rev:105273] Updated !TableListField sublcass template to work with new !TableListField->!SelectOptions() setting
 * [rev:105272] Fixed _t() call in !PageCommentInterface.ss
 * [rev:105270] missing slash / from Requirements::css() parameter
 * [rev:105267] Removed jquery.livequery as a Requirement from !LeftAndMain.php, its only necessary in !SecurityAdmin for !MemberImportForm.js now.
 * [rev:105198] Fixed fixture location for !DbDatetimeTest
 * [rev:105196] Added !DbDatetimeTest cases to sapphire (these were previously in the sqlite3 module, but they actually test core Database functionality)
 * [rev:105188] Documentation
 * [rev:105139] increased height of the todo text field in the cms
 * [rev:105027] Checking for headers_sent() before setting cookies in Versioned::choose_site_stage() to avoid problems with URL parameters like showqueries=1 and !ContentController calling choose_site_stage() (fixes #5557)
 * [rev:105011] Documentation
 * [rev:105009] Documentation
 * [rev:105005] Documentation
 * [rev:104996] Documentation
 * [rev:104993] Language master file
 * [rev:104992] Removed duplicated code in i18nTextCollector, more defensive checks for get_owner_module()
 * [rev:104980] Added translations for !BrokenLinksReport, !ReportAdminForm.ss, !AssetTableField.ss (fixes #5527, thanks Martimiz)
 * [rev:104978] Allowing translation of "save" button in !SiteConfig->getCMSActions()
 * [rev:104970] Translations in !PageCommentInterface.ss (fixes #5598, thanks Pike)
 * [rev:104924] Reverted r104923, as current database releases of mssql and sqlite3 modules don't support this yet
 * [rev:104883] Fixed hidden mbstring reliance in !SiteTree->generateURLSegment() (broken in r104679)
 * [rev:104835] Save and restore lang state in test
 * [rev:104798] Fixed !SiteTreeTest and !SiteTreePermissionsTest to work alongside subsites module (!SiteTreeSubsites changes the canEdit() behaviour)
 * [rev:104796] Fixed !SiteConfigTest to work alongsite subsites module (!SiteTreeSubsites changes the canEdit() behaviour)
 * [rev:104795] Documentation
 * [rev:104769] Documentation
 * [rev:104767] Documentation
 * [rev:104733] fixed umlauts
 * [rev:104711] Added !DirectorTest->testURLParam() and !DirectorTest->testURLParams()
 * [rev:104710] Installing screen now has a page title called "Installing !SilverStripe..." instead of "PHP 5 is required"
 * [rev:104709] Removed double returns in installer (redundant code)
 * [rev:104708] Renamed checkdatabase method to checkDatabase to be consistent
 * [rev:104705] Show install MySQL version at 5.0+ as 4.1 does not work properly with !SilverStripe
 * [rev:104704] Tweaks to positioning of help text in installer
 * [rev:104682] fixed api doc
 * [rev:104636] added illustrator formats to the allowed extensions.
 * [rev:104610] Documentation
 * [rev:104598] Fixed wrong _t() notation in !ChangePasswordForm (broken in r103226 and r104596)
 * [rev:104596] Making strings in !ContentControllerSearchExtension translatable
 * [rev:104594] Defensive coding in !MigrateSiteTreeLinkingTask
 * [rev:104490] Removed !ForumAdmin.js which shouldn't belong in the CMS module
 * [rev:104483] Documentation
 * [rev:104404] Documentation
 * [rev:104402] Documentation
 * [rev:104158] Documentation migrated from doc.ss.org
 * [rev:104157] Migrated various API-style documentation from doc.ss.org


### Other

 * [rev:105057] MINOT Translation in !SiteTree (#5603, thanks Pike)
 * [rev:104674] ENHANCMENT: !RsyncMultiHostPublisher also rsyncs sapphire/static-main.php.
 * [rev:104668] Sake fix: look for php binary before php5, to prevent errors on CentOS and Cygwin.
 * [rev:104667] Added explicit bash handler to sake
 * [rev:104442] Multi-use redemption page created

<code>./sscreatechangelog --version 2.4.1 --branch branches/2.4 --stopbranch tags/2.4.0</code>