#  2.3.0 (2009-02-23)

## Upgrading

### Translatable Problems

**Don't use Translatable for multilingual database content.  Don't upgrade to 2.3.0 if you're already using
Translatable.**

The [Translatable extension](/topics/translation) is currently marked as
unstable for the initial 2.3 release. **If your site uses more than one language for page content, don't upgrade to this
release.** We're working on bugfixes which will be contained in a minor 2.3.x release soon. Check our [releaseannouncements](http://groups.google.com/group/silverstripe-announce) for updates on Translatable bugfixes.

### BasicAuth disabled on test sites by default

Basic auth isn't enabled by default on test sites.  If you need this, put this in your _config.php

	if(Director::isTest()) BasicAuth::enable();


### /silverstripe and /cms no longer work as aliases to /admin

Removed certain URL aliases for CMS interface to allow for common page URLs like "silverstripe" or "cms". Please use
/admin as the main URL to access the CMS. See http://open.silverstripe.com/ticket/3267

### SiteTree Access tab now lets you select multiple groups

In order to do this, `SiteTree->ViewersGroup` and `SiteTree->EditorsGroup` have been changed from has_one relations
to many_many relations.

Your group-assignements for "Who can view this page" and "Who can edit this page" should be automatically migrated upon
calling `dev/build`. See [#2847](http://open.silverstripe.com/ticket/2847)

### Newsletter moved into new module

Newsletter functionality has been moved into its own module called **[newsletter](modules/newsletter)**. If you were
previously using this as a feature out of the box with SilverStripe, then you will need to download the userforms module
to continue using it.

If you **don't** require the functionality, it's safe to delete these database tables:

*  Newsletter
*  NewsletterType
*  SubscribeForm
*  UnsubscribeRecord

#### auth_openid removed from default installation

The auth_openid module has been removed from default installation.  Please install the module separately from
[silverstripe.org](http://silverstripe.org/auth-openid-module/)

### GenericDataAdmin and RelatedDataEditor moved into new module

GenericDataAdmin functionality has been moved into its own module called

**[genericdataadmin](modules/genericdataadmin)**. If you were previously using this as a feature out of the box with
SilverStripe, then you will need to download this module to continue using it.

### User Defined Form moved into new module

User Defined Form has been moved into its own module called **[userforms](modules/userforms)**. If you were previously
using this as a feature out of the box with SilverStripe, then you will need to download the userforms module to
continue using it.

//Important note: If you **do** have an existing page of User Defined Form type in your CMS site tree, it's best to
install the module first as shown above. If you run dev/build?flush=1 without installing userforms, you'll lose the User
Defined Form page type until you install it then run dev/build?flush=1.//

If you **don't** require the User Defined Form functionality, it's safe to delete these database tables:

*  EditableCheckbox
*  EditableCheckboxOption
*  EditableDropdownOption
*  EditableEmailField
*  EditableFileField
*  EditableFormField
*  EditableMemberListField
*  EditableRadioOption
*  EditableTextField
*  SubmittedFileField
*  SubmittedForm
*  SubmittedFormField
*  UserDefinedForm
*  UserDefinedForm_Live
*  UserDefinedForm_versions

### PostBackup

PostBackup has been moved into a module.  See [postbackup
module](http://open.silverstripe.com/browser/modules/postbackup/trunk).

### /db/build/?flush=1 is now called /dev/build

Flushing the manifest with `?flush=1` doesn't need to be explicitly added.

### Core API Changes

*  Removed ViewableData->setVal(), use ViewableData->setValue() ===
*  Removed Director::isLiveMode(), use Director::isLive() ===
*  Removed DataObjectSet->append(), use DataObjectSet->push() or DataObjectSet->merge()
*  Removed Controller->LinkTo(), use Controller->join_links()
*  Removed DataObject->getLastWriteFields(), use DataObject->getChangedFields()
*  Removed Convert::raw2attr(), use Convert::raw2att()
*  Removed Member->isAdmin(), use Permission::check('ADMIN')
*  Removed Debug::warning(), use user_error("your message", E_USER_WARNING)
*  Removed SiteTree->canView_page(), Use instance-specific SiteTree->canView() instead by checking for `$this->ID`.
*  Deprecated URL parameter ?buildmanifest=1 (please use ?flush=1)
*  i18ntextcollector is executed from a new URL.  Use http://mysite.com/dev/task/i18nTextCollectorTask instead of
http://mysite.com/i18ntextcollector

### Director::addRules()

If you have made your own custom director rules with `Director::addRules`, you will need to add a double-slash into
the rule, to separate the part of the URL that specifies "this is how I get to this controller" from the part that
specifies "these are arguments to the controller".

In other words, change this:

	:::php
	Director::addRules(50, array(
		'admin/ImageEditor/$Action' => 'ImageEditor',
	));


To this:

	:::php
	Director::addRules(50, array(
		'admin/ImageEditor//$Action' => 'ImageEditor',
	));



### Decorators

*  Renamed DataObjectDecorator->extraDBFields() to extraStatics() (see
[r65065](http://open.silverstripe.com/changeset/65065))

*  DataObjectDecorator->updateCMSFields() is now called from DataObject->getCMSFields(), instead of only SiteTree
instances

*  Changed return values for DataObjectDecorator->updateCMSActions() to FieldSet, rather than an array.

### Data Model

*  Removed Datetime class, use SSDatetime instead (it was conflicting with PHP 5.2 integrated classes)
*  Removed Text->Att(), use Text->ATT_val() instead

### Forms

*  Removed NoScriptField, use LiteralField
*  Removed EncryptField, use PasswordField
*  Removed NamedLabelField, use LabelField
*  Removed NoScriptFormAction, use unobtrusive scripting
*  Removed FormField->setExtraClass(), use FormField->addExtraClass()
*  Removed deprecated ComplexRequiredFields, `RequiredFields` and custom javascript instead
*  If you have created your own FormField classes, FormField::performReadonlyTransformation() and
FormField::performDisabledTransformation() must return new form fields, e.g., cloned instances, or unit tests will fail.

### Templates

*  '''$Top''' in templates has changed its behaviour; if you call $Top from inside a template that is rendered
separately (eg, a Form template), it will point to the top element of that template execution (in this case, the Form
object) rather than the top element of the outermost template (which would presumably be the page in question).  This
was a bug that we have fixed, but some people may rely on it.  See http://open.silverstripe.com/ticket/2781

*  A `<legend>` element has been added before any `<fieldset>` in all SilverStripe forms. SearchForm.ss and Form.ss are
where it has been added. This now validates the form HTML for W3C compliance. Please verify that your forms visually
look okay after upgrading. Legend can be set by calling ''->setLegend('my legend here')'' on your Form object.

### CMS menu API

We have deprecated the LeftAndMain menu customisation API.

*  Don't set any menu-item static variables any more.
*  For the most part, you won't need to add anything to _config.php to add CMS menu items; just define the static
variables `$menu_title` and `$url_segment` on your `LeftAndMain` subclasses.

*  If you want to add a menu item that's not a subclass of `LeftAndMain` (eg, help or a link to a webstats package),
use `CMSMenu::add_menu_item()`

*  To remove a menu item, use `CMSMenu::remove_menu_item()`.  It identifies items by classname rather than arbitrary
$code value.

### ContentNegotatior is now disabled by default, mostly

The ContentNegotatior system was a bit of voodoo that confused a lot of people, so we have disabled it by default for
regular templates.  It will still enabled by default for templates that include the `<?xml ?>` header, because these
are the only templates that benefit from it significantly.

If you want to enable it for your HTML4 templates, then you can do so by calling `ContentNegotiator::enable()`.  Note
also that the DOCTYPE altering, which was a frequent cause of pain, only executes if your original template had the
`<?xml ?>` header.

### Other API Changes

*  Removed deprecated File::loadallcontent(), use Upload class
*  Image->URL returns relative instead of absolute URL.  Use Image->AbsoluteURL instead.
*  Moved DataReport and SQLReport into the ecommerce module.  If you're using these classes, please download the
[ecommerce module](modules/ecommerce).

### Default mysite/_config.php

The installer includes a default configuration file: *mysite/_config.php*. If you have already have your own

*mysite/_config.php*, you can safely keep your own version and disregard the new file.

### Default validators for Form instances (PHP and JavaScript)

Enforcing usage of a Validator instance in Forms if its not explicitly passed to the Form constructor. By default a new
RequiredField instance is used without any fields marked as required. This was necessary because some FormField
implementations rely on their validate() method, sometimes as a wrongly placed processing hook, but mostly for security
reasons. One example are file extension checks in FileField subclasses.
In most cases this won't have any effect on existing forms, although you might get additional JavaScript dependencies
like Validator.js and behaviour.js. If you want to disable JavaScript validation across forms, add the following to your
_config.php:

	:::php
	Validator::set_javascript_validation_handler('none');

See http://open.silverstripe.com/changeset/69688


##  New Features

 * ![rev:71761] Allow combined files to be disabled
 * ![rev:70697] CRM Security with two levels: viewable and writeable.
 * ![rev:70422] added silverstripe version number to meta generator tag
 * ![rev:70142] add permission control for AddForm and EditForm
 * ![rev:69687] added Smiliey support to BBCode / forum. Now BBCode supports :) :P :D :( 8-) and :^). Yays for icons. Should move from BBCodeParser to TextParser so its available in tinymce but this will do for the forum
 * ![rev:66163] #1531 - Allow moving files in root assets file (hamish)
 * ![rev:65904] #1614: Allow use of admin/addpage?ParentID=(ID)&PageType=(Class) url to quick-add pages
 * ![rev:65690] #594: Added javascript-on-demand support
 * ![rev:65689] #594: Added javascript-on-demand support
 * ![rev:65688] #594: Added javascript-on-demand support
 * ![rev:65555] #2767 wakeless: Allow popuplation of non-DataObject tables with YamlFixture
 * ![rev:65351] merged back patch for image editor. Currently completely broken on trunk this patch does nothing to fix it sadly. I think its a prototype thing
 * ![rev:65095] Added CMSMenu and CMSMenuItem and adjusted existing LeftAndMain subclasses to use new notation.See #2872 (thanks to hamish for the patch!)
 * ![rev:64881] Making DataObject attributes translatable through i18n class, e.g. $db and all relation statics. Use DataObject->fieldLabels() to access translated attributes.
 * ![rev:64877] Added JavaScript unit tests with jQuery QUnit. Can be viewed similiarly to PHPUnit tests through dev/jstests URL. Uses an `<iframe>` to include all tests.
 * ![rev:64758] Update to TinyMCE 3.2 - CMS changes
 * ![rev:64492] Support for i18n entity namespaces in templates
 * ![rev:64480] Added support for 'sake dev/tests/all --showslow' to list slow tests
 * ![rev:64473] Added ?debug_memory=1 flag
 * ![rev:64461] Show max memory usage on dev/tests/all
 * ![rev:64444] Flush template cache before running tests
 * ![rev:64417] Added SiteTreeMaintenanceTask
 * ![rev:64345] #2956 seaeagle1: Added If-Modified-Since support to HTTP::add_cache_headers()                             [16:00:18]
 * ![rev:64308] Allowing for field-level permissions in DataObject::$api_access - respecting those permissions for reading and writing in RestfulServer (#2918)
 * ![rev:64307] Allowing for field-level permissions in DataObject::$api_access - respecting those permissions for reading and writing in RestfulServer (#2918)
 * ![rev:64231] #2951 simon_w: Use 301 redirect on Director::forceWWW()
 * ![rev:64157] Added FormScaffolder for more flexible scaffolding of FieldSets from DataObject metadata
 * ![rev:64103] #2601 - More template handlers
 * ![rev:63679] Added HTTP method override support to HTTPRequest and Form (through $_POST['_method'] or $_SERVER['X-HTTP-Method-Override']), incl. unit tests
 * ![rev:63659] Frontend CRUD scaffolding with RecordController and CollectionController (not fully functional yet, needs correct Link() methods)
 * ![rev:63637] Added coloured output to dev/tests/all
 * ![rev:63623] Added DataObject->getFormFields() - uses DataObject->scaffoldFormFields() by default. Added DataObjectDecorator->updateFormFields() for easy customization
 * ![rev:63462] Added Email::obfuscate()
 * ![rev:62477] Including Firebug Lite when requested by ?debug_firebug=1 for easy debugging in IE/Opera/Safari- otherwise including fake-objects with FirebugX by default to enable usage of console.* commands without javascript errors
 * ![rev:62472] Added GoogleSitemap::enable()
 * ![rev:62467] Formatting MySQL error messages with newlines through new SQLFormatter class (used in MySQLDatabase)
 * ![rev:62458] Allow Use of ?fields=ID,Name,OtherField,RelName get variable on RESTful server queries, to restrict the fields and relations returned int the data set
 * ![rev:62396] Added BulkLoader_Result for better inspection of import results, replacing the simple numeric count result format.
 * ![rev:62333] TableListField's TRs can now have class=loading added to them to show a loading icon. (Used by ModelAdmin)
 * ![rev:62286] Allow customisation of HTTPResponse status text, as well as status code
 * ![rev:62284] Files & Images tree now shows filename rather than meta-data title, to make it easier to find the file you're looking for
 * ![rev:62211] #1403 - addFieldToTab(), push(), insertBefore(), etc will allow duplicates - the old field is replaced with the new.
 * ![rev:61824] #2594 - Allow decoration of getCMSActions() (simon_w)
 * ![rev:61605] relate groups with column selections in SearchForm of CRM Admin
 * ![rev:61444] xml2array now works with recursion so it will actually work with most xml files. Unit tests to comei
 * ![rev:60396] Added configurable Requirements::$write_js_to_body for performance improvements (turned off by default)
 * ![rev:60368] Improved debugging view on CLI interface, by having a separate DebugView subclass that takes care of error output for this situation.
 * ![rev:60220] Merged in CompositeDBField


##  API Change

 * ![rev:70697] add Group::canView() so that give group object a different level of security control.
 * ![rev:70150] we move the filedata generation part of export() function to a new function generateExportFileData, so that, a child class could reuse the function when overload export function
 * ![rev:70057] Decimal->requireField now includes 'not null' constraint, as Sapphire doesn't expect the value to be null. MySQL switches null values to 0.00 on build.
 * ![rev:69730] Removed access to broken image editor feature
 * ![rev:69688] Enforcing usage of a Validator instance in Forms if its not explicitly passed to the Form constructor. By default a new RequiredField instance is used without any fields marked as required. This was necessary because some FormField implementations rely on their validate() method, sometimes as a wrongly placed processing hook, but mostly for security reasons. One example are file extension checks in FileField subclasses.
 * ![rev:69363] Added ModelAdmin_CollectionController::columsnAvailable() and ModelAdmin_CollectionController::columnsSelectedByDefault() that can be overridden to customise the fields available in the column selection control.
 * ![rev:69360] Add keyField and titleField arguments to SQLMap
 * ![rev:68484] ContentNegotiator is now disabled by default, unless you include the xml header in your template. (merged from r68482)
 * ![rev:67426] Added SSViewer::set_source_file_comments() to allow disabling of comments in SSViewer output
 * ![rev:67380] Deprecated Email->setFormat()
 * ![rev:66894] Move some of the installer into the sapphire directory.
 * ![rev:66394] 
 * ![rev:66392] if a DataObject has getCMSActions, its model admin should be able to add them.
 * ![rev:66268] Deprecated Controller::PastVisitor(), it generates a lot of unused cookies
 * ![rev:66266] Improve encapsulation of cookies in Director::test()
 * ![rev:66264] Revamped CMSMenu system to not instantiate any objects, so that _config.php doesn't get fskd
 * ![rev:66175] Moving GoogleSitemap functionality into new "googlesitemaps" module
 * ![rev:65744] make CreateForm be able to disable
 * ![rev:65742] introduce SearchFilter::getDbFormattedValue() and GreateThanFilter will used this method to make the qurey so that it can apply to a field that input format is different that its db format, such as CalendarDateField.
 * ![rev:65669] even when no results found, the HTTPResponse should return a "200" HTTPResponse rather than "404" HTTPResponse, otherwise, the right panel didn't refresh the result table, and the error message shows up.
 * ![rev:65581] Deprecated CompositeField->insertBeforeRecursive(), use CompositeField->insertBefore()
 * ![rev:65554] tidy up NewsletterAdmin.
 * ![rev:65454] Deprecated DataObjectDecorator->augmentInit(), use LeftAndMainDecorator->init()
 * ![rev:65453] Deprecated DataObjectDecorator->alternateCanCreate(), use DataObjectDecorator->canCreate()
 * ![rev:65452] Removed Folder->userCan*() and File->userCan*()permissions and added more consistent behaviour with Folder->can*() and File->can*()
 * ![rev:65451] Don't include NULL returns in decorated methods called through Object->extend(), meaning empty method bodies in decorators won't confuse permission checks through $myObj->extend('canView') etc.
 * ![rev:65388] make DataObject::getField() visible to the public
 * ![rev:65385] Removed manifest's dependency on database, by removing hastable information                                                 [17:47:04]
 * ![rev:65229] Use return value of alternateCanPublish()
 * ![rev:65150] Changed SiteTree->EditorsGroup has_one relationship to SiteTree->EditorGroups has_many relationship (see #2847)
 * ![rev:65095] Removed LeftAndMain::add_menu_item(), LeftAndMain::remove_menu_item(), LeftAndMain::replace_menu_item(), LeftAndMain::clear_menu()
 * ![rev:65068] Removed DataObjectSet->consolidate(), use DataObjectSet->toNestedArray()
 * ![rev:65066] Removed DataObjectSet->consolidateString()
 * ![rev:65065] Renamed DataObjectDecorator->extraDBFields() to extraStatics()
 * ![rev:65060] Moved DataObject::get_by_url() to SiteTree::get_by_url()
 * ![rev:65059] Marked DataObject->filledOut() deprecated
 * ![rev:64958] #2922: RequestHandler:: now inherit
 * ![rev:64954] #2857 - Renamed RequestHandlingData to RequestHandler
 * ![rev:64953] #2857 - Renamed RequestHandlingData to RequestHandler
 * ![rev:64951] #2698 ajshort: URL handler only passes control to subclasses of RequestHandlingData
 * ![rev:64807] Added LastChange() method to BulkLoader_Result
 * ![rev:64806] Updated CsvBulkLoader to have hasHeaderRow = true by default, even when a columnMap is specified
 * ![rev:64805] add updateFieldLabels() to DataObjectDecorator, so as that a dataobject could update fieldLables by its decorator.
 * ![rev:64792] A Text db field, by default, should be rendered as a TextareaField in its scaffoldForm
 * ![rev:64528] delete GenericDataAdmin, RelatedDataEditor, DropdownField_WithAdd and their related code (js, css, etc) from cms, sapphire, "GenericDataAdmin" name space has also been deleted from lang files. They are all added in the new module "genericdataadmin"
 * ![rev:64504] Changed HTMLVarchar->scaffoldFormField() to use HtmlEditorField instead of HtmlOneLineField, which does not work.
 * ![rev:64428] Moved CheckboxFieldDisabled class to more common CheckboxField_Disabled notation
 * ![rev:64426] Removed NoScriptField, please use LiteralField
 * ![rev:64425] Removed EncryptField, use PasswordField
 * ![rev:64421] Moved setAllowHTML() to DataLessField
 * ![rev:64420] Removed NamedLabelField, use LabelField
 * ![rev:64416] Removed SiteTree->makelinksunique() and SiteTree->makelinksuniquequick() - use new SiteTreeMaintenanceTask
 * ![rev:64407] Removed NoScriptFormAction, use unobtrusive scripting
 * ![rev:64402] Removed deprecated File::loadallcontent(), use Upload class
 * ![rev:64401] Removed Filesystem::moverootfilesto()
 * ![rev:64399] Removed deprecated ComplexRequiredFields, use RequiredFields and custom javascript instead
 * ![rev:64398] Removed SecurityAdmin->listmembers()
 * ![rev:64394] Removed deprecated Datetime class, use SSDatetime instead (was conflicting with PHP 5.2 integrated classes)
 * ![rev:64384] Removed Email_Template, use Email
 * ![rev:64383] Removed ViewableData->setVal(), use ViewableData->setValue()
 * ![rev:64381] Removed Debug::mailBuffer()
 * ![rev:64380] Removed Director::isLiveMode(), use Director::isLive()
 * ![rev:64379] Removed FormField->setExtraClass(), use FormField->addExtraClass()
 * ![rev:64378] Removed DataObjectSet->append(), use DataObjectSet->push() or DataObjectSet->merge()
 * ![rev:64377] Removed Controller->LinkTo(), use Controller->join_links()
 * ![rev:64376] Removed Image->transferlegacycontent()
 * ![rev:64375] Removed DataObject->getLastWriteFields(), use DataObject->getChangedFields()
 * ![rev:64374] Removed  Convert::raw2attr(), use Convert::raw2att()
 * ![rev:64373] Removed deprecated RestfulService->connect(), use RestfulService->request()
 * ![rev:64372] Removed deprecated CustomValidator class
 * ![rev:64371] Removed deprecated EditForm classa
 * ![rev:64351] #551: Move code from CMSMain to SiteTree
 * ![rev:64350] #551: Move code from CMSMain to SiteTree
 * ![rev:64332] Removed deprecated methods related to CanCMS and CanCMSAdmin which are now removed from the Group class in favour of the Permission system
 * ![rev:64330] Removed deprecated method isAdmin() on Member - use Permission::check('ADMIN') instead
 * ![rev:64327] Removed references to CanCMS and CanCMSAdmin in Group, including references to it in Member. See ticket #2959 for more details.
 * ![rev:64157] Added third optional parameter $object to DBField::create() to comply with ForeignKey and PrimaryKey constructors
 * ![rev:63997] Deprecated GhostPage
 * ![rev:63922] Added support for dot syntax to FieldSet::fieldByName()
 * ![rev:63827] Added initial CMS tests to the system.  These will execute tests on the data model provided by a user's project code
 * ![rev:63764] Deprecated Form->loadNonBlankDataFrom() - it was duplicating loadDataFrom() without allowing for the same options, and it was buggy in its definition of "blank" by doing non-typesafe checks with if($value) $field->setValue($value) which resulted in '0' strings not being loaded
 * ![rev:63759] Moved PostBackup class to module (see r63758)
 * ![rev:63637] Added SSCli class to help with outputting coloured text on the command line
 * ![rev:63579] Deprecated HTTP::sendFileToBrowser() in favour of more testable HTTPRequest::send_file()
 * ![rev:63563] Created CSVParser class and updated CSVBulkLoader to use it
 * ![rev:63468] Deprecated Form->resetData() - use Form->resetField()
 * ![rev:63465] Changed parameters for Debug::friendlyError()
 * ![rev:63337] Deprecated DataObject->listOfFields() - use custom code instead
 * ![rev:63310] Removed SiteTree->canView_page() - originally created under the false assumption that SiteTree->can('view_page') is still valid. Every canView() can be instance specific. Original patch by simon_w in r53183 and #2198
 * ![rev:63182] Deprecated URL parameter ?buildmanifest=1 (please use ?flush=1)
 * ![rev:63177] Removed Text->Att(), use Text->ATT_val() instead
 * ![rev:63176] Deprecated Varchar->Attr(), use Varchar->ATT_val() instead
 * ![rev:63077] Removed useless File->test() method
 * ![rev:62883] TableListField::sourceFilter() can be overloaded to change the querying logic.
 * ![rev:62847] Deprecated Member::isInGroup() - use Member::inGroup() instead
 * ![rev:62846] Deprecated Member::isInGroup() - use Member::inGroup() instead
 * ![rev:62843] Removed Debug::warning()
 * ![rev:62325] Moved DataReport and SQLReport into the ecommerce module, since this is the only place it is used, plus it's going to be deprecated soon anyway
 * ![rev:62324] Moved DataReport and SQLReport into the ecommerce module, since this is the only place it is used, plus it's going to be deprecated soon anyway
 * ![rev:62316] Deprecated LabelledLiteralField by adding a @deprecated note with alternate approaches, and added a PHP notice for people currently using it
 * ![rev:62309] Moved ProgressBar and support files to newsletter/trunk module, as this is the module where it's used
 * ![rev:61683] TableListField::ajax_refresh is deprecated.  Removed all calls to it from the core, instead getting HTML fragments by visiting the field's URL.
 * ![rev:61632] BasicAuth is now disabled by default on test sites
 * ![rev:61505] Allow definition of DataObject::getCMSAddFormFields() to alter modeladmin step 1
 * ![rev:61485] Deprecated GroupedDropdownField, DropdownField should now be used instead
 * ![rev:60894] Added Validator::set_javascript_validation_handler() and ->setJavscriptValidatorHandler(), to choose a different way of dealing with javascript validation.  Currently 'none' and 'prototype' are the only legal options, but 'jquery' would be an obvious thing to implement.
 * ![rev:60711] Template precedence changed.  Page_results now takes precedence over HomePage.  That is, all action templates of parent classes take precedence over the actionless templates.
 * ![rev:60665] TableListField utility links no longer have target=_blank
 * ![rev:60405] Removed merged USZipCode field -  should be custom code until we figure out proper localization
 * ![rev:60392] Renamed static Member::autologinhash() to static Member::member_from_autloginhash() to be more in line with naming convnetions, and not conflict with Member.AutoLoginHash in the database
 * ![rev:60376] Allow the definition of SS_ERROR_LOG in _ss_environment.php to set up Debug::log_errors_to().
 * ![rev:60368] Added Debug::log_errors_to(), to log errors to a file.


##  Bugfixes

 * ![rev:71923] In SSViewer::parseTemplateContent($content, $template=""), when the $content is a xml template, we should not wrap anything around it, for web browser able to correct parse the xml
 * ![rev:71872] #3491 - Fix nonexistant plugin stopping tinymce from working in safari.
 * ![rev:71846] #3481 - Check if classes exist before trying to instantiate a singleton on database build, to work around stale manifest errors
 * ![rev:71841] #2723 - Allow more than more subclass of RelationComplexTableField on a page at a time.
 * ![rev:71797] removed doubled up pipes and border on switch view links in footer.
 * ![rev:71764] Fix wrong conditional
 * ![rev:71709] BUGFIX Fixed redirection to external URLs through Security/login with BackURL parameter (merged from trunk
 * ![rev:71642] Disable DataObject validation temporarily while importing yaml fixtures
 * ![rev:71568] CRM "select all" and "select none" doesn't work when the crm manages multiple models.
 * ![rev:71499] i18n::include_by_locale() should skip check the web root level and ../webroot level for language file, this is not only "not necessary" but also "must" because some server configuration prevent from any file access above the site root folder.
 * ![rev:71436] Error adding custom header in Email because of non-existant array key. Thanks ed! Ticket #3485
 * ![rev:71348] Removed unused ComplexTableField->unpagedSourceItems - was already commented out in r70956, and doesn't seem to be used across parent- or subclasses. Added ticket #3484 to re-enable popup pagination, which was broken and disabled due to the deprecation of $unpagedSourceItems (see r53830)
 * ![rev:71250] fixed site page restoration
 * ![rev:71177] cms ui, fixed loading spinner style
 * ![rev:71024] #3429: Fixed CMS change detection
 * ![rev:71023] #3443: Fixed refreshing of relation CTFs after editing data
 * ![rev:71018] #3442: Fix pagination in HasManyComplexTable, HasOneComplexTableField, ManyManyComplexTable
 * ![rev:70997] #3441 funkygibbon: Stop ThumbnailStripField breaking on orphaned images
 * ![rev:70994] CMS UI site content > search > add criteria select element now returns back to prompt & tweaked layout
 * ![rev:70935] adjust positioning of SilverStripeNavigator published/draft message
 * ![rev:70895] Ensure string "0" is not considered a NULL value when CsvBulkLoader imports values from a CSV file
 * ![rev:70893] reinstating silverstripe navigator and restyling to match cms ui
 * ![rev:70891] removed extra colon appearing in SilverStripeNavigator
 * ![rev:70848] Removed reference to Requirements::javascript() for including jquery as it's already included, and causes JS errors in MemberLoginForm
 * ![rev:70847] Fixed correct path to jquery.js in MemberLoginForm
 * ![rev:70832] $hide_ancestor hides Page as well when set from multiple subclasses of Page. Thanks dio5!
 * ![rev:70784] #3415 ajshort: Requesting root page via ajax now preserves isAjax value.
 * ![rev:70781] #3430 page versions don't appear automatically in Safari - versions DOM panel was floated behind the edit form
 * ![rev:70775] Fixed "cancel" button for inline "create folder" functionality (was not stopping event in IE7)
 * ![rev:70773] Disabled faulty usage of setStyle() with object literals instead of strings in SWFUpload
 * ![rev:70766] Removed hack that hid the Avatar field for the forum
 * ![rev:70750] Fix incorrect URL when adding a new Member via the MemberTableField
 * ![rev:70747] 
 * ![rev:70743] 1. TableListField exportfunality random bug. 2. make Email_BounceRecord::canCreate() return false; so that it can not be manully create from CRM, instead, it should create through email buncing system.
 * ![rev:70741] 
 * ![rev:70729] Add EditForm to list of allowed actions
 * ![rev:70725] 
 * ![rev:70724] Fixed loader_frame.html scrollbar madness. Removed hacked CSS and tidied up popup to work in IE6/7 and Firefox consistently
 * ![rev:70698] Group::AllChildrenIncludingDeleted() should filter on canEdit() rather than a can() call
 * ![rev:70695] $_POST[$this->Name] in TableField::SubmittedFieldSet are not always set
 * ![rev:70691] show flash icon and box if flash file exists. MINOR: created a default editor.css file which has base css styles for the CMS.
 * ![rev:70683] cms ui added colon to image upload prompt (inline with other step)
 * ![rev:70682] cms ui remove errant dashed borders in IE6
 * ![rev:70681] cms ui text size in righthand image panel
 * ![rev:70680] Fixed behaviour.reapply() call in TableListField->refresh() javascript to applyToParent (the actual DOM container). Otherwise methods of the TableListField prototypes aren't properly attached to the DOM nodes, which causes problems like #3377
 * ![rev:70671] Fixed newsletter send button alignment
 * ![rev:70616] stopped double scrollbars on popups in IE7 (IE6 still broken)
 * ![rev:70613] Fixed styling for "Delete selected files" in the left-hand tree actions for AssetAdmin. Thanks ajshort!
 * ![rev:70609] Defined jsValidation() and validate() so that inherited validation from DateField doesn't break PopupDateTimeField - this still needs fixing, and PopupDateTimeField shouldn't inherit from CalendarDateField
 * ![rev:70604] autocomplete style change.
 * ![rev:70603] cms ui fix files & images upload images styling
 * ![rev:70602] cms ui fix files & images table styling
 * ![rev:70601] cms ui removed backgound from delete button on files & images
 * ![rev:70583] cms ui fixing up treetool
 * ![rev:70573] cms ui removed extra padding from bottom of tools
 * ![rev:70572] cms ui fix styling of tools on files & images section
 * ![rev:70567] cms ui fix styling of tools on files & images section
 * ![rev:70566] reverted previous tree tool change
 * ![rev:70565] when the total number of rows is 0 the pagination says 1 to 0 of 0
 * ![rev:70563] cms ui fix styling of tools on files & images section
 * ![rev:70561] cms ui padding on tree
 * ![rev:70545] Hidden field needs to exist for DateField_Disabled in order for validation to pass correctly
 * ![rev:70541] cms ui padding on tree in right pane (eg. image selector)
 * ![rev:70508] cms ui tidying up tree tools
 * ![rev:70507] cms ui tidying up tree tools
 * ![rev:70497] merged patch from ajshort. Fixed getURL() so it preserved the extension
 * ![rev:70496] cms ui tidying up padding of tree tools elements
 * ![rev:70495] cms ui fix specifivity of alignment of radio buttons and labels in right pane
 * ![rev:70486] cms ui fix alignment of radio buttons and labels in right pane
 * ![rev:70481] If __form.elements.ID is not defined, don't cause an error in the CMS under certain circumstances
 * ![rev:70479] cms ui site tree tools style fix
 * ![rev:70474] Fixed float issue caused by change in r70303
 * ![rev:70445] fixed size of popup on 1024x768 resolutions
 * ![rev:70441] added scroll bars
 * ![rev:70404] site tree form element alignment
 * ![rev:70397] stopped swfupload div appearing behind cms ui in firefox 2 on windows
 * ![rev:70396] cms ui sitetree tools padding
 * ![rev:70395] IE6 cms login remember me alignment
 * ![rev:70393] cms ui sitetree padding across cms sections
 * ![rev:70392] centered GreyBox popup in the CMS
 * ![rev:70390] cms ui form site tree input alignments
 * ![rev:70389] cms ui form site tree input alignments
 * ![rev:70388] cms ui fixed width of tools at top of site tree
 * ![rev:70377] fixed site tree padding issue
 * ![rev:70376] URL input validation for RestfulServer
 * ![rev:70356] fixed positioning on site tree actions on left tree for Security and comment tags
 * ![rev:70172] due to changeset 65289 by phalkunz, the ImportForm() and import() functions need to move from CRMAdmin class to CRMAdmin_CollectionController class, fix relative bugs by the move.
 * ![rev:70160] Add workaround for PHP bug #46753
 * ![rev:70135] Fixed spacing at the top of right forms in the CMS caused by the `<legend>` element. Fixed by hiding it via CSS instead of removing it completely
 * ![rev:70130] Fixed issue of not enough space in the AssetAdmin "Upload" tab for multiple file uploading, mostly affecting IE6/7
 * ![rev:70127] Changed the FieldHolder method to use explicit functionality instead of statically calling FormField::FieldHolder()
 * ![rev:70117] Fixed clearing issue in IE7 for the left hand tree
 * ![rev:70077] Removed ANSI compatible SQL that shouldn't be in branches/2.3 - this feature is available in trunk
 * ![rev:70063] Removed ID for back links table which is ambiguous, unncessary and caused the CSV export to break
 * ![rev:70052] Deleted setting of $content variable that broke HTTP::findByTagAndAttribute()
 * ![rev:70049] Strip out any "~" characters that may stop the staging link from working in IE6/IE7
 * ![rev:70046] Check for form object before calling observe() on the element. The CheckBoxRange constructor allows for a null form, so a check for a form object is essential.
 * ![rev:70026] Disallow execution from DailyTask and HourlyTask by website visitors.
 * ![rev:69988] `<% end_if %>` was breaking the template where it should've been a `<% end_control %>`. This fixes the export link in #3333
 * ![rev:69986] Added page-limiting back to CMS tree querying
 * ![rev:69975] Fixed FileField->getFolderName() - it was not returning $this->folderName, instead it was returning an undefined variable in error
 * ![rev:69973] error when creating a form
 * ![rev:69951] More solid string-parsing through regular expressions in SQLQuery->filtersOnID() and SQLQuery->filtersOnFK(), incl. unit tests
 * ![rev:69943] #3329: Improved speed of folder creation in files + images
 * ![rev:69931] Fixed flash HTML that gets inserted into the content so it's cross browser compatible with browsers that don't support the `<object>` tag (`<embed>` is added inside)
 * ![rev:69930] Checkbox "Remeber me next time?" now works because of a missing method call logIn() on Member
 * ![rev:69927] #3024 - Stopped style dropdowns from getting stuck by making them regular dropdowns. Not as pretty but more stable.
 * ![rev:69921] Fixed minor error on dev/buildcache
 * ![rev:69910] Allowing to pass $context into Hierarchy->markPartialTree() and Hierarchy->markChildren()
 * ![rev:69909] Making sure a valid DataObjectSet is returned from Hierarchy->stageChildren()
 * ![rev:69899] Explicitly setting "lang" as a GET var when getting a page within the CMS (if the language chooser DOM object is available, hence translation mode is enabled). Used in CMSMain->init() to set the "current language". (merged from branches/translatable in r64523, thanks wakeless!)
 * ![rev:69894] Using baseDataClass() in Translatable::get_existing_content_languages()
 * ![rev:69893] Added extension point for augmentAllChildrenIncludingDeleted(), augmentNumChildrenCountQuery(), augmentStageChildren() in Hierarchy (merged from branches/translatable in r64523, thanks wakeless!)
 * ![rev:69891] Using SQL DISTINCT in get_existing_content_languages()
 * ![rev:69879] Fixed label positioning in CompositeFields for original language fields in translation mode (was shifted left before)
 * ![rev:69878] Fixed $add_action behaviour for SiteTree classes (through i18n_singular_name() method). Deprecated in favour of "`<myclassname>`.TITLE" entity to enable localized page titles. Limited add_action behaviour to SiteTree (was implemented on DataObject before)
 * ![rev:69872] Fixed status checking in SiteTree->getIsDeletedFromStage()/getIsModifiedOnStage()/getIsAddedToStage() for new pages with non-numeric IDs
 * ![rev:69870] Fixed use of undefined constant error, and undefined variable error in TableField stopping CMS user from adding records to a TableField
 * ![rev:69832] #3235: Fixed linking of images and other HTML tags
 * ![rev:69830] #3219: dev/buildcache showing up in static links
 * ![rev:69828] Fixed styling for caption checkbox field on the right hand image panel in CMSMain
 * ![rev:69803] If TreeDropdownField source object is "Folder", don't show "File" tree items unless the marking filter function is explicitly set. This fixes the bug where files were appearing for selecting a folder in the thumbnailstrip field in CMS
 * ![rev:69752] somtimes +/- icons hidden. ticket #893
 * ![rev:69728] #3254 - Fixed fatal errors when creating subclass of member
 * ![rev:69720] #3199: No longer warned about saving changes if you have actually pressed save.
 * ![rev:69718] #2550 - Fixed bug with draggability of newly created nodes.
 * ![rev:69715] #2342: Database names with hyphens and other special characters can now be used.
 * ![rev:69700] #3224 ajshort: Get HTTP::setGetVar() working with variables that contain array indexes
 * ![rev:69697] #3165 nicolaas: Fixed Director::history() in some cases.
 * ![rev:69696] #3248: Fixed TreeDropdownField when using non-ID key field
 * ![rev:69695] #3188: Fixed default HeaderField name to be non-conflicting with other fields, for backward compat
 * ![rev:69694] #3097: Removed buggy template feature
 * ![rev:69693] #3249: Allow altering of encryption algorithm
 * ![rev:69690] #3081 simon_w: Fixed pagination on spam comments
 * ![rev:69689] Don't include Validator.js if Validator->javascriptValidationHandler is set to 'none' (in Validator::__construct()).
 * ![rev:69681] Fixed HTML insertion through TinyMCE in Safari - TextArea fallback for lacking Codepress-support wasn't working. Known bug in Codepress JS Highlighter, see http://sourceforge.net/tracker/index.php?func=detail&aid=1913725&group_id=186981&atid=919470
 * ![rev:69657] Fixed js error due to inlined inclusion of CMSMain_upload.js which was conflicting with inline initialization. Disabled initializiation as the flash uploader was pulled out a while ago anyway (see #3251)
 * ![rev:69504] Fixed SiteTreeHandlers.loadTree_url url concatenation
 * ![rev:69442] Fixed permissions in CMSMain->revert() - only needs edit permissions, not publish permissions
 * ![rev:69378] CountryDropdownField now allows for title to be optional, which uses the name of the field if not set. This makes it consistent with DropdownField
 * ![rev:69377] Added check before foreach() to fix potential HMCTF bugs
 * ![rev:69360] Get DrodpownField::$emptyString working when used with a SQLMap source
 * ![rev:69321] Added `<td class="action">` to AssetTableField.ss to comply with template semantics of parent classes (necessary to detect javascript actions)
 * ![rev:69222] Strip potential whitespace from the beginning and end of string before limiting word count in Text->LimitWordCount(), fixing potential interference with truncation process
 * ![rev:69220] Fixed Text->LimitWordCount() not returning the correct number of words in the truncated text.
 * ![rev:69204] Making Password formfield in Member->getCMSFields() translatable
 * ![rev:69203] Making "Main" tab in FormScaffolder translatable
 * ![rev:69065] Fixed notice-level error in no-get-var URL processing when there is no querystring.
 * ![rev:68999] Make sure the website URL that the commenter posts has a correct "http://" or "http://" bit at the start of the string
 * ![rev:68940] Fixed bug in SQLQuery::unlimitedRowCount() when used with grouped queries, that should fix a lot of pagination situations.
 * ![rev:68935] Fixed PHP notice potential error in MemberTableField->addtogroup()
 * ![rev:68921] Turned english text into translatable entity for PageCommentInterface link for RSS feed of all comments for all pages
 * ![rev:68890] "console not defined" error in IE in en_US.js, check typeof(console) is not undefined before calling console.error()
 * ![rev:68881] remove Debug::message
 * ![rev:68875] Fix uglyness when title is longer than the tree dropdown field
 * ![rev:68858] Added closing tags to relation XML in XMLDataFormatter. Was relying on ContentNegotiator fixing self-closing tags automatically, but this form of content parsing is disabled for xml content by default now (see r68484)
 * ![rev:68834] Make sure date is a string before trying to use strtotime
 * ![rev:68817] Fixed sprintf detection bug in SiteTree->getClassDropdown()
 * ![rev:68810] Making only formfields readonly (not formactions) when comparing versions and showing historical versions within CMSMain
 * ![rev:68809] Check hasChanged method exists before calling it
 * ![rev:68764] Fixed translation of CommentAdmin_SiteTree.ss
 * ![rev:68762] Fixed label spacing in Date->TimeDiff()
 * ![rev:68757] Fixed additional tabs for image popus in AssetTableField. They we're not being generated in non-english interfaces due to the translated title being used as the tab identifier
 * ![rev:68754] Limiting readonly transformation of form in CMSMain->EditForm() to fields only (excluding actions). FormAction readonly transformations were fixed a while ago, which meant that they were actually enforced now, causing unavailable cms actions in certain scenarios (e.g. with a page deleted from live, which should make the fields readonly, but leave buttons functional)
 * ![rev:68752] Fixed TranslatableTest to instanciate Page instead of SiteTree fixtures - pages in the database should never have ClassName=SiteTree. This was causing failing tests due to the changes in SiteTree->getClassDropdown()
 * ![rev:68751] Including all translated language tables by default in i18n::_t() instead of selectively including modules based on filename. This caused bugs where entities were located in language tables in a different module than their filepath would suggest. Example: Page.SINGULARNAME is stored in sapphire/lang/en_US.php, while Page.php is stored in mysite/Page.php
 * ![rev:68746] Don't overwrite existing module arrays in i18nTextcollector - fixing bug with entities for "foreign modules" being reset during parsing
 * ![rev:68702] Updated CMS to support HtmlEditorField changes in r68701
 * ![rev:68662] #3166 jam13: Fixed caching in RestfulService
 * ![rev:68628] Fixed HasManyComplexTableField/ManyManyComplexTableField issue with source items which broke from changes in r66080. Thanks hamish!
 * ![rev:68627] Fixed javascript error in the CMS
 * ![rev:68626] Fixed javascript error in the CMS
 * ![rev:68603] Fixed new searchform changes for Live/Stage
 * ![rev:68515] Making sure phpinstaller works on subdomains (see #3167)
 * ![rev:68463] Fixed PHP notice in RebuildStaticCacheTask
 * ![rev:68331] Fixed ModelAdmin import success message (too few arguments for sprintf())
 * ![rev:68194] Allowing FormAction instances to be readonly by setting disabled="disabled". Adding CSS class "disabled".
 * ![rev:68177] Moved creation of "help" menu entry from cms/_config.php to LeftAndMain::init() to get localized titles (locale isn't set at _config.php level)
 * ![rev:68176] Fixed i18n display of menu titles rendered by CMSMenu in LeftAndMain->MainMenu()
 * ![rev:68170] Escape table name in versioned to allow creation of page type classes with the same names as SQL reserved words
 * ![rev:68159] Changing i18n entity format in CMSMenu->provideI18nEntities() to have actual class as namespace (related: r66264)
 * ![rev:68155] Added stub PDODatabase->renameField() implementation to avoid errors when batch-instanciating singletons
 * ![rev:68130] Supporting URLs with folder-structure in "sake -start `<myprocessname>` `<myurl>`"
 * ![rev:68039] Improved DataObjectSet->PaginationSummary() to show full context (instead of halved) when on first or last page
 * ![rev:68027] Don't show template comments in RSSFeed, or it'll break the XML document
 * ![rev:68026] Fixed undefined variable $matches in SSViewer::parseTemplateContent()
 * ![rev:68024] SSViewer::set_source_file_comments(false) wasn't working because of lack of checking if enabled.
 * ![rev:67777] Added check ot i18n::include_by_class() to prevent repeated calls.
 * ![rev:67681] Add a unique identifier to the "direction" method for Email::obfuscate() to avoid duplicate custom CSS being included in the page header
 * ![rev:67678] Method not found error. Requirements::customCSS() should be calling self::backend()->customCSS() not custom()
 * ![rev:67609] #3182 - Fix URL fixing on machines where url is case insensitive (hamish)
 * ![rev:67605] #3204 - Broken link tracking is broken (ajshort)
 * ![rev:67587] #3174 - Unable to drop widgets into widget areas in CMS (marcink)
 * ![rev:67584] #3218 - Spelling mistake in RestfulService (hamish)
 * ![rev:67582] Fixed a check for CSV field formatting.
 * ![rev:67580] Fixed an aliasing problem when saving popup items, and a bug with when associating a new record with the parent ID associated with the field.
 * ![rev:67530] SSDatetime can handle being given a NZ date in dd/mm/yyyy format
 * ![rev:67529] Only setting LockedOutUntil to NULL in Member->logIn() if the column is actually present in the database. Otherwise this setting will case an UPDATE Member SQL query to fail on the first /dev/build call on a 2.2->2.3 upgrade if not in dev-mode (=requiring login) (see #3171)
 * ![rev:67526] Added $CurrentLink to templates of AssetTableField and MemberTableField in order to support auto-refreshing after popup-close (see #2925)
 * ![rev:67520] Fixed i18n::get_owner_module() to detect template paths in themes (array notation) correctly (see #3022)
 * ![rev:67519] Added GoogleSitemap.ss from sapphire
 * ![rev:67506] Avoid ugly border in CMS forms by adding "border: none" in CSS to cms/css/layout.css
 * ![rev:67503] disabling template comments for xml output like sitemap.xml
 * ![rev:67455] Fixed incorrect parameter variable name in Mailer->sendPlain()
 * ![rev:67417] Added `<legend>` element immediately after `<fieldset>` for SearchForm and Form templates. This is required to validate these templates as W3C compliant
 * ![rev:67401] Moving Requirements::combine_files() calls from cms/_config.php to LeftAndMain->init() to avoid side-effects in non-CMS contexts. Examples:
 * ![rev:67363] $allowHTML argument was not passed to DatalessField::__construct
 * ![rev:67304] Since ModelAsController->handleRequest() expects a URLSegment, we make the ErrorPage Link() return a relative URLSegment in ErrorPage->publish()
 * ![rev:67299] Changed Director::test($this->URLSegment) to Director::test($this->Link()) in ErrorPage->publish() to be more robust
 * ![rev:67290] Added parent::setUp() and parent::tearDown() calls to various tests, in preparation for push/pop a mock controller the controller-stack
 * ![rev:67271] dev/build should function even when new classes are referenced in _config.php
 * ![rev:67268] Filter on the baseclassid in Hierarchy, not the class id, in case the class doesnt have a table (aoneil)
 * ![rev:67221] Save default locale for new members, so the profile form doesn't show first available locale in dropdown because its defaults are overwritten by Member->Locale = NULL (see #3159)
 * ![rev:67201] Declared behaviour.js variables as local for better recursive functionality
 * ![rev:67199] Fixed incorrect permission checking when the current member isn't being used
 * ![rev:67162] Scrollbars didn't appear properly in CMS without resizing the window manually, so used jQuery to properly detect when document is ready before attempting resize. Ticket #3089
 * ![rev:67150] Checking for "$this instanceof VirtualPage" instead of "$this->class == 'VirtualPage' to support subclassing in VirtualPage->onBeforeWrite()
 * ![rev:67147] Fix requirements not being restored after an email is sent
 * ![rev:67140] Checking for existence of $this->record in VirtualPage_Controller->init()
 * ![rev:67137] Fix publishing of error pages
 * ![rev:67083] Fixed StaticExporter output format
 * ![rev:67078] Put the order of save and publish buttons back to normal (so save and publish are next to eachother)
 * ![rev:67045] Fixed Enum::scaffoldSearchForm() to always include an (All) option
 * ![rev:67035] Fixed error in javascript (because of commented out code) that broke IE6/7 in the CMS
 * ![rev:66946] Fixing tests
 * ![rev:66940] Fixed warning on AssetAdmin (merged from trunk)
 * ![rev:66922] #3100: Graceful degradation for codepress in safari
 * ![rev:66918] #3115 ajshort: Fixed backslashes in temp folder location in manifest builder
 * ![rev:66894] Friendlier error when you have a site running on a PHP4 server, or a server without PHP.
 * ![rev:66891] Don't make blank dates show 1/1/1970
 * ![rev:66888] Better generation of PastMember cookie when you have stale login info
 * ![rev:66828] Fixed sortWidgets() function in WidgetAreaEditor not working because it was picking up comment nodes
 * ![rev:66820] Added extension to email address when accessing Security/passwordsent since the . (dots) are split into extensions when the URL is parsed
 * ![rev:66799] Fixed importer not working because of i18n_singular_name(), just use the class name of the model instead
 * ![rev:66793] Made use of Convert::raw2att() before returning the ModelName for Import spec fields
 * ![rev:66791] Fixed "Show specification..." link not working because ModelName had spaces in it
 * ![rev:66784] Only including ModelAdmin->ImportForm() if an actual importer was specified
 * ![rev:66740] Passing through $member param from SiteTree->canPublish() to SiteTree->canEdit()
 * ![rev:66723] fixed typo in filesystem
 * ![rev:66707] Fixed notice-level errors in PhoneNumberField
 * ![rev:66701] Add LeftAndMain:$url_rule to minimise bugs in modules
 * ![rev:66698] Fixed sake bug when checking for an argument in bash script. Ticket #3112. Thanks simon_w.
 * ![rev:66638] Fixed flaw logic checking for $member variable, since it's always set the alternative for choosing Member::currentUser() would never work.
 * ![rev:66635] Fixed SiteTree->getCMSActions() so it returns a FieldSet, instead of a DataObjectSet. This makes it consistent with DataObject->getCMSActions() as well as SiteTree->getCMSFields()
 * ![rev:66632] Fixed SiteTree->getCMSActions() not extending properly because it was passing an array to the extend() 2nd argument, which expected a FieldSet object
 * ![rev:66629] Fixed incorrect class name in user_error message for deprecated function HTTP::sendFileToBrowser()
 * ![rev:66608] ModelAdmin clear search now preserves the result column selection
 * ![rev:66505] Consistenly returning cloned instances for all FormField classes when calling performReadonlyTransformation() or performDisabledTransformation(). Making sure that these instances are actually flagged as readyonly/disabled. Addd unit tests to dynamically instanciate most FormField classes to check for this behaviour. Originally, this bugfix was necessary to avoid changed FormField state when recursively calling replaceField() on FieldSet->dataFields() in Translatable->updateCMSFields()
 * ![rev:66431] Removed SearchForm->FormMethod() and used $this->setFormMethod() in SearchForm constructor instead which is a nicer solution instead of overloading a Form method
 * ![rev:66334] Hiding "change password" fields by default in admin/myprofile, they shouldn't validate the input by default. Replaced with a link to toggle those fields (#3106)
 * ![rev:66332] Include jquery_improvements.js whenever jquery.js is required, so jQuery.noConflict() is set. This is required to ensure $() behaves in the prototypey way (alias for document.getElementByID()) rather than jQuery style (document.getElementsBySelector())
 * ![rev:66331] Removed overloaded $() function which added support for multiple string arguments in behaviour.js - was conflicting with argument usage in jQuery when not in noConflict() mode. As far as i can tell, multiple string arguments in $() were never used anyway.
 * ![rev:66319] Removed dependency on ComplexTableField JS in LeftAndMain for "My Profile" popup
 * ![rev:66318] Check if $member variable isn't empty before looking for first name in MemberLoginForm
 * ![rev:66317] Fixed call to incorrect case of function name, Member::currentUser() should be used
 * ![rev:66313] Fixed ForeignKey->scaffoldFormField() usage of model class instead of relation class to generate dropdown list
 * ![rev:66309] Fixed far too small height and width of "Profile" popup in CMS, popupHeight and popupWidth should be defaultPopupHeight and defaultPopupWidth instead according to the ComplexTableField prototype
 * ![rev:66306] Fixed HasManyComplexTableField, and subclass fields HasOneComplexTableField and ManyManyComplexTableField saving bug because javascript wasn't being included properly
 * ![rev:66305] Fixed recursion bug with FieldSet::fieldPosition
 * ![rev:66274] Improved reliability of LeftAndMain->CMSVersion() - not failing on empty $URL$ placeholder with subversion path to determine version numbers
 * ![rev:66269] Merged from trunk; fix DataObject::hasDatabaseFields()
 * ![rev:66266] Fix test/cookie conflict in ErrorPage rendering
 * ![rev:66252] Immediately apply behaviours that are added after the Behaviour.apply() call, in Behaviour.register() calls as well as Class.applyTo() calls
 * ![rev:66251] Removed unnecessary and bug-causing Behaviour.apply() call.
 * ![rev:66250] Made Behaviour.apply calls more specific
 * ![rev:66229] Added flash button to tinymce_ssbuttons
 * ![rev:66196] #2714 - Cookie::set doesn't operate correctly with expiryDays 0 (wakeless)
 * ![rev:66195] #2694 - Mathspam question clear
 * ![rev:66194] Fixed draggable bug in AssetTableField - thanks for ajshort for the patch - ticket #3051
 * ![rev:66162] #118 - Fixed count of marked pages (hamish)
 * ![rev:66137] Fixed editable formfields not showing up in translation mode (#3083). Updated Translatable->updateCMSFields() by partially merging wakeless' patch from (r64523)
 * ![rev:66136] Disabled js code in CMSMain->switchlanguage() which was assuming wrong DOM structure (TODO: Replace with more robust selectors)
 * ![rev:66135] Fixed field labels for original readonly fields in translation mode
 * ![rev:66107] Fixed PHP variable initialization in SiteTree->getClassDropdown() which broke class dropdown in behaviour tab (regression from r66092)
 * ![rev:66091] $cache flag wasn't passend through from ViewableData_Customised->XML_val() to ViewableData->XML_val()
 * ![rev:66079] #3051 ajshort: Improved layout of assettablefield drag icon
 * ![rev:66070] Fixed HTTP->findByTagAndAttribute missing variable error causing HtmlEditorField to break since it used HTTP::getLinksIn()
 * ![rev:66067] #3065: Fixed restore page
 * ![rev:66066] #3012 jam13: Fixed tabstrip default tab selection when working with querystrings
 * ![rev:66065] Fixed security tabs for JSoD code
 * ![rev:66062] #3063: Allow old-school method of adding menu items to LeftAndMiain:
 * ![rev:66052] #3087 simon_w: Added ResfulService::connect() back, for backward compatability
 * ![rev:66049] Fixed unescaped html display in DevelopmentAdmin (#3080)
 * ![rev:66044] Fixed `<% require %>` call in ModelAdmin_left.ss
 * ![rev:66043] Fix PHP notice where variable with array didn't exist in HTTP->findByTagAndAttribute()
 * ![rev:66029] use a undefined variable $member.
 * ![rev:66027] Fixed incorrect call to Permission::checkMember() - missing second argument, first argument should've been a Member object or Member ID
 * ![rev:66026] Fixed PHP notice level error in some circumstances in DataObject->buildDataObjectSet()
 * ![rev:65944] #3073: Fixed LeftAndMain::deleteitems()
 * ![rev:65923] #3066: Fix ?isDev=1 option
 * ![rev:65900] #2868: Fix after-popup-close behaviour on security member table
 * ![rev:65899] #2820: Fixed use of buggy reflection in Object::uninherited()
 * ![rev:65896] #2706: Fixed JS error in multi-nested pages deletion
 * ![rev:65895] #2232: Prevent requirements from breaking ErrorPage publication
 * ![rev:65894] #1721: Fixed del/ins styling in page comparison
 * ![rev:65881] Don't let permission errors on assets/ folder completely prevent javascript from loading
 * ![rev:65865] Fixed tabstrip JS error in ReportAdmin
 * ![rev:65863] Ensure that menu items of the same priority show the first added item closes to the left
 * ![rev:65860] Fixed JS error in ReportAdmin
 * ![rev:65851] #3062: Fixed ondemand support for jQuery responses as well as prototype
 * ![rev:65850] Alow decoration of Member with has_many relationships
 * ![rev:65843] #3062: Fixed ondemand support for jQuery responses as well as prototype
 * ![rev:65842] #3061: Text.FirstSentence returns '.' instead of empty string on an empty field
 * ![rev:65827] Fixed flash uploader not searching for the correct files, due to changes in r65820
 * ![rev:65825] Tidied up messages in flash uploader right hand panel in CMS
 * ![rev:65769] Fixed deletion of RedirectorPage
 * ![rev:65763] Missing variable in some circumstances caused Requirements::include_in_response() to break
 * ![rev:65761] Missing variable in some circumstances caused Requirements::include_in_response() to break
 * ![rev:65711] Added support for CSS media types to CSS on demand
 * ![rev:65680] there is no horizontal scroll bar for Model Admin right panel if the results table is long.
 * ![rev:65671] temp fix for flash inserter.
 * ![rev:65616] Fixed searching on sapphire/trunk due to Form changes - FormAction was useless on SearchForm anyway
 * ![rev:65612] Removed offending $this->canEdit() which returned a boolean, not appropriate to be passed into Member::mapInCMSGroups()
 * ![rev:65583] Adjusted Translatable to api changes from r65581
 * ![rev:65554] a lot of methods in this class now passed $params as HTTPRequest object, rather than as a array if the function is called from Ajax or top-level of front-end, some method is called in both manner, ie. called from Ajax and called internally as well, so we need to check $params type and do further process. This is a partial fix of open source ticket #3035
 * ![rev:65539] Setting correct user locale in ImageField and FileIframeField - the controller is separate from the CMS context, so wasn't initialized with i18n (see #1727)
 * ![rev:65538] Using 'SiteTree' classname instead of 'Page' in UpgradeSiteTreePermissionSchemaTask to avoid clashes in schema when Page.php has its own tables
 * ![rev:65536] Making Metadata fields writeable in translation mode (see #2993)
 * ![rev:65518] Removed project-specific hack in DataObject->getManyManyComponentsQuery() as it was breaking Translatable saving
 * ![rev:65517] Fixed breadcrumb exploding in DebugView when base-URL is "/" - was confusing the str_replace() logic
 * ![rev:65515] Fixed Translatable::default_lang() call in CMSMain
 * ![rev:65512] Fixed SiteTreeMaintenanceTask from extending unkown class Task to extending Controller
 * ![rev:65510] #3015: Fixed close buttons on tinymce side panels
 * ![rev:65502] Fixed bug with // placement in CMSMenu Director rule generation
 * ![rev:65469] Better initial-site-setup boundary condition checking needed after the manifest builder update
 * ![rev:65462] Setting Director::set_site_mode('site') in RootURLController in newly added init() method, which fixes Translatable::choose_site_lang(). The original bug was a wrong selected language in the `<meta>` tags through SiteTree->MetaTags()
 * ![rev:65456] Using uncached DataObject::get_one() calls in ModelAsController to avoid stale data with subsequent Director::test() calls which alter the page relations inbetween
 * ![rev:65424] #2987 - IE8 support via IE7 compatability mode
 * ![rev:65394] Fixed broken dev/build compilation of manifest
 * ![rev:65361] Added SSViwer support for i18n namespaces in templates with `<% _t('MyNamespace.MyEntity', ... %>`, to work around magically added namespaces from the parsed template file. Those auto-namespaces were logically not working in includes, as the parsing context is always the including template. Legacy support for auto-namespaces is still present due to its high usage.
 * ![rev:65336] Making ModelAdmin labels in left panel translatable again (regression from moving them into one common panel)
 * ![rev:65335] Respecting $dontEscape in FormAction
 * ![rev:65293] Using empty title in TreeDropdownField->Field() if the related DataObject cannot be found
 * ![rev:65291] Reverted text replacement performance improvement in SQLQuery - it was replacing more ocurrences via str_replace() than the previous implementation based on arrays, which broke queries augmented by Translatable (originally committed in r60468 and r54044)
 * ![rev:65282] Fixed page comment javascript to suit new Form name
 * ![rev:65275] #2243: Fixed ViewableData::Odd
 * ![rev:65271] #2630 - Removed notice-level error
 * ![rev:65269] #2954 - Fixed support for negative numbers in decimal fields
 * ![rev:65250] #2992: Fixed T_PAAMAYIM_NEKUDOTAYIM error in RequestHandler
 * ![rev:65242] fixed canPublish() so it actually got the member if none was passed and fixed notice with $results not existing
 * ![rev:65232] #2056: Removed all references to deprecated Member::isAdmin()
 * ![rev:65229] Allow DBField::__construct() without a name
 * ![rev:65214] Remove LeftAndMain entry from CMSMenu (#3014). Thanks to hamish for the patch!
 * ![rev:65213] Only enforcing record-level permissions in LeftAndMain if passed ID is numeric to avoid breaking AssetAdmin with string-based IDs (regression from r65152). See #3017
 * ![rev:65212] Calling parent constructor in ComplexTableField_ItemRequest, was confusing RequestHandler
 * ![rev:65180] Add magic methods on ModelAdmin to $allowed_actions (regression from r64988)
 * ![rev:65174] MemberTableField use of sourceFilter should be treated as a string, not an array as per the API of TableListField
 * ![rev:65152] Enforce permission checks in LeftAndMain and CMSMain through SiteTree->canView()/canEdit()/canAddChildren()/canPublish()/canDelete() (see #2701)
 * ![rev:65151] Fixed SiteTreeAccess.js DOM IDs to field changes made in r65150
 * ![rev:65150] Disallow SiteTree->canEdit() if SiteTree->canView() is not granted
 * ![rev:65148] Fixed js error in LeftAndMain_right.js when displaying readonly pages
 * ![rev:65141] TableField delete row inconsistency with TableListField which caused table fields to not fade the row out
 * ![rev:65135] Fixed call to Member function that didn't exist
 * ![rev:65127] Fix potential PHP notice opening a ComplexTableField popup
 * ![rev:65123] Fixed bug with ID-less generation of YamlFixture entries that trigger $this->write() in setters
 * ![rev:65106] Setting menu titles for CMSMenu items in LeftAndMain::init() to get translated values for the current user locale (see #2873)
 * ![rev:65104] Fixed menu titles entity references in CMSMain and AssetAdmin
 * ![rev:65094] Fixed SearchContextTest to comply to new scaffolded searchfield in Text DBFIeld
 * ![rev:65071] Reverted auto-detection of i18n statics like $db in DataObject through provideI18nEntities() - was getting too complicated with decorated properties. Overload DataObject->fieldLabels() or DataObjectDecorator->updateFieldLabels() instead
 * ![rev:65063] Checking for array existence before iterating through DataObjectDecorator->provideI18nEntities()
 * ![rev:65062] Dont instanciate abstract classes in i18nTextCollector
 * ![rev:65061] Using SiteTree::get_by_url() (see r65060)
 * ![rev:65057] Collecting i18n entities for decorators separately from the decorated classes, as decorated properties like $db have to be stored in the module of the decorated, not in the module of the decorated class.
 * ![rev:65030] Different class_implements() usage without instanciating the class in i18nTextCollector - not all classes are instanciatable without arguments. This raises the minimum requirement for text collection to PHP 5.1+
 * ![rev:65028] Fixed SecurityAdminTest to work with i18n enabled
 * ![rev:65026] Fixed CsvBulkLoaderTest to comply to hasHeaderRow API change (r64806)
 * ![rev:65024] Fixed CMSMainTest to check for translated entities to avoid failing tests with i18n enabled
 * ![rev:65023] Changed i18nTextCollectorTest to only trigger _t() calls in instance methods (they don't fully work in __construct()). Manually adding ClassInfo state for the fakewebroot needed to test textcollection - ManifestBuilder/ClassInfo currently don't support setting of other webroots, or flexible inclusion/exclusion of certain subfolders which would be necessary to do this without hacks.
 * ![rev:64981] Don't allow calling of magically added methods via URL unless explicitly listed in allowed_actions
 * ![rev:64976] Fixed wrong case of class names for ImageIFrameField causing errors
 * ![rev:64879] Fixed title-handling in FormAction, regression from r64410
 * ![rev:64878] Fixed missing $H() reference in i18n.js (#2989)
 * ![rev:64850] Avoid ajax evaluator errors by checking if $resizedImage actually exists before calling relativePath() on it
 * ![rev:64812] Content wasn't saving on subsequent page loads, after TinyMCE3 upgrade
 * ![rev:64798] Fix DataObject::write() with a specified ID and forceInsert to be true
 * ![rev:64788] in IE, overflow left pane is hidden and cannot enable scrollbar
 * ![rev:64771] Made ContentController work properly if it doesn't have a dataRecord
 * ![rev:64770] merged patch from ajshort to fix checkbox fields in the cms
 * ![rev:64754] Fixed old references to GenericDataAdmin in ModelAdmin.php and ModelAdmin_Results.ss
 * ![rev:64739] Security->passwordsent() didn't get the "Email" variable from the URL properly, because of updates to HTTPRequest
 * ![rev:64736] Fixed non-object or not null error in TreeSelectorField
 * ![rev:64732] New folders weren't getting their name set correctly, instead they would just be called "NewFolder". This occurred in the Site Content section of the CMS, creating a folder using the right hand panel in that section.
 * ![rev:64604] Fixed incorrectly reverted methods related to sizing of the popup.
 * ![rev:64601] Fixed extra class addition on various FormField->Field() methods
 * ![rev:64562] Using include_once() instead of include() for _ss_environment.php in install.php and Core.php to avoid PHP notice errors about double constant defines (see r64561)
 * ![rev:64506] Renamed "Save & Publish" to "Save and Publish" since this value is used in the value attribute of input elements, properly parsed, this would produce &amp; instead of &
 * ![rev:64494] Fixed distribution of textcollector files to modules (was collecting all entities into all modules before) - added unit tests
 * ![rev:64491] Fixed wrongly formatted _t() call in Security class
 * ![rev:64490] Fixed $module parameter for i18nTextCollectorTask
 * ![rev:64471] Fix issue with language files not being included
 * ![rev:64467] Removed duplicate setValue() method on Time (was supposed to be deleted instead of renamed from setVal() to setValue())
 * ![rev:64466] posix_isatty sometimes returns a benign error
 * ![rev:64462] Don't run migration code for permissions if the old field doesn't exist.
 * ![rev:64443] Fixed RestfulServerTest fixture path
 * ![rev:64440] Unit tests for RestfulServer (see r64439)
 * ![rev:64439] Returning 409 Conflict HTTP Header when trying to create a resource on an existing URL through RestfulServer
 * ![rev:64438] Removed $headingLevel reference from LabelField (was supposed to go into HeaderField)
 * ![rev:64437] Second constructor argument $title for HeaderField should be optional for legacy reasons
 * ![rev:64427] Using PasswordField instead of deprecated EncryptField
 * ![rev:64423] Adjusted HeaderField and LabelField implementation to new constructor arguments (see r64421)
 * ![rev:64422] Adjusted HeaderField and LabelField implementation to new constructor arguments (see r64421)
 * ![rev:64361] #2963 - Fix RSSFeed to work with new add_cache_headers
 * ![rev:64334] Reverted Member->isAdmin() removal since it's being used in a lot of places, we shouldn't deprecated it... yet.
 * ![rev:64329] correct wrong syntax of TableField class in its frontend javascript
 * ![rev:64328] avoid a CSSClass is added to a veiwable data twice.
 * ![rev:64325] $this->extraData is not alway set for an TableField_Item
 * ![rev:64320] If DropdownField->Field() lack of source checking before looping through it
 * ![rev:64318] Fixed DropdownField handling of Iterator objects rather than arrays in the newly created getSource()
 * ![rev:64314] If ajaxActionsOnTop is called twice, the actions are removed.
 * ![rev:64313] Don't use singleton() to create DataFormatter instances, as it will cause weird side-effects with multiple formatter instances with different parameters (broke subsequent test runs of RestfulServerTest and SoapModelAccessTest) - all aboard the failboat!
 * ![rev:64310] Unsetting $_SERVER globals in RestfulServerTest to avoid side-effects across unit tests
 * ![rev:64309] Added RestfulServerTest->testApiAccessBoolean()
 * ![rev:64307] Fixed RestfulServerTest->testAuthenticatedGET()
 * ![rev:64275] fixed default_country_value so that it will actually call the default country if IP lookup doesnt work
 * ![rev:64263] Fix disappearing fields when a field without a name was being pushed onto a FieldSet (eg a CompositeField)
 * ![rev:64251] Fixed ComplexTableField->saveComplexTableField() success message object link - was assuming same context as ComplexTableField_ItemRequest
 * ![rev:64239] Adjusted ForeignKey->scaffoldFormField() to new scaffolding notation ("ajaxSafe" instead of "ajax")
 * ![rev:64237] Fixed FormScaffolder string literal parsing FALE in getFieldSet()
 * ![rev:64229] Storing HTTP "Referer" header from $_SERVER in Director::direct() and passing it along in Director::test()
 * ![rev:64228] Checking for an empty array for $postVars in Director::test() to determine HTTP method - an existing array should cause POST rather than GET, even if its empty
 * ![rev:64227] Fixed stupid ommission from r64223 which caused HTTPRequest to construct without a proper URL
 * ![rev:64224] Using fieldLabel() for $has_one relationships in FormScaffolder
 * ![rev:64173] Fixed wrong call to scaffoldCMSFields() in Member->getCMSFields(), removed addScaffoldRelationFields() call as this is done by the newly called parent::getCMSFields() already
 * ![rev:64153] #2906 - Fixed manifest conflict in web-tests
 * ![rev:64142] fixed ss.i18n.sprintf() call in Validator.js
 * ![rev:64124] #2936: Define STDOUT if it's not already defined...
 * ![rev:64109] Fixed order of arguments.
 * ![rev:64099] Bad XHTML in en_US language file (#2624) - thanks tiwoc!
 * ![rev:64098] Director::fileExists() fails on windows with absolute paths (#2935) - thanks to ajshort!
 * ![rev:64097] Fixed CSSContentParser to only use tidy on CLI mode if its available, and first check for existence of PHP tidy extension. Fixes failing unit tests on standard WAMP windows installations.
 * ![rev:64096] Fixed CSVParser assumptions about absolute unix-style filepaths - using Director::absFile() instead now
 * ![rev:64081] Consistent usage of ss.i18n.sprintf() instead of ss.i18n.printf() - the method is returning a string rather than outputting directly, so should be sprintf()
 * ![rev:64077] Fixing AssetAdmin translations which were previously moved to Folder.php - i18n::include_by_class() doesn't like filenames/namespaces which are in a different folder than the language file they're referenced in (see #2359) - started in r64076
 * ![rev:64076] Fixing AssetAdmin translations which were previously moved to Folder.php - i18n::include_by_class() doesn't like filenames/namespaces which are in a different folder than the language file they're referenced in (see #2359)
 * ![rev:64074] Fixed AssetTableField javascript errors caused by r64049
 * ![rev:64072] Fixed DebugView Breadcrumbs to not include query string as separate link, and don't append an arrow after the last element
 * ![rev:64049] fix the bug that add some rules for summary columns even when they are not there.
 * ![rev:64042] Using _t() to check content strings in unit tests and avoid tests failing when i18n is enabled
 * ![rev:64038] Removed $_ALL_CLASSES in ReportAdmin::has_reports() - this doesn't need to be here anymore, due to changes in ManifestBuilder
 * ![rev:64013] Limited error message scope on invalid classname for TestRunner
 * ![rev:64011] Ignore TestOnly classes when collecting permissions
 * ![rev:64010] Removed dependency of ss.i18n.js on other libraries by replacing $$ with document.getElementsByTagName() and implementing a custom event attacher - see #2927
 * ![rev:64007] Making less assumptions about object structure in FieldSet->addFieldToTab() error messages
 * ![rev:64005] YamlFixture->saveIntoDatabase(): In order to support reflexive relations which need a valid object ID, the record is written twice: first after populating all non-relational fields, then again after populating all relations (has_one, has_many, many_many). Fixes a bug where FileTest was testing onBeforeWrite() behaviour
 * ![rev:64004] Writing record from yml before parsing relations in YamlFixture->saveIntoDatabase() to avoid missing lookups for reflexive relations on the same object
 * ![rev:64002] Moved RecordController and CollectionController to external module (see r63905)
 * ![rev:64001] Adjusted FormTest->testLoadDataFromObject() to new assumptions about changed behaviour on loadDataFrom() from $loadBlanks to $clearMissingFields - which means that form fields are cleared regardless if they have blank values in the passed object or not
 * ![rev:64000] Making sure that DataObject->has*Field() methods always return an array, in order not to fail any array_key_exists() checks
 * ![rev:63999] Fixing DataObject->hasField() to detect dynamic getters by using hasMethod("get$fieldName")
 * ![rev:63998] Fixed Form->loadDataFrom() to properly populate FormField->setValue() when an object is passed as the first parameter (needed e.g. for CheckboxSetField->setValue()) - see mailinglist discussion at http://groups.google.com/group/silverstripe-dev/browse_thread/thread/717bada8ccafdd70
 * ![rev:63983] Fixes so ?flush=1 doesn't stop showing the Reports tab in CMS
 * ![rev:63981] Allow use of ClassInfo methods in _config.php when manifest is being rebuilt
 * ![rev:63945] Added missing slash in TableListField_Item->Link()
 * ![rev:63939] Improved RedirectorPage's handling of invalid configuration options to prevent infinite loops and segfaults
 * ![rev:63927] Improved detection of CLI colour support
 * ![rev:63920] Fix broken breadcrumbs

##  Bugfixes

 * ![rev:63915] #2588 Fix issue with IIS not stripping GET variables from the URL (mackeyn)
 * ![rev:63909] Prevent misconfigured redirector pages from breaking static publishing
 * ![rev:63890] Validation result was ignoring the $valid flag passed as the first argument.
 * ![rev:63858] Fixed js i18n entity names for TableField (see #2916)
 * ![rev:63857] Properly merging different dictionaries for javascript i18n implementation (see #2916)
 * ![rev:63839] Added missing default english text to i18n call in TableField and TableListField javascript
 * ![rev:63828] MemberTableField_Popup had an odd way of overloading saveComplexTableField() - this should be on MemberTableField instead, since that's the direct subclass of ComplexTableField for where saveComplexTableField() is defined. This broke the "Add Member" button in CMS Security, probably due to the way the form URLs have been changed. See ticket #2907 for the reported problem.
 * ![rev:63825] Don't let Director::test() clobber current stage
 * ![rev:63824] Fix FieldSet::replaceField() so that it doesn't clobber tabs
 * ![rev:63823] SiteTree::onAfterPublish() will still pass an object to the handlers on the first publish
 * ![rev:63819] Fixed pagination in TableListField after hsmith's changes
 * ![rev:63813] Fixed array_key_exists check in DataObject->setField that was failing when DataObject->record was not yet initialised by DataObject->setField.
 * ![rev:63809] PHP Notice in InlineFormAction_Readonly
 * ![rev:63804] Side reports weren't working on initial opening of the side tab
 * ![rev:63799] Fixed blatant error where $SNG_member wasn't defined
 * ![rev:63797] Member->getCMSFields() should use scaffoldCMSFields() instead of scaffoldFormFields() - currently it is operating in the wrong context.
 * ![rev:63793] MemberTableField->AddLink() was calling &methodName=add - this should be just "add", as per changes to the forum URLs in sapphire
 * ![rev:63786] Removed query that was causing issues displaying members in the security groups. Open ticket #2591
 * ![rev:63785] URLs to security groups in CMS were not linked correctly. Removed Director::link() references and replaced with strings. Director::link() is deprecated and shouldn't be used.
 * ![rev:63769] Fixed paths to CSV fixtures for case-sensitive file systems.
 * ![rev:63768] Fixed $fixture_file for Ext2fs and other case-sensitive file systems.
 * ![rev:63748] Use of getOwnerID() in ReportAdmin which doesn't make sense, since ID() is sufficient.
 * ![rev:63739] Fixed bug in getCMSFields scaffolding of relations
 * ![rev:63716] Fixed createTag for proper generation of DropdownField blank items
 * ![rev:63698] Only include i18n.js if javascript files are included - and to be safe, include the required prototype.js along with the library
 * ![rev:63691] Removed old reference to ?executeForm=EditForm
 * ![rev:63681] Requiring a parentController for RecordController
 * ![rev:63649] Fixed unclear SQL escaping responsibilities in SearchFilter subclasses - it now expects unescaped data, and escapes automatically when adding to the query)
 * ![rev:63647] Making "add %s" translatable for ComplexTableField
 * ![rev:63640] Automatically including sapphire/javascript/i18n.js in Requirements::process_i18n_javascript() to avoid errors when Requirements are manually overwritten
 * ![rev:63635] #2901 - RootURLController didn't properly manipulate the Controller stack
 * ![rev:63634] Reverted earlier change to ModelAdmin.js statusMessage() display
 * ![rev:63629] Translated Member formfields through fieldLabels()
 * ![rev:63627] php notice in CountryDropdownField
 * ![rev:63622] Disabled user_error in ComplexTableField->sourceID() when no formfield 'ID' is found in ComplexTableField->$detailFormFields - not strictly required as we can deduce it from the URL. It was causing conflicts with DataObject->scaffoldFormFields() not returning an 'ID' field
 * ![rev:63621] Making sure that Dataobject->getManyManyJoin() inserts a valid database table for the relation - not all component classes returned by ComponentSet->ownerClass are valid tables (see r54797 and r60909 for previous commits on this issue)
 * ![rev:63618] Escaping added database columns in queries for TableListField
 * ![rev:63611] typo mentioned in #2775
 * ![rev:63602] Fixed bounce-address generation so that it doesn't have a human component to the email address
 * ![rev:63593] #1816: Added a little padding to page version table
 * ![rev:63581] Fixed ComplexTableField export
 * ![rev:63571] typo in js file
 * ![rev:63570] typo in js file
 * ![rev:63549] Updated TreeSelectorField to work properly within CTF popups
 * ![rev:63527] Removed notice-level errors in ListboxField
 * ![rev:63525] #2883 - Remove use of short tag
 * ![rev:63509] Fixed DataObject::dbObject() operation with CompositeDbFields
 * ![rev:63467] Fixed Upload->isValidExtension() - was checking array keys instead of array values ....
 * ![rev:63464] Fixed hardcoded HTTP protocol information in BasicAuth
 * ![rev:63457] AssetAdmin->Link() returned a trailing slash that was not necessary. See ticket #2884
 * ![rev:63452] Fixed ReportAdmin breakages - changes to HTTPRequest required that show($params) be changes to show($request) and then check $request->allParams() for the URL parameters - this caused major breakages as this code was not updated to reflect the new URL handling changes.
 * ![rev:63432] #2753: Couldn't have fields named the same as methods
 * ![rev:63304] #2529: Fixed HTTP/1.0 support
 * ![rev:63297] Fixed loading indicator in for add form in ModelAdmin.js
 * ![rev:63296] wrong jsparty PATH references
 * ![rev:63295] wrong jsparty PATH references
 * ![rev:63294] Fixed ModelAdmin Requirements path references
 * ![rev:63291] Don't try to use HTTP_HOST environment variable if its not set in Director::protocolAndHost(). Throw a warning, then return false - before if script execution was not set to stop on WARNING, you'll get a NOTICE as well.
 * ![rev:63290] Moved *_PATH and PR_*constants from main.php/cli-script.php back to Core.php - was causing problems with installer (directly includes Core.php, but doesn't run through main.php) - see ticket #2867 for improvement suggestions in bootstrapping code to avoid these bugs
 * ![rev:63204] Moved TEMP_FOLDER define back from main.php/cli-script.php to Core.php, as it was causing problems with the installer
 * ![rev:63157] Reverted Director class using BASE_PATH instead of dirname(dirname(['SCRIPT_FILENAME'])), originally committed in r63154
 * ![rev:63079] decrease width of elements in image/flash/link panel on right-hand side to avoid close-button being shoved off to the void (#1669)
 * ![rev:62910] #2390: Not indexed pages are removed from sitemap.xml
 * ![rev:62909] Fixed bug introduced into AssetTableField by previous CTF change
 * ![rev:62892] #2721 - Show decent preview on FileIFrameField
 * ![rev:62885] Fixed a number of really basic problems with a number of date fields - got basic loading and saving working across them all
 * ![rev:62875] More robust setting of defaults; necessary due to altered ViewableData::__isset()
 * ![rev:62868] #2697 - Removed junk slash from login message
 * ![rev:62701] Changed URL format for password sent confirmation display, to avoid issues with new request handling trying to detect the email-TLD as a pseudo-file-extension (which resulted in truncated email-addresses in display). Old: /Security/passwordsent/myemailaddress. New: Security/passwordsent/?email=myemailaddress
 * ![rev:62490] createTag() on FormField subclasses should use getTabIndex() instead of getTabIndexHTML() as createTag() is responsible for generating the HTML, and all we need is the tabindex value
 * ![rev:62471] Allowing HTTPRequest::match() to match rules with extensions (e.g. /sitemap.xml used for GoogleSitemap)
 * ![rev:62463] Pushing current controller into stack in RootURLController->handleRequest to Session-usage in Translatable if enabled. Session::get() is dependent on controllers, and is needed to determine the current language for any Translatable queries (like RootURLController::get_homepage_urlsegment())
 * ![rev:62381] Type checking problem in LookupField->Field(), merged in from r62387
 * ![rev:62325] Removed DataReport.js calls in LeftAndMain until we figure out a better way of doing
 * ![rev:62324] Removed DataReport.js calls in LeftAndMain until we figure out a better way of doing
 * ![rev:62320] Allow creation of a tab and a field of the same name; bug cause by the duplicate field merging code introduced recently.
 * ![rev:61975] not all decorators has a summary_fields defined, so the code need to deal with this.
 * ![rev:61699] Fixed bulk loader constructor
 * ![rev:61686] Fixed styling, searching, and pagination of CommentTableField
 * ![rev:61505] Fix direct access of (class)/(id)/edit on the ModelAdmiN
 * ![rev:61395] SetHeight() was calling SetWidth using getFormattedImage()
 * ![rev:61292] fixed ManyMany relation for same object
 * ![rev:61202] Reverted change r61158 which stopped scrollbars working
 * ![rev:61195] Asset area in CMS refused to load because of error in code from r60920 - #2751
 * ![rev:61162] sourceFilter should be a string, not an array
 * ![rev:61155] HtmlEditorField_Toolbar->LinkForm() for editing a link inside an HtmlEditorField instance was showing page titles using the "Title"
 * ![rev:61151] ComplexTableField_popup.css "overflow: auto" should only be applied to the container HTML element instead of HTML and BODY which can
 * ![rev:60920] #1458 - GEOIP now does not return any error if it cannot look up the ip address (as it uses a shell command this is not enabled on many WAMP systems)
 * ![rev:60897] fixed Member name not being saved in database with ReadonlyField()
 * ![rev:60757] Fixed TableListField->Link() to allow for instanciation without a form/controller (e.g. for unit tests)
 * ![rev:60756] Fixed ScaffoldINGComplexTableField file name
 * ![rev:60726] Fixed DataObject::fieldLabels() to detect labels on inherited database fields
 * ![rev:60723] Fixed partial merge from nzct (originally from r47039, partially merged in r60440)
 * ![rev:60712] Fixed ModelAdmin typo in $searchCriteria method parameter
 * ![rev:60710] Fixed $this reference in static Member call
 * ![rev:60643] Reinstated error_handling(E_ALL) for dev environments in main.php after clarifying with sam - we want to force developers to recard notice-level errors unless they expicitly opt-out in their _config.php
 * ![rev:60636] Disabled mandatory override of default PHP error handler to E_ALL when in dev mode (which means you have no way of overriding error_reporting() in your _config.php, and by that no way of disabling e.g. E_NOTICE level errors)
 * ![rev:60635] Fixed CMSMainTest to use /admin/crm as a standard URL rather than /admin (which could be overloaded by other admins for application-like interfaces without CMS components)
 * ![rev:60573] Fixed bug with unpaginated TableListFields.  Added tests for TableListField pagination
 * ![rev:60415] Added Requirements::path_for_file() to support external URLs in required paths (incl. unit test)
 * ![rev:60413] Fixed RequirementsTest combine_files() testing to accept new javascript inclusion format with added modified flags
 * ![rev:60412] Fixed JSON.php include path in Convert.php
 * ![rev:60410] Fixed test runner's handling of errors
 * ![rev:60404] Further fixes to Director::test()
 * ![rev:60397] Changes to DataObject::get_one() caching to try and fix segfaults
 * ![rev:60393] Fixed superglobal masquerading in Director::test()
 * ![rev:60388] Fixed Yaml fixtures for SapphireTest
 * ![rev:60382] Re-added additional GroupTest tests (merge error from branches/roa)
 * ![rev:60378] Removed duplicate GroupTest.php files
 * ![rev:60224] Fixed merge error in ModelAsController
 * ![rev:60219] Fixed reverted access checks in Controller->handleAction() due to merge error
 * ![rev:60213] Javascript error in ComplexTableField_popup.js - missing a comma in an object literal which broke ajax updates in the CMS
 * ![rev:60092] Using $extraClass in AutocompleteTextField
 * ![rev:59340] Fixed TableListField->setClick_PopupLoad() to parse ID-value out of new `<td>` identifiers
 * ![rev:59285] Changed span.middleColumn to .middleColumn in cms_right.css in preparation for building proper HTML/XHTML nesting in formfields
 * ![rev:59284] Changed span.middleColumn to .middleColumn in cms_right.css in preparation for building proper HTML/XHTML nesting in formfields
 * ![rev:59283] Fixed i18n namespacing issue in TableListField_Item.ss - was using _t('Form.DELETE'), but templates don't allow to re-use variables outside their own namespace
 * ![rev:59282] Removed duplicate SecurityID fields on each row of a TableField (calls $myForm->Fields() which by default will include more than the actual form fields passed to the constructor)
 * ![rev:59281] Fixed colspan on `<td class="actions">` in MemberTableField.ss


##  Enhancement

 * ![rev:71650] Applying the asynch request patch to our tag field. We use a simple queue management idea to keep only the latest ajax request is valid, ie, we abort all requests before the current request is submitted, so that there is only at most one request spanning in the client side, so no early request's response cover late request's response, also greatly enhance the performance of both sides, especially in case of complicated operations in server side and complicated post-events in client side.
 * ![rev:71597] delete button keep spinning when cancel a deletion operation from the confirm window.
 * ![rev:70956] Ticket 2756: Newsletter performance problem, run out of memory.
 * ![rev:70861] Allow selection of the unique identifier field on Member by setting Member::set_unique_identifier_field(AnotherField). Default is "Email".
 * ![rev:70846] When MemberLoginForm controller page has loaded, focus on the Email input field so the user doesn't have to focus the field themselves. Ticket #3418
 * ![rev:70809] Removed blacklist newsletter specific code out of core and into newsletter module
 * ![rev:70783] Export to CSV data of MemberTableField gets all fields on the member from the db array, instead of just FirstName, Surname and Email
 * ![rev:70775] Removed BrowserDetect javascript library which was randomly placed in Security_login.js and just included in AssetAdmin. Reverted to regex-matching for simple browser detection for now
 * ![rev:70465] Allow Member::getCMSFields() to be extended via DataObjectDecorator->updateCMSFields()
 * ![rev:70190] Added nicer (and more useful) error message if ErrorPage cannot open the error HTML file for writing
 * ![rev:70131] Creation of a new page type now uses a consistent source of classes that respect $hide_ancestor on SiteTree.
 * ![rev:70064] Default to "Page" for new page type dropdown
 * ![rev:70060] Added a table for showing linked pages in the Report -> BackLinks tab
 * ![rev:69954] Calling augmentSQL() on decorators in DataObject::get(), which is necessary (among others) to limit ContentController->getMenu() with Translatable enabled to the currently active language. Was previously just implemented in DataObject::get_one()
 * ![rev:69953] Passing through same arguments in SiteTree::get_by_url() than in the wrapped DataObject::get_one()
 * ![rev:69952] Removing specialized routing for Translatable from Director->currentPage() and ModelAsController->getNestedController. Calls SiteTree::get_by_url() now, which abstracts out the Translatable handling.
 * ![rev:69924] #3313 gigtech: Added ComplexTableField::setAddTitle()
 * ![rev:69909] Allowing for passing of $context in Hierarchy->markChildren()
 * ![rev:69896] Allowing more arguments in Object->extend() (merged from branches/translatable in r64523, thanks wakeless!)
 * ![rev:69895] Added SQLQuery->filtersOnFK() (merged from branches/translatable in r64523, thanks wakeless!)
 * ![rev:69891] Moved i18n::get_existing_content_languages() to correct namespace in Translatable::get_existing_content_languages().
 * ![rev:69888] Added DataObjectSet->replace()
 * ![rev:69864] Allow selection of parent page with adding page through URL - Ticket #3177. Thanks simon_w!
 * ![rev:69833] Separated the class name for captioned images to normal images, so styling can be separately applied
 * ![rev:69824] Caption support for the HtmlEditorField in the SS CMS. Ticket #2937
 * ![rev:69823] Caption support for the TinyMCE editor in the SS CMS. Ticket #2937
 * ![rev:69821] #3180: Added RsyncMultiHostPubilsher to 2.3 from trunk
 * ![rev:69734] Allow specifying application URL for the top right logo instead of hardcoded silverstripe.com. Thanks hamish!
 * ![rev:69661] Removed /cms URL alias for CMS interface to allow for pages named "cms" (see #3267)
 * ![rev:69660] Removed /silverstripe URL alias for CMS interface to allow for pages named "silverstripe" (see #3267)
 * ![rev:69449] Added .message styles to cms/css/layout.css
 * ![rev:69370] Add a `<span class="highlight">` around all keywords (space delimited) and not just the entire search phrase
 * ![rev:69360] Update ForeignKey and Primary key default fields to use SQLMap for their dropdown source for better performance.
 * ![rev:69323] Added styling for "form .message.notice" in sapphire/css/Form.css
 * ![rev:69322] More readable (and linked) output of "you are comparing..." message when viewing version of a page
 * ![rev:69244] Added renameField() to FieldSet
 * ![rev:69224] Allow choosing ellipsis for truncated text on Text->LimitWordCountXML()
 * ![rev:69218] Added ability to define the ellipsis for LimitWordCount() setting "..." as the default
 * ![rev:69207] Changed order of array merging in DataObject->db() - contains fields from subclasses at end of the array instead of the beginning. Important because db() is used by FormScaffolder, which shoved custom fields on the front of auto-generated forms. Shouldn't have any effect on the actual content of returned array
 * ![rev:69204] Hiding Member->BlacklistedEmail field in getCMSFields() by default - only relevant in newsletter/bounce context at the moment
 * ![rev:68860] Added RestfulServerTest->testGETRelationshipsXML()
 * ![rev:68818] Appending classnames to translated pagetype titles in CMSMain->getPageTypes() when the cms is loaded in a non-english version - see inline comment
 * ![rev:68817] Appending classnames to translated pagetype titles in SiteTree->getClassDropdown() when the cms is loaded in a non-english version - see inline comment
 * ![rev:68771] Improved display of class permissions in /admin/security by using the menu title in addition to the classname (users won't necessarily know which classname an admin area corresponds to). Also using "Access to all CMS interfaces" as a permission description for CMS_ACCESS_LeftAndMain
 * ![rev:68761] Making Date->Ago() translatable
 * ![rev:68747] Using i18nEntityProvider on SiteTree to ensure entities in "Page" namespace get stored on sapphire instead of the "module folder" for Page.php - we can't make those properties translatable within core if they are in a custom folder
 * ![rev:68745] Allowing textcollection of multiple modules selectively
 * ![rev:68701] Allow HtmlEditorField on front-end forms
 * ![rev:68508] Checking for $_FILE_TO_URL_MAPPING in DevelopmentAdmin if called in CLI mode to avoid nasty bugs e.g. during FunctionalTest sessions (Example: Controller stack was failing for some weird reason in LeftAndMainTest)
 * ![rev:68460] Added CMSMenu::get_viewable_menu_items() and using it in LeftAndMain->MainMenu()
 * ![rev:68193] Added Email->setTemplate() and Email->getTemplate() (as the Email_Template class is deprecated)
 * ![rev:68160] Added support for specifying target module in i18nEntitityProvider->provideEntities()
 * ![rev:68156] Added support for specifying target module in i18nEntitityProvider->provideEntities()
 * ![rev:67984] Documented and improved DataObjectSet->PaginationSummary(). Removed DataObjectSet->paginationSummaryDots
 * ![rev:67675] Fixed Email::obfuscate() to include custom CSS for reversing the email address using the "direction" method
 * ![rev:67638] Added "reverse" method to Email::obfuscate() to reverse the email address in PHP, then CSS can be used to reverse it back to normal to avoid email harvesting
 * ![rev:67502] Added SSViewer::get_source_file_comments()
 * ![rev:67422] Allow setting of the legend value in the Form template by use of Form->setLegend('my legend')
 * ![rev:67398] Added ability to include a blockquote in the CMS WYSIWYG editor
 * ![rev:67345] Allowing custom methods in DataObjectSet->column()
 * ![rev:67321] Only showing import form in ModelAdmin if an importer is set
 * ![rev:67294] Added SITETREE_GRANT_ACCESS permission code to SiteTree to control editability of the "Access" tab (incl. unit tests)
 * ![rev:67292] Supporting object parameter in FieldSet->makeFieldReadonly()
 * ![rev:67291] Added mock controller instances to each FunctionalTest, which passes the existing mock session object into the controller stack. This means Sesssion::get()/set() in application code will use the test session. Helpful mainly for overriding login information used by Member::currentUser().
 * ![rev:67242] Make it easier to create pageless subclasses of Page_Controller
 * ![rev:67224] Adding "close popup" link after saving /admin/myprofile (see #3195)
 * ![rev:67139] Added TreeDropdownField->refresh() js method
 * ![rev:67138] Allowing usage of extraClass() in TreeDropdownField
 * ![rev:67083] Using TEMP_FOLDER for StaticExporter
 * ![rev:67072] Disallowing CMSMain->revert() if SiteTree->canPublish() is not granted (used to be SiteTree->canEdit()). If a user isn't allowed to publish, he shouldn't be allowed to revert the live state of a page either.
 * ![rev:67061] Moving "save" and "delete" cms actions from CMSMain->EditForm() into SiteTree->getCMSActions() to make them decoratable (e.g. disallow delete action) and easier to cover with unit tests. Leaving fallback "save" and "delete" actions in CMSMain in case no actions are defined (necessary e.g. for Group class in SecurityAdmin)
 * ![rev:66958] Added SearchForm->setPageLength() and SearchForm->getPageLength()
 * ![rev:66946] Add `<%-- --%>` comments
 * ![rev:66830] Disabled sending of warnings through Debug::send_errors_to() by default. If you need extended error reporting including warnings (e.g. for a site which is still in active development), use Debug::send_errors_to('example@example.com', true) or Debug::send_warnings_to('example@example.com')
 * ![rev:66803] Just redirect back after "import" action called, and set the session message on the Form object instead of hardcoded ID
 * ![rev:66654] Renamed tab "Meta-data" to "Metadata" for better readability (see #3142)
 * ![rev:66646] Fixed default level in HeaderField - was duplicating defaults already present in two other places (see r66639)
 * ![rev:66625] Allow CheckboxSetField to use extra classes as other FormField classes do. Also dded test for this behaviour in CheckboxSetFieldTest.
 * ![rev:66622] Sort test class list by alphabetical order so it's easier to read
 * ![rev:66596] Defaulting to show all columns in ModelAdmin CSV export, ignoring user selection of result table columns (users can always limit CSV columns by manually deleting them e.g. in Excel)
 * ![rev:66583] Added experimental support using (relname)Query methods to pass complex relations (those defined by methods) into searchfilter
 * ![rev:66343] Added comments in rendered templates to indicate the source .ss files, on dev sites only:
 * ![rev:66333] Added ConfirmedPasswordField->setShowOnClickTitle()
 * ![rev:66323] If there are no files in a folder in AssetAdmin, show a message
 * ![rev:66322] Added SearchFormTest
 * ![rev:66320] Added more known file extensions (tiff, js, html, css, ico) to File->getFileType()
 * ![rev:66312] Added support for $relationCallbacks on the importer class (in addition to methods on the model class)
 * ![rev:66173] Moving GoogleSitemap functionality (priority dropdown and database fields) from SiteTree to GoogleSitemapDecorator
 * ![rev:66168] Removed GoogleSitemap references in SiteTree (moving to decorator implementation)
 * ![rev:66137] Added TranslatableTest with minimal assertions about existing form fields in translation mode
 * ![rev:66045] Added support for custom importer methods in CsvBulkLoader
 * ![rev:65827] Added error messages to flash uploader panel, to be consistent with the image uploader one
 * ![rev:65582] Using actual classname in DataObjectSet->debug()
 * ![rev:65581] Added unit tests for FieldSet->insertBefore()/insertAfter()
 * ![rev:65513] Using currently used content languages for options in the TinyMCE spellchecker (see http://open.silverstripe.com/ticket/2498#comment:2)
 * ![rev:65508] Added language tables for tinymce_ssbuttons Plugin, incl. German translation
 * ![rev:65495] Calling UpgradeSiteTreePermissionSchemaTask from SiteTree->requireDefaultRecords as a temporary workaround for missing migration infrastructure. This means that upgrading the schema for 2.3 can be done without manual task triggers, just the usual dev/build (see http://open.silverstripe.com/ticket/2847#comment:4)
 * ![rev:65494] Added DatabaseTest
 * ![rev:65464] Better CLI output for browsing dev/tests
 * ![rev:65463] Allowing strings instead of arrays in ModelAdmin::$managed_models to make it less error-prone for beginners
 * ![rev:65457] Allowing to pass strings instead of arrays into FunctionalTest->assert*() methods, and convert them internally to arrays
 * ![rev:65455] Adjusted AssetAdmin to Folder->can*() changes
 * ![rev:65454] Added LeftAndMainDecorator
 * ![rev:65453] Added stub methods to DataObjectDecorator for documentation purposes
 * ![rev:65452] Allowing decoration of can*() methods in File and Folder
 * ![rev:65361] Added unit tests for i18n template parsing
 * ![rev:65266] Folder name can now be used for uploading files. Ticket #3026 - Thanks simon_w!
 * ![rev:65181] Updated LeftAndMain->getMenuTitle() to use classname as fallback if $menu_title is not defined - one less thing to specify in a minimalist ModelAdmin subclass
 * ![rev:65173] Refactored CSS applied to filter boxes by using common selector
 * ![rev:65153] Added UpgradeSiteTreePermissionSchemaTask as a manual migration of SiteTree schema upgrades in 2.3 (see #2847)
 * ![rev:65150] Added unit tests for SiteTree permissions
 * ![rev:65147] Only logging out users on Security::permissionFailure() is called in non-ajax context. For ajax requests, we now return a 403 HTTP Status in a HTTPResponse Object, with a ":NOTLOGGEDIN" body for backwards compatibility. If a logout+redirection is required after an ajax-request, this should be handled by the clientside.
 * ![rev:65125] Added a "strict-mode" for Member->inGroup() and Member->inGroups() to determine true membership to a group (without inheritance)
 * ![rev:65092] Scaffolding TextField instead of TextareaField in Text DBField due to size
 * ![rev:65073] Added fieldLabels() overloading to various DataObject subclasses. Use this method instead of directly calling _t() in getCMSFields(), and use fieldLabel('MyField') to get the label for a specific FormField. This way, we can transparently support formfield scaffolding and re-use the labels for search fields automatically.
 * ![rev:65072] Added fieldLabels() overloading to various DataObject subclasses. Use this method instead of directly calling _t() in getCMSFields(), and use fieldLabel('MyField') to get the label for a specific FormField. This way, we can transparently support formfield scaffolding and re-use the labels for search fields automatically.
 * ![rev:65056] Removed DataObjectDecorator->updateSummaryFieldsExcludeExtra() - was a straight copy of updateSummaryFields()...
 * ![rev:65055] More solid fulltext checks against master language tables in i18nTextCollectorTest
 * ![rev:65054] Using eval() in textcollector to test for valid PHP syntax
 * ![rev:65051] Added unit tests for i18nTextCollector handling of newlines in entity values
 * ![rev:65029] Using namespaces for filenames in RequirementsTest
 * ![rev:65027] Using safer get_by_id() call in SecurityAdmin->getMemberForm()
 * ![rev:65022] Added i18nEntityProvider interface (see comments in #1625) incl. unit tests
 * ![rev:65020] Allowing translation of some static properties on DataObject and subclasses through DataObject->fieldLabels(). Part of the provideI18nEntities() work which was started in r64881 (see #1625)
 * ![rev:64881] Ignoring entity-names with $ signs (most likely dynamic properties) in i18nTextCollector->collectFromCode()
 * ![rev:64878] Added unit tests for i18n.js
 * ![rev:64682] Changed FormField->Field() to make use of FormField->createTag() over complicated dynamic string building
 * ![rev:64596] Allow use of RestfulService->setQueryString() and test to support it. Patch from ticket #2973. Thanks to simon_w!
 * ![rev:64558] Used _t() entity instead of hardcoded "not set" string in TextareaField->Field()
 * ![rev:64556] Clearer indication of setting disabled attribute in DropdownField->Field() since the disabled attribute shouldn't be set if the field isn't to be disabled
 * ![rev:64553] Clearer indication of setting disabled attribute in CheckboxField->Field() since the disabled attribute shouldn't be set if the field isn't to be disabled
 * ![rev:64552] If TextField->disabled has been set to true, then add the "disabled" attribute to the input type text attribute list
 * ![rev:64551] Made use of FormField->createTag() functionality for creating a textarea field in TextareaField->Field()
 * ![rev:64494] Using ksort() in textcollector to get alphabetized language master files (=easier to compare and debug)
 * ![rev:64493] Made _t() global function in Core.php an alias for the new i18n::_t() method
 * ![rev:64492] Refactored i18nTextCollector and added unit tests
 * ![rev:64489] Added ClassInfo::classes_for_file()
 * ![rev:64447] Moving i18n->textcollector() and related methods to new class i18nTextCollector and i18nTextCollectorTask - enabling running textcollector through CLI, refactored to instance methods for better testability
 * ![rev:64446] Improved TaskRunner and BuildTask metadata and styling
 * ![rev:64421] Using createTag() to create HeaderField and LabelField, which adds support for HTML id attributes and extra css classes through addExtraClass()
 * ![rev:64410] Made use of createTag() on FormAction->Field()
 * ![rev:64408] Added ID to allow CSS styling of forgot password link on MemberLoginForm
 * ![rev:64406] Added a message if no email address was specified, for user feedback purposes on MemberLoginForm->forgotPassword()
 * ![rev:64405] Changed the "I've lost my password" action to a link instead, since the button is too prominent, and usability is poor  having this as a form submit button.
 * ![rev:64397] Versioned::get_one_by_stage() and Versioned::get_by_stage() were missing parameters from their get_one() and get() counterparts in DataObject. Those parameters have been added. See ticket #2965 for the origin of this patch.
 * ![rev:64366] Pulled out Newsletter specific stuff from Member, the changes in the newsletter module were done on r64365
 * ![rev:64356] Added additional known file types, for audio and video files
 * ![rev:64311] Added unit tests for Silverstripe's custom static handling (with lots of commented out failing tests)
 * ![rev:64306] is_array() checks in DataFormatter to respect empty arrays as a form of denying permissions on fields
 * ![rev:64305] Added BankAccountField::is_valid_array_structure() to avoid PHP Notices when converting empty array values
 * ![rev:64304] Added DropdownFieldTest
 * ![rev:64252] Making confirmation message in ConfirmedFormAction translatable
 * ![rev:64238] Showing image thumb before input field in a separate block `<div class="thumbnail">` in SimpleImageField
 * ![rev:64236] Added unit tests for form session messages and session validation, FormTest->testSessionValidationMessage() and FormTest->testSessionSuccessMessage()
 * ![rev:64229] Storing a "fake referer" in TestSession->lastURL to allow for redirectBack() calls, e.g. after failed form validation
 * ![rev:64224] Disrecard $includeRelations setting when scaffolding $has_one relationships in FormScaffolder - use $restrictFields to limit instead
 * ![rev:64223] Making URL accessible through HTTPRequest->getURL()
 * ![rev:64157] Added $params parameter to all DBField->scaffoldFormField() subclasses
 * ![rev:64144] Setting default level for ContentController->getMenu($level = 1) to allow for calls without arguments
 * ![rev:64078] Using $locale in _t() instead of repeatedly calling i18n::get_locale()
 * ![rev:64075] Replaced hardcoded "en_US" references in i18n class with $default_locale
 * ![rev:64073] Supporting titles in FieldSet->findOrMakeTab()
 * ![rev:64071] Added german translation for ModelAdmin
 * ![rev:64067] Using i18n fieldlabels for column-headlines in TableListField
 * ![rev:64041] Re-enabled RSSFeedTest - seems to work now due to Director::baseURL() fixes (#2861)
 * ![rev:64012] Improved error message on invalid classname for TestRunner
 * ![rev:64003] Added DataFormatter->setCustomRelations()
 * ![rev:64001] Made FormTest fixtures more expressive
 * ![rev:63999] Re-enabled two test cases in DataObjectSet as a result of the above fixes
 * ![rev:63996] Added unit test CheckboxSetFieldTest?->testLoadDataFromObject()
 * ![rev:63995] Using fixtures in CheckboxSetFieldTest?, restructured from hard-to-debug manymany-join on self to a Article`<->`Tag relation
 * ![rev:63955] Pulled out Report::has_reports() which was hardcoded into LeftAndMain, and put into cms/_config.php which makes more sense
 * ![rev:63763] Reformatted and documented Form->loadDataFrom() - no functionality changed
 * ![rev:63762] Added unit tests for "_unchanged" handling in Form->loadDataFrom()
 * ![rev:63761] Added unit tests for Form->loadDataFrom()
 * ![rev:63748] Added missing "abstract" Report class to compliment ReportAdmin. Currently it is unclear what abstract base class you're supposed to implement from.
 * ![rev:63681] Custom getViewer() methods to use Page main templates if CollectionController is nested in a ContentController
 * ![rev:63680] Added SSViewer->getTemplateFileByType() and SSViewer->setTemplateFile()
 * ![rev:63679] Added HTTPRequest::detect_method()
 * ![rev:63653] Added Controller->getRequest()
 * ![rev:63652] Added Controller->render($params) as a shortcut for Controller->customise($params)->renderWith(array('MyTemplate','MySubTemplate')) - templates are auto-detected by Controller->getViewer() and Controller->getAction()
 * ![rev:63651] Consistently allowing for $restrictFields and $fieldClasses parameters passed to DataObject->scaffoldFormFields(), DataObject->scaffoldSearchFields(), DataObject->scaffoldCMSFields()
 * ![rev:63650] Added RequestHandlingTest->testNestedBase()
 * ![rev:63648] Added support for customize parameters to ViewableData->renderWith() to avoid unnecessary chaining ($this->customize($params)->renderWith($template))
 * ![rev:63633] Better i18n for TableField and ComplexTableField
 * ![rev:63632] Using DataObject->Title for has_one dropdowns generated in DataObject->scaffoldFormFields()
 * ![rev:63630] Added DataObject->fieldLabel() and removed $fieldname parameter from DataObject->fieldLabels($fieldName) to simplify overloading of fieldLabels() for i18n
 * ![rev:63628] Added FieldSet->hasTabSet() incl. unit test
 * ![rev:63626] Removed overloaded MemberTableField->DetailForm() and reduced overloaded constructor logic - same behaviour found in parent classes
 * ![rev:63624] Scaffolding Member->getCMSFields() to allow for easy extension
 * ![rev:63623] Calling DataObjectDecorator->updateCMSFields() in DataObject->getCMSFields() - was previously only called in SiteTree instances
 * ![rev:63620] Only list ID field in DataObject->summaryFields() if no summaryfields are defined (or can be autodetected). Listing all fields was not feasible, as some subclasses have more fields than fits the column layout
 * ![rev:63619] Added ObjectTest->testSingletonCreation()
 * ![rev:63615] Added FieldSetTest->testRemoveTab()
 * ![rev:63614] Updated translations from translate.silverstripe.com
 * ![rev:63613] Updated translations from translate.silverstripe.com
 * ![rev:63572] Removed project-specific requirements from CMSMain
 * ![rev:63569] Started using ss.i18n clientside javascript in LeftAndMain classes (only a fraction made translatable)
 * ![rev:63567] Using ss.i18n in all sapphire form fields with clientside language strings
 * ![rev:63566] Added javascript i18n support through Requirements::process_i18n_javascript() and ss.i18n javascript lib
 * ![rev:63565] Added ViewableData->i18nLocale, used in LeftAndMain.ss to determine interface language through meta tags (see r63564)
 * ![rev:63564] Added ViewableData->i18nLocale, used in LeftAndMain.ss to determine interface language through meta tags
 * ![rev:63554] Checking for instanceof DataObject instead of has_one() in DataObject->update() to support virtual relations as well (fix to r63531)
 * ![rev:63528] #1848 - Select the title field for new pages
 * ![rev:63526] #2875: Make CLI execution more robust when FILE_TO_URL_MAPPING not set
 * ![rev:63493] Added support for dot syntax to DataObject::update()
 * ![rev:63470] Setting SimpleImageField->allowedExtensions to sensible defaults
 * ![rev:63468] Added Form->resetField()
 * ![rev:63465] Showing contact information in Debug::friendlyError() from Email::getAdminEmail()
 * ![rev:63463] Added Director::get_environment_type()
 * ![rev:63452] Better URL handling. Instead of "admin/showreport/something", we do "admin/report/show/something", which is more consistent with the rest of the CMS.
 * ![rev:63388] Director::forceWWW() now does a 301 redirect for SEO (to be consistent with Director::forceSSL())
 * ![rev:63337] Added DataObjectTest test cases for checking various field existence levels
 * ![rev:63327] #2172: Added counts to comment admin submenu items
 * ![rev:63321] Updated cli-script handling to be more in line with web calls, and improved Director::setBaseURL() calls.
 * ![rev:63289] Tidied up DropdownField->Field() by making use of FormField->createTag() as other FormField subclasses such as TextField do
 * ![rev:63249] Moved UserDefinedForm and related code, templates, CSS and javascript out of cms and sapphire classes into userforms/trunk
 * ![rev:63198] Added user_error() if RebuildStaticCacheTask is called without a Page->allPagesToCache() method defined
 * ![rev:63182] Added ManifestBuilder::$cache_expiry_mins
 * ![rev:63181] Using HTTP Status 301 for RedirectorPage class, to be nice to search engines and improve SEO (with 200 page rank gets split between pages, with 301 its all transferred to the target page)
 * ![rev:63175] Introduced constants for system paths like /sapphire in preparation for a more flexible directory reorganisation. Instead of hardcoding your path, please use the following constants: BASE_PATH, BASE_URL, SAPPHIRE_DIR, SAPPHIRE_PATH, CMS_DIR, CMS_PATH, THIRDPARTY_DIR, THIRDPARTY_PATH, ASSETS_DIR, ASSETS_PATH, THEMES_DIR, THEMES_PATH
 * ![rev:63154] Introduced constants for system paths like /sapphire in preparation for a more flexible directory reorganisation. Instead of hardcoding your path, please use the following constants: BASE_PATH, BASE_URL, SAPPHIRE_DIR, SAPPHIRE_PATH, CMS_DIR, CMS_PATH, THIRDPARTY_DIR, THIRDPARTY_PATH, ASSETS_DIR, ASSETS_PATH, THEMES_DIR, THEMES_PATH
 * ![rev:63153] Moved procedural bootstrapping code hiding away between function definitions in Core.php to main.php and cli-script.php (TEMP_FOLDER and PR_* constants)
 * ![rev:63057] Updated argument handling for sake
 * ![rev:63025] Better CLI output of 'sake dev'
 * ![rev:63022] #2853 - Added dev/build as a the new name for db/build; prettied it up
 * ![rev:62995] Prevent CMS session timing out and losing content - Added a ping to Security/ping every 5 mins, and altered the onSessionLost behaviour to open login form in a pop-up instead of closing the CMS (see #2242)
 * ![rev:62994] Prevent CMS session timing out and losing content - Added Security/ping as a destination for session-preserving ajax pings
 * ![rev:62894] #2700 - Added section title to CMS title tag
 * ![rev:62883] ComplexTableFilters used to edit relations have their filter automatically set, as well as the foreign key on new records.
 * ![rev:62867] #2417: Replaced http://www.yoursite.com with the actual base URL
 * ![rev:62848] Allowing to specify dropdown title field in TypeDropdown->setTitleFieldName() - patch by nicolaas (#2689)
 * ![rev:62847] Allowing usage of ID, Code-String or Object as $group parameter in Member::inGroup()
 * ![rev:62844] Allowing usage of $member parameter for Member::check() as ID, Code or Object
 * ![rev:62843] Added Debug::send_warnings_to()
 * ![rev:62841] Using optional $member parameter for DataObject::can*() methods
 * ![rev:62477] Improved ajax error display within the CMS: Using Firebug (or Firebug Lite) for plaintext output instead of cramming everything into the CMS-status field
 * ![rev:62468] In Debug::showError(), if error is displayed through ajax with CliDebugView, use plaintext output
 * ![rev:62467] Removed "ERROR:" prefix hack for ajax error responses - clientside evaluation should inspect HTTP status codes instead
 * ![rev:62397] Adjusted ModelAdmin->import() to new BulkLoader_Result API (see r62403)
 * ![rev:62267] Added DBFieldTest to test prepValueForDB()
 * ![rev:61685] You can now use Controller::join_links() to add querystring arguments to a URL
 * ![rev:61627] Added dev/tests/startsession and dev/tests/endsession to allow the use of fixtures with external test frameworks, such as Windmill
 * ![rev:61618] wakeless - Added SQLQuery::filtersOnID()
 * ![rev:61485] DropdownField now allows for `<optgroup>` elements in the field source by passing in a two dimensional array - this was taken from GroupedDropdownField
 * ![rev:61420] RequiredFields->php() uses quotes around title of field, falling back to the name of the field if title isn't available
 * ![rev:61415] Added LowerCase() to DBField to return the raw2xml converted value as lower case for any type of field if applicable
 * ![rev:61394] Added SetHeight() to the Image class, so we can call it from the templates
 * ![rev:61392] Added SetSize() to the Image class so we can use it in the templates
 * ![rev:61166] Consistent styling of TypeDropdown in the CMS
 * ![rev:61165] Added h3, h4 and h5 CSS styles
 * ![rev:61157] Added FieldSet->removeFieldsFromTab() which does exactly what removeFieldFromTab() does, but with an array of field names
 * ![rev:61154] Director::forceSSL() redirects are now 301 instead of 302 redirects, which is better for SEO
 * ![rev:61153] ErrorPage:: should also list ShowInSearch as 0, since it is not required to be searched
 * ![rev:61149] Added getter method for CompositeField->children
 * ![rev:61147] If title not passed into TextareaField constructor, it defaults to the name value
 * ![rev:60724] Removed recently added DataObject::$result_permissions and replaced with more specific TableListField::permissions_for_object()
 * ![rev:60645] Added Maori to i18n::$common_languages
 * ![rev:60637] Showing error level in custom error handlers on DebugView and CliDebugView
 * ![rev:60635] Added default /admin/cms route to cms/_config.php to clear default namespace for other controllers
 * ![rev:60395] Using Requirements instead of hardcoded template logic to include some LeftAndMain js/css
 * ![rev:59286] Added `<div class=""middleColumn">` around TableListField templates and all subclasses


##  Minor changes

 * ![rev:71706] Make FirstName and Surname of Member table be indexed.
 * ![rev:71621] Allow setting page size for MemberTableField
 * ![rev:71569] some label, texture change for AHIP project SC #99
 * ![rev:71345] added user friendly labels - should really be _t compatible I guess
 * ![rev:71292] Fixed tab-spacing in cms/upload js files
 * ![rev:71194] Fixed CSVParserTest with encoding issues
 * ![rev:70960] Added basic tests for Date and DateField
 * ![rev:70953] Code formatting fix in DateField
 * ![rev:70895] Updated tests to check boolean values in CsvBulkLoaderTest
 * ![rev:70843] Added phpDoc comments for documentation that needs to be written explaining the different source data that can be used with CheckboxSetField
 * ![rev:70833] Ensure that $result is defined before calling array functions on it in SiteTree::getClassDropdown()
 * ![rev:70807] Code formatting cleanup in Member
 * ![rev:70799] Code formatting fix in SecurityAdmin_left.ss
 * ![rev:70783] Code formatting fix
 * ![rev:70769] Defensive handling of events in TreeSelectorField->hideTree
 * ![rev:70761] Added important piece of information for where the callback method should be defined for duplicate checks in BulkLoader
 * ![rev:70693] fixing flash insertion and removing console log messages
 * ![rev:70678] Use FormResponse instead of echoing strings as JS
 * ![rev:70677] Removed hard-to-debug error trap in SecurityAdmin_right.js
 * ![rev:70666] merged r70665 from trunk
 * ![rev:70664] removed dulicate css code
 * ![rev:70663] merged r70323 from trunk
 * ![rev:70662] tinymce toolbar improvements. Fixed gradient image and border issue
 * ![rev:70657] #3416 MCE Editor Minor Beautification (thanks ajshort!)
 * ![rev:70647] Changed $title parameter to HtmlEditorField constructor to null to be consistent with TextareaField and so title is derived based on the name of the field if no title is given.
 * ![rev:70635] Patch from ajshort. changed site tree shortcut icon to transparent.
 * ![rev:70608] Code formatting fix in FormField
 * ![rev:70598] ticket 1846. Changed Action to title case
 * ![rev:70596] ticket 1846. changed logout text to title case
 * ![rev:70591] merged patch from simon_w. Fixed language in model admin
 * ![rev:70587] fix for ticket 3384. Instead of messing round with added requirements back if you cannot merge them just return
 * ![rev:70571] in-line documentation correction
 * ![rev:70548] Added default english text for "Email" in Secrity->LostPasswordForm()
 * ![rev:70540] Added default english text for "Email" and "Password" fields in MemberLoginForm
 * ![rev:70530] merged patch from keeny. Put comment data into Cookie and load if user fails maths spam question. Clear comment cookie on successful posting
 * ![rev:70498] Fixed incorrect parameters breaking PasswordField HTML validity because maxlength and size were being populated by non-numeric characters
 * ![rev:70494] merged patch from simon_w. Removed unnesscary comments
 * ![rev:70493] merged patch from simon_w. Changed can*() methods to check they are sent valid member objects rather then arrays
 * ![rev:70484] merged patch from rjmackay. Fixed inclusion of BBCode filters and reported error supression
 * ![rev:70483] merged patch from simon_w: added check to Children() to make sure user has canView() rights
 * ![rev:70411] added empty statics for decoration
 * ![rev:70409] added empty statics to allow decoration
 * ![rev:70408] added empty statics to PageComment to allow for decoration
 * ![rev:70400] SilverStripeNavigator toolbar is now i18n friendy
 * ![rev:70360] removed Gallery Module code from AssetTableField
 * ![rev:70355] CSS hover background fix. Merged from ticket #3264. Thanks gigtech
 * ![rev:70269] Update ResetFormAction to make use of createTag() method instead of patching together strings to make the form input
 * ![rev:70257] Fixed undefined variable error in TableListField->generateExportFileData()
 * ![rev:70255] Whitespace removal at end of DataObjectDecorator class
 * ![rev:70252] Update phpDoc for DataObject->getFrontEndFields()
 * ![rev:70251] Renamed DataObjectDecorator->updateFormFields() to updateFrontEndFields() to be more accurate to the extended method
 * ![rev:70238] Removed "Groups" field that wasn't used in Member::getCMSFields()
 * ![rev:70236] Code tidy up and coding style fixes for MemberTableField
 * ![rev:70188] If the error-404.html or error-500.html file can't be opened, supress the warning so an error isn't shown in the CMS
 * ![rev:70154] phpDoc for Varchar->getName()
 * ![rev:70153] Removed redundant code from Varchar
 * ![rev:70133] Fix potential undefined variable errors in Query->column() and Query->keyedColumn() by always returning an array, even if it's empty. This now conforms to the phpDoc for these two functions, instead of returning null if there's no $column variable set
 * ![rev:70132] Defined $column as an array so "undefined variable" error is supressed
 * ![rev:70070] tidied up padding in headings complextablefields with long titles
 * ![rev:70065] Removed redundant code in CMSMain->AddPageOptionsForm()
 * ![rev:70061] Removed redundant code
 * ![rev:70059] Code formatting fixes in HtmlEditorField
 * ![rev:70053] Added test for HTTP::getLinksIn() which subsequently tests HTTP::findByTagAndAttribute()
 * ![rev:70048] fix on-line documentation syntax so that phpDocumentor can creating automatically the API doc
 * ![rev:70032] fix on-line documentation syntax so that phpDocumentor can creating automatically the API doc
 * ![rev:69955] Passing context object through in LeftAndMain->getSiteTreeFor() (necessary for Translatable)
 * ![rev:69939] Removed "edit image" button since the image editor has been removed
 * ![rev:69890] Updated language tables
 * ![rev:69889] Added Extension->getOwner()
 * ![rev:69883] Fixed alignment of "Create translation" button in CMS - removed unnecessary horizontal floating and removed background
 * ![rev:69871] merged r69857 from trunk
 * ![rev:69865] Removed old references to check-php, which has since been removed
 * ![rev:69843] Moved form session error set up from Form constructor to method so it can be used again if need be
 * ![rev:69840] Added SiteTreeActionsTest
 * ![rev:69839] Merged r69410 from trunk
 * ![rev:69838] Merged r69409 and r69410 from trunk
 * ![rev:69749] Fixed Sitetree expand and collapse icons alignment in FF3
 * ![rev:69717] added support for :-) as well as :) in the Similes
 * ![rev:69706] search interface design improvements
 * ![rev:69686] Updated correct HTTPRequest class for @deprecated notice on HTTP::sendFileToBrowser()
 * ![rev:69611] Updated cms master tables
 * ![rev:69592] Added french translation (see #3290)
 * ![rev:69591] Added french translation (see #3290)
 * ![rev:69562] merge patch from ajshort: allow db build without running requireDefaultRecords
 * ![rev:69514] fixed ModelAdmin right tab layout. Removed scrollbar off the tab strip. Ticket #2900
 * ![rev:69419] Code syntax tidy up
 * ![rev:69369] Removed @todo from Text->ContextSummary as it's already done
 * ![rev:69368] Added phpDoc to Text->ContextSummary() $string argument
 * ![rev:69348] Added todo and phpDoc to Text->ContextSummary()
 * ![rev:69249] Disable caching in RestfulService test
 * ![rev:69248] Removed debug message
 * ![rev:69244] Added test for FieldSet->renameField() to test method behaviour
 * ![rev:69226] Added tests for Text->LimitWordCountXML()
 * ![rev:69225] Added phpDoc to Convert::raw2xml() and Convert::raw2js()
 * ![rev:69221] Removed comment that isn't appropriate
 * ![rev:69220] Added TextTest for testing Text class methods
 * ![rev:69219] Updated phpDoc cautionary message on Text->LimitCharacters()
 * ![rev:69218] Added documentation to various Text class methods for limiting field values
 * ![rev:69206] logical bug in FormScaffolder
 * ![rev:69205] translation
 * ![rev:68973] reorganized layout of bbcode list elements to move longer ones to bottom row for BBCode popouts
 * ![rev:68858] renamed $json to $xml in XMLDataFormatter
 * ![rev:68853] added link to all Comments feed in Page Comments
 * ![rev:68771] Updated language tables
 * ![rev:68763] translation
 * ![rev:68760] Making Folder->getCMSFields() translatable
 * ![rev:68759] translation
 * ![rev:68758] Making CTF save button translatable
 * ![rev:68753] translation
 * ![rev:68749] translation
 * ![rev:68748] translation
 * ![rev:68747] translation
 * ![rev:68743] Translation
 * ![rev:68742] Translation
 * ![rev:68741] translation
 * ![rev:68600] Removed debug message
 * ![rev:68534] Hardcoded yoursite.com in assets treeview (see #3230)
 * ![rev:68531] fixed javascript initialization bug in SecurityAdmin_left.js (see #3211)
 * ![rev:68526] Hiding border around `<fieldset>`s in ModelAdmin add form (see #3214)
 * ![rev:68517] fixed php notices on AssetAdmin (see #3187)
 * ![rev:68457] formatting in Security.php
 * ![rev:68195] Styling for input.disabled
 * ![rev:68178] updated translations
 * ![rev:68162] Updated language master table
 * ![rev:68161] Updated language master table
 * ![rev:68147] Updated cms lang master table
 * ![rev:68029] Added whitespace after <!-- end include to be consistent
 * ![rev:67705] formatting
 * ![rev:67689] Documented ClassInfo::subclassesFor() and added unit tests
 * ![rev:67682] Updated phpDoc for Requirements::customCSS() and Requirements_Backend::customCSS()
 * ![rev:67676] Code formatting cleanup
 * ![rev:67675] Code formatting cleanup
 * ![rev:67468] Removed whitespace after ?> end PHP tag
 * ![rev:67467] Removed whitespace after ?> end PHP tag
 * ![rev:67424] Tidy up of Form.ss template in sapphire/templates/Includes
 * ![rev:67380] Documentation in Email class
 * ![rev:67327] Added test for ErrorPage
 * ![rev:67301] Declared Director::direct() and Director::test() as static functions to avoid confusion
 * ![rev:67300] Code formatting improvements for Director->test()
 * ![rev:67295] Re-enabled calls to updateCMSFields() accidentally disabled in r67294
 * ![rev:67293] Removing custom mock controller from SearchFormTest, now handled in FunctionalTest (see r67291)
 * ![rev:67230] ImageEditor indentation
 * ![rev:67213] Merged r66794 from trunk (related to #3192)
 * ![rev:67188] fixed typo in email_template docblock and added note from sean
 * ![rev:67176] Reverted r64384 and re-added Email_Template (see #3183)
 * ![rev:67083] Documentation for StaticExporter
 * ![rev:67075] removed debug code
 * ![rev:66958] Deprecated internal property SearchForm->$numPerPage, use $pageLength instead
 * ![rev:66944] merged from trunk
 * ![rev:66942] merged r66670 from trunk
 * ![rev:66939] Merged r66681 from trunk
 * ![rev:66819] Code formatting conventions in HTTPRequest->param()
 * ![rev:66803] phpDoc comments for ModelAdmin->import()
 * ![rev:66800] Added code example of $model_importers array item
 * ![rev:66751] Reverted replacement of jQuery.js with minified version, we're doing minification on the fly, and there's jQuery-packed.js as a readymade alternative (see r66708)
 * ![rev:66748] Revered jquery/orig folder, not necessary as we have an unminified jQuery.js anyway (see r66717)
 * ![rev:66747] Reverted reference to jquery-packed.js which causes problems by double minification in cms (see r66735)
 * ![rev:66745] Revered accidental deletion of jQuery.js in r66719
 * ![rev:66736] Formatting in Permission::checkMember()
 * ![rev:66735] fixed path include for jquery
 * ![rev:66700] merged r66672 from trunk
 * ![rev:66643] Removed unused action "waitingon" from CMSMain::$allowed_actions
 * ![rev:66642] Removed TaskList remnants of old cms workflow code
 * ![rev:66640] Removed redundant code
 * ![rev:66637] Code formatting of !isset($member) on SiteTree->canAddChildren() for consistency with other can*() methods
 * ![rev:66636] Renamed to correct updateCMSActions() in php comment
 * ![rev:66631] Removed unused private static $dataobject_select in File
 * ![rev:66630] phpDoc comments for File->getAbsoluteSize()
 * ![rev:66628] Code formatting cleanup on CheckboxSetField->Field()
 * ![rev:66624] Added tests for checking extra class was added to DropdownField
 * ![rev:66623] Added tests for checking extra class was added to FormField subclasses (TextField, EmailField and OptionsetField)
 * ![rev:66615] Readd of end php tag as per coding conventions
 * ![rev:66614] Added missing end php tag for ImageEditor, as per coding conventions
 * ![rev:66613] Removed whitespace after end php tag for AssetTableField
 * ![rev:66612] Removed commented out code that shouldn't be lying around
 * ![rev:66542] actually allow youtube / blip videos to be embedded into the cms content area
 * ![rev:66426] added setter function to write_js_on_body() so I can override the settings
 * ![rev:66386] SecurityAdmin code formatting cleanup
 * ![rev:66385] Removed old references to "rightbottom", which is now obsolete and caused a big box to appear in the CMS sometimes
 * ![rev:66373] Tidied up messy template syntax in LeftAndMain.ss
 * ![rev:66333] Documentation for ConfirmedPasswordField
 * ![rev:66322] Documentation for SearchForm
 * ![rev:66318] Coding conventions, inconsistent use of tabs and spaces
 * ![rev:66317] Code conventions (spaces should be between operator characters)
 * ![rev:66311] Removed old references from workflow in SiteTree and VirtualPage (AssignedToID and RequestedByID were old properites of a workflow page type)
 * ![rev:66310] Removed old workflow instances in the cms module. See ticket #3044
 * ![rev:66302] Added isset($_SERVER['HTTP_HOST']) checks to Director->isDev() and Director->isTest() - these environment variables are not available in CLI mode, and show up as PHP notices in a default cli-script/sake execution
 * ![rev:66270] Code formatting in FormField
 * ![rev:66167] Fixed class naming in LeftAndMainDecorator.php
 * ![rev:66093] Removed debug code in AjaxUniqueTextField
 * ![rev:66092] Fixed PHP Notice in SiteTree
 * ![rev:66024] Removed debug code committed in r65554
 * ![rev:65616] Removed unused code from SearchForm, commented out junk etc
 * ![rev:65537] removed debug commits from r65523 in Folder.php
 * ![rev:65516] Updated merge-info
 * ![rev:65485] type enviroment -> environment
 * ![rev:65484] Removed obsolete code from MySQLDatabase
 * ![rev:65458] Removed duplicate dev/simpletest, already present in thirdparty/simpletest
 * ![rev:65457] PHPDoc for FunctionalTest
 * ![rev:65446] Tidied up ThumbnailStripField->getimages() formatting
 * ![rev:65445] Tidied up ThumbnailStripField->getflash() formatting
 * ![rev:65444] Tidied up ThumbnailStripField->getimages() formatting
 * ![rev:65443] Tidied up formatting - spaces to tabs
 * ![rev:65437] Changed die() to user_error() so that correct error level is returned
 * ![rev:65418] Tidied up messy code formatting
 * ![rev:65409] Tidied up AssetAdmin->SiteTreeAsUL()
 * ![rev:65398] images for the new imageeditor which didnt get included in the patch
 * ![rev:65292] JS translations in LeftAndMain
 * ![rev:65233] Removed redundant code
 * ![rev:65205] phpDoc of HtmlEditorField
 * ![rev:65190] Improve robustness of some of the widget definition
 * ![rev:65149] Moved tasks from sapphire/cli to new folder sapphire/tasks
 * ![rev:65146] Fixed PHP Notices in Member.php
 * ![rev:65145] Fixed PHP Notices in TreeMultiSelectField
 * ![rev:65135] Check if OldPassword data exists before running checkPassword()
 * ![rev:65127] Code formatting in ComplexTableField
 * ![rev:65126] Code formatting in CMSMenuItem
 * ![rev:65124] Formatting in Group.php
 * ![rev:65095] Disabled LeftAndMainTest, now covered by CMSMenuTest
 * ![rev:65075] Updated master language tables
 * ![rev:65074] Updated master language tables
 * ![rev:65067] formatting
 * ![rev:65058] Restructured code in Object.php to consistently have properties and important methods like __call() at the top of definitions (no logic changes). Added minor documentation.
 * ![rev:65052] rearranged methods in i18nTextCollector
 * ![rev:65043] Collecting entities for language master table with new i18nTextCollector functionality. The table is now sorted alphabetically by namespace and entity. Entities now include more translatable statics from DataObject subclasses like $db, $has_one etc.
 * ![rev:65035] Collecting entities for language master table with new i18nTextCollector functionality. The table is now sorted alphabetically by namespace and entity. Entities now include more translatable statics from DataObject subclasses like $db, $has_one etc.
 * ![rev:65025] Moved i18n tests into sapphire/tests/i18n subfolder
 * ![rev:65022] documentation for i18nTextCollector
 * ![rev:65021] package information for ModuleManager
 * ![rev:65019] Moved js unit tests from sapphire/javascript/tests to sapphire/tests/javascript to have a consistent location for all tests on server- and clientside
 * ![rev:64986] Renamed variable to avoid confusion in SecurityAdmin->SiteTreeAsUL()
 * ![rev:64982] Tests for r64981
 * ![rev:64871] Code formatting in TextareaField->Field()
 * ![rev:64850] Code formatting cleanup
 * ![rev:64786] Added deprecated note to ConfirmedFormAction
 * ![rev:64771] phpDoc update for ContentController->getMenu()
 * ![rev:64733] Code formatting cleanup in AssetAdmin->addfolder()
 * ![rev:64560] Temporarily disabled Debug::message() calls in i18nTextCollector as they're disturbing unit test output and we currently dont have context switches for this
 * ![rev:64559] Adjusted i18nTextCollector to use DataObject->i18nCollectStatics()
 * ![rev:64557] Unnecessary check of trim() twice on TextareaField->Field()
 * ![rev:64555] whitespace removal
 * ![rev:64551] Documentation tweaks in TextareaField
 * ![rev:64550] Convert::raw2att() isn't required because FormField->createTag() already does this
 * ![rev:64505] Added to @deprecated note for TypeDropdown about why this class shouldn't be used
 * ![rev:64503] phpDoc changes in LeftAndMain - removal of @usedby which doesn't exist, replaced with @uses on the remote function
 * ![rev:64502] Code formatting changes to be more consistent
 * ![rev:64498] Moved CollectionController_Results template into genericviews module
 * ![rev:64460] documenting my new method, correct a coding convention about whitespace
 * ![rev:64442] moved RestfulServerTest from cms to sapphire module, same as the actual RestfulServer class
 * ![rev:64441] moved RestfulServerTest from cms to sapphire module, same as the actual RestfulServer class
 * ![rev:64429] deprecation notes
 * ![rev:64419] Misc deprecation notes
 * ![rev:64418] Changed visibility of SiteTree->getClassDropdown()
 * ![rev:64415] documentation
 * ![rev:64414] Removed unused DatabaseAdmin->makeURL()
 * ![rev:64413] documentation
 * ![rev:64412] Marked some Convert methods as deprecated, as their purpose is unclear, they're neither documented nor tested. Stuff like Convert::xml2js() is just way too fuzzy
 * ![rev:64411] phpDoc comment error fix
 * ![rev:64409] Changed visibility of Convert::recursiveXMLToArray
 * ![rev:64406] Tidied up code formatting for MemberLoginForm->forgotPassword() to be clearer
 * ![rev:64404] Security->LostPasswordForm() code formatting changes for clarity
 * ![rev:64403] Moved Controller::init() to top of file
 * ![rev:64400] Misc deprecation notes
 * ![rev:64397] phpDoc for Versioned::get_by_stage() to be consistent with Versioned::get_one_by_stage()
 * ![rev:64396] Removed deprecated method addmember() from CMSMain - this should be contained on SecurityAdmin instead
 * ![rev:64395] Removed commented out code in CMSMain->PageTypes()
 * ![rev:64385] Misc deprecation fixes
 * ![rev:64382] Misc deprecation notices
 * ![rev:64369] Removed Group_Unsecure which was never used
 * ![rev:64364] Removed Director::addRules() item for Unsubscribe_Controller that should will be done by the Newsletter _config.php file instead
 * ![rev:64362] Fixed FileTest for changes to getFileType() on the File class
 * ![rev:64356] Tweaked text of file type descriptions slightly
 * ![rev:64344] Whitespace changes in TextField
 * ![rev:64338] delete some unnecessary duplicated variable in a assignment statement.
 * ![rev:64322] Removed useless comment and commented out code that went along with it in Group class
 * ![rev:64319] fixed php notice error in DataObject
 * ![rev:64312] Todos for ObjectTest
 * ![rev:64301] Added mergeinfo
 * ![rev:64300] Added mergeinfo
 * ![rev:64261] Moved HTTPRequest constructor to beginning of method definitions
 * ![rev:64079] Documentation in i18n class
 * ![rev:64068] Removed CollectionController language strings from master table
 * ![rev:64020] Removed subtree mergeinfo
 * ![rev:64014] Formatting
 * ![rev:64009] Swapped $mainFields and $fields assignments in Member->getCMSFields() to reflect what they're actually containing
 * ![rev:64008] Syntax fix in CliTestReporter which was causing wrong array indices
 * ![rev:64006] Fixed PHP notice in CLITestReporter
 * ![rev:63985] Documentation
 * ![rev:63982] Removed unnecessary $this->extend() on SSReport->getCMSFields()
 * ![rev:63961] Updated inconsistent documentation on SSReport
 * ![rev:63959] Updated SSReport class documentation to make sense
 * ![rev:63958] Documentation and @package phpDoc code additions to ReportAdmin and SSReport
 * ![rev:63937] Reformatting
 * ![rev:63898] Add warning for deprecated function.
 * ![rev:63897] Change memory limit to -1 on publishall to stop sapphire running out of memory on unit tests.
 * ![rev:63873] Updated entities from translate.silverstripe.com
 * ![rev:63869] Updated entities from translate.silverstripe.com
 * ![rev:63864] Updated language master table
 * ![rev:63861] Updated language master table
 * ![rev:63856] Reverted manual setting of i18n fallback strings in r63839, fixed original problem (wrong entity name)
 * ![rev:63840] Renamed Report to SSReport as it was conflicting with project code
 * ![rev:63822] Fix to SiteTreeTest's data fixtures
 * ![rev:63815] Tidied up argument list for Object::create() in ComplexTableField->AddForm()
 * ![rev:63802] Fixed JS undefined errors with 'addgroup' and 'deletegroup' elements
 * ![rev:63801] Fixed JS undefined error with 'Loading' element
 * ![rev:63790] Line break between static variables on SecurityAdmin
 * ![rev:63766] removed subtree mergeinfo on ModelAdmin_Results.ss in preparation for client branch merge
 * ![rev:63760] Documentation for Form class
 * ![rev:63753] Code formatting cleanup
 * ![rev:63752] Very minor whitespace change
 * ![rev:63747] Removed PageTypes directory from cms which is not used anymore
 * ![rev:63680] Documentation and formatting in SSViewer and Controller
 * ![rev:63657] Documentation for HTTPRequest and RequestHandlingData
 * ![rev:63655] Documentation for HTTPRequest and RequestHandlingData
 * ![rev:63632] Removed scaffolded header field in DataObject->scaffoldFormFields()
 * ![rev:63617] Documentation
 * ![rev:63616] Documentation
 * ![rev:63608] fixed formatting on no images found
 * ![rev:63568] Documentation
 * ![rev:63531] Documentation in DataObject
 * ![rev:63530] Reverted my email address with something more spambot safe from r63489 ;)
 * ![rev:63492] removed `< and >` characters from @author phpdoc token
 * ![rev:63491] phpdoc tweaks
 * ![rev:63490] phpdoc tweaks
 * ![rev:63489] Filled in Ingo's email for phpdoc since he failed to do it himself
 * ![rev:63469] Formatting in Member
 * ![rev:63468] Documentation for Form
 * ![rev:63466] Documentation in ErrorPage
 * ![rev:63459] Code formatting inconsistency
 * ![rev:63458] Added TODOs for areas of code that needs some work, either in documentation or code cleanup.
 * ![rev:63456] Committed missing files related to r63452
 * ![rev:63453] Fixed wrong position of return array() in ReportAdmin->showWithEditForm()
 * ![rev:63452] Documentation and TODO for ReportAdmin methods
 * ![rev:63449] Fix undefined variable error in ManifestBuilder::get_manifest_info()
 * ![rev:63420] Code formatting changes for readability and consistency in DropdownField->Field()
 * ![rev:63390] Ticket #2869 Fixed PHP notice in Director::forceWWW()
 * ![rev:63388] Fix PHP notice in checking $_SERVER['HTTPS']
 * ![rev:63385] Fixed PHP notices in ListboxField->Field() by defining the variables first
 * ![rev:63370] documentation
 * ![rev:63355] allow tinymce to suck down script code at least in tinymce
 * ![rev:63339] todos for DataObjectTest
 * ![rev:63293] Documentation
 * ![rev:63180] Added externals for thirdparty JSON library
 * ![rev:63179] Moved JSON library to thirdparty externals
 * ![rev:63178] Reverted accidental commit to main.php from  r63177
 * ![rev:63174] Documentation for image uploads
 * ![rev:63156] Reverted accidental disabling of ManifestBuilderTest cleanup code
 * ![rev:63155] Temporarily disabled RSSFeedTest as its overriding environment variables that should be handled by Director class with Director::setBaseURL() (which is currently not fully working). Added stub-tests for Director.
 * ![rev:63127] Fix phpdoc parsing error
 * ![rev:63125] Fix phpdoc parsing error
 * ![rev:63124] Fix phpdoc parsing error
 * ![rev:63123] Fix phpdoc parsing error
 * ![rev:63122] Fix phpdoc parsing error
 * ![rev:63121] Fix phpdoc parsing error
 * ![rev:63081] Added CMS->SiteTreeAsUL() to $allowed_actions (#2733)
 * ![rev:63080] Removed stale version number from `<meta name="generator">` tag (#1908)
 * ![rev:62877] Added some more api doku for DataObject::
 * ![rev:62845] Added documentation and TODOs for RestfulServer
 * ![rev:62843] Documentation and formatting for Debug class
 * ![rev:62842] Documentation
 * ![rev:62841] Added documentation to DataObject about permission handling
 * ![rev:62484] Changed console.log() to console.error() in ajax error handling
 * ![rev:62470] documentation
 * ![rev:62462] documentation
 * ![rev:62461] documentation
 * ![rev:62424] FileField->Field() code formatting changes
 * ![rev:62313] HTMLVarchar->scaffoldFormField() was referencing a class name of different case that didn't exist (change it to the correct one to be sure)
 * ![rev:61840] fixed comment on MathSpamProtection
 * ![rev:61826] #2696 - Add message when trying to load the CMS with javascript
 * ![rev:61825] Fixed PHP notice
 * ![rev:61702] Remove commented out code
 * ![rev:61484] added @deprecated note in PHPdoc to show that Email_Template is deprecated
 * ![rev:61483] phpdoc of @package and @subpackage to reflect the actual package and subpackage
 * ![rev:61482] comment changes to allow better readability of comments of what we're testing
 * ![rev:61481] Additions to FieldSetTest to test removeByName() and removeFieldsFromTab()
 * ![rev:61217] setRelationAutoSetting function adding
 * ![rev:61164] Fixed PHP notice in CheckboxSetField when transforming to readonly
 * ![rev:61161] PHPdoc for FieldSet->replaceField()
 * ![rev:61160] PHP notice fix for FileIFrameField->Field()
 * ![rev:60949] Added FieldSetTest to the test library
 * ![rev:60409] Re-activated tabstrip.js in LeftAndMain (merge error?)
 * ![rev:60408] Renamed jquery_improvement.js to plural form (consistent with prototype_improvements.js)
 * ![rev:60407] Re-enabled DataObjectDecoratorTest
 * ![rev:60406] Moved sapphire/misc* to sapphire/thirdparty and sapphire/integration
 * ![rev:60401] Moved ScaffoldComplexTableField to separate file
 * ![rev:60400] Removed DataObject->mapRelationshipObjects() - incomplete functionality
 * ![rev:60398] Removed sapphire/tools
 * ![rev:60371] Documentation
 * ![rev:60370] Removed debug code from Member.php
 * ![rev:60367] removed obsolete code from DataObject.php
 * ![rev:60217] syntax error
 * ![rev:60216] syntax error
 * ![rev:60210] Documentation
 * ![rev:60157] Fix php notice
 * ![rev:59518] Fixed crazy messed up indentation in TableField
 * ![rev:59279] wording for "IP Range" description


##  Other

 * ![rev:71921] Undo the change committed in r71918 since the commit message is missing
 * ![rev:71758] Improved DataObject validation tests to use PHPUnit's setExpectedException stuff.
 * ![rev:71755] Disable xdebug in the test runner, because it has a habit of causing bus errors
 * ![rev:71170] BUGIX: CMS UI search spinner style tweak
 * ![rev:71169] BUGIX: CMS UI changed search spinner, hide search button while processing (better interaction feedback)
 * ![rev:71035] Include the media widget into the CMS
 * ![rev:71034] Removed media plugin code that got copied into ssbuttons
 * ![rev:70995] Disable basicauth in RestfulServiceTest
 * ![rev:70900] BUGIFX tweak to navigator layout and tidying up unnecessary styles
 * ![rev:70894] BUGIFX tweak to navigator layout
 * ![rev:70860] Made selection of custom security templates easier
 * ![rev:70845] Don't let content negotiator clobber the mime types of things other than HTML & XHTML
 * ![rev:70844] Replaced HTTPReponse settings of Content-type header with Content-Type, to match RestfulServer
 * ![rev:70747] 2. make Email_BounceRecord::canCreate() return false; so that it can not be manully create from CRM, instead, it should create through email buncing system.
 * ![rev:70740] Undoing change committed in r 70734
 * ![rev:70738] Undoing change committed in r 70734
 * ![rev:70725] 2. Not all DataObject has a 'Title' database field, but all DataObject has a 'Title' field due to function DataObject::getTitle() exists.
 * ![rev:70702] Merged patch submitted by ajshort that calls loadDataForm on a newly created object in ModelAdmin so that  properties of the object are loaded properly
 * ![rev:70372] fixed ajax button alignment
 * ![rev:70303] cms ui: site tree tools visual update
 * ![rev:70240] cms ui: fixed line background to drop down from root node
 * ![rev:70239] cms ui: fixed line background for open nested lists
 * ![rev:70237] cms ui fix: styles for uniform site tree line
 * ![rev:70235] cms ui fix: make site tree hierarchy line uniformly dotted
 * ![rev:70206] cms ui fix: adding separator above allow drag and drop
 * ![rev:70143] IE6 ui fixe for search filter date input width
 * ![rev:70141] IE6 ui fixes for calendar in search filters (positioning and when sidebar is expanded)
 * ![rev:70136] ui fixes for calendar in search filters (positioning and when sidebar is expanded)
 * ![rev:70127] 
 * ![rev:70091] stopped null properties being added when images inserted in cms (hspace, vspace, align)
 * ![rev:70090] Added missing Decimal->nullValue method.
 * ![rev:69983] Removed unnecessary db query in CMS tree generation
 * ![rev:69982] Pre-cache page version numbers when querying CMS tree for query efficiency
 * ![rev:69981] Added Versioned::prepopulate_versionnumber_cache() to allow for querying efficiencies
 * ![rev:69977] Added cache to Permission::checkMember() to reduce the number of queries
 * ![rev:69933] Reverted change because it wasn't necessary
 * ![rev:69925] EHANCEMENT #3326 hamish: Added Image::getOrientation()
 * ![rev:69815] Added getter to retrieve alternative database name.
 * ![rev:69731] Better error messages when HasManyComplexTableField can't configure itself properly.
 * ![rev:69681] See #3275
 * ![rev:69382] Fixed label of back button
 * ![rev:69350] Simplified implementation of FieldSet::makeReadonlyField()
 * ![rev:69349] Simplified implementation of FieldSet::makeReadonlyField()
 * ![rev:69052] Fixed URL in the list of tasks.
 * ![rev:68945] Fixed loading of CMS toolbar with the HtmlEditorField
 * ![rev:68873] Improved rendering of [php] tags in BBCode view
 * ![rev:68700] Made CalendarDataField JS more self-suffficient
 * ![rev:68598] Added SearchForm::classesToSearch() to set the classes that you want it to search.  Still limited to SiteTree and File but you can exclude one of those.
 * ![rev:68474] Merged r67482 to branches/2.3 - let db/build add auto_increment
 * ![rev:68326] Added ability for comment authors to leave a URL as a separate form field
 * ![rev:67877] PaginationSummary return all pages by default
 * ![rev:67793] Added PaginationSummary function that enable DataObjectSet to display a portion of page list
 * ![rev:67776] Added headers_sent() check to header() call in main.php to stop it from being so brittle.
 * ![rev:67583] Restore requirements after sending email
 * ![rev:67432] Improved graphs displayed on dev/viewmodel
 * ![rev:67427] Added diagrams to dev/viewmodel
 * ![rev:67414] Added simple model viewer at dev/viewmodel
 * ![rev:67401] - including greybox.js had caused the screen to become unscrollable because of an (unrelated) inclusion of LeftAndMain.js which sets `<body>` to overflow:hidden on javascript page load
 * ![rev:67194] Merged r67152 from trunk
 * ![rev:67169] Add TableListField::setFieldList()
 * ![rev:67165] Added ModelAdmin:: for changing the class used to generate results tables
 * ![rev:67131] Moved LegacyIDs from BlogEntry and File to Decorators
 * ![rev:67114] Added LegacyID for keeping orginal ID. Used for site migration
 * ![rev:66941] Fixed SiteTreePermissionsTest login failure tests
 * ![rev:66923] #1885: Fixed safari bold, italic, underline by removing HTML scrubbing.
 * ![rev:66889] Better checking of tabstrip stuff
 * ![rev:66834] Removed call-time pass by reference from CsvBulkLoader
 * ![rev:66824] Removed unnecessary updateCMSFields call; DataObject::getCMSFields does this for us
 * ![rev:66719] getting things tidied up
 * ![rev:66717] trying to get jquery to stick
 * ![rev:66712] packed jquery
 * ![rev:66708] packed jquery and jquery ui
 * ![rev:66645] DataObject::relObject() throws an exception rather than an error so that it can be caught
 * ![rev:66639] Set default level for HeaderField
 * ![rev:66634] Added white background for tabs in all places; not just the right frame
 * ![rev:66626] Allow passing of columns to ColumnSelectionField() and allow different ColumnSelectionField() values to influence the result columsn
 * ![rev:66582] Added support to DataObject::relObject() for looking at $casting to get information about the relation - good for dynamic relations
 * ![rev:66546] Fix incorrect logic in r66544
 * ![rev:66544] Make sure only fields that exist can be autocompleted on MemberTableFields, and never autocomplete on password.
 * ![rev:66431] 
 * ![rev:66394] 1. Add note to each record in 1-many relation. Add the tab "Notes" for showing/editing/deleting notes of a record.
 * ![rev:66356] Merged pre-2.3-oct08 into 2.3 (via trunk)
 * ![rev:66353] Merge pre-2.3-oct08 into 2.3 (via trunk)
 * ![rev:66350] Fix to LeftAndMain to ensure that jquery doesn't break other admin sections
 * ![rev:66304] Fixed bug in test makefile
 * ![rev:66296] Build database before testing, for RestfulService test, etc
 * ![rev:66267] Return an HTTPResponse consistently from controllers
 * ![rev:66265] Fixed RequirementsTest
 * ![rev:66225] #2771: Fix SQLQuery::filtersOnID() (wakeless)
 * ![rev:66192] #2635 - More informative errors in DataObject (simon_w)
 * ![rev:66103] FIX: permission migrator for missing groups
 * ![rev:66086] Merged pre-2.3-oct08 into branches/2.3 (via trunk)
 * ![rev:66084] Merged pre-2.3-oct08 into branches/2.3 (via trunk)
 * ![rev:66008] Boundary condition check for top-level pages with 'inherit' permission
 * ![rev:65981] Update sapphire so that it can run with the default .htaccess and mysite/_config.php files provided in the phpinstaller.  If database config is missing, then redirect to install.php
 * ![rev:65971] Include tabstrip js and css for modeladmin
 * ![rev:65970] Fixed WYSIWYG styling
 * ![rev:65967] Added validation for DataObject::db, has_one, has_many, many_many, belongs_many_many properties, so that improper use of the array syntax doesn't raise strange bugs elsewhere.
 * ![rev:65959] #3068 - Fixed memory issue in IE
 * ![rev:65939] Replace source view with one based on codepress
 * ![rev:65938] Added advcode tinymce plugin that is a wrapper around codepress
 * ![rev:65915] Set default view/edit permissions
 * ![rev:65913] Added light blue colouring to notinmenu items
 * ![rev:65912] Added notinmenu class to CMS tree items that aren't in menus
 * ![rev:65861] Fixed dropdown-based ModelAdmin navigation
 * ![rev:65859] Fixed root node not displaying correctly
 * ![rev:65828] Removed console debug messages for ThumbnailStripField
 * ![rev:65824] Merged in image search capabilities from trunk version - r65820, r65823
 * ![rev:65802] Fixes for IE support of script tags being down the bottom
 * ![rev:65789] #2991 - Fixed change detection in mce fields
 * ![rev:65783] Fixed fatal error in CommentTableField:
 * ![rev:65782] New test for old URL redirection
 * ![rev:65781] #2679: Auto-redirect renamed pages
 * ![rev:65778] Get sapphire to self-allocate at least 64M of memory, if possible.
 * ![rev:65735] Fixed media-type selection on demand in IE
 * ![rev:65718] Added livequery to leftandmain install
 * ![rev:65717] Refactored tabstrip.js to use livequery for loading
 * ![rev:65716] Refactored tabstrip.js to use livequery for loading
 * ![rev:65709] Removed time limit when minifying files and disabled processing of multiple files if on dev.
 * ![rev:65673] Change back to english on teardown
 * ![rev:65530] No execution time limit on test runner
 * ![rev:65529] Replaced 300-second 'long execution' times with unlimited
 * ![rev:65524] Merged branches/2.2
 * ![rev:65523] Merged from branches/2.2
 * ![rev:65507] Ensure that Requirements backend instance is preserved between tests
 * ![rev:65506] Reformatted memory usage to be more concise
 * ![rev:65503] #2997 - Added `<% require %>` tag to SSViewer
 * ![rev:65471] Added default for HTTP_USER_AGENT
 * ![rev:65465] Cleaned up the commented-code
 * ![rev:65438] Bugfixes to Requirements alterations
 * ![rev:65436] ARCHITECTURE #3034 wakeless: Make Requirements mockable by pushing the meat of the functionality to Requirements_Backend
 * ![rev:65407] Removed redundant code
 * ![rev:65397] Removed redundant code
 * ![rev:65385] dquote> API CHANGE: Simplified Core.php manifest include to just call ManifestBuilder::include_manifest() - manifest takes care of its own cache file
 * ![rev:65332] IMPROVEMENT Fix tab display and button position when adding a record (ticket #3029)
 * ![rev:65289] IMPROVEMENT moved managed models' forms to one panel (ticket #2898)
 * ![rev:65287] #2135 - Disallow XSS bug in development RestfulService use
 * ![rev:65252] Added deprecation method for LeftAndMain::add_menu_item()
 * ![rev:65229] API CAHNGE: Allow augmentPopulateDefaults on data object decorators
 * ![rev:65189] Added spellchecker to CMS
 * ![rev:65175] Reverted previous change, as MemberTableField has it's own use of sourceFilter - not the most documentation situation however.
 * ![rev:65173] 
 * ![rev:65150] Note: Use dev/tasks/UpgradeSiteTreePermissionSchemaTask/run to migrate legacy data to the new schema as outlined above
 * ![rev:65140] Simplified CliTestReporter output so that buildbot can read it
 * ![rev:64952] Text scaffolds to a TextareaField, not a TextField
 * ![rev:64947] #2975 - Malformed javascript language string (ajshort)
 * ![rev:64896] In general all Form Fields should imply with this rule if a page contain mulitiple forms, but this is not under our current developing cycle, since our form fields validation is changing to use jQuery.
 * ![rev:64880] Deleted SmallerThanFilter - please use LessThanFilter
 * ![rev:64863] Changed default # of rows on HTMLEditorField from 15 to 30
 * ![rev:64862] Fixed TinyMCE stylihg
 * ![rev:64839] Fixed CMS uploading
 * ![rev:64814] call $this->extend('updateFieldLabels', $labels) in FieldLabels() to get its decorator's customized field labels
 * ![rev:64778] Removed scrubbing of the HTML
 * ![rev:64768] #2957 - Fixed entity decoding in Convert::html2raw
 * ![rev:64760] Fixed bug in tinymce_ssbuttons plugin inclusion
 * ![rev:64759] Added LinkText field to link inserter
 * ![rev:64684] Removed sapphire/images/fe_icons - these will be put in the userforms module instead, where the FieldEditor
 * ![rev:64470] Removed junk text from CSSContentParserTest
 * ![rev:64368] HTTP:add_cache_headers() - don't throw warning when  not passed
 * ![rev:64345] dquote> API CHANGE: HTTP::add_cache_headers() now designed to manipulate an HTTPResponse object rather than add headers directly
 * ![rev:64343] Removed TextField_Disabled - this is unnecessary
 * ![rev:64340] Included jquery.js before prototype.
 * ![rev:64339] Implemented a jQuery based version of documents.getElementsBySelector
 * ![rev:64326] API: add CurrencyField_Readonly
 * ![rev:64325] API: add funcion TableField_Item::IsAddRow()
 * ![rev:64324] Feature: attach extraClasses to a FormField when it is transform to readonly
 * ![rev:64323] API: add TextField_Disabled
 * ![rev:64152] Removed #! entry from cli-script.php; its unreliable and cli-script.php should be called as 'php cli-script.php' instead
 * ![rev:64070] ENHANCMENT Making ModelAdmin translatable (#2874)
 * ![rev:63938] Improved backtrace generation in test reporter, to limit the amount of unnecessary waffle.
 * ![rev:63912] BGFIX: #2587 Fix HTTPS detection on IIS (mackeyn)
 * ![rev:63904] BGFIX: #2527 - Fix mysql version detection on hosts with custom mysql version names (HakTom)
 * ![rev:63892] Added PHP doc for the ValidationException thrown by DataObject::write
 * ![rev:63891] DataObject::write now throws a ValidationException rather than calling user_error if the call to DataObject::validate fails. This allows the validation exception to be caught and handled by tests or other controllers.
 * ![rev:63883] Added missing TableListField_printable.ss template.
 * ![rev:63882] Corrected reverted merge. ComplexTableField::setPopupSize is now present.
 * ![rev:63843] Removed legacy Report.php
 * ![rev:63842] BUGF Renamed Report class to SSReport, file name wasn't altered but class name was
 * ![rev:63837] Updated Member's getCMSFields() to consistently work with fields in a tab
 * ![rev:63821] Moved error_reporting setting from main.php to Core.php
 * ![rev:63820] Removed relational CTFs reliance on DataObject->ClassName
 * ![rev:63807] Merged from branches/nzct-trunk. Use 'svn log -c `<changeset>` -g' for full commit message. Merge includes stability fixes and minor refactor of TableListField and ComplexTableField.
 * ![rev:63806] Merged from branches/nzct-trunk. Use 'svn log -c `<changeset>` -g' for full commit message. Merge includes stability fixes and minor refactor of TableListField and ComplexTableField.
 * ![rev:63748] 
 * ![rev:63745] Updated Member::isInGroup() to function as well as being deprecated
 * ![rev:63733] Added get data to a form submission of SearchForm/search, so that ResultAssembly is passed
 * ![rev:63715] Updated errorMessage() call in ModelAdmin to actually show the message to the user.  For example, 404s return messages of the form 'your search returned no results'
 * ![rev:63636] Added instructions to try and prevent #2901 issues reoccurring
 * ![rev:63625] ENHANCMENT Using errorMessage() instead of statusMessage('bad') for ModelAdmin.js
 * ![rev:63594] Fixed FormField::createTag() generation for empty `<select>` tag, which meant that page version history was displayed in single-language mode
 * ![rev:63583] Updated file functions to use HTTPRequest::send_file
 * ![rev:63582] Added tests for security group export
 * ![rev:63580] Break sake dev/tests/all status dots onto lines of 80
 * ![rev:63552] Updated BankAccountField to allow setting it to blank without a notice-level error
 * ![rev:63548] #2397 - Fixed HTMLEditorField style dropdown
 * ![rev:63546] Added groups field on member details, so that you can add members to other group
 * ![rev:63545] Added dev/modules/remove and cleaned up rebuilding code on add and remove module
 * ![rev:63537] Fixed dumb error in my makeRelative change
 * ![rev:63535] Added security for experimental module manager
 * ![rev:63534] Added initial module manager API, with the capability of adding a module to svn:externals
 * ![rev:63532] Secured SapphireInfo
 * ![rev:63531] ENHANCMENT Checking for valid has_one relationship on dot-notation-usage in DataObject->update
 * ![rev:63506] Don't claim that there's an invalid password if no password is set - members may be created for newsletters, etc.
 * ![rev:63488] fixed fix position of action area (status message and ajax action buttons) in IE6 using javascript
 * ![rev:63452] 
 * ![rev:63431] Fixed bug in cli-script argument parsing
 * ![rev:63389] Reverted r63388
 * ![rev:63388] 
 * ![rev:63383] removed debug::show
 * ![rev:63382] - commented out this.style.position = "absolute"; in LeftAndMain.js
 * ![rev:63251] Reverted en_US.php changes from r63249
 * ![rev:63113] Turned dos line endings into unix
 * ![rev:63078] Link Editor: Close button dissapears in Firefox 3 (#2478)
 * ![rev:63020] EHANCEMENT #2853 - You can now use db/build instead of db/build?flush=1
 * ![rev:62998] Fixed bug with ComplexTableField inappropriately referencing a relation field that doesn't exist
 * ![rev:62912] Added status notifications to cli test runs
 * ![rev:62866] Corrected layout of field groups
 * ![rev:62865] Replaced alert()s in UniqueFields.js with statusMessage()s, to be less obnoxious
 * ![rev:62756] Fixed bug publishing homepage using Director::test
 * ![rev:62692] Added CountryDropdownField::defaultToVisitorCountry(false):
 * ![rev:62689] Removed save button from add form
 * ![rev:62654] Update test runner so that password validation config isn't tested by default
 * ![rev:62653] This results in more reliable log-in redirection
 * ![rev:62648] Fixed bug with preivous CheckboxSetField change
 * ![rev:62641] Fixed loadDataFrom for CheckboxSetFields that are used to edit a many-many relation, if loadBlanks is set to true
 * ![rev:62599] comment Debug.traceback that occur when the field is a tab
 * ![rev:62386] Added empty string as a default (first item)
 * ![rev:62335] Improved ModelAdmin.js - removed formData and showRecord, creating .fn('loadForm') instead; used livequery more to reduce the amount of behaviour reapplication that was necesary.
 * ![rev:62334] Updated ModelAdmin's javascript to provide more status indicator (loading icons, success/failure messages), using HTTP status codes and custom status text.
 * ![rev:62331] Fixed ConfirmedPasswordField validation for min password length
 * ![rev:62325] 
 * ![rev:62324] 
 * ![rev:62322] Merged branches/roa into trunk
 * ![rev:62321] Merged branches/roa into trunk
 * ![rev:62318] Add another test for addFieldToTab when creating tabs
 * ![rev:62312] SearchContext generates SELECT DISTINCT query rather than SELECT, so that duplicate records aren't shown as a result of certain search filters
 * ![rev:62311] MemberTableField delete just removes the member from the group
 * ![rev:62310] Fixed MemberTableField ajax actions after a search
 * ![rev:62295] Allow MetaTags to be extended by a decorator.
 * ![rev:62287] Introduce notion of using HTTP status text to pass status message to the end user
 * ![rev:62278] Reorganised ModelAdmin javascript to be better structured
 * ![rev:62268] Fixed bugs with #1403 changes made in r62218.
 * ![rev:62267] 
 * ![rev:62213] Made allowed_actions case insensitive
 * ![rev:62188] Null values fixed for PHP 5.3
 * ![rev:62184] Multiple 'protected' variable declaration fixed
 * ![rev:61826] disabled (simon_w)
 * ![rev:61721] Show result-assembly columns so that you read down the column instead of zigzagging
 * ![rev:61720] Removed Created from member summary fields
 * ![rev:61714] adding ?flush=all option which clears all cached templates from the LOLCACHE
 * ![rev:61698] Updated CSV bulk loader to import unix/windows files on a mac server
 * ![rev:61685] TESTS: Added tests for Controller::join_links()
 * ![rev:61634] Windmill test - whacked up timeout on CMS load for slow build slave
 * ![rev:61631] Fixed setup of windmill admin tests
 * ![rev:61630] Disabled across-the-board use of windmill tests in continuous integration; instead a specific build is set up for it
 * ![rev:61629] Included windmill testing in the continous integration again
 * ![rev:61628] Fixed glitch in test
 * ![rev:61626] Updated windmill tests to use python syntax, as this will scale better
 * ![rev:61614] Fixed bugs in MemberTableField search
 * ![rev:61613] Fixed bug in TableListField::ajax_refresh
 * ![rev:61578] added a call to magic method to check extra (crm) permission
 * ![rev:61525] Added EPMU's process control sake
 * ![rev:61523] add Created as summary_fields
 * ![rev:61511] The searchCriteria will be added as $_GET to the form action, rather than that TableListField's extraLinkParams
 * ![rev:61509] getSummaryFields() will also get those summary fields defined in Member's decorator applied to the results and export
 * ![rev:61497] Reverted r61492
 * ![rev:61462] Improved File tests
 * ![rev:61461] Fixed coverage reporting on test runner
 * ![rev:61411] Fixed saving of TableField and added tests
 * ![rev:61410] Better error message if you have forgotten to set fixture_file
 * ![rev:61370] Undeprecated a critical feature of TableField, and reimplemented in the Group's permission field.  Cleaned up its implementation to be more in line with TableListField
 * ![rev:61351] Fixed display of Permission dropdown in SecurityAdmin
 * ![rev:61344] Fixed bug with manifest generation
 * ![rev:61184] Merged branches/kiwiselect into trunk
 * ![rev:61155] field, changed to "MenuTitle" to be consistent with the main CMS site tree and to avoid confusion
 * ![rev:61152] Work to decouple the ManifestBuilder from the database, so that you can run manifest builder tests without an active database existing
 * ![rev:61151] introduce double scrolling and thus poor usability
 * ![rev:61136] Fixed bug with CsvBulkLoader
 * ![rev:61135] uncommmented processRecord that process each record because it was mistakenly commented previously
 * ![rev:61123] $resultsCount now gets int value from loader directly instead of DataObjectSet
 * ![rev:61122] change the return type of processAll of CsvBulkLoader from DataObjectSet to int, the number of affected row
 * ![rev:61120] modified csv import function documention. It returns number of affected records.
 * ![rev:61067] Made some methods on SearchFilter public so that SearchFilters can be co-opted for other purposes.  Really, moving the magic to a DataQuery object would be better
 * ![rev:61066] Fixed action handlers on fields of ResultsForm (notably the TableListField) by adding querystring arguments to the Link() of the form.
 * ![rev:61065] Fixed bug in TableListField sort links
 * ![rev:61064] Fix FormField::Link() to allow querystrings in the form's action
 * ![rev:61063] Turn off default caching
 * ![rev:61056] Added back button to ModelAdmin detail views
 * ![rev:60937] Removed double quoute from the from fields as it means field terminator
 * ![rev:60913] Updated AssetTableField to work with ComplexTableField updates
 * ![rev:60912] Fixed bug in Member::mapInCMSGroups()
 * ![rev:60911] Reverted Folder::CanEdit() to its original behaviour; that of returning a many-many join.   Note that this conflicts with DataObject::CanEdit() now.
 * ![rev:60910] Added ComplexTableField::getCustomFieldsFor() that you can overload in subclasses of ComplexTableField to create alternative pop-up forms
 * ![rev:60909] Added table references to many-many join used by scaffolder, to remove 'ambiguous column' bugs
 * ![rev:60907] replaced `<br />` with newline for CSV export
 * ![rev:60886] Removed memory limit for publication
 * ![rev:60885] Added warnings for parts of Member that require the newsletter module.  Note that this code should really be moved to the newsletter module at some stage.
 * ![rev:60874] Made all sapphire/thirdparty classes _manifest_exclude'd
 * ![rev:60873] Renamed illegal function that was hiding in Time.php
 * ![rev:60870] Removed time-limit for publication process
 * ![rev:60841] Fixed page comment system for new URL handler
 * ![rev:60830] Fixed saving of blank values to the has_one relations on versioned objects
 * ![rev:60829] Fixed HasManyComplexTableField and ManyManyComplexTableField in trunk
 * ![rev:60789] Fixed layout of CMS RHS panel to suit new form HTML structure
 * ![rev:60779] Fixed bugs with Image upload fields
 * ![rev:60778] Trap potential data-integrity bug
 * ![rev:60717] Ensure that a theme template is tried before getting a non-theme template
 * ![rev:60711] Added logging of SSViewer and Controller behaviour when using ?debug_request=1
 * ![rev:60664] Added tests for CheckboxSetField
 * ![rev:60612] Removed notice level error when ArrayLib::valuekey() is passed an empty array
 * ![rev:60608] Correct line numbers in error source fragment view
 * ![rev:60607] Ensure that MySQLDatabase::tableList() always returns an array
 * ![rev:60606] Fix error in Geoip when REMOTE_ADDR isn't set
 * ![rev:60605] Include full traces in unit test failures, for easier debugging
 * ![rev:60604] Removed unnecessary chatter from test runner
 * ![rev:60603] Improved db/build output for CLI
 * ![rev:60602] Removed junk output from stderr
 * ![rev:60601] Added Debug::get_rendered_backtrace() for rendering backtraces from other contexts (such as exceptions)
 * ![rev:60597] Improved performance of testrunner so that it doesn't create a new database for each test, instead only once per test run.
 * ![rev:60592] Removed warning when session_regenerate_id can't be set.  It's not strictly necessary and just causes testing headaches
 * ![rev:60586] Passed controller argument to ChangedPasswordForm constructor
 * ![rev:60582] Fixed MemberAuthenticator::authenticationFailedUnknownUser code
 * ![rev:60581] Improve CLI use of Debugging tools and test execution.
 * ![rev:60579] Removed code that used 2nd arg as HTTP_HOST value, in favour of more robust $_FILE_TO_URL_MAPPING
 * ![rev:60578] Add checks to see if REMOTE_ADDR is set before making use of it.
 * ![rev:60577] Improvements to better allow for CLI-based testing
 * ![rev:60575] Ensure that IP-based security can't be bypassed if an IP address isn't set.
 * ![rev:60572] Improved DataObjectTest to use more helpful assertions
 * ![rev:60571] Blocked [rev:47113].
 * ![rev:60570] Merged [rev:47110]: Hack fix for an email validation problem. Needs better solution.
 * ![rev:60569] Blocked [rev:47109].
 * ![rev:60568] Merged [rev:47108]: Ajax requests no longer trigger the audit trail hook in LeftAndMain::init.
 * ![rev:60567] Merged [rev:47107]: Added audit logging hook.
 * ![rev:60563] Fixed bug in Requirements::clear()
 * ![rev:60561] Blocked [rev:47106].
 * ![rev:60560] Merged [rev:47105]: Fixed a typo.
 * ![rev:60558] Blocked [rev:47104].
 * ![rev:60557] Merged [rev:47103]: MemberTableField.js now uses named sheets.
 * ![rev:60556] Merged [rev:47102]: Optimization for Behaviour sheets that allows you to provide a unique identifier so that duplicate sheets aren't applied twice.
 * ![rev:60555] Changed Debug::loadErrorHandlers to use value returned by error_reporting() rather than E_ALL. This way, the user can adjust the error handler screens with the error_reporting function.
 * ![rev:60548] Merged [rev:47101]: Adds class=action to action cells in MemberTableField.
 * ![rev:60546] Merged [rev:47094]: Fixes Session IP addresses in reverse order.
 * ![rev:60544] Blocked [rev:47093].
 * ![rev:60543] Refactored [rev:47092]: Add TableListField::getCastedValue
 * ![rev:60536] Merged [rev:47091]: Added Round and NiceRound to Float.
 * ![rev:60529] Refactored [rev:47088]: File::getFullPath now compares the filename with Director::baseFolder and returns filename if the filename stars with Director::baseFolder.
 * ![rev:60526] Blocked [rev:47084]: Needs refactoring for new Sapphire code which provides similar functionality.
 * ![rev:60522] Refactored [rev:47082]: Modified Member::mapInCMSGroups to make use of CMSMain::providePermissions.
 * ![rev:60515] Merged [rev:47081]: Modified construction of manifest to allow custom definition of MANIFEST_FILE constant filename in _config.php.
 * ![rev:60514] Merged [rev:47080]: Fix for pagination when using customSourceItems in TableListField.
 * ![rev:60512] Merged [rev:47079]: Fix for template logic.
 * ![rev:60511] Refactored [rev:47078]: AccessLogEntry will be created via an object extension.
 * ![rev:60510] Blocked [rev:47074] to [rev:47077].
 * ![rev:60509] Merged [rev:47074]: Added register and unregister as aliases to Authenticator.
 * ![rev:60508] Merged [rev:47073]: Fix for pagination in TableListField::sourceItems.
 * ![rev:60507] Blocked [rev:47072]: Changeset needs to be refactored so Session logging isn't strictly required.
 * ![rev:60506] Merged [rev:47071]: Added Session::get_timeout.
 * ![rev:60505] Blocked [rev:47070].
 * ![rev:60504] Merged [rev:47069]: Replaced explicit calls to AccessLogEntry::create with more flexible calls to extensions. AccessLogEntry to be refactored into separate module.
 * ![rev:60498] Refactored [rev:47068]: Member::logOut now calls memberLoggedOut on any extensions on Member.
 * ![rev:60491] Blocked [rev:47065] to [rev:47067].
 * ![rev:60490] Merged [rev:47064]: Set 'show' as the default action for ComplexTableField.
 * ![rev:60488] Blocked [rev:47062].
 * ![rev:60487] Merged [rev:47061].
 * ![rev:60486] Merged [rev:47060].
 * ![rev:60485] Merged [rev:47059]: Session expiry times can now be set based on the client's IP address.
 * ![rev:60481] Blocked [rev:47057] to [rev:47058].
 * ![rev:60480] Merged [rev:47056]: Adds unique identifier when creating Behaviour rule sheets to prevent duplicate behaviours from being applied repeatedly.
 * ![rev:60479] Merged [rev:47055]: Modified FormResponse to append Behaviour rules last.
 * ![rev:60478] Blocked [rev:47047] to [rev:47054].
 * ![rev:60477] Merged [rev:47046]: Minor optimisation to BankAccountField and added methods to get specific parts of the account number.
 * ![rev:60474] Reverted accidental change
 * ![rev:60473] Included regression test
 * ![rev:60470] Ability to lock down comments to logged-in members only
 * ![rev:60469] Merged [rev:47044]: Introduces modifications to Sapphire's form handling that allows it to ignore fields marked as Disabled when saving the contents of a form's fields to a DataObject.
 * ![rev:60468] Merged changes from 2.2.2-assets - everything except the asset refactoring
 * ![rev:60448] Allow object-methods to be used as columns in TableListField
 * ![rev:60446] Fixed js error when defaultAction isn't set
 * ![rev:60442] Reverted Hierarchy::extraDBFields() because it interfered with normal generation of the site hierarchy.  Note that children(), stageChildren(), and liveChildren() cannot be simply labelled as relations because they are methods with a different semantic meaning.  I recommend the use of something similar to  to enable access to information beyond relations via the data formatters
 * ![rev:60440] Refactored [rev:47041] to [rev:47043]: Moved to project-specific PhoneNumberField.
 * ![rev:60437] Refactored [rev:47040]: Functionality moved to project-specific Member subclass.
 * ![rev:60433] Merged [rev:47039]: Introduces custom actions to TableListField and ComplexTableField. By default, the show, edit and delete actions are included.
 * ![rev:60431] API Change: Turned Requirements::clear_combined_files() into Requirements::delete_combined_files() and Requirements::clear_combined_files()
 * ![rev:60428] Fix test runner to show errors as well as assertion failures
 * ![rev:60427] Updated SecurityTest to use new FunctionalTest system consistently
 * ![rev:60426] Added FunctionalTest->autoFollowRedirection, so that redirection following can be disabled on a test by test basis
 * ![rev:60425] Improved error checking in TestSession
 * ![rev:60411] Fixed call to badly named static method
 * ![rev:60394] Update SecurityTest to use the FunctionalTest base-class
 * ![rev:60391] Improved robustness of MemberTest
 * ![rev:60390] Improved Debug::backtrace() output
 * ![rev:60385] Blocked [rev:47034] to [rev:47038].
 * ![rev:60383] Merged [rev:47033]: TableListField::performReadonlyTransformation now sets show permission.
 * ![rev:60377] Added argument checking to Controller::handleRequest()
 * ![rev:60375] Set [REQUEST_URI] in cli-script for better error reporting
 * ![rev:60362] Fixed URL handling for /dev after merge from branches/roa to trunk
 * ![rev:60355] Fixed sake to pass cli-script error levels through
 * ![rev:60354] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60353] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60352] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60348] Blocked [rev:47098] to [rev:47100].
 * ![rev:60347] Blocked [rev:47020] to [rev:47026].
 * ![rev:60346] Blocked [rev:47012] to [rev:47014].
 * ![rev:60345] Blocked [rev:47006].
 * ![rev:60343] Blocked [rev:46198].
 * ![rev:60342] Blocked [rev:46193].
 * ![rev:60341] Blocked [rev:47029].
 * ![rev:60340] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60339] Blocked [rev:47027].
 * ![rev:60338] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60336] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60335] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60334] Blocked [rev:46974] to [rev:47005].
 * ![rev:60333] Blocked [rev:46960] to [rev:46972].
 * ![rev:60332] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60331] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60330] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60329] Blocked [rev:46953] to [rev:46958].
 * ![rev:60328] Blocked [rev:46951].
 * ![rev:60327] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60326] Blocked [rev:46262] to [rev:46288].
 * ![rev:60324] Blocked [rev:46261].
 * ![rev:60323] Committing missing mergeinfo for [rev:47028] for ManifestBuilder and ComplexTableField.ss
 * ![rev:60322] Blocked [rev:46192] and [rev:46197]
 * ![rev:60321] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60320] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60319] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60314] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60311] Merged [rev:47028]: Encountered a problem with Form::formHtmlContent not always including javascript validation, so added a call to includeJavascriptValidation on the validator in Form::formHtmlContent. Also modified Validator to notify the form that the client-side validation JavaScript has already been included. This way it isn't included twice.
 * ![rev:60307] Merged [rev:47019]: Actual merge in [rev:60309]
 * ![rev:60303] Committing merge info for [rev:60309]: Merge was performed manually.
 * ![rev:60302] Merged [rev:47018]: Some additions made to use Object::create to allow MemberTableField to deal with subclasses of Member. Also merged a modification to MemberTableField::__construct that allowed greater control over the details form's fields (defaults to same behaviour as trunk), and MemberTableField::DetailForm, although this might need to be removed later.
 * ![rev:60290] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60289] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60287] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60281] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60279] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60278] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:60276] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60268] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60266] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60265] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60264] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60261] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60259] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60258] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60257] Merged [rev:47017]: Modified behaviour for MemberTableField popups so that the behaviour is applied if the Security section uses a subclass of MemberTableField rather than an instance of MemberTableField.
 * ![rev:60256] Committing missing svn:mergeinfo for [rev:46973].
 * ![rev:60255] Merged [rev:47016]: Used Object::create to allow SecurityAdmin to use subclasses of MemberTableField to list members.
 * ![rev:60236] removed duplicate RestfulServerTest files, they're already in /cms (merge error)
 * ![rev:60235] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60234] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60233] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60232] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60231] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60230] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60229] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60228] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60227] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60226] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60225] (manually merged from branches/roa)
 * ![rev:60215] blocked r54568
 * ![rev:60214] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60212] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60211] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60209] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60208] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60207] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60206] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60205] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60204] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60203] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:60179] Merged [rev:47015]: Moved call to DataObject::write and makes use of DataObject::destroy.
 * ![rev:60178] Improved behaviour of ViewableData_Iterator.  It's not clear why, but this was causing a bug on our build slave.  Maybe a PHP version difference?
 * ![rev:60175] Merged [rev:47011]: Additional CSS for GenericDataAdmin.
 * ![rev:60173] Merged [rev:47010]: Modified GenericDataAdmin::buildResultFieldValue to accept relations of the form: obj1.obj2...objN->MethodCall, similar to TableListField_Item.
 * ![rev:60169] Merged [rev:47009]: Calls bind using Prototype Event.
 * ![rev:60168] Merged [rev:47008]: Disables the create button while creating a new entry with GenericDataAdmin.
 * ![rev:60167] Merged [rev:47007]: Fix to prevent GenericDataAdmin setting a status on a new record and thus overwritting a data field named 'Status'. Includes a fix for onclick on Ajax buttons if event is not passed.
 * ![rev:60162] Merged [rev:46973]: Notes a correction that will need to be made in the future.
 * ![rev:60137] Blocked [rev:46952]
 * ![rev:60123] Merged [rev:46959]: Summary values calculated on server are shown in the summary row when displaying a ComplexTableField.
 * ![rev:60108] Merged [rev:46289]: Committing the missing meta-data for sapphire.
 * ![rev:59969] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:59927] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:59925] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:59923] (blocked bidirectional merge from trunk into branches/roa)
 * ![rev:59922] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:59920] (merged from branches/roa. use "svn log -c `<changeset>` -g `<module-svn-path>`" for detailed commit message)
 * ![rev:59897] r52080, r52101, r52102 (merged from branches/roa)
 * ![rev:59890] r52079 (merged from branches/roa)
 * ![rev:59876] Merged [rev:46959]: ComplexTableField.ss now includes server-generated values in summary row cells.
 * ![rev:59875] Merged [rev:46289]: Spaces in SCRIPT_FILENAME are now replaced with underscores.