# Mac OSX with Homebrew

This topic covers setting up your Mac as a web server and installing SilverStripe.

OSX comes bundled with PHP, but you're stuck with the version and modules it ships with.
If you run projects on different PHP versions, or care about additional PHP module support
and other dependencies such as MariaDB, we recommend an installation through [Homebrew](http://brew.sh/).

Check out the [MAC OSX with MAMP](../Mac_OSX) for an alternative installation process
which packages up the whole environment into a convenient application.

## Requirements

Since we're compiling PHP, some build tooling is required.
Run the following command to install Xcode Command Line Tools.

	xcode-select --install

Now you can install Homebrew itself:

	ruby -e "$(curl -fsSL https://raw.githubusercontent.com/Homebrew/install/master/install)"

## Install PHP

First we're telling Homebrew about some new repositories to get the PHP installation from:

	brew tap homebrew/dupes
	brew tap homebrew/php

We're installing PHP 5.5 here, with the required `mcrypt` module:

	brew install php55 php55-mcrypt

There's a [Homebrew Troubleshooting](https://github.com/Homebrew/homebrew/blob/master/share/doc/homebrew/Troubleshooting.md) guide if Homebrew doesn't work out as expected (run `brew update` and `brew doctor`).

Have a look at the [brew-php-switcher](https://github.com/philcook/brew-php-switcher)
project to install multiple PHP versions in parallel and switch between them easily.

## Install the Database (MariaDB/MySQL)

	brew install mariadb
	unset TMPDIR
	mysql_install_db --user=`whoami` --basedir="$(brew --prefix mariadb)" --datadir=/usr/local/var/mysql --tmpdir=/tmp
	mysql.server start
	'/usr/local/opt/mariadb/bin/mysql_secure_installation'

To start the database server on boot, run the following:

	ln -sfv /usr/local/opt/mariadb/*.plist ~/Library/LaunchAgents

You can also use `mysql.server start` and `mysql.server stop` on demand.

## Configure PHP and Apache

We're not installing Apache, since OSX already ships with a perfectly fine installation of it.

Edit the existing configuration at `/etc/apache2/httpd.conf`,
and uncomment/add the following lines to activate the required modules:

	LoadModule rewrite_module libexec/apache2/mod_rewrite.so
	LoadModule php5_module /usr/local/opt/php55/libexec/apache2/libphp5.so

Change the `DocumentRoot` setting to your user folder (replacing `<user>` with your OSX user name):

	DocumentRoot "/Users/<user>/Sites"

Now find the section starting with `<Directory "/Library/WebServer/Documents">` and change it as follows,
again replacing `<user>` with your OSX user name:

	<Directory "/Users/<user>/Sites">
	    Options FollowSymLinks Multiviews
	    MultiviewsMatch Any
	    AllowOverride All
	    Require all granted
	</Directory>

We also recommend running the web server process with your own user on a development environment,
since it makes permissions easier to handle when running commands both 
from the command line and through the web server. Find and adjust the following options,
replacing the `<user>` placeholder:

	User <user>
	Group staff

Now start the web server:

	sudo apachectl start

Every configuration change requires a restart:

	sudo apachectl restart

You can also load this webserver on boot:

	sudo launchctl load -w /System/Library/LaunchDaemons/org.apache.httpd.plist

After starting the webserver, you should see a simple "Forbidden" page generated by Apache
when accessing `http://localhost`.

## SilverStripe Installation

[Composer](http://getcomposer.org) is a dependancy manager for PHP, and the preferred way to
install SilverStripe. It ensures that you get the correct set of files for your project.
Composer uses the PHP executable we've just installed. It also needs [git](http://git-scm.com)
to automatically download the required files from GitHub and other repositories.

Run `curl -sS https://getcomposer.org/installer | php` to install the `composer` executable.
We recommend that you make the executable available globally,
which requires moving the file to a different folder. Run `mv composer.phar /usr/local/bin/composer`.
More detailed installation instructions are available on [getcomposer.org](https://getcomposer.org/doc/00-intro.md#installation-linux-unix-osx).
You can verify the installation by typing the `composer` command, which should show you a command overview.

Finally, we're ready to install SilverStripe through composer:
`composer create-project silverstripe/installer /Users/<user>/Sites/silverstripe/`.
After finishing, the installation wizard should be available at `http://localhost/silverstripe`.
The Homebrew MariaDB default database credentials are user `root` and password `root`.

We have a separate in-depth tutorial for [Composer Installation and Usage](composer).