<?php

use Illuminate\Database\Migrations\Migration;
use Illuminate\Database\Schema\Blueprint;
use Illuminate\Support\Facades\Schema;

return new class extends Migration
{
    /**
     * Run the migrations.
     */
    public function up(): void
    {
        Schema::create('clients', function (Blueprint $table) {
            $table->id();
            $table->unsignedBigInteger('client_id')->nullable(); 
            $table->string('first_name');
            $table->string('last_name');
            $table->string('email')->unique();
            $table->string('password');
            $table->string('company_name');
            $table->string('company_email')->unique();
            $table->string('company_phone');
            $table->string('company_mobile');
            $table->string('company_country');
            $table->string('company_city');
            $table->string('company_zip_code');
            $table->string('company_fax')->nullable();
            $table->string('company_website')->nullable();
            $table->string('skype')->nullable();
            $table->string('company_address');
            $table->string('hosting_company')->nullable();
            $table->string('hosting_username')->nullable();
            $table->string('hosting_password')->nullable();
            $table->string('hosting_port')->nullable();
            $table->string('language');
            $table->string('mobile');
            $table->string('phone');
            $table->string('skype_contact')->nullable();
            $table->string('country');
            $table->string('address');
            $table->string('profile_photo')->nullable();
            $table->string('social_facebook_url')->nullable();
            $table->string('social_twitter_url')->nullable();
            $table->string('social_linkedin_url')->nullable();
            $table->timestamps();

        });
    }

    /**
     * Reverse the migrations.
     */
    public function down(): void
    {
        Schema::dropIfExists('clients');
    }
};
