<?php
 
namespace App\Http\Controllers;
 
use Illuminate\Http\Request;
use App\Models\Leave;
use App\Models\User;
use Carbon\Carbon;
 
class LeaveController extends Controller
{
    // Constants for leave status
    const STATUS_NEW = 'new';
    const STATUS_APPROVED = 'approved';
    const STATUS_REJECTED = 'rejected';
 
    // Function to show the list of leaves
    public function index()
    {
        $getLeave = Leave::paginate(10); // Paginate results for better performance with large datasets
        $userList = User::all(); // Get list of users
 
        return view('leave.index', compact('getLeave', 'userList'));
    }
 
    // Function to update the leave status
    public function updateStatus(Request $request, $id)
    {
        $leave = Leave::find($id);
 
        // Check if the leave request exists
        if (!$leave) {
            return back()->with('error', 'Leave not found.');
        }
 
        // Validate status
        $validStatuses = [self::STATUS_NEW, self::STATUS_APPROVED, self::STATUS_REJECTED];
        if (!in_array($request->status, $validStatuses)) {
            return back()->with('error', 'Invalid leave status.');
        }
 
        $leave->status = $request->status;
        $leave->save();
 
        return back()->with('success', 'Leave status updated successfully.');
    }
 
    // Function to delete leave
    public function deleteLeave($id)
    {
        $leave = Leave::find($id);
 
        // Check if the leave exists before attempting to delete
        if (!$leave) {
            return back()->with('error', 'Leave not found.');
        }
 
        $leave->delete();
 
        return back()->with('success', 'Leave deleted successfully.');
    }
 
    // Add new leave request (submit)
    public function store(Request $request)
    {
 
       
        // Validate the input data
        $request->validate([
            'employee_name' => 'string',
            'leave_type' => 'required|string',
            'remaining_leave' => 'required|numeric',
            'date_from' => 'required',
            'date_to' => 'required|after_or_equal:date_from',
            'number_of_day' => 'required|numeric',
            'reason' => 'required|string',
 
        ]);
   
        // Create a new leave entry
        $leave = new Leave();
        $leave->staff_id = $request->staff_id; // Assuming this is the employee ID
        $leave->employee_name = $request->employee_name; // Employee name
        $leave->leave_type = $request->leave_type;
        $leave->remaining_leave = $request->remaining_leave;
        $leave->date_from = $request->date_from;
        $leave->date_to = $request->date_to;
        $leave->leave_date = json_encode($request->leave_date); // Store as JSON if multiple dates are selected
        $leave->leave_day = json_encode($request->leave_day); // Store as JSON
        $leave->number_of_day = $request->number_of_day;
        $leave->reason = $request->reason;
        $leave->status="Open";
        $leave->save();
   
        // Redirect with success message
        return redirect()->back()->with('success', 'Leave request has been added successfully.');
    }
   
    // Edit Leave
   // Fetch and display the leave record for editing
   public function editLeave($id)
   {
       $leave = Leave::find($id);  // Find the leave by ID
   
       if (!$leave) {
           return redirect()->route('leave.index')->with('error', 'Leave not found');
       }
   
       return view('employees.leaves_manage.leavesadmin', compact('leave'));
   }
   
 
// Handle the leave update
public function updateLeave(Request $request, $id)
{
    $leave = Leave::find($id);
   
    if ($leave) {
        // Validate and update the leave
        $validated = $request->validate([
            'employee_name' => 'required|string',
            'leave_type' => 'required|string',
            'date_from' => 'required|date',
            'date_to' => 'required|date',
            'reason' => 'required|string',
            'status' => 'required|string',
        ]);
 
        $leave->employee_name = $validated['employee_name'];
        $leave->leave_type = $validated['leave_type'];
        $leave->date_from = $validated['date_from'];
        $leave->date_to = $validated['date_to'];
        $leave->reason = $validated['reason'];
        $leave->status = $validated['status'];
 
        $leave->save();
 
        return redirect()->route('form/leaves/new')->with('success', 'Leave updated successfully');
    }
 
    return back()->with('error', 'Leave not found.');
}
 
 
}
 