<?php

namespace App\Http\Controllers;

use App\Models\Client;
use Illuminate\Http\Request;
use Illuminate\Support\Facades\Validator;
use Illuminate\Validation\Rule;

class ClientController extends Controller
{
    // Display the list of clients
    public function index()
    {
        $clients = Client::all(); // Get all clients
        return view('client.index', compact('clients'));
    }

    // Show the form for creating or editing a client
    public function create()
    {
        return view('clients.create');
    }

    // Store a newly created client or update an existing client
    public function store(Request $request)
{
    // If client_id is provided, find that client, otherwise create a new client
    if ($request->client_id) {
        $client =1;

        if (!$client) {
            return redirect()->route('client.index')->with('error', 'Client not found');
        }
    } else {
        // Create a new client instance if client_id is null
        $client = new Client();
    }

    // Ensure that client_id isn't manually assigned (if it should be auto-incremented)
    // You can leave out $client->client_id, Laravel will automatically handle it

    // Now proceed with assigning other fields
    $client->first_name = $request->first_name;
    $client->client_id = 1;
    $client->last_name = $request->last_name;
    $client->email = $request->email;
    $client->password = bcrypt($request->password);
    $client->company_name = $request->company_name;
    $client->company_email = $request->company_email;
    $client->company_phone = $request->company_phone;
    $client->company_mobile = $request->company_mobile;
    $client->company_country = $request->company_country;
    $client->company_city = $request->company_city;
    $client->company_zip_code = $request->company_zip_code;
    $client->company_fax = $request->company_fax;
    $client->company_website = $request->company_website;
    $client->skype = $request->skype;
    $client->company_address = $request->company_address;
    $client->hosting_company = $request->hosting_company;
    $client->hosting_username = $request->hosting_username;
    $client->hosting_password = $request->hosting_password;
    $client->hosting_port = $request->hosting_port;
    $client->language = $request->language;
    $client->mobile = $request->mobile;
    $client->phone = $request->phone;
    $client->skype_contact = $request->skype_contact;
    $client->country = $request->country;
    $client->address = $request->address;
    $client->social_facebook_url = $request->social_facebook_url;
    $client->social_twitter_url = $request->social_twitter_url;
    $client->social_linkedin_url = $request->social_linkedin_url;

    // Handle profile photo upload if it's present
    if ($request->hasFile('profile_photo')) {
        $profilePhoto = $request->file('profile_photo');
        $filename = time() . '.' . $profilePhoto->getClientOriginalExtension();
        $profilePhoto->move(public_path('uploads/clients/'), $filename);
        $client->profile_photo = 'uploads/clients/' . $filename;
    }

    // Save the client data to the database
    $client->save();

    // Redirect the user with a success message
    return redirect()->route('client.index')->with('success', 'Client saved successfully');
}

    

    // Show the form for editing an existing client
    public function edit($id)
    {
        $client = Client::find($id);
        return response()->json($client);
    }

    public function update(Request $request, $id){
        $client = Client::find($id);
        if (!$client) {
            return redirect()->route('client.index')->with('error', 'Client not found');
        }

        $client->first_name = $request->first_name;
        $client->client_id = 1;
        $client->last_name = $request->last_name;
        $client->email = $request->email;
        $client->password = bcrypt($request->password);
        $client->company_name = $request->company_name;
        $client->company_email = $request->company_email;
        $client->company_phone = $request->company_phone;
        $client->company_mobile = $request->company_mobile;
        $client->company_country = $request->company_country;
        $client->company_city = $request->company_city;
        $client->company_zip_code = $request->company_zip_code;
        $client->company_fax = $request->company_fax;
        $client->company_website = $request->company_website;
        $client->skype = $request->skype;
        $client->company_address = $request->company_address;
        $client->hosting_company = $request->hosting_company;
        $client->hosting_username = $request->hosting_username;
        $client->hosting_password = $request->hosting_password;
        $client->hosting_port = $request->hosting_port;
        $client->language = $request->language;
        $client->mobile = $request->mobile;
        $client->phone = $request->phone;
        $client->skype_contact = $request->skype_contact;
        $client->country = $request->country;
        $client->address = $request->address;
        $client->social_facebook_url = $request->social_facebook_url;
        $client->social_twitter_url = $request->social_twitter_url;
        $client->social_linkedin_url = $request->social_linkedin_url;
    
        // Handle profile photo upload if it's present
        if ($request->hasFile('profile_photo')) {
            $profilePhoto = $request->file('profile_photo');
            $filename = time() . '.' . $profilePhoto->getClientOriginalExtension();
            $profilePhoto->move(public_path('uploads/clients/'), $filename);
            $client->profile_photo = 'uploads/clients/' . $filename;
        }
    
        // Save the client data to the database
        $client->save();
    
        // Redirect the user with a success message
        return redirect()->route('client.index')->with('success', 'Client Updated successfully');
        
        // dd($request->all());
    }

    // Delete a client
    public function destroy($id)
    {
        $client = Client::find($id);
        if ($client) {
            $client->delete();
        }

        return redirect()->route('client.index')->with('success', 'Client deleted successfully');
    }
}
